/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import java.util.ArrayList;
import java.util.List;

public class PDFobj {
    protected static final String TYPE = "/Type";
    protected static final String SUBTYPE = "/Subtype";
    protected static final String FILTER = "/Filter";
    protected static final String WIDTH = "/Width";
    protected static final String HEIGHT = "/Height";
    protected static final String COLORSPACE = "/ColorSpace";
    protected static final String BITSPERCOMPONENT = "/BitsPerComponent";
    protected int offset;
    protected int number;
    public List<String> dict;
    public byte[] stream;
    protected int stream_offset;
    public byte[] data;

    public PDFobj(int offset) {
        this.offset = offset;
        this.dict = new ArrayList<String>();
    }

    public String getValue(String key) {
        String token;
        for (int i = 0; i < this.dict.size() && !(token = this.dict.get(i)).equals("stream") && !token.equals("endobj"); ++i) {
            if (!token.equals(key)) continue;
            return this.dict.get(i + 1);
        }
        return "";
    }

    public int getLength(List<PDFobj> objects) {
        for (int i = 0; i < this.dict.size(); ++i) {
            String token = this.dict.get(i);
            if (!token.equals("/Length")) continue;
            int number = Integer.valueOf(this.dict.get(i + 1));
            if (this.dict.get(i + 2).equals("0") && this.dict.get(i + 3).equals("R")) {
                return this.getLength(objects, number);
            }
            return number;
        }
        return 0;
    }

    public int getLength(List<PDFobj> objects, int number) {
        for (int i = 0; i < objects.size(); ++i) {
            PDFobj obj = objects.get(i);
            if (obj.number != number) continue;
            return Integer.valueOf(obj.dict.get(3));
        }
        return 0;
    }

    public void setStream(byte[] pdf, int length) {
        this.stream = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.stream[i] = pdf[this.stream_offset + i];
        }
    }
}

