/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Decompressor;
import com.pdfjet.Font;
import com.pdfjet.Image;
import com.pdfjet.PDFobj;
import com.pdfjet.Page;
import com.pdfjet.Salsa20;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PDF {
    protected static boolean original_zlib = false;
    private int compliance = 0;
    private OutputStream buf = null;
    protected int objNumber = 0;
    protected int metadataObjNumber = 0;
    protected int outputIntentObjNumber = 0;
    protected List<Font> fonts = new ArrayList<Font>();
    protected List<Image> images = new ArrayList<Image>();
    protected List<Page> pages = new ArrayList<Page>();
    private List<Integer> objOffset = new ArrayList<Integer>();
    private String producer = "PDFjet v2.78 (http://pdfjet.com)";
    private String creationDate;
    private String createDate;
    private String title = "";
    private String subject = "";
    private String author = "";
    private int byte_count = 0;
    private boolean CR_LF = false;
    private List<PDFobj> objects = null;
    private List<PDFobj> objects2 = null;
    private List<PDFobj> objects3 = null;
    private List<PDFobj> objects4 = null;

    public PDF(OutputStream buf) throws Exception {
        this(buf, 0);
    }

    public PDF(OutputStream buf, int compliance) throws Exception {
        this.buf = buf;
        this.compliance = compliance;
        Date date = new Date();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.creationDate = sdf1.format(date);
        this.createDate = sdf2.format(date);
        this.append("%PDF-1.4\n");
        this.append('%');
        this.append((byte)-14);
        this.append((byte)-13);
        this.append((byte)-12);
        this.append((byte)-11);
        this.append((byte)-10);
        this.append('\n');
        if (compliance == 1) {
            this.metadataObjNumber = this.addMetadataObject();
            this.outputIntentObjNumber = this.addOutputIntentObject();
        }
    }

    protected void newobj() throws IOException {
        this.objOffset.add(this.byte_count);
        this.append(++this.objNumber);
        this.append(" 0 obj\n");
    }

    protected void endobj() throws IOException {
        this.append("endobj\n");
    }

    private int addMetadataObject() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xpacket begin='\ufeff' id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n");
        sb.append("<x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n");
        sb.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n");
        sb.append("<rdf:Description rdf:about=\"\" xmlns:pdf=\"http://ns.adobe.com/pdf/1.3/\" pdf:Producer=\"");
        sb.append(this.producer);
        sb.append("\"></rdf:Description>\n");
        sb.append("<rdf:Description rdf:about=\"\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n");
        sb.append("<dc:format>application/pdf</dc:format>\n");
        sb.append("<dc:title><rdf:Alt><rdf:li xml:lang=\"x-default\">");
        sb.append(this.title);
        sb.append("</rdf:li></rdf:Alt></dc:title>\n");
        sb.append("<dc:creator><rdf:Seq><rdf:li>");
        sb.append(this.producer);
        sb.append("</rdf:li></rdf:Seq></dc:creator>\n");
        sb.append("<dc:description><rdf:Alt><rdf:li xml:lang=\"en-US\">");
        sb.append("\n---------------------------------------------------------------------------\n\nThis PDF file contains embedded fonts from The Android Open Source Project:\n\nhttp://developer.android.com/index.html\n\nThe fonts were MODIFIED by Innovatics Inc. and are licensed under the\n\noriginal Apache License, Version 2.0:\n\n---------------------------------------------------------------------------\n\n\n   Copyright (c) 2005-2008, The Android Open Source Project\n\n   Licensed under the Apache License, Version 2.0 (the \"License\");\n   you may not use this file except in compliance with the License.\n\n   Unless required by applicable law or agreed to in writing, software\n   distributed under the License is distributed on an \"AS IS\" BASIS,\n   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n   See the License for the specific language governing permissions and\n   limitations under the License.\n\n\n                                 Apache License\n                           Version 2.0, January 2004\n                        http://www.apache.org/licenses/\n\n   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n\n   1. Definitions.\n\n      \"License\" shall mean the terms and conditions for use, reproduction,\n      and distribution as defined by Sections 1 through 9 of this document.\n\n      \"Licensor\" shall mean the copyright owner or entity authorized by\n      the copyright owner that is granting the License.\n\n      \"Legal Entity\" shall mean the union of the acting entity and all\n      other entities that control, are controlled by, or are under common\n      control with that entity. For the purposes of this definition,\n      \"control\" means (i) the power, direct or indirect, to cause the\n      direction or management of such entity, whether by contract or\n      otherwise, or (ii) ownership of fifty percent (50%) or more of the\n      outstanding shares, or (iii) beneficial ownership of such entity.\n\n      \"You\" (or \"Your\") shall mean an individual or Legal Entity\n      exercising permissions granted by this License.\n\n      \"Source\" form shall mean the preferred form for making modifications,\n      including but not limited to software source code, documentation\n      source, and configuration files.\n\n      \"Object\" form shall mean any form resulting from mechanical\n      transformation or translation of a Source form, including but\n      not limited to compiled object code, generated documentation,\n      and conversions to other media types.\n\n      \"Work\" shall mean the work of authorship, whether in Source or\n      Object form, made available under the License, as indicated by a\n      copyright notice that is included in or attached to the work\n      (an example is provided in the Appendix below).\n\n      \"Derivative Works\" shall mean any work, whether in Source or Object\n      form, that is based on (or derived from) the Work and for which the\n      editorial revisions, annotations, elaborations, or other modifications\n      represent, as a whole, an original work of authorship. For the purposes\n      of this License, Derivative Works shall not include works that remain\n      separable from, or merely link (or bind by name) to the interfaces of,\n      the Work and Derivative Works thereof.\n\n      \"Contribution\" shall mean any work of authorship, including\n      the original version of the Work and any modifications or additions\n      to that Work or Derivative Works thereof, that is intentionally\n      submitted to Licensor for inclusion in the Work by the copyright owner\n      or by an individual or Legal Entity authorized to submit on behalf of\n      the copyright owner. For the purposes of this definition, \"submitted\"\n      means any form of electronic, verbal, or written communication sent\n      to the Licensor or its representatives, including but not limited to\n      communication on electronic mailing lists, source code control systems,\n      and issue tracking systems that are managed by, or on behalf of, the\n      Licensor for the purpose of discussing and improving the Work, but\n      excluding communication that is conspicuously marked or otherwise\n      designated in writing by the copyright owner as \"Not a Contribution.\"\n\n      \"Contributor\" shall mean Licensor and any individual or Legal Entity\n      on behalf of whom a Contribution has been received by Licensor and\n      subsequently incorporated within the Work.\n\n   2. Grant of Copyright License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      copyright license to reproduce, prepare Derivative Works of,\n      publicly display, publicly perform, sublicense, and distribute the\n      Work and such Derivative Works in Source or Object form.\n\n   3. Grant of Patent License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      (except as stated in this section) patent license to make, have made,\n      use, offer to sell, sell, import, and otherwise transfer the Work,\n      where such license applies only to those patent claims licensable\n      by such Contributor that are necessarily infringed by their\n      Contribution(s) alone or by combination of their Contribution(s)\n      with the Work to which such Contribution(s) was submitted. If You\n      institute patent litigation against any entity (including a\n      cross-claim or counterclaim in a lawsuit) alleging that the Work\n      or a Contribution incorporated within the Work constitutes direct\n      or contributory patent infringement, then any patent licenses\n      granted to You under this License for that Work shall terminate\n      as of the date such litigation is filed.\n\n   4. Redistribution. You may reproduce and distribute copies of the\n      Work or Derivative Works thereof in any medium, with or without\n      modifications, and in Source or Object form, provided that You\n      meet the following conditions:\n\n      (a) You must give any other recipients of the Work or\n          Derivative Works a copy of this License; and\n\n      (b) You must cause any modified files to carry prominent notices\n          stating that You changed the files; and\n\n      (c) You must retain, in the Source form of any Derivative Works\n          that You distribute, all copyright, patent, trademark, and\n          attribution notices from the Source form of the Work,\n          excluding those notices that do not pertain to any part of\n          the Derivative Works; and\n\n      (d) If the Work includes a \"NOTICE\" text file as part of its\n          distribution, then any Derivative Works that You distribute must\n          include a readable copy of the attribution notices contained\n          within such NOTICE file, excluding those notices that do not\n          pertain to any part of the Derivative Works, in at least one\n          of the following places: within a NOTICE text file distributed\n          as part of the Derivative Works; within the Source form or\n          documentation, if provided along with the Derivative Works; or,\n          within a display generated by the Derivative Works, if and\n          wherever such third-party notices normally appear. The contents\n          of the NOTICE file are for informational purposes only and\n          do not modify the License. You may add Your own attribution\n          notices within Derivative Works that You distribute, alongside\n          or as an addendum to the NOTICE text from the Work, provided\n          that such additional attribution notices cannot be construed\n          as modifying the License.\n\n      You may add Your own copyright statement to Your modifications and\n      may provide additional or different license terms and conditions\n      for use, reproduction, or distribution of Your modifications, or\n      for any such Derivative Works as a whole, provided Your use,\n      reproduction, and distribution of the Work otherwise complies with\n      the conditions stated in this License.\n\n   5. Submission of Contributions. Unless You explicitly state otherwise,\n      any Contribution intentionally submitted for inclusion in the Work\n      by You to the Licensor shall be under the terms and conditions of\n      this License, without any additional terms or conditions.\n      Notwithstanding the above, nothing herein shall supersede or modify\n      the terms of any separate license agreement you may have executed\n      with Licensor regarding such Contributions.\n\n   6. Trademarks. This License does not grant permission to use the trade\n      names, trademarks, service marks, or product names of the Licensor,\n      except as required for reasonable and customary use in describing the\n      origin of the Work and reproducing the content of the NOTICE file.\n\n   7. Disclaimer of Warranty. Unless required by applicable law or\n      agreed to in writing, Licensor provides the Work (and each\n      Contributor provides its Contributions) on an \"AS IS\" BASIS,\n      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or\n      implied, including, without limitation, any warranties or conditions\n      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A\n      PARTICULAR PURPOSE. You are solely responsible for determining the\n      appropriateness of using or redistributing the Work and assume any\n      risks associated with Your exercise of permissions under this License.\n\n   8. Limitation of Liability. In no event and under no legal theory,\n      whether in tort (including negligence), contract, or otherwise,\n      unless required by applicable law (such as deliberate and grossly\n      negligent acts) or agreed to in writing, shall any Contributor be\n      liable to You for damages, including any direct, indirect, special,\n      incidental, or consequential damages of any character arising as a\n      result of this License or out of the use or inability to use the\n      Work (including but not limited to damages for loss of goodwill,\n      work stoppage, computer failure or malfunction, or any and all\n      other commercial damages or losses), even if such Contributor\n      has been advised of the possibility of such damages.\n\n   9. Accepting Warranty or Additional Liability. While redistributing\n      the Work or Derivative Works thereof, You may choose to offer,\n      and charge a fee for, acceptance of support, warranty, indemnity,\n      or other liability obligations and/or rights consistent with this\n      License. However, in accepting such obligations, You may act only\n      on Your own behalf and on Your sole responsibility, not on behalf\n      of any other Contributor, and only if You agree to indemnify,\n      defend, and hold each Contributor harmless for any liability\n      incurred by, or claims asserted against, such Contributor by reason\n      of your accepting any such warranty or additional liability.\n\n   END OF TERMS AND CONDITIONS\n\n---------------------------------------------------------------------------\n");
        sb.append("</rdf:li></rdf:Alt></dc:description>\n");
        sb.append("</rdf:Description>\n");
        sb.append("<rdf:Description rdf:about=\"\" xmlns:pdfaid=\"http://www.aiim.org/pdfa/ns/id/\">");
        sb.append("<pdfaid:part>1</pdfaid:part>");
        sb.append("<pdfaid:conformance>B</pdfaid:conformance>");
        sb.append("</rdf:Description>");
        sb.append("<rdf:Description rdf:about=\"\" xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n");
        sb.append("<xmp:CreateDate>");
        sb.append(this.createDate);
        sb.append("</xmp:CreateDate>\n");
        sb.append("</rdf:Description>\n");
        sb.append("</rdf:RDF>\n");
        sb.append("</x:xmpmeta>\n");
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 10; ++j) {
                sb.append("          ");
            }
            sb.append("\n");
        }
        sb.append("<?xpacket end=\"w\"?>");
        byte[] xml = sb.toString().getBytes("UTF-8");
        this.newobj();
        this.append("<<\n");
        this.append("/Type /Metadata\n");
        this.append("/Subtype /XML\n");
        this.append("/Length ");
        this.append(xml.length);
        this.append("\n");
        this.append(">>\n");
        this.append("stream\n");
        for (int i = 0; i < xml.length; ++i) {
            this.append(xml[i]);
        }
        this.append("\nendstream\n");
        this.endobj();
        return this.objNumber;
    }

    protected int addOutputIntentObject() throws Exception {
        int ch;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream("icc-profiles/sRGB_IEC61966-2-1_black_scaled.icc"));
        while ((ch = bis.read()) != -1) {
            baos.write(ch);
        }
        bis.close();
        byte[] sRGB = baos.toByteArray();
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos2, new Deflater());
        dos.write(sRGB, 0, sRGB.length);
        dos.finish();
        this.newobj();
        this.append("<<\n");
        this.append("/N 3\n");
        this.append("/Length ");
        this.append(baos2.size());
        this.append("\n");
        this.append("/Filter /FlateDecode\n");
        this.append(">>\n");
        this.append("stream\n");
        this.append(baos2);
        this.append("\nendstream\n");
        this.endobj();
        this.newobj();
        this.append("<<\n");
        this.append("/Type /OutputIntent\n");
        this.append("/S /GTS_PDFA1\n");
        this.append("/OutputCondition (sRGB IEC61966-2.1)\n");
        this.append("/OutputConditionIdentifier (sRGB IEC61966-2.1)\n");
        this.append("/Info (sRGB IEC61966-2.1)\n");
        this.append("/DestOutputProfile ");
        this.append(this.objNumber - 1);
        this.append(" 0 R\n");
        this.append(">>\n");
        this.endobj();
        return this.objNumber;
    }

    private int addResourcesObject() throws Exception {
        int i;
        this.newobj();
        this.append("<<\n");
        this.append("/Font\n");
        this.append("<<\n");
        for (i = 0; i < this.fonts.size(); ++i) {
            Font font = this.fonts.get(i);
            this.append("/F");
            this.append(font.objNumber);
            this.append(" ");
            this.append(font.objNumber);
            this.append(" 0 R\n");
        }
        this.append(">>\n");
        this.append("/XObject\n");
        this.append("<<\n");
        for (i = 0; i < this.images.size(); ++i) {
            Image image = this.images.get(i);
            this.append("/Im");
            this.append(image.objNumber);
            this.append(" ");
            this.append(image.objNumber);
            this.append(" 0 R\n");
        }
        this.append(">>\n");
        this.append(">>\n");
        this.endobj();
        return this.objNumber;
    }

    protected int addPagesObject() throws Exception {
        this.newobj();
        this.append("<<\n");
        this.append("/Type /Pages\n");
        this.append("/Kids [ ");
        int pageObjNumber = this.objNumber + 1;
        for (int i = 0; i < this.pages.size(); ++i) {
            Page page = this.pages.get(i);
            this.append(pageObjNumber);
            this.append(" 0 R ");
            pageObjNumber += 2;
            pageObjNumber += page.annots.size();
        }
        this.append("]\n");
        this.append("/Count ");
        this.append(this.pages.size());
        this.append('\n');
        this.append(">>\n");
        this.endobj();
        return this.objNumber;
    }

    protected int addInfoObject() throws Exception {
        this.newobj();
        this.append("<<\n");
        this.append("/Title (");
        this.append(this.title);
        this.append(")\n");
        this.append("/Subject (");
        this.append(this.subject);
        this.append(")\n");
        this.append("/Author (");
        this.append(this.author);
        this.append(")\n");
        this.append("/Producer (");
        this.append(this.producer);
        this.append(")\n");
        if (this.compliance != 1) {
            this.append("/CreationDate (D:");
            this.append(this.creationDate);
            this.append(")\n");
        }
        this.append(">>\n");
        this.endobj();
        return this.objNumber;
    }

    protected void addAllPages(int pagesObjNumber, int resObjNumber) throws Exception {
        for (int i = 0; i < this.pages.size(); ++i) {
            Page page = this.pages.get(i);
            this.newobj();
            this.append("<<\n");
            this.append("/Type /Page\n");
            this.append("/Parent ");
            this.append(pagesObjNumber);
            this.append(" 0 R\n");
            this.append("/MediaBox [0.0 0.0 ");
            this.append(page.width);
            this.append(" ");
            this.append(page.height);
            this.append("]\n");
            this.append("/Resources ");
            this.append(resObjNumber);
            this.append(" 0 R\n");
            this.append("/Contents ");
            this.append(this.objNumber + 1);
            this.append(" 0 R\n");
            if (page.annots.size() > 0) {
                this.append("/Annots [ ");
                for (int j = 0; j < page.annots.size(); ++j) {
                    this.append(this.objNumber + 2 + j);
                    this.append(" 0 R ");
                }
                this.append("]\n");
            }
            this.append(">>\n");
            this.endobj();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, new Deflater());
            dos.write(page.buf.toByteArray(), 0, page.buf.toByteArray().length);
            dos.finish();
            this.newobj();
            this.append("<<\n");
            this.append("/Filter /FlateDecode\n");
            this.append("/Length ");
            this.append(baos.size());
            this.append("\n");
            this.append(">>\n");
            this.append("stream\n");
            this.append(baos);
            this.append("\nendstream\n");
            this.endobj();
            this.addAnnotDictionaries(page);
        }
    }

    protected void addAnnotDictionaries(Page page) throws Exception {
        for (int i = 0; i < page.annots.size(); ++i) {
            Annotation annot = page.annots.get(i);
            this.newobj();
            this.append("<<\n");
            this.append("/Type /Annot\n");
            this.append("/Subtype /Link\n");
            this.append("/Rect [");
            this.append(annot.x1);
            this.append(' ');
            this.append(annot.y1);
            this.append(' ');
            this.append(annot.x2);
            this.append(' ');
            this.append(annot.y2);
            this.append("]\n");
            this.append("/Border[0 0 0]\n");
            this.append("/F 4\n");
            this.append("/A <<\n");
            this.append("/S /URI\n");
            this.append("/URI (");
            this.append(annot.uri);
            this.append(")\n");
            this.append(">>\n");
            this.append(">>\n");
            this.endobj();
        }
    }

    public void flush() throws Exception {
        int resObjNumber = this.addResourcesObject();
        int infoObjNumber = this.addInfoObject();
        int pagesObjNumber = this.addPagesObject();
        this.addAllPages(pagesObjNumber, resObjNumber);
        this.newobj();
        this.append("<<\n");
        this.append("/Type /Catalog\n");
        this.append("/Pages ");
        this.append(pagesObjNumber);
        this.append(" 0 R\n");
        if (this.compliance == 1) {
            this.append("/Metadata ");
            this.append(this.metadataObjNumber);
            this.append(" 0 R\n");
            this.append("/OutputIntents [");
            this.append(this.outputIntentObjNumber);
            this.append(" 0 R]\n");
        }
        this.append(">>\n");
        this.endobj();
        int startxref = this.byte_count;
        this.append("xref\n");
        this.append("0 ");
        this.append(this.objNumber + 1);
        this.append('\n');
        this.append("0000000000 65535 f \n");
        for (int i = 0; i < this.objOffset.size(); ++i) {
            int offset = this.objOffset.get(i);
            String str = String.valueOf(offset);
            for (int j = 0; j < 10 - str.length(); ++j) {
                this.append('0');
            }
            this.append(str);
            this.append(" 00000 n \n");
        }
        this.append("trailer\n");
        this.append("<<\n");
        this.append("/Size ");
        this.append(this.objNumber + 1);
        this.append('\n');
        String id = new Salsa20().getID();
        this.append("/ID[<");
        this.append(id);
        this.append("><");
        this.append(id);
        this.append(">]\n");
        this.append("/Root ");
        this.append(this.objNumber);
        this.append(" 0 R\n");
        this.append("/Info ");
        this.append(infoObjNumber);
        this.append(" 0 R\n");
        this.append(">>\n");
        this.append("startxref\n");
        this.append(startxref);
        this.append('\n');
        this.append("%%EOF\n");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    protected void append(int num) throws IOException {
        this.append(String.valueOf(num));
    }

    protected void append(double val) throws IOException {
        this.append(String.valueOf(val).replace(',', '.'));
    }

    protected void append(String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.buf.write((byte)str.charAt(i));
        }
        this.byte_count += len;
    }

    protected void append(char ch) throws IOException {
        this.append((byte)ch);
    }

    protected void append(byte b) throws IOException {
        this.buf.write(b);
        ++this.byte_count;
    }

    protected void append(byte[] buf2, int off, int len) throws IOException {
        this.buf.write(buf2, off, len);
        this.byte_count += len;
    }

    protected void append(ByteArrayOutputStream baos) throws IOException {
        baos.writeTo(this.buf);
        this.byte_count += baos.size();
    }

    public void setCompressor(boolean original_zlib) {
        PDF.original_zlib = original_zlib;
    }

    private int indexOfStartXRef(byte[] buf) {
        for (int i = buf.length - 10; i >= 0; --i) {
            if (buf[i] != 115 || buf[i + 1] != 116 || buf[i + 2] != 97 || buf[i + 3] != 114 || buf[i + 4] != 116 || buf[i + 5] != 120 || buf[i + 6] != 114 || buf[i + 7] != 101 || buf[i + 8] != 102) continue;
            return i;
        }
        return -1;
    }

    public List<PDFobj> read(InputStream inputStream) throws Exception {
        int i;
        int startxref;
        int ch;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((ch = inputStream.read()) != -1) {
            baos.write(ch);
        }
        byte[] pdf = baos.toByteArray();
        if (pdf[(startxref = this.indexOfStartXRef(pdf)) + 9] == 13 && pdf[startxref + 10] == 10) {
            this.CR_LF = true;
        }
        this.objects = new ArrayList<PDFobj>();
        PDFobj obj = this.getObject(pdf, startxref, pdf.length);
        String xref = obj.dict.get(1);
        obj = this.getObject(pdf, Integer.valueOf(xref), pdf.length);
        if (obj.dict.get(0).equals("xref")) {
            for (i = 3; i < obj.dict.size(); i += 3) {
                int off;
                String token = obj.dict.get(i);
                if (token.equals("trailer") || (off = Integer.valueOf(token).intValue()) == 0) continue;
                this.objects.add(this.getObject(pdf, off, pdf.length));
            }
        } else {
            this.getObjOffsets(pdf, xref);
        }
        for (i = 0; i < this.objects.size(); ++i) {
            obj = this.objects.get(i);
            int offset = obj.dict.size() - 1;
            if (!obj.dict.get(offset).equals("stream")) continue;
            obj.setStream(pdf, obj.getLength(this.objects));
        }
        this.objects2 = new ArrayList<PDFobj>();
        for (i = 0; i < this.objects.size(); ++i) {
            obj = this.objects.get(i);
            if (obj.getValue("/Type").equals("/XRef") || !obj.getValue("/S").equals("")) continue;
            if (obj.getValue("/Type").equals("/XObject") || obj.getValue("/Subtype").equals("/Type1C") || obj.getValue("/Subtype").equals("/CIDFontType0C")) {
                this.objects2.add(obj);
                continue;
            }
            if (!obj.getValue("/Filter").equals("/FlateDecode")) continue;
            Decompressor decompressor = new Decompressor(obj.stream);
            obj.data = decompressor.getDecompressedData();
            this.objects2.add(obj);
        }
        this.objects3 = new ArrayList<PDFobj>();
        for (i = 0; i < this.objects2.size(); ++i) {
            obj = this.objects2.get(i);
            if (obj.getValue("/Type").equals("/ObjStm")) {
                int first = Integer.valueOf(obj.getValue("/First"));
                int n = Integer.valueOf(obj.getValue("/N"));
                PDFobj o2 = this.getObject(obj.data, 0, first);
                for (int j = 0; j < o2.dict.size(); j += 2) {
                    int num = Integer.valueOf(o2.dict.get(j));
                    int off = Integer.valueOf(o2.dict.get(j + 1));
                    int end = obj.data.length;
                    if (j <= o2.dict.size() - 4) {
                        end = first + Integer.valueOf(o2.dict.get(j + 3));
                    }
                    PDFobj o3 = this.getObject(obj.data, first + off, end);
                    o3.dict.add(0, "obj");
                    o3.dict.add(0, "0");
                    o3.dict.add(0, String.valueOf(num));
                    this.objects3.add(o3);
                }
                continue;
            }
            this.objects3.add(obj);
        }
        this.objects4 = new ArrayList<PDFobj>();
        for (i = 0; i < this.objects.size(); ++i) {
            obj = this.objects.get(i);
            if (obj.getValue("/Type").equals("/ObjStm") || obj.getValue("/Type").equals("/XRef")) continue;
            obj.number = Integer.valueOf(obj.dict.get(0));
            this.objects4.add(obj);
        }
        for (i = 0; i < this.objects3.size(); ++i) {
            obj = this.objects3.get(i);
            obj.number = Integer.valueOf(obj.dict.get(0));
            this.objects4.add(obj);
        }
        return this.objects4;
    }

    private boolean append(PDFobj obj, StringBuilder sb, int offset) {
        String token = sb.toString().trim();
        if (!token.equals("")) {
            obj.dict.add(token);
        }
        sb.setLength(0);
        if (token.equals("stream") || token.equals("endobj") || token.equals("trailer")) {
            if (token.equals("stream")) {
                obj.stream_offset = this.CR_LF ? offset + 1 : offset;
            }
            return false;
        }
        return true;
    }

    private PDFobj getObject(byte[] buf, int off, int end) {
        PDFobj obj = new PDFobj(off);
        StringBuilder sb = new StringBuilder();
        int n = 0;
        int c1 = 32;
        while (true) {
            int c2;
            if (off == end) {
                this.append(obj, sb, off);
                break;
            }
            if ((c2 = (int)buf[off++]) == 40) {
                if (n == 0 && !this.append(obj, sb, off)) break;
                sb.append((char)c2);
                ++n;
                continue;
            }
            if (c2 == 41) {
                sb.append((char)c2);
                if (--n != 0 || this.append(obj, sb, off)) continue;
                break;
            }
            if (n > 0) {
                sb.append((char)c2);
                continue;
            }
            if (c2 == 0 || c2 == 9 || c2 == 10 || c2 == 12 || c2 == 13 || c2 == 32) {
                if (!this.append(obj, sb, off)) break;
                c1 = 32;
                continue;
            }
            if (c2 == 47) {
                if (!this.append(obj, sb, off)) break;
                sb.append((char)c2);
                c1 = c2;
                continue;
            }
            if (c2 == 60 || c2 == 62) {
                if (c2 != c1) {
                    if (!this.append(obj, sb, off)) break;
                    sb.append((char)c2);
                    c1 = c2;
                    continue;
                }
                sb.append((char)c2);
                if (!this.append(obj, sb, off)) break;
                c1 = 32;
                continue;
            }
            if (c2 == 91 || c2 == 93) {
                if (!this.append(obj, sb, off)) break;
                obj.dict.add(String.valueOf((char)c2));
                c1 = c2;
                continue;
            }
            if (c2 == 123 || c2 == 125) {
                if (!this.append(obj, sb, off)) break;
                obj.dict.add(String.valueOf((char)c2));
                c1 = c2;
                continue;
            }
            if (c2 == 37) {
                if (c2 != c1) {
                    if (!this.append(obj, sb, off)) break;
                    sb.append((char)c2);
                    c1 = c2;
                    continue;
                }
                sb.append((char)c2);
                if (!this.append(obj, sb, off)) break;
                c1 = 32;
                continue;
            }
            sb.append((char)c2);
            c1 = c2;
        }
        return obj;
    }

    public int toInt(byte[] buf, int off, int len) {
        int i = 0;
        for (int j = 0; j < len; ++j) {
            i |= buf[off + j] & 0xFF;
            if (j >= len - 1) continue;
            i <<= 8;
        }
        return i;
    }

    private void getObjOffsets(byte[] pdf, String xref) throws Exception {
        PDFobj obj = this.getObject(pdf, Integer.valueOf(xref), pdf.length);
        obj.setStream(pdf, obj.getLength(null));
        xref = obj.getValue("/Prev");
        if (!xref.equals("")) {
            this.getObjOffsets(pdf, xref);
        }
        Decompressor decompressor = new Decompressor(obj.stream);
        byte[] data = decompressor.getDecompressedData();
        int p1 = 0;
        int f1 = 0;
        int f2 = 0;
        int f3 = 0;
        for (int i = 0; i < obj.dict.size(); ++i) {
            String token = obj.dict.get(i);
            if (token.equals("/Predictor") && obj.dict.get(i + 1).equals("12")) {
                p1 = 1;
            }
            if (!token.equals("/W")) continue;
            f1 = Integer.valueOf(obj.dict.get(i + 2));
            f2 = Integer.valueOf(obj.dict.get(i + 3));
            f3 = Integer.valueOf(obj.dict.get(i + 4));
        }
        int n = p1 + f1 + f2 + f3;
        byte[] entry = new byte[n];
        for (int i = 0; i < data.length; i += n) {
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                entry[n2] = (byte)(entry[n2] + data[i + j]);
            }
            if (entry[1] != 1) continue;
            int off = this.toInt(entry, p1 + f1, f2);
            this.objects.add(this.getObject(pdf, off, pdf.length));
        }
    }
}

