/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Box;
import com.pdfjet.Page;
import com.pdfjet.Point;

public class Line {
    private double x1 = 0.0;
    private double y1 = 0.0;
    private double x2 = 0.0;
    private double y2 = 0.0;
    private double box_x = 0.0;
    private double box_y = 0.0;
    private double[] color = new double[]{0.0, 0.0, 0.0};
    private double width = 0.3;
    private String pattern = "[] 0";

    public Line() {
    }

    public Line(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setStartPoint(double x, double y) {
        this.x1 = x;
        this.y1 = y;
    }

    public void setEndPoint(double x, double y) {
        this.x2 = x;
        this.y2 = y;
    }

    public Point getStartPoint() {
        return new Point(this.x1, this.y1);
    }

    public Point getEndPoint() {
        return new Point(this.x2, this.y2);
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setColor(double[] color) {
        this.color = color;
    }

    public void setColor(int[] rgb) {
        this.color = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
    }

    public void placeIn(Box box) throws Exception {
        this.placeIn(box, 0.0, 0.0);
    }

    public void placeIn(Box box, double x_offset, double y_offset) throws Exception {
        this.box_x = box.x + x_offset;
        this.box_y = box.y + y_offset;
    }

    public void scaleBy(double factor) throws Exception {
        this.x1 *= factor;
        this.x2 *= factor;
        this.y1 *= factor;
        this.y2 *= factor;
    }

    public void drawOn(Page page) throws Exception {
        page.setPenColor(this.color[0], this.color[1], this.color[2]);
        page.setPenWidth(this.width);
        page.setLinePattern(this.pattern);
        page.drawLine(this.x1 + this.box_x, this.y1 + this.box_y, this.x2 + this.box_x, this.y2 + this.box_y);
    }
}

