/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class JPEGImage {
    static final char M_SOF0 = '\u00c0';
    static final char M_SOF1 = '\u00c1';
    static final char M_SOF2 = '\u00c2';
    static final char M_SOF3 = '\u00c3';
    static final char M_SOF5 = '\u00c5';
    static final char M_SOF6 = '\u00c6';
    static final char M_SOF7 = '\u00c7';
    static final char M_SOF9 = '\u00c9';
    static final char M_SOF10 = '\u00ca';
    static final char M_SOF11 = '\u00cb';
    static final char M_SOF13 = '\u00cd';
    static final char M_SOF14 = '\u00ce';
    static final char M_SOF15 = '\u00cf';
    static final char M_SOS = '\u00da';
    int width = 0;
    int height = 0;
    int colorComponents = 0;
    ByteArrayInputStream bais = null;
    byte[] data;

    public JPEGImage(InputStream inputStream) throws Exception {
        int count;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((count = inputStream.read(buf, 0, buf.length)) != -1) {
            baos.write(buf, 0, count);
        }
        this.data = baos.toByteArray();
        this.bais = new ByteArrayInputStream(this.data);
        char ch1 = (char)this.bais.read();
        char ch2 = (char)this.bais.read();
        if (ch1 == '\u00ff' && ch2 == '\u00d8') {
            boolean foundSOFn = false;
            do {
                char ch = this.nextMarker(inputStream);
                switch (ch) {
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c5': 
                    case '\u00c6': 
                    case '\u00c7': 
                    case '\u00c9': 
                    case '\u00ca': 
                    case '\u00cb': 
                    case '\u00cd': 
                    case '\u00ce': 
                    case '\u00cf': {
                        this.bais.read();
                        this.bais.read();
                        this.bais.read();
                        this.height = this.readTwoBytes(inputStream);
                        this.width = this.readTwoBytes(inputStream);
                        this.colorComponents = this.bais.read();
                        foundSOFn = true;
                        break;
                    }
                    default: {
                        this.skipVariable(inputStream);
                    }
                }
            } while (!foundSOFn);
        } else {
            throw new Exception();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColorComponents() {
        return this.colorComponents;
    }

    public byte[] getData() {
        return this.data;
    }

    private int readTwoBytes(InputStream inputStream) throws Exception {
        int value = this.bais.read();
        value <<= 8;
        return value |= this.bais.read();
    }

    private char nextMarker(InputStream inputStream) throws Exception {
        int discarded_bytes = 0;
        char ch = ' ';
        ch = (char)this.bais.read();
        while (ch != '\u00ff') {
            ++discarded_bytes;
            ch = (char)this.bais.read();
        }
        while ((ch = (char)((char)this.bais.read())) == '\u00ff') {
        }
        if (discarded_bytes != 0) {
            throw new Exception();
        }
        return ch;
    }

    private void skipVariable(InputStream inputStream) throws Exception {
        int length = this.readTwoBytes(inputStream);
        if (length < 2) {
            throw new Exception();
        }
        length -= 2;
        while (length > 0) {
            this.bais.read();
            --length;
        }
    }
}

