/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.BMPImage;
import com.pdfjet.Box;
import com.pdfjet.JPEGImage;
import com.pdfjet.PDF;
import com.pdfjet.PDFobj;
import com.pdfjet.PNGImage;
import com.pdfjet.Page;
import java.io.InputStream;

public class Image {
    protected int objNumber = 0;
    protected double x = 0.0;
    protected double y = 0.0;
    protected double w = 0.0;
    protected double h = 0.0;
    private double box_x = 0.0;
    private double box_y = 0.0;
    private byte[] data = null;

    public Image(PDF pdf, InputStream inputStream, int imageType) throws Exception {
        if (imageType == 1) {
            JPEGImage jpg = new JPEGImage(inputStream);
            this.data = jpg.getData();
            this.w = jpg.getWidth();
            this.h = jpg.getHeight();
            if (jpg.getColorComponents() == 1) {
                this.addImage(pdf, this.data, imageType, "DeviceGray", 8);
            } else if (jpg.getColorComponents() == 3) {
                this.addImage(pdf, this.data, imageType, "DeviceRGB", 8);
            }
        } else if (imageType == 2) {
            PNGImage png = new PNGImage(inputStream);
            this.data = png.getData();
            this.w = png.getWidth();
            this.h = png.getHeight();
            if (png.colorType == 0) {
                this.addImage(pdf, this.data, imageType, "DeviceGray", png.bitDepth);
            } else if (png.bitDepth == 16) {
                this.addImage(pdf, this.data, imageType, "DeviceRGB", 16);
            } else {
                this.addImage(pdf, this.data, imageType, "DeviceRGB", 8);
            }
        } else if (imageType == 3) {
            BMPImage bmp = new BMPImage(inputStream);
            this.data = bmp.getData();
            this.w = bmp.getWidth();
            this.h = bmp.getHeight();
            this.addImage(pdf, this.data, imageType, "DeviceRGB", 8);
        }
        inputStream.close();
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void scaleBy(double factor) {
        this.w *= factor;
        this.h *= factor;
    }

    public void placeIn(Box box) throws Exception {
        this.box_x = box.x;
        this.box_y = box.y;
    }

    public void drawOn(Page page) throws Exception {
        this.x += this.box_x;
        this.y += this.box_y;
        page.append("q\n");
        page.append(this.w);
        page.append(" 0 0 ");
        page.append(this.h);
        page.append(' ');
        page.append(this.x);
        page.append(' ');
        page.append(page.height - this.y - this.h);
        page.append(" cm\n");
        page.append("/Im");
        page.append(this.objNumber);
        page.append(" Do\n");
        page.append("Q\n");
    }

    private void addImage(PDF pdf, byte[] data, int imageType, String colorSpace, int bitsPerComponent) throws Exception {
        pdf.newobj();
        pdf.append("<<\n");
        pdf.append("/Type /XObject\n");
        pdf.append("/Subtype /Image\n");
        if (imageType == 1) {
            pdf.append("/Filter /DCTDecode\n");
        } else if (imageType == 2 || imageType == 3) {
            pdf.append("/Filter /FlateDecode\n");
        }
        pdf.append("/Width ");
        pdf.append((int)this.w);
        pdf.append('\n');
        pdf.append("/Height ");
        pdf.append((int)this.h);
        pdf.append('\n');
        pdf.append("/ColorSpace /");
        pdf.append(colorSpace);
        pdf.append('\n');
        pdf.append("/BitsPerComponent ");
        pdf.append(bitsPerComponent);
        pdf.append('\n');
        pdf.append("/Length ");
        pdf.append(data.length);
        pdf.append('\n');
        pdf.append(">>\n");
        pdf.append("stream\n");
        pdf.append(data, 0, data.length);
        pdf.append("\nendstream\n");
        pdf.endobj();
        pdf.images.add(this);
        this.objNumber = pdf.objNumber;
    }

    public Image(PDF pdf, PDFobj obj) throws Exception {
        pdf.newobj();
        pdf.append("<<\n");
        pdf.append("/Type /XObject\n");
        pdf.append("/Subtype /Image\n");
        pdf.append("/Filter ");
        pdf.append(obj.getValue("/Filter"));
        pdf.append('\n');
        pdf.append("/Width ");
        pdf.append(obj.getValue("/Width"));
        pdf.append('\n');
        pdf.append("/Height ");
        pdf.append(obj.getValue("/Height"));
        pdf.append('\n');
        pdf.append("/ColorSpace ");
        pdf.append(obj.getValue("/ColorSpace"));
        pdf.append('\n');
        pdf.append("/BitsPerComponent ");
        pdf.append(obj.getValue("/BitsPerComponent"));
        pdf.append('\n');
        pdf.append("/Length ");
        pdf.append(obj.stream.length);
        pdf.append('\n');
        pdf.append(">>\n");
        pdf.append("stream\n");
        pdf.append(obj.stream, 0, obj.stream.length);
        pdf.append("\nendstream\n");
        pdf.endobj();
        pdf.images.add(this);
        this.objNumber = pdf.objNumber;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }
}

