/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.CP1250;
import com.pdfjet.CP1251;
import com.pdfjet.CP1252;
import com.pdfjet.CP1253;
import com.pdfjet.CP1254;
import com.pdfjet.CP1257;
import com.pdfjet.CoreFont;
import com.pdfjet.PDF;

public class Font {
    protected String name = null;
    protected int objNumber = 0;
    protected int fileObjNumber = -1;
    protected double size = 12.0;
    protected int unitsPerEm = 1000;
    protected double ascent = 0.0;
    protected double descent = 0.0;
    protected double body_height = 0.0;
    protected int[][] metrics = null;
    protected boolean isStandard = true;
    protected boolean kernPairs = false;
    protected boolean isComposite = false;
    protected int firstChar = 32;
    protected int lastChar = 255;
    private PDF pdf = null;
    private boolean isCJK = false;
    private int codePage = 2;
    private double bBoxLLx = 0.0;
    private double bBoxLLy = 0.0;
    private double bBoxURx = 0.0;
    private double bBoxURy = 0.0;
    private int[] advanceWidths = null;
    private int[] glyphWidth = null;
    private int fontUnderlinePosition = 0;
    private int fontUnderlineThickness = 0;
    protected double underlinePosition = 0.0;
    protected double underlineThickness = 0.0;

    public Font(PDF pdf, String fontName) throws Exception {
        this.pdf = pdf;
        this.name = fontName;
        pdf.newobj();
        pdf.append("<<\n");
        pdf.append("/Type /Font\n");
        pdf.append("/Subtype /Type1\n");
        pdf.append("/BaseFont /");
        pdf.append(fontName);
        pdf.append('\n');
        if (!fontName.equals("Symbol") && !fontName.equals("ZapfDingbats")) {
            pdf.append("/Encoding /WinAnsiEncoding\n");
        }
        pdf.append(">>\n");
        pdf.endobj();
        this.objNumber = pdf.objNumber;
        CoreFont font = (CoreFont)Class.forName("com.pdfjet." + this.name.replace('-', '_')).newInstance();
        this.bBoxLLx = font.getBBoxLLx();
        this.bBoxLLy = font.getBBoxLLy();
        this.bBoxURx = font.getBBoxURx();
        this.bBoxURy = font.getBBoxURy();
        this.metrics = font.getMetrics();
        this.ascent = this.bBoxURy * this.size / (double)this.unitsPerEm;
        this.descent = this.bBoxLLy * this.size / (double)this.unitsPerEm;
        this.body_height = this.ascent - this.descent;
        this.fontUnderlineThickness = font.getUnderlineThickness();
        this.fontUnderlinePosition = font.getUnderlinePosition();
        this.underlineThickness = (double)this.fontUnderlineThickness * this.size / (double)this.unitsPerEm;
        this.underlinePosition = (double)this.fontUnderlinePosition * this.size / (double)(-this.unitsPerEm) + this.underlineThickness / 2.0;
        pdf.fonts.add(this);
    }

    public Font(PDF pdf, String fontName, int codePage) throws Exception {
        this.pdf = pdf;
        this.name = fontName;
        this.codePage = codePage;
        this.isCJK = true;
        this.isStandard = false;
        this.isComposite = true;
        this.firstChar = 32;
        this.lastChar = 65518;
        pdf.newobj();
        pdf.append("<<\n");
        pdf.append("/Type /FontDescriptor\n");
        pdf.append("/FontName /");
        pdf.append(fontName);
        pdf.append('\n');
        pdf.append("/Flags 4\n");
        pdf.append("/FontBBox [0 0 0 0]\n");
        pdf.append(">>\n");
        pdf.endobj();
        pdf.newobj();
        pdf.append("<<\n");
        pdf.append("/Type /Font\n");
        pdf.append("/Subtype /CIDFontType0\n");
        pdf.append("/BaseFont /");
        pdf.append(fontName);
        pdf.append('\n');
        pdf.append("/FontDescriptor ");
        pdf.append(pdf.objNumber - 1);
        pdf.append(" 0 R\n");
        pdf.append("/CIDSystemInfo <<\n");
        pdf.append("/Registry (Adobe)\n");
        if (fontName.startsWith("AdobeMingStd")) {
            pdf.append("/Ordering (CNS1)\n");
            pdf.append("/Supplement 4\n");
        } else if (fontName.startsWith("AdobeSongStd")) {
            pdf.append("/Ordering (GB1)\n");
            pdf.append("/Supplement 4\n");
        } else if (fontName.startsWith("KozMinPro")) {
            pdf.append("/Ordering (Japan1)\n");
            pdf.append("/Supplement 4\n");
        } else if (fontName.startsWith("AdobeMyungjoStd")) {
            pdf.append("/Ordering (Korea1)\n");
            pdf.append("/Supplement 1\n");
        } else {
            throw new Exception("Unsupported font: " + fontName);
        }
        pdf.append(">>\n");
        pdf.append(">>\n");
        pdf.endobj();
        pdf.newobj();
        pdf.append("<<\n");
        pdf.append("/Type /Font\n");
        pdf.append("/Subtype /Type0\n");
        pdf.append("/BaseFont /");
        if (fontName.startsWith("AdobeMingStd")) {
            pdf.append(fontName + "-UniCNS-UTF16-H\n");
            pdf.append("/Encoding /UniCNS-UTF16-H\n");
        } else if (fontName.startsWith("AdobeSongStd")) {
            pdf.append(fontName + "-UniGB-UTF16-H\n");
            pdf.append("/Encoding /UniGB-UTF16-H\n");
        } else if (fontName.startsWith("KozMinPro")) {
            pdf.append(fontName + "-UniJIS-UCS2-H\n");
            pdf.append("/Encoding /UniJIS-UCS2-H\n");
        } else if (fontName.startsWith("AdobeMyungjoStd")) {
            pdf.append(fontName + "-UniKS-UCS2-H\n");
            pdf.append("/Encoding /UniKS-UCS2-H\n");
        } else {
            throw new Exception("Unsupported font: " + fontName);
        }
        pdf.append("/DescendantFonts [");
        pdf.append(pdf.objNumber - 1);
        pdf.append(" 0 R]\n");
        pdf.append(">>\n");
        pdf.endobj();
        this.objNumber = pdf.objNumber;
        this.ascent = this.size;
        this.descent = -this.ascent / 4.0;
        this.body_height = this.ascent - this.descent;
        pdf.fonts.add(this);
    }

    public void setSize(double fontSize) {
        this.size = fontSize;
        if (this.isCJK) {
            this.ascent = this.size;
            this.descent = -this.ascent / 4.0;
            return;
        }
        this.ascent = this.bBoxURy * this.size / (double)this.unitsPerEm;
        this.descent = this.bBoxLLy * this.size / (double)this.unitsPerEm;
        this.body_height = this.ascent - this.descent;
        this.underlineThickness = (double)this.fontUnderlineThickness * this.size / (double)this.unitsPerEm;
        this.underlinePosition = (double)this.fontUnderlinePosition * this.size / (double)(-this.unitsPerEm) + this.underlineThickness / 2.0;
    }

    public double getSize() {
        return this.size;
    }

    public void setKernPairs(boolean kernPairs) {
        this.kernPairs = kernPairs;
    }

    public double stringWidth(String str) {
        int width = 0;
        if (this.isCJK) {
            return (double)str.length() * this.ascent;
        }
        block0: for (int i = 0; i < str.length(); ++i) {
            int c1 = str.charAt(i);
            if (!this.isStandard) {
                if (c1 < this.firstChar || c1 > this.lastChar) {
                    width += this.advanceWidths[0];
                    continue;
                }
                width += this.nonStandardFontGlyphWidth(c1);
                continue;
            }
            if (c1 < this.firstChar || c1 > this.lastChar) {
                c1 = 32;
            }
            width += this.metrics[c1 -= 32][1];
            if (!this.kernPairs || this.name.startsWith("C") || this.name.startsWith("S") || this.name.startsWith("Z")) continue;
            if (i == str.length() - 1) break;
            int c2 = str.charAt(i + 1);
            if (c2 < this.firstChar || c2 > this.lastChar) {
                c2 = 32;
            }
            for (int j = 2; j < this.metrics[c1].length; j += 2) {
                if (this.metrics[c1][j] != c2) continue;
                width += this.metrics[c1][j + 1];
                continue block0;
            }
        }
        return (double)width * this.size / (double)this.unitsPerEm;
    }

    private int nonStandardFontGlyphWidth(int c1) {
        int width = 0;
        if (this.isComposite) {
            width = this.glyphWidth[c1];
        } else if (c1 < 127) {
            width = this.glyphWidth[c1];
        } else if (this.codePage == 0) {
            width = this.glyphWidth[CP1250.codes[c1 - 127]];
        } else if (this.codePage == 1) {
            width = this.glyphWidth[CP1251.codes[c1 - 127]];
        } else if (this.codePage == 2) {
            width = this.glyphWidth[CP1252.codes[c1 - 127]];
        } else if (this.codePage == 3) {
            width = this.glyphWidth[CP1253.codes[c1 - 127]];
        } else if (this.codePage == 4) {
            width = this.glyphWidth[CP1254.codes[c1 - 127]];
        } else if (this.codePage == 7) {
            width = this.glyphWidth[CP1257.codes[c1 - 127]];
        }
        return width;
    }
}

