/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Border;
import com.pdfjet.Box;
import com.pdfjet.Font;
import com.pdfjet.Page;
import com.pdfjet.Point;

public class Cell {
    protected double width = 70.0;
    protected double height = 0.0;
    protected Font font = null;
    protected String text = " ";
    protected int align = 0;
    protected Point point = null;
    public Border border = null;
    protected int colspan = 1;
    protected double[] bgColor = new double[]{1.0, 1.0, 1.0};
    protected double[] penColor = new double[]{0.0, 0.0, 0.0};
    protected double[] brushColor = new double[]{0.0, 0.0, 0.0};
    protected double lineWidth = 0.0;

    public Cell(Font font) {
        this.font = font;
        this.border = new Border();
    }

    public Cell(Font font, String text) {
        this.font = font;
        this.text = text;
        this.border = new Border();
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public Point getPoint() {
        return this.point;
    }

    public Border getBorder() {
        return this.border;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getColspan() {
        return this.colspan;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setNoBorders() {
        this.border.top = false;
        this.border.bottom = false;
        this.border.left = false;
        this.border.right = false;
    }

    public void setBgColor(double[] bgColor) {
        this.bgColor = bgColor;
    }

    public void setBgColor(int[] rgb) {
        this.bgColor = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
    }

    public void setFgColor(double[] fgColor) {
        this.penColor = fgColor;
        this.brushColor = fgColor;
    }

    public void setFgColor(int[] rgb) {
        this.penColor = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
        this.brushColor = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
    }

    public void setPenColor(double[] fgColor) {
        this.penColor = fgColor;
    }

    public void setPenColor(int[] rgb) {
        this.penColor = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
    }

    public void setBrushColor(double[] fgColor) {
        this.brushColor = fgColor;
    }

    public void setBrushColor(int[] rgb) {
        this.brushColor = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
    }

    public void setTextAlignment(int alignment) {
        this.align = alignment;
    }

    public void setColSpan(int colspan) {
        this.colspan = colspan;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public void paint(Page page, double x, double y, double w, double h, double margin) throws Exception {
        this.drawBackground(page, x, y, w, h);
        this.drawBorders(page, x, y, w, h);
        this.drawText(page, x, y, w, margin);
    }

    private void drawBackground(Page page, double x, double y, double cell_w, double cell_h) throws Exception {
        page.setBrushColor(this.brushColor[0], this.brushColor[1], this.brushColor[2]);
        Box box = new Box(x, y, cell_w, cell_h);
        box.setColor(this.bgColor);
        box.setFillShape(true);
        box.drawOn(page);
    }

    private void drawBorders(Page page, double x, double y, double cell_w, double cell_h) throws Exception {
        page.setPenWidth(this.lineWidth);
        page.setPenColor(this.penColor[0], this.penColor[1], this.penColor[2]);
        if (this.border.left) {
            page.moveTo(x, y);
            page.lineTo(x, y + cell_h);
            page.strokePath();
        }
        if (this.border.right) {
            page.moveTo(x + cell_w, y);
            page.lineTo(x + cell_w, y + cell_h);
            page.strokePath();
        }
        if (this.border.top) {
            page.moveTo(x, y);
            page.lineTo(x + cell_w, y);
            page.strokePath();
        }
        if (this.border.bottom) {
            page.moveTo(x, y + cell_h);
            page.lineTo(x + cell_w, y + cell_h);
            page.strokePath();
        }
    }

    private void drawText(Page page, double x, double y, double cell_w, double margin) throws Exception {
        double y_text = y + this.font.ascent + margin;
        page.setPenColor(this.penColor[0], this.penColor[1], this.penColor[2]);
        page.setBrushColor(this.brushColor[0], this.brushColor[1], this.brushColor[2]);
        if (this.align == 2) {
            page.drawString(this.font, this.text, x + cell_w - (this.font.stringWidth(this.text) + margin), y_text);
        } else if (this.align == 1) {
            page.drawString(this.font, this.text, x + (cell_w - this.font.stringWidth(this.text)) / 2.0, y_text);
        } else {
            page.drawString(this.font, this.text, x + margin, y_text);
        }
        if (this.point != null) {
            this.point.x = x + cell_w - (this.font.ascent / 2.0 + margin);
            this.point.y = y + (this.font.ascent / 2.0 + margin);
            this.point.r = this.font.ascent / 3.0;
            page.drawPoint(this.point);
        }
    }
}

