/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Page;

public class Box {
    protected double x = 0.0;
    protected double y = 0.0;
    private double w = 0.0;
    private double h = 0.0;
    private double[] color = new double[]{0.0, 0.0, 0.0};
    private double width = 0.3;
    private String pattern = "[] 0";
    private boolean fill_shape = false;

    public Box() {
    }

    public Box(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(double w, double h) {
        this.w = w;
        this.h = h;
    }

    public void setColor(double[] color) {
        this.color = color;
    }

    public void setColor(int[] rgb) {
        this.color = new double[]{(double)rgb[0] / 255.0, (double)rgb[1] / 255.0, (double)rgb[2] / 255.0};
    }

    public void setLineWidth(double width) {
        this.width = width;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setFillShape(boolean fill_shape) {
        this.fill_shape = fill_shape;
    }

    public void placeIn(Box box, double x_offset, double y_offset) throws Exception {
        this.x = box.x + x_offset;
        this.y = box.y + y_offset;
    }

    public void scaleBy(double factor) throws Exception {
        this.x *= factor;
        this.y *= factor;
    }

    public void drawOn(Page page) throws Exception {
        page.setPenWidth(this.width);
        page.setLinePattern(this.pattern);
        page.moveTo(this.x, this.y);
        page.lineTo(this.x + this.w, this.y);
        page.lineTo(this.x + this.w, this.y + this.h);
        page.lineTo(this.x, this.y + this.h);
        page.closePath();
        if (this.fill_shape) {
            page.setBrushColor(this.color[0], this.color[1], this.color[2]);
            page.fillPath();
        } else {
            page.setPenColor(this.color[0], this.color[1], this.color[2]);
            page.strokePath();
        }
    }
}

