/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class BMPImage {
    int w = 0;
    int h = 0;
    byte[] image;
    byte[] deflated;
    private int bpp;
    private byte[][] palette = null;
    private boolean r5g6b5;
    private static final int m10000000 = 128;
    private static final int m01000000 = 64;
    private static final int m00100000 = 32;
    private static final int m00010000 = 16;
    private static final int m00001000 = 8;
    private static final int m00000100 = 4;
    private static final int m00000010 = 2;
    private static final int m00000001 = 1;
    private static final int m11110000 = 240;
    private static final int m00001111 = 15;

    public BMPImage(InputStream is) throws Exception {
        byte[] bm = this.getBytes(is, 2);
        if (bm[0] == 66 && bm[1] == 77 || bm[0] == 66 && bm[1] == 65 || bm[0] == 67 && bm[1] == 73 || bm[0] == 67 && bm[1] == 80 || bm[0] == 73 && bm[1] == 67 || bm[0] == 80 && bm[1] == 84) {
            this.skipNBytes(is, 8);
            int offset = this.readSignedInt(is);
            int sizeOfHeader = this.readSignedInt(is);
            this.w = this.readSignedInt(is);
            this.h = this.readSignedInt(is);
            this.skipNBytes(is, 2);
            this.bpp = this.read2BytesLE(is);
            int compression = this.readSignedInt(is);
            if (this.bpp > 8) {
                this.r5g6b5 = compression == 3;
                this.skipNBytes(is, 20);
                if (offset > 54) {
                    this.skipNBytes(is, offset - 54);
                }
            } else {
                this.skipNBytes(is, 12);
                int numpalcol = this.readSignedInt(is);
                this.skipNBytes(is, 4);
                this.parsePalette(is, numpalcol);
            }
        } else {
            throw new Exception("BMP data could not be parsed!");
        }
        this.parseData(is);
    }

    /*
     * Unable to fully structure code
     */
    private void parseData(InputStream is) throws Exception {
        this.image = new byte[this.w * this.h * 3];
        rowsize = 4 * (int)Math.ceil((double)(this.bpp * this.w) / 32.0);
lbl3:
        // 3 sources

        try {
            for (i = 0; i < this.h; ++i) {
                block14: {
                    row = this.getBytes(is, rowsize);
                    switch (this.bpp) {
                        case 1: {
                            row = BMPImage.bit1to8(row, this.w);
                            break;
                        }
                        case 4: {
                            row = BMPImage.bit4to8(row, this.w);
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 16: {
                            if (this.r5g6b5) {
                                row = BMPImage.bit16to24(row, this.w);
                                break;
                            }
                            row = BMPImage.bit16to24b(row, this.w);
                            break;
                        }
                        case 24: {
                            break;
                        }
                        case 32: {
                            row = BMPImage.bit32to24(row, this.w);
                            break;
                        }
                        default: {
                            throw new Exception("Can only parse 1 bit, 4bit, 8bit, 16bit, 24bit and 32bit images");
                        }
                    }
                    index = this.w * (this.h - i - 1) * 3;
                    if (this.palette == null) break block14;
                    for (j = 0; j < this.w; ++j) {
                        this.image[index++] = this.palette[row[j] < 0 ? row[j] + 256 : row[j]][2];
                        this.image[index++] = this.palette[row[j] < 0 ? row[j] + 256 : row[j]][1];
                        this.image[index++] = this.palette[row[j] < 0 ? row[j] + 256 : row[j]][0];
                    }
                    ** GOTO lbl3
                }
                for (j = 0; j < this.w * 3; j += 3) {
                    this.image[index++] = row[j + 2];
                    this.image[index++] = row[j + 1];
                    this.image[index++] = row[j + 0];
                }
                ** GOTO lbl3
            }
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            throw new Exception("BMP parse error: imagedata not correct");
        }
        data2 = new ByteArrayOutputStream(32768);
        dos = new DeflaterOutputStream((OutputStream)data2, new Deflater());
        dos.write(this.image, 0, this.image.length);
        dos.finish();
        this.deflated = data2.toByteArray();
    }

    private static byte[] bit16to24(byte[] row, int width) {
        byte[] ret = new byte[width * 3];
        int j = 0;
        for (int i = 0; i < width * 2; i += 2) {
            ret[j++] = (byte)((row[i] & 0x1F) << 3);
            ret[j++] = (byte)(((row[i + 1] & 7) << 5) + ((row[i] & 0xE0) >> 3));
            ret[j++] = (byte)(row[i + 1] & 0xF8);
        }
        return ret;
    }

    private static byte[] bit16to24b(byte[] row, int width) {
        byte[] ret = new byte[width * 3];
        int j = 0;
        for (int i = 0; i < width * 2; i += 2) {
            ret[j++] = (byte)((row[i] & 0x1F) << 3);
            ret[j++] = (byte)(((row[i + 1] & 3) << 6) + ((row[i] & 0xE0) >> 2));
            ret[j++] = (byte)((row[i + 1] & 0x7C) << 1);
        }
        return ret;
    }

    private static byte[] bit32to24(byte[] row, int width) {
        byte[] ret = new byte[width * 3];
        int j = 0;
        for (int i = 0; i < width * 4; i += 4) {
            ret[j++] = row[i + 1];
            ret[j++] = row[i + 2];
            ret[j++] = row[i + 3];
        }
        return ret;
    }

    private static byte[] bit4to8(byte[] row, int width) {
        byte[] ret = new byte[width];
        for (int i = 0; i < width; ++i) {
            ret[i] = i % 2 == 0 ? (byte)((row[i / 2] & 0xF0) >> 4) : (byte)(row[i / 2] & 0xF);
        }
        return ret;
    }

    private static byte[] bit1to8(byte[] row, int width) {
        byte[] ret = new byte[width];
        block10: for (int i = 0; i < width; ++i) {
            switch (i % 8) {
                case 0: {
                    ret[i] = (byte)((row[i / 8] & 0x80) >> 7);
                    continue block10;
                }
                case 1: {
                    ret[i] = (byte)((row[i / 8] & 0x40) >> 6);
                    continue block10;
                }
                case 2: {
                    ret[i] = (byte)((row[i / 8] & 0x20) >> 5);
                    continue block10;
                }
                case 3: {
                    ret[i] = (byte)((row[i / 8] & 0x10) >> 4);
                    continue block10;
                }
                case 4: {
                    ret[i] = (byte)((row[i / 8] & 8) >> 3);
                    continue block10;
                }
                case 5: {
                    ret[i] = (byte)((row[i / 8] & 4) >> 2);
                    continue block10;
                }
                case 6: {
                    ret[i] = (byte)((row[i / 8] & 2) >> 1);
                    continue block10;
                }
                case 7: {
                    ret[i] = (byte)(row[i / 8] & 1);
                }
            }
        }
        return ret;
    }

    private void parsePalette(InputStream is, int size) throws Exception {
        this.palette = new byte[size][];
        for (int i = 0; i < size; ++i) {
            this.palette[i] = this.getBytes(is, 4);
        }
    }

    private void skipNBytes(InputStream inputStream, int n) {
        try {
            this.getBytes(inputStream, n);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] getBytes(InputStream inputStream, int length) throws Exception {
        byte[] buf = new byte[length];
        inputStream.read(buf, 0, buf.length);
        return buf;
    }

    private int read2BytesLE(InputStream inputStream) throws Exception {
        byte[] buf = this.getBytes(inputStream, 2);
        int val = 0;
        val |= buf[1] & 0xFF;
        val <<= 8;
        return val |= buf[0] & 0xFF;
    }

    private int readSignedInt(InputStream inputStream) throws Exception {
        byte[] buf = this.getBytes(inputStream, 4);
        long val = 0L;
        val |= (long)(buf[3] & 0xFF);
        val <<= 8;
        val |= (long)(buf[2] & 0xFF);
        val <<= 8;
        val |= (long)(buf[1] & 0xFF);
        val <<= 8;
        return (int)(val |= (long)(buf[0] & 0xFF));
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public byte[] getData() {
        return this.deflated;
    }
}

