/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf;

import com.l2fprod.common.swing.plaf.ComponentAddon;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import com.l2fprod.common.swing.plaf.aqua.AquaLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.metal.MetalLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.motif.MotifLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.windows.WindowsLookAndFeelAddons;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.UIManager;

public abstract class AbstractComponentAddon
implements ComponentAddon {
    private String name;

    protected AbstractComponentAddon(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void initialize(LookAndFeelAddons addon) {
        addon.loadDefaults(this.getDefaults(addon));
    }

    @Override
    public void uninitialize(LookAndFeelAddons addon) {
        addon.unloadDefaults(this.getDefaults(addon));
    }

    protected void addBasicDefaults(LookAndFeelAddons addon, List<Object> defaults) {
    }

    protected void addMacDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        this.addBasicDefaults(addon, defaults);
    }

    protected void addMetalDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        this.addBasicDefaults(addon, defaults);
    }

    protected void addMotifDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        this.addBasicDefaults(addon, defaults);
    }

    protected void addWindowsDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        this.addBasicDefaults(addon, defaults);
    }

    private Object[] getDefaults(LookAndFeelAddons addon) {
        ArrayList<Object> defaults = new ArrayList<Object>();
        if (this.isWindows(addon)) {
            this.addWindowsDefaults(addon, defaults);
        } else if (this.isMetal(addon)) {
            this.addMetalDefaults(addon, defaults);
        } else if (this.isMac(addon)) {
            this.addMacDefaults(addon, defaults);
        } else if (this.isMotif(addon)) {
            this.addMotifDefaults(addon, defaults);
        } else {
            this.addBasicDefaults(addon, defaults);
        }
        return defaults.toArray();
    }

    protected void addResource(List<Object> defaults, String bundleName) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            defaults.add(key);
            defaults.add(bundle.getObject(key));
        }
    }

    protected boolean isWindows(LookAndFeelAddons addon) {
        return addon instanceof WindowsLookAndFeelAddons;
    }

    protected boolean isMetal(LookAndFeelAddons addon) {
        return addon instanceof MetalLookAndFeelAddons;
    }

    protected boolean isMac(LookAndFeelAddons addon) {
        return addon instanceof AquaLookAndFeelAddons;
    }

    protected boolean isMotif(LookAndFeelAddons addon) {
        return addon instanceof MotifLookAndFeelAddons;
    }

    protected boolean isPlastic() {
        return UIManager.getLookAndFeel().getClass().getName().indexOf("Plastic") != -1;
    }

    protected boolean isSynth() {
        return UIManager.getLookAndFeel().getClass().getName().indexOf("ynth") != -1;
    }

    protected Font getFont(String key, Font defaultFont) {
        Font result = UIManager.getFont(key);
        return result != null ? result : defaultFont;
    }

    protected Color getColor(String key, Color defaultColor) {
        Color result = UIManager.getColor(key);
        return result != null ? result : defaultColor;
    }
}

