/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.ProgressListener;
import com.mortennobel.imagescaling.ResampleFilter;
import com.mortennobel.imagescaling.ResampleFilters;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ResampleOp {
    private List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    private static final int SCALE = 2;
    private int srcWidth;
    private int srcHeight;
    private int dstWidth;
    private int dstHeight;
    private SubSamplingData horizontalSubsamplingData;
    private SubSamplingData verticalSubsamplingData;
    private int processedItems;
    private float totalItems;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();
    private AtomicInteger multipleInvocationLock = new AtomicInteger();
    private ResampleFilter filter = ResampleFilters.getLanczos3Filter();

    protected void fireProgressChanged(float fraction) {
        for (ProgressListener progressListener : this.listeners) {
            progressListener.notifyProgress(fraction);
        }
    }

    public final void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public final boolean removeProgressListener(ProgressListener progressListener) {
        return this.listeners.remove(progressListener);
    }

    public ResampleFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ResampleFilter filter) {
        this.filter = filter;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public void doFilter(final double[] srcImg, int srcWidth, int srcHeight, final double[] dest) {
        int finalI;
        int i;
        assert (this.multipleInvocationLock.incrementAndGet() == 1) : "Multiple concurrent invocations detected";
        this.dstWidth = srcWidth * 2;
        this.dstHeight = srcHeight * 2;
        if (dest.length < this.dstWidth * this.dstHeight) {
            throw new IllegalArgumentException("Output buffer not big enough");
        }
        this.srcWidth = srcWidth;
        this.srcHeight = srcHeight;
        final double[][] workPixels = new double[srcHeight][this.dstWidth];
        this.processedItems = 0;
        this.totalItems = srcHeight + this.dstWidth;
        this.horizontalSubsamplingData = ResampleOp.createSubSampling(this.filter, srcWidth, this.dstWidth);
        this.verticalSubsamplingData = ResampleOp.createSubSampling(this.filter, srcHeight, this.dstHeight);
        Thread[] threads = new Thread[this.numberOfThreads - 1];
        for (i = 1; i < this.numberOfThreads; ++i) {
            finalI = i;
            threads[i - 1] = new Thread(new Runnable(){

                @Override
                public void run() {
                    ResampleOp.this.horizontallyFromSrcToWork(srcImg, workPixels, finalI, ResampleOp.this.numberOfThreads);
                }
            });
            threads[i - 1].start();
        }
        this.horizontallyFromSrcToWork(srcImg, workPixels, 0, this.numberOfThreads);
        this.waitForAllThreads(threads);
        for (i = 1; i < this.numberOfThreads; ++i) {
            finalI = i;
            threads[i - 1] = new Thread(new Runnable(){

                @Override
                public void run() {
                    ResampleOp.this.verticalFromWorkToDst(workPixels, dest, finalI, ResampleOp.this.numberOfThreads);
                }
            });
            threads[i - 1].start();
        }
        this.verticalFromWorkToDst(workPixels, dest, 0, this.numberOfThreads);
        this.waitForAllThreads(threads);
        assert (this.multipleInvocationLock.decrementAndGet() == 0) : "Multiple concurrent invocations detected";
    }

    private void waitForAllThreads(Thread[] threads) {
        try {
            for (Thread t : threads) {
                t.join(Long.MAX_VALUE);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    static SubSamplingData createSubSampling(ResampleFilter filter, int srcSize, int dstSize) {
        int[] arrN = new int[dstSize];
        double fwidth = filter.getSamplingRadius();
        int numContributors = (int)(fwidth * 2.0 + 1.0);
        double[] arrWeight = new double[dstSize * numContributors];
        int[] arrPixel = new int[dstSize * numContributors];
        for (int i = 0; i < dstSize; ++i) {
            int k;
            int subindex = i * numContributors;
            double center = ((double)i + 0.5) / 2.0;
            int left = (int)Math.floor(center - fwidth);
            int right = (int)Math.ceil(center + fwidth);
            for (int j = left; j <= right; ++j) {
                double weight = filter.apply(center - (double)j - 0.5);
                if (weight == 0.0) continue;
                int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                int k2 = arrN[i];
                int n2 = i;
                arrN[n2] = arrN[n2] + 1;
                if (n < 0 || n >= srcSize) {
                    weight = 0.0;
                }
                arrPixel[subindex + k2] = n;
                arrWeight[subindex + k2] = weight;
            }
            int max = arrN[i];
            double tot = 0.0;
            for (k = 0; k < max; ++k) {
                tot += arrWeight[subindex + k];
            }
            assert (tot != 0.0) : "should never happen except bug in filter";
            if (tot == 0.0) continue;
            for (k = 0; k < max; ++k) {
                int n = subindex + k;
                arrWeight[n] = arrWeight[n] / tot;
            }
        }
        return new SubSamplingData(arrN, arrPixel, arrWeight, numContributors);
    }

    private void verticalFromWorkToDst(double[][] workPixels, double[] outPixels, int start, int delta) {
        for (int x = start; x < this.dstWidth; x += delta) {
            int xLocation = x;
            for (int y = this.dstHeight - 1; y >= 0; --y) {
                int yTimesNumContributors = y * this.verticalSubsamplingData.numContributors;
                int max = this.verticalSubsamplingData.arrN[y];
                int sampleLocation = y * this.dstWidth + x;
                double sample0 = 0.0;
                int index = yTimesNumContributors;
                for (int j = max - 1; j >= 0; --j) {
                    int valueLocation = this.verticalSubsamplingData.arrPixel[index];
                    double arrWeight = this.verticalSubsamplingData.arrWeight[index];
                    sample0 += workPixels[valueLocation][xLocation] * arrWeight;
                    ++index;
                }
                outPixels[sampleLocation] = sample0 < -128.0 ? -128.0 : (sample0 > 127.0 ? 127.0 : sample0);
            }
            ++this.processedItems;
            if (start != 0) continue;
            this.setProgress();
        }
    }

    private void horizontallyFromSrcToWork(double[] srcImg, double[][] workPixels, int start, int delta) {
        double[] srcPixels = new double[this.srcWidth];
        for (int k = start; k < this.srcHeight; k += delta) {
            System.arraycopy(srcImg, k * this.srcWidth, srcPixels, 0, this.srcWidth);
            for (int i = this.dstWidth - 1; i >= 0; --i) {
                int sampleLocation = i;
                int max = this.horizontalSubsamplingData.arrN[i];
                double sample0 = 0.0;
                int index = i * this.horizontalSubsamplingData.numContributors;
                for (int j = max - 1; j >= 0; --j) {
                    double arrWeight = this.horizontalSubsamplingData.arrWeight[index];
                    int pixelIndex = this.horizontalSubsamplingData.arrPixel[index];
                    sample0 += srcPixels[pixelIndex] * arrWeight;
                    ++index;
                }
                workPixels[k][sampleLocation] = sample0;
            }
            ++this.processedItems;
            if (start != 0) continue;
            this.setProgress();
        }
    }

    private void setProgress() {
        this.fireProgressChanged((float)this.processedItems / this.totalItems);
    }

    static class SubSamplingData {
        private final int[] arrN;
        private final int[] arrPixel;
        private final double[] arrWeight;
        private final int numContributors;

        private SubSamplingData(int[] arrN, int[] arrPixel, double[] arrWeight, int numContributors) {
            this.arrN = arrN;
            this.arrPixel = arrPixel;
            this.arrWeight = arrWeight;
            this.numContributors = numContributors;
        }

        public int getNumContributors() {
            return this.numContributors;
        }

        public int[] getArrN() {
            return this.arrN;
        }

        public int[] getArrPixel() {
            return this.arrPixel;
        }

        public double[] getArrWeight() {
            return this.arrWeight;
        }
    }
}

