/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.ResampleFilter;

final class MitchellFilter
implements ResampleFilter {
    private static final double B = 0.3333333333333333;
    private static final double C = 0.3333333333333333;

    MitchellFilter() {
    }

    @Override
    public double getSamplingRadius() {
        return 2.0;
    }

    @Override
    public final double apply(double value) {
        if (value < 0.0) {
            value = -value;
        }
        double tt = value * value;
        if (value < 1.0) {
            value = 7.0 * (value * tt) + -12.0 * tt + 5.333333333333333;
            return value / 6.0;
        }
        if (value < 2.0) {
            value = -2.3333333333333335 * (value * tt) + 12.0 * tt + -20.0 * value + 10.666666666666666;
            return value / 6.0;
        }
        return 0.0;
    }

    @Override
    public String getName() {
        return "BSpline";
    }
}

