/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.ResampleFilter;

final class Lanczos3Filter
implements ResampleFilter {
    Lanczos3Filter() {
    }

    private double sincModified(double value) {
        return Math.sin(value) / value;
    }

    @Override
    public final double apply(double value) {
        if (value == 0.0) {
            return 1.0;
        }
        if (value < 0.0) {
            value = -value;
        }
        if (value < 3.0) {
            return this.sincModified(value *= Math.PI) * this.sincModified(value / 3.0);
        }
        return 0.0;
    }

    @Override
    public double getSamplingRadius() {
        return 3.0;
    }

    @Override
    public String getName() {
        return "Lanczos3";
    }
}

