/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.ResampleFilter;

class BiCubicFilter
implements ResampleFilter {
    protected final double a;

    public BiCubicFilter() {
        this.a = -0.5;
    }

    protected BiCubicFilter(double a) {
        this.a = a;
    }

    @Override
    public final double apply(double value) {
        if (value == 0.0) {
            return 1.0;
        }
        if (value < 0.0) {
            value = -value;
        }
        double vv = value * value;
        if (value < 1.0) {
            return (this.a + 2.0) * vv * value - (this.a + 3.0) * vv + 1.0;
        }
        if (value < 2.0) {
            return this.a * vv * value - 5.0 * this.a * vv + 8.0 * this.a * value - 4.0 * this.a;
        }
        return 0.0;
    }

    @Override
    public double getSamplingRadius() {
        return 2.0;
    }

    @Override
    public String getName() {
        return "BiCubic";
    }
}

