﻿CREATE TABLE [dbo].[AspNetRoles] (
    [Id] [nvarchar](128) NOT NULL,
    [Name] [nvarchar](256) NOT NULL,
    CONSTRAINT [PK_dbo.AspNetRoles] PRIMARY KEY ([Id])
)
CREATE UNIQUE INDEX [RoleNameIndex] ON [dbo].[AspNetRoles]([Name])
CREATE TABLE [dbo].[AspNetUserRoles] (
    [UserId] [nvarchar](128) NOT NULL,
    [RoleId] [nvarchar](128) NOT NULL,
    CONSTRAINT [PK_dbo.AspNetUserRoles] PRIMARY KEY ([UserId], [RoleId])
)
CREATE INDEX [IX_UserId] ON [dbo].[AspNetUserRoles]([UserId])
CREATE INDEX [IX_RoleId] ON [dbo].[AspNetUserRoles]([RoleId])
CREATE TABLE [dbo].[AspNetUsers] (
    [Id] [nvarchar](128) NOT NULL,
    [Email] [nvarchar](256),
    [EmailConfirmed] [bit] NOT NULL,
    [PasswordHash] [nvarchar](max),
    [SecurityStamp] [nvarchar](max),
    [PhoneNumber] [nvarchar](max),
    [PhoneNumberConfirmed] [bit] NOT NULL,
    [TwoFactorEnabled] [bit] NOT NULL,
    [LockoutEndDateUtc] [datetime],
    [LockoutEnabled] [bit] NOT NULL,
    [AccessFailedCount] [int] NOT NULL,
    [UserName] [nvarchar](256) NOT NULL,
    CONSTRAINT [PK_dbo.AspNetUsers] PRIMARY KEY ([Id])
)
CREATE UNIQUE INDEX [UserNameIndex] ON [dbo].[AspNetUsers]([UserName])
CREATE TABLE [dbo].[AspNetUserClaims] (
    [Id] [int] NOT NULL IDENTITY,
    [UserId] [nvarchar](128) NOT NULL,
    [ClaimType] [nvarchar](max),
    [ClaimValue] [nvarchar](max),
    CONSTRAINT [PK_dbo.AspNetUserClaims] PRIMARY KEY ([Id])
)
CREATE INDEX [IX_UserId] ON [dbo].[AspNetUserClaims]([UserId])
CREATE TABLE [dbo].[AspNetUserLogins] (
    [LoginProvider] [nvarchar](128) NOT NULL,
    [ProviderKey] [nvarchar](128) NOT NULL,
    [UserId] [nvarchar](128) NOT NULL,
    CONSTRAINT [PK_dbo.AspNetUserLogins] PRIMARY KEY ([LoginProvider], [ProviderKey], [UserId])
)
CREATE INDEX [IX_UserId] ON [dbo].[AspNetUserLogins]([UserId])
ALTER TABLE [dbo].[AspNetUserRoles] ADD CONSTRAINT [FK_dbo.AspNetUserRoles_dbo.AspNetRoles_RoleId] FOREIGN KEY ([RoleId]) REFERENCES [dbo].[AspNetRoles] ([Id]) ON DELETE CASCADE
ALTER TABLE [dbo].[AspNetUserRoles] ADD CONSTRAINT [FK_dbo.AspNetUserRoles_dbo.AspNetUsers_UserId] FOREIGN KEY ([UserId]) REFERENCES [dbo].[AspNetUsers] ([Id]) ON DELETE CASCADE
ALTER TABLE [dbo].[AspNetUserClaims] ADD CONSTRAINT [FK_dbo.AspNetUserClaims_dbo.AspNetUsers_UserId] FOREIGN KEY ([UserId]) REFERENCES [dbo].[AspNetUsers] ([Id]) ON DELETE CASCADE
ALTER TABLE [dbo].[AspNetUserLogins] ADD CONSTRAINT [FK_dbo.AspNetUserLogins_dbo.AspNetUsers_UserId] FOREIGN KEY ([UserId]) REFERENCES [dbo].[AspNetUsers] ([Id]) ON DELETE CASCADE
CREATE TABLE [dbo].[__MigrationHistory] (
    [MigrationId] [nvarchar](150) NOT NULL,
    [ContextKey] [nvarchar](300) NOT NULL,
    [Model] [varbinary](max) NOT NULL,
    [ProductVersion] [nvarchar](32) NOT NULL,
    CONSTRAINT [PK_dbo.__MigrationHistory] PRIMARY KEY ([MigrationId], [ContextKey])
)
INSERT [dbo].[__MigrationHistory]([MigrationId], [ContextKey], [Model], [ProductVersion])
VALUES (N'201807050914249_Identity datamodel', N'OopRestaurant201807.Migrations.Configuration',  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

