﻿using System.Data.Entity;
using System.Security.Claims;
using System.Threading.Tasks;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.EntityFramework;

namespace OopRestaurant201807.Models
{
    // You can add profile data for the user by adding more properties to your ApplicationUser class, please visit https://go.microsoft.com/fwlink/?LinkID=317594 to learn more.
    public class ApplicationUser : IdentityUser
    {
        public async Task<ClaimsIdentity> GenerateUserIdentityAsync(UserManager<ApplicationUser> manager)
        {
            // Note the authenticationType must match the one defined in CookieAuthenticationOptions.AuthenticationType
            var userIdentity = await manager.CreateIdentityAsync(this, DefaultAuthenticationTypes.ApplicationCookie);
            // Add custom user claims here
            return userIdentity;
        }
    }

    /// <summary>
    /// Az adatok elérését lehetővé tevő osztály, több lépésben leszármaztatva
    /// a DbContext-ből. Az adattáblák elérését lehetővé tevő gyűjteményeket
    /// itt kell elhelyezni.
    /// </summary>
    public class ApplicationDbContext : IdentityDbContext<ApplicationUser>
    {
        public ApplicationDbContext()
            : base("DefaultConnection", throwIfV1Schema: false)
        {
        }

        /// <summary>
        /// Saját adattábla kerül az Identity adatbázisába
        /// </summary>
        public DbSet<MenuItem> MenuItems { get; set; }

        /// <summary>
        /// Ezt a hivatkozást a Controller varázsló gyártotta ide,
        /// enélkül nincs Categories controller, mert az adatokhoz
        /// nem fér hozzá közvetlenül, csak a MenuItems táblán keresztül
        /// </summary>
        public DbSet<Category> Categories { get; set; }

        public DbSet<Table> Tables { get; set; }
        public DbSet<Location> Locations { get; set; }

        public static ApplicationDbContext Create()
        {
            return new ApplicationDbContext();
        }

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<MenuItem>().Property(x => x.Category).HasDefaultValueSql();

            base.OnModelCreating(modelBuilder);
        }

    }
}