namespace OopRestaurant201807.Migrations
{
    using Microsoft.AspNet.Identity;
    using Microsoft.AspNet.Identity.EntityFramework;
    using OopRestaurant201807.Models;
    using System;
    using System.Data.Entity;
    using System.Data.Entity.Migrations;
    using System.Linq;

    internal sealed class Configuration : DbMigrationsConfiguration<OopRestaurant201807.Models.ApplicationDbContext>
    {
        public Configuration()
        {
            AutomaticMigrationsEnabled = false;
        }

        /// <summary>
        /// Ez a fggvny minden update-database futsakor a migrcis lpsek vgrehajtsa utn lefut
        /// </summary>
        /// <param name="context"></param>
        protected override void Seed(OopRestaurant201807.Models.ApplicationDbContext context)
        {
            //hozzuk ltre a kategrikat
            //Id Name
            //1   Levesek
            //2   Hideg eltelek
            //4   Meleg eltelek

            var category1 = new Category() { Name = "Levesek" };
            var category2 = new Category() { Name = "Hideg eltelek" };
            var category3 = new Category() { Name = "Meleg eltelek" };


            context.Categories.AddOrUpdate(x => x.Name, category1, category2, category3);
            //context.Categories.AddOrUpdate(x => x.Name, category2);
            //context.Categories.AddOrUpdate(x => x.Name, category3);

            //hozzuk ltre az teleket
            //Id Name    Description Price   Category_Id
            //1   Tengeri hal tri Atlanti lazactatr, pcolt lazacfil s tonhal lazackavirral   7500    2
            //3   Borjesszencia Zldsges gyngytyk galuska    4500    1
            //5   Szarvasgomba cappuccino NULL    4500    1
            //6   Hirtelen slt fogasderk illatos erdei gombkkal    NULL    4500    4
            //8   Gundel Kroly gulyslevese 1910 NULL    3500    1
            //9   Szrtott rlelt blszn carpaccio  reg Trappista sajt, keser levelek 5000    2

            context.MenuItems.AddOrUpdate(x => x.Name, new MenuItem()
            {
                Name = "Tengeri hal tri",
                Description = "Atlanti lazactatr, pcolt lazacfil s tonhal lazackavirral",
                Price = 7500,
                Category = category2
            });

            context.MenuItems.AddOrUpdate(x => x.Name, new MenuItem()
            {
                Name = "Borjesszencia",
                Description = "Zldsges gyngytyk galuska (mdostva)",
                Price = 4500,
                Category = category1
            });

            context.MenuItems.AddOrUpdate(x => x.Name, new MenuItem()
            {
                Name = "Szarvasgomba cappuccino",
                Price = 4500,
                Category = category1
            });

            context.MenuItems.AddOrUpdate(x => x.Name, new MenuItem()
            {
                Name = "Hirtelen slt fogasderk illatos erdei gombkkal",
                Price = 4500,
                Category = category3
            });

            context.MenuItems.AddOrUpdate(x => x.Name, new MenuItem()
            {
                Name = "Gundel Kroly gulyslevese 1910",
                Price = 3500,
                Category = category1
            });

            context.MenuItems.AddOrUpdate(x => x.Name, new MenuItem()
            {
                Name = "Szrtott rlelt blszn carpaccio",
                Description = "reg Trappista sajt, keser levelek",
                Price = 5000,
                Category = category2
            });




            //helysznek feltltse
            var loc1 = new Location { Name = "Nemdohnyz terem", IsNonSmoking = true };
            var loc2 = new Location { Name = "Dohnyz terem", IsNonSmoking = false };
            var loc3 = new Location { Name = "Terasz", IsNonSmoking = false };
            context.Locations.AddOrUpdate(x => x.Name, loc1, loc2, loc3);

            context.Tables.AddOrUpdate(x => x.Name,
                new Table { Name = "1. asztal", Location = loc1 },
                new Table { Name = "2. asztal", Location = loc1 },
                new Table { Name = "3. asztal", Location = loc2 },
                new Table { Name = "4. asztal", Location = loc2 },
                new Table { Name = "5. asztal", Location = loc3 },
                new Table { Name = "6. asztal", Location = loc3 }
            );

            //cook, waiter, admin
            // jogosultsgcsoport rgztse
            AddRoleIfNotExists(context, "admin");
            AddRoleIfNotExists(context, "cook");
            AddRoleIfNotExists(context, "waiter");

            //felhasznlk rgztse
            AddUserIfNotExists(context, "gabor.plesz@gmail.com", "gabor.plesz@gmail.com", "admin,cook,waiter");
            AddUserIfNotExists(context, "pincer@gmail.com", "pincer@gmail.com", "waiter");
            AddUserIfNotExists(context, "szakacs@gmail.com", "szakacs@gmail.com", "cook");
        }


        /// <summary>
        /// Felhasznlcsoport rgztse, ha mg nem ltezik
        /// </summary>
        /// <param name="context"></param>
        /// <param name="roleName"></param>
        private void AddRoleIfNotExists(ApplicationDbContext context, string roleName)
        {

            //RoleStore: adatbzist r rteg
            //RoleManager: az alkalmazs fel az egysges fellet

            var store = new RoleStore<IdentityRole>(context);
            var manager = new RoleManager<IdentityRole>(store);

            var roleExists= manager.FindByName(roleName);
            if (roleExists==null)
            { //nincs mg ilyen, ltre kell hoznunk
                var role = new IdentityRole(roleName);
                var result = manager.Create(role);

                if (!result.Succeeded)
                {
                    throw new Exception(string.Join(",", result.Errors));
                }
            }
        }

        /// <summary>
        /// felhasznl rgztse, ha mg nem ltezik
        ///   figyelem: nem rgztnk adatbzisba kzvetlenl adatot, 
        ///   hanem az Identity ltal knlt szolgltats(oka)t hasznljuk
        /// </summary>
        /// <param name="context"></param>
        /// <param name="userName"></param>
        /// <param name="email"></param>
        private static void AddUserIfNotExists(ApplicationDbContext context, string userName, string email, string roles)
        {
            var user = new ApplicationUser
            {
                UserName = userName,
                Email = email,
            };

            //UserStore: ez felel az adatok rgztsrt
            //UserManager: a programozsi fellet.
            //context <- UserStore <- UserManager

            var store = new UserStore<ApplicationUser>(context);
            var manager = new ApplicationUserManager(store);

            //ellenrizni kell, hogy ltezik-e mr ilyen felhasznl?
            var userExists = manager.FindByEmail(user.Email);
            if (null == userExists)
            { // mg nincs ilyen felhasznl, rgztsk
              //itt megadjuk a felhasznl jelszavt, s 
              //gy az Identity generlja az adatbzisba rt HASH kdot
                var result = manager.Create(user, "123456");
                if (!result.Succeeded)
                {

                    ////a legrszletesebb megolds
                    //var errorMessage = "";
                    //foreach (var error in result.Errors)
                    //{
                    //    if (string.IsNullOrEmpty(errorMessage))
                    //    {
                    //        errorMessage = error;
                    //    }
                    //    else
                    //    {
                    //        errorMessage = errorMessage + ", " + error;
                    //    }
                    //}

                    ////elz megolds tmrtve
                    //foreach (var error in result.Errors)
                    //{
                    //    //feltteles (ternris) opertor hasznlata
                    //    errorMessage = errorMessage
                    //        + (string.IsNullOrEmpty(errorMessage) ? "" : ",")
                    //        + error;
                    //}

                    //a legtmrebb megolds pedig a string osztly beptett Join fggvnye
                    throw new Exception(string.Join(",", result.Errors));
                }

                //hozzrendels jogosultsgcsoportokhoz
                foreach (var role in roles.Split(',')) //a vessz mentn sztszedjk a paramtert tmbre, amin vgigstlunk
                {
                    manager.AddToRole(user.Id, role);
                }
            }
        }
    }
}
