![](https://github.com/OloOcki/awesome-citygml/blob/main/img/awesomeGif.gif)

# :cityscape: Awesome CityGML 🌆
The ultimate list of open source semantic city models. Albeit great effort of several institutions (e.g., [CityGML Wiki](https://www.citygmlwiki.org/index.php?title=Open_Data_Initiatives), [TU Delft](https://3d.bk.tudelft.nl/opendata/opencities/), [Towards Data Science](https://towardsdatascience.com/open-source-3d-semantical-building-models-in-2020-f47c91f6cd97)) the list of open datasets for cities/regions is still incomplete. It is believed that empowering the *awesome* -tag community will solve the problem! 

  
Please feel free to contribute or write to olaf.wysocki@tum.de!

For *"What software for the models?"* question find an answer [under the subpage](https://github.com/OloOcki/awesome-citygml/blob/main/software.md).

If you use this repo please considering linking it or citing the [paper](https://isprs-archives.copernicus.org/articles/XLVIII-4-2024/493/2024/):
```plain
@article{wysocki2024reviewing,
  title={Reviewing Open Data Semantic 3D City Models to Develop Novel 3D Reconstruction Methods},
  author={Wysocki, Olaf and Schwab, Benedikt and Beil, Christof and Holst, Christoph and Kolbe, Thomas H},
  journal={The International Archives of the Photogrammetry, Remote Sensing and Spatial Information Sciences},
  volume={48},
  pages={493--500},
  year={2024},
}
```


# Stats

Last update: 19/08/2024

2️⃣1️⃣ countries + 1️⃣ artificial! **||** 6️⃣3️⃣ regions/cities + 1️⃣ artificial! 

More than 2️⃣1️⃣5️⃣ mln buildings freely available - see more details in the [paper](https://isprs-archives.copernicus.org/articles/XLVIII-4-2024/493/2024/)!

# Tags

Follow the tags to discover what is inside the dataset!

- Building: 🏠 
- Street space: 🚗
- Vegetation: 🌲 
- Terrain: 🗻
- City Furniture: 🚦 
- Textures: 🎇 
- Generic City Object: ⛲ 
- LoD 1: 1️⃣
- LoD 2: 2️⃣
- LoD 3: 3️⃣
- LoD 4: 4️⃣
- Mixed LoDs: 🔢
- Historical data: ⌛   

**Attention!** Units that publish their 3D models as open datasets but not in the CityGML-like standard (aka. semantic city models) are marked by :large_orange_diamond:


# List of Countries

- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/AU@2x.png?raw=true' width='21' height='15'> [Australia](#Australia)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/AT@2x.png?raw=true' width='21' height='15'> [Austria](#Austria)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/BE@2x.png?raw=true' width='21' height='15'> [Belgium](#Belgium)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/CA%402x.png?raw=true' width='21' height='15'> [Canada](#Canada)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/CN@2x.png?raw=true' width='21' height='15'> [China](#China)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/CZ@2x.png?raw=true' width='21' height='15'> [Czechia](#Czechia)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/EE%402x.png?raw=true' width='21' height='15'> [Estonia](#Estonia)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/FI%402x.png?raw=true' width='21' height='15'> [Finland](#Finland)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/FR@2x.png?raw=true' width='21' height='15'> [France](#France)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/DE@2x.png?raw=true' width='21' height='15'>  [Germany](#Germany)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/IE@2x.png?raw=true' width='21' height='15'>  [Ireland](#Ireland)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/JP@2x.png?raw=true' width='21' height='15'>  [Japan](#Japan)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/LV@2x.png?raw=true' width='21' height='15'>  [Latvia](#Latvia)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/LI@2x.png?raw=true' width='21' height='15'>  [Liechtenstein](#Liechtenstein)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/LU@2x.png?raw=true' width='21' height='15'>  [Luxembourg](#Luxembourg)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/NL@2x.png?raw=true' width='21' height='15'>  [Netherlands](#Netherlands)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/GB@2x.png?raw=true' width='21' height='15'>  [UK](#UK)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/US@2x.png?raw=true' width='21' height='15'>  [USA](#USA)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/PL@2x.png?raw=true' width='21' height='15'>  [Poland](#Poland)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/SG@2x.png?raw=true' width='21' height='15'>  [Singapore](#Singapore)
- <img src='https://github.com/madebybowtie/FlagKit/blob/master/Assets/PNG/CH@2x.png?raw=true' width='21' height='15'>  [Switzerland](#Switzerland)

- :triangular_flag_on_post: [ArtificialCities](#ArtificialCities)



## Australia

- **Adelaide** :large_orange_diamond: datasets prepared for the immediate utilisation in Unreal Engine and CAD software (FBX, Skp etc.) but also in Esri Multipatch format

[🗻] [🏠] [🎇] [1️⃣] [2️⃣] [🔢] 

[[Download](https://data.sa.gov.au/data/dataset/3d-model)] [[More](https://indaily.com.au/news/business/2018/02/16/aussie-firm-beats-french-tech-giant-build-3d-model-adelaide/)] 

- **Melbourne** detailed street space representation in LoD 1 & 2 (see download section)

[🚗] [🏠] [1️⃣] [2️⃣]

[[Download](http://www.3dcitydb.net/3dcitydb/fileadmin/public/datasets/Melbourne/Melbourne_Streetspace_CityGML.zip)] [[VisualisationLoD2](http://www.3dcitydb.org/3dcitydb-web-map/1.8.2/3dwebclient/?title=Melbourne_Streetspace_LoD2&shadows=false&terrainShadows=0&latitude=-37.808172850916705&longitude=144.96510794314432&height=443.4330303601941&heading=9.896470830181748&pitch=-74.89240010024886&roll=359.87863005263307&layer_0=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FMelbourne%252FMelbourne_Streetspace_LoD2%252FMelbourne_Carriageway_LoD2%252FMelbourne_Carriageway_LoD2_geometry_MasterJSON.json%26name%3DMelbourne_Carriageway_LoD2%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D2.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1sw1Lh9m1DTJotSa8Bbr4BKHQF9WkseRmeAjsS2ypVWw%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_1=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FMelbourne%252FMelbourne_Streetspace_LoD2%252FMelbourne_Footpath_LoD2%252FMelbourne_Footpath_LoD2_geometry_MasterJSON.json%26name%3DMelbourne_Footpath_LoD2%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D2.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F15igWEPL_Hicfu1t29ryzSsPa593h48uYwgDp9sy4pAY%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_2=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FMelbourne%252FMelbourne_Streetspace_LoD2%252FMelbourne_Median_LoD2%252FMelbourne_Median_LoD2_geometry_MasterJSON.json%26name%3DMelbourne_Median_LoD2%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D2.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1b7jpctmo2mPAh0cyZ_WpGipr9Ea2klRRJVTos7spJ4E%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_3=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FMelbourne%252FMelbourne_Streetspace_LoD2%252FMelbourne_Kerb_LoD2%252FMelbourne_Kerb_LoD2_geometry_MasterJSON.json%26name%3DMelbourne_Kerb_LoD2%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D2.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1KOI0fZx9y1AsCPpFAxF2OK7clnrHaSu069AN4GoIVKs%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_4=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FMelbourne%252FMelbourne_Streetspace_LoD2%252FMelbourne_Parking_Bay_LoD2%252FMelbourne_Parking_Bay_LoD2_geometry_MasterJSON.json%26name%3DMelbourne_Parking_Bay_LoD2%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D2.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1tGuB2_Ckt14Fq6ws6b2_gldTob4tF_JeFxPpFj8adLk%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_5=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FMelbourne%252FMelbourne_Streetspace_LoD2%252FMelbourne_Road_Channel_LoD2%252FMelbourne_Road_Channel_LoD2_geometry_MasterJSON.json%26name%3DMelbourne_Road_Channel_LoD2%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D2.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1Y2gAOvFa2B3_dg24ptrzH0V3k5n3bUNn7UgRJ2V9jFE%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_6=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FMelbourne%252FMelbourne_Streetspace_LoD2%252FMelbourne_Tramway_LoD2%252FMelbourne_Tramway_LoD2_geometry_MasterJSON.json%26name%3DMelbourne_Tramway_LoD2%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D2.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F146HHsN82mpNzAr6g6CAXQCMBLupGeaGwmvfsOT1oQQc%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_7=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FMelbourne%252FMelbourne_Building_LoD1%252FMelbourne_Building_LoD1_collada_MasterJSON.json%26name%3DMelbourne_Building_LoD1%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D2.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1vAfXUTi6YbgHh1SvfmkPGjMNgPALKKATqcyqbg9SyXs%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&splashWindow=url%3Dsplash%252FSplashWindow.html%26showOnStart%3Dtrue)] [[VisualisationLoD1](https://www.3dcitydb.org/3dcitydb-web-map/1.7.2/3dwebclient/index.html?title=Melbourne_Streetspace_LoD1&shadows=false&terrainShadows=0&latitude=-37.81011251757671&longitude=144.9631999448069&height=656.2681691357357&heading=7.505459775427195&pitch=-59.50883495500552&roll=359.9523173380835&layer_0=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FMelbourne%252FMelbourne_Streetspace_LoD1%252FMelboune_Streetspace_LoD1_geometry_MasterJSON.json%26name%3DMelbourne_Streetspace_LoD1%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fwww.google.com%252Ffusiontables%252FDataSource%253Fdocid%253D1it5kP2V1yAHnzMyvxbgWqKdYKNqY27pquDK_8u19%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_1=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FMelbourne%252FMelbourne_Building_LoD1%252FMelbourne_Building_LoD1_collada_MasterJSON.json%26name%3DMelbourne_Building_LoD1%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D2.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fwww.google.com%252Ffusiontables%252FDataSource%253Fdocid%253D14wGFcpPSVRtqsOG8aMhGjUAjOhuVtxjk7C-NmysA%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&splashWindow=url%3Dsplash%252FSplashWindow.html%26showOnStart%3Dfalse)] [[More](https://wiki.tum.de/display/gisproject/Download+Section)] 

- **Victoria** :large_orange_diamond: the whole state reperesented with at least LoD1 up to LoD2 building models in Melbourne and vicinity. Some districts are also textured.

[🏠] [🎇] [1️⃣] [2️⃣] [🔢]

[[Download](https://www.land.vic.gov.au/maps-and-spatial/spatial-data/vicmap-catalogue/vicmap-buildings)] [[Visualisation](https://vic.digitaltwin.terria.io/#share=s-nM5NdVNTjXBNrKqSqpK5NNnKuyi)] [[More](https://www.land.vic.gov.au/maps-and-spatial/spatial-data/vicmap-catalogue/vicmap-buildings)][[Point cloud](https://www.land.vic.gov.au/maps-and-spatial/spatial-data/vicmap-catalogue/vicmap-elevation)] 


## Austria


- **Linz** 3D buildings of the city of Linz available in LoD2

[🏠] [🎇] [2️⃣] 

[[Download](http://geo.data.linz.gv.at/katalog/geodata/3d_geo_daten_lod2/)] [[Visualisation](https://3d.linz.at/)] [[More](https://www.linz.at/stadtentwicklung/linz3d.php)] 


- **Vienna** 3D buildings of the capital city of Austria available in LoD1 and 2. To access the full dataset go to Visualisation link -> activate the layer "Generalisiertes Dachmodell (LOD2)" or "Baukörpermodell (LOD1)" -> click on a tile to download the respective model. Also one can access samples of datasets and more info from the list in the Download link.

[🏠][1️⃣][2️⃣] 

[[Download](https://www.wien.gv.at/stadtentwicklung/stadtvermessung/geodaten/viewer/geodatendownload.html)] [[Visualisation](https://www.wien.gv.at/ma41datenviewer/public/start.aspx)] [[More](https://www.data.gv.at/katalog/dataset/generalisiertes-dachmodell)] [[More2](https://www.wien.gv.at/stadtentwicklung/stadtvermessung/geodaten/mobile-mapping/index.html)]


## Belgium

- **Brussels** :large_orange_diamond: various datasets as SketchUp (previously CityGML available)

[🏠] [2️⃣] 

[[Download](https://datastore.brussels/web/urbis-download)] [[More](https://urbisdownload-backend.datastore.brussels/rest/documentation?language=EN)] [[More2](https://medium.com/@timdecraecker/creating-a-city-landscape-in-blender-3d-a06015eb0a1b)]

- **Namur** textured LoD2 buildings and examples of [[citadel and bridges](https://data.namur.be/explore/dataset/namur-3d-citadelle-et-ponts/table/)]  for city of Namur in CityGML and Skp format

[🏠] [2️⃣] 

[[Download](https://data.namur.be/explore/dataset/namur-3d-batiments-textures-par-dalle-de-200m/table/?location=14,50.46467,4.8669&basemap=jawg.streets&dataChart=eyJxdWVyaWVzIjpbeyJjb25maWciOnsiZGF0YXNldCI6Im5hbXVyLTNkLWJhdGltZW50cy10ZXh0dXJlcy1wYXItZGFsbGUtZGUtMjAwbSIsIm9wdGlvbnMiOnt9fSwiY2hhcnRzIjpbeyJhbGlnbk1vbnRoIjp0cnVlLCJ0eXBlIjoiY29sdW1uIiwiZnVuYyI6IkNPVU5UIiwic2NpZW50aWZpY0Rpc3BsYXkiOnRydWUsImNvbG9yIjoiIzAxMUY0OSJ9XSwieEF4aXMiOiJub20iLCJtYXhwb2ludHMiOjUwLCJzb3J0IjoiIn1dLCJ0aW1lc2NhbGUiOiIiLCJkaXNwbGF5TGVnZW5kIjp0cnVlLCJhbGlnbk1vbnRoIjp0cnVlfQ%3D%3D)] [[Visualisation](https://data.namur.be/explore/dataset/namur-3d-batiments-textures-par-dalle-de-200m/map/?location=14,50.46467,4.8669&basemap=jawg.streets&dataChart=eyJxdWVyaWVzIjpbeyJjb25maWciOnsiZGF0YXNldCI6Im5hbXVyLTNkLWJhdGltZW50cy10ZXh0dXJlcy1wYXItZGFsbGUtZGUtMjAwbSIsIm9wdGlvbnMiOnt9fSwiY2hhcnRzIjpbeyJhbGlnbk1vbnRoIjp0cnVlLCJ0eXBlIjoiY29sdW1uIiwiZnVuYyI6IkNPVU5UIiwic2NpZW50aWZpY0Rpc3BsYXkiOnRydWUsImNvbG9yIjoiIzAxMUY0OSJ9XSwieEF4aXMiOiJub20iLCJtYXhwb2ludHMiOjUwLCJzb3J0IjoiIn1dLCJ0aW1lc2NhbGUiOiIiLCJkaXNwbGF5TGVnZW5kIjp0cnVlLCJhbGlnbk1vbnRoIjp0cnVlfQ%3D%3D)]  [[More](https://data.namur.be/explore/dataset/namur-3d-batiments-textures-par-dalle-de-200m/information/?location=14,50.46467,4.8669&basemap=jawg.streets&dataChart=eyJxdWVyaWVzIjpbeyJjb25maWciOnsiZGF0YXNldCI6Im5hbXVyLTNkLWJhdGltZW50cy10ZXh0dXJlcy1wYXItZGFsbGUtZGUtMjAwbSIsIm9wdGlvbnMiOnt9fSwiY2hhcnRzIjpbeyJhbGlnbk1vbnRoIjp0cnVlLCJ0eXBlIjoiY29sdW1uIiwiZnVuYyI6IkNPVU5UIiwic2NpZW50aWZpY0Rpc3BsYXkiOnRydWUsImNvbG9yIjoiIzAxMUY0OSJ9XSwieEF4aXMiOiJub20iLCJtYXhwb2ludHMiOjUwLCJzb3J0IjoiIn1dLCJ0aW1lc2NhbGUiOiIiLCJkaXNwbGF5TGVnZW5kIjp0cnVlLCJhbGlnbk1vbnRoIjp0cnVlfQ%3D%3D)] 

## Canada

- **Calgary** :large_orange_diamond: LoD2 building models in as CAD and GDB files

[🏠][2️⃣] 

[[Download](https://data.calgary.ca/Base-Maps/3D-Buildings-Citywide/cchr-krqg/about_data)] [[Visualisation](https://mapgallery.calgary.ca/apps/bcd22e7089a440e792628ac61f35f4c1/explore)] [[More](https://data.calgary.ca/Base-Maps/3D-Buildings-Citywide/cchr-krqg/about_data)] 

- **Montreal** terrain and buildings in various formats also ALS dataset available

[🗻] [🏠] [🎇] [2️⃣] 

[[Download](https://donnees.montreal.ca/ville-de-montreal/maquette-numerique-plateau-mont-royal-batiments-lod2-avec-textures)] [[Visualisation](https://transfer.hft-stuttgart.de/pages/montreal-citygml/web3Dviewer/)] [[More](https://open.canada.ca/data/en/dataset/58dd9b17-8242-4013-bf9d-0c8d3d93f081)] 

- **Toronto** :large_orange_diamond: building models in various formats

[🏠][1️⃣] 

[[Download](https://open.toronto.ca/dataset/3d-massing/)] [[More](https://open.toronto.ca/dataset/3d-massing/)] 


## China

- **China** LoD1 building models for several cities (Tianjin, Shanghai, Beijing) with the promised nationwide extension. The builidings are saved as .shp files, where the rooftop type is identified but not modeled; Part of the research project.

[🏠][1️⃣]

[[Download](https://github.com/AICyberTeam/GABLE)] [[More](https://www.sciencedirect.com/science/article/pii/S0034425724000683)] 

## Czechia

- **Brno** :large_orange_diamond: LoD1, roof models, and bridges in SHP and DWG

[🏠][1️⃣][⛲]

[[Download](https://data.gov.cz/datasets?query=3D%20brno)] [[More](https://data.gov.cz/datasets?query=3D%20brno)]


- **Prague** LoD2 building models, bridges, and DEM 1m model of the whole city and its vicinity

[🗻][🏠][2️⃣][⛲]

[[Download](https://geoportalpraha.cz/en/data-and-services/7e6316e95cfe4f36ae06bbfb687bf34b)] [[Visualisation](https://geoportalpraha.cz/en/data-and-services/7e6316e95cfe4f36ae06bbfb687bf34b)] [[More](https://geoportalpraha.cz/en/data-and-services/7e6316e95cfe4f36ae06bbfb687bf34b)]

## Estonia

- **Estonia** building models in LoD1 and LoD2 in various formats as well as DTM and DSM

[🗻] [🏠] [🚗] [🎇] [1️⃣] [2️⃣] 


[[Download](https://geoportaal.maaamet.ee/eng/Download-3D-data-p837.html)] [[More](https://geoportaal.maaamet.ee/eng/Spatial-Data/Geo3D/3D-Data-p836.html)] 

## Finland

- **Espoo** various of data consisting of water bodies, roads, land use, relief, vegetation and buildings. Note that LoD3 does not cosists of windows, doors etc. but rather marks texturing (see More for detailed explanation).

[🏠][🚗] [🌲] [🗻] [🚦] [🎇] [1️⃣] [2️⃣] [3️⃣] [🔢]


[[Download](https://kartat.espoo.fi/3d/services_en.html)] [[Visualisation](https://www.youtube.com/watch?v=b0Rwphtuspk&feature=emb_logo)] [[More](https://kartat.espoo.fi/3d/citymodel_en.html)] 


- **Helsinki** has a semantic model and a reality mesh model

[🏠] [🎇] [1️⃣] [2️⃣]

[[Download](https://kartta.hel.fi/3d/#/)] [[Visualisation](https://kartta.hel.fi/3d/#/)] [[More](https://hri.fi/data/en_GB/dataset/helsingin-3d-kaupunkimalli)] 

- **Kuopio** textured building models with various timestamps, available in CityGML 2.0 format and DWG

[🏠] [⌛] [🎇] [1️⃣] [2️⃣] 

[[Download](https://data.europa.eu/data/datasets/1cda485e-0c0a-4f77-9f7d-185bae9144f7?locale=en)] [[Visualisation](https://kuopio.kunta3d.fi/Map.html)] [[More](https://data.europa.eu/data/datasets/1cda485e-0c0a-4f77-9f7d-185bae9144f7?locale=en)] 

- **Vantaa** LoD1 and LoD2 building models available in the CityGML, Sketchup and KML formats. CityGML buildings also include roof and wall textures added based on oblique aerial images

[🏠] [🎇] [1️⃣] [2️⃣] 

[[Download](https://www.betaavoindata.fi/data/en_GB/dataset/vantaan-3d-rakennukset)] [[Visualisation](https://kartta.vantaa.fi/?setlanguage=fi&e=25501410.86&n=6688959.38&r=32&w=**&l=Kaupunkikartta_gd2%2Calueet_suuralueet%2Calueet_kaupunginosat&o=100%2C100%2C100#)] [[More](https://www.betaavoindata.fi/data/en_GB/dataset/vantaan-3d-rakennukset)] 
 

## France

- **Bordeaux** :large_orange_diamond: city of Bordeaux in 3DS format

[🏠][🎇][2️⃣]

[[Download](https://opendata.bordeaux-metropole.fr/explore/dataset/bati3d/information/)] [[More](https://opendata.bordeaux-metropole.fr/explore/dataset/bati3d/information/)]

- **Lyon** has a semantic model and also historic datasets from 2009, 2012 and 2015

[🏠][🎇][2️⃣] [⌛]

[[Download](
https://data.grandlyon.com/jeux-de-donnees/maquettes-3d-texturees-2018-communes-metropole-lyon/donnees)] [[Download Historic](https://zenodo.org/record/3611354#.YCFqPS0xm-o)]

## Germany

- **Baden-Württemberg** the complete state of Baden-Württemberg in LoD1 and LoD2, also including orthophotos and DEM1

[🏠][1️⃣][2️⃣][🗻]

[[Download LoD1](https://opengeodata.lgl-bw.de/#/(sidenav:product/13)))] [[Download LoD2](https://opengeodata.lgl-bw.de/#/(sidenav:product/12))] [[More](https://www.lgl-bw.de/Produkte/Open-Data/)]

- **Bavaria** the complete state of Bavaria in LoD2, also including orthopohotos and DEM1

[🏠][2️⃣][🗻]

[[Download](https://geodaten.bayern.de/opengeodata/OpenDataDetail.html?pn=lod2)] [[Visualisation](https://geoportal.bayern.de/bayernatlas/?lang=de&topic=ba&bgLayer=atkis&catalogNodes=11&layers=WMS%7C%7COpendata_Auswahl_LoD2%7C%7Chttps:%2F%2Fgeoservices.bayern.de%2Fwms%2Fv1%2Fopendatagrid%7C%7Clod2%7C%7C1.1.1&lon=11.47015&lat=46.65297&elevation=184167&heading=360.000&pitch=-43.711)] [[Visualisation_VCS](https://www.virtualcitymap.de/?lang=de&layerToActivate=%5B%22Bayern%20-%20LOD2%20(pbr)%22%2C%22Sachsen%20-%20LOD2%20(pbr%20recalculation)%22%2C%22Sachsen-Anhalt%20-%20LOD2%20(pbr%20recalculation)%22%2C%22Th%C3%BCringen%20-%20LOD2%20(pbr%20recalculation)%22%2C%22Niedersachsen%20(pbr%20recalculation)%22%2C%22NRW%20-%20LOD2%20(pbr%20recalculation)%22%2C%22Hessen%20-%20LOD2%20(pbr%20recalculation)%22%2C%22Hamburg%20-%20LOD2%20(pbr%20recalculation)%22%2C%22Brandenburg%20-%20LOD2%20(pbr%20recalculation)%22%2C%22Berlin%20untexturiert%20openData%20(pbr%20recalculation)%22%2C%22GermanyBaseTerrain%22%5D&layerToDeactivate=%5B%22Mesh%20Classification%20Layer%22%2C%22mesh_surface%22%5D&startingmap=Cesium%20Map&cameraPosition=11.56810%2C48.13646%2C760.10638&groundPosition=11.57355%2C48.13889%2C527.52229&distance=539.84&pitch=-25.52&heading=56.33&roll=0.18#/legend)]  [[More](https://geodaten.bayern.de/opengeodata/)]

- **Berlin** the model of German capital also has mesh available

[🏠][🎇][2️⃣]

[[Download LoD1](https://gdi.berlin.de/geonetwork/srv/ger/catalog.search#/metadata/e2a1e24e-bd9a-3de4-86af-af1a7a21a29e)][[Download LoD2](https://gdi.berlin.de/geonetwork/srv/ger/catalog.search#/metadata/3c7c49af-00a4-3bcd-bc00-20e7f0f1b7bf)][[Download mesh](https://www.businesslocationcenter.de/berlin3d-downloadportal/?lang=en#/export)] [[Visualisation](https://www.3dcitydb.org/3dcitydb-web-map/1.7/3dwebclient/index.html?title=Berlin_Demo&batchSize=1&latitude=52.517479728958044&longitude=13.411141287558161&height=534.3099172951087&heading=345.2992773976952&pitch=-44.26228062802528&roll=359.933888621294&layer_0=url%3Dhttps%253A%252F%252Fwww.3dcitydb.org%252F3dcitydb%252Ffileadmin%252Fmydata%252FBerlin_Demo%252FBerlin_Buildings_rgbTexture_ScaleFactor_0.3%252FBerlin_Buildings_rgbTexture_collada_MasterJSON.json%26name%3DBrlin_Buildings_rgbTexture%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fwww.google.com%252Ffusiontables%252FDataSource%253Fdocid%253D19cuclDgIHMqrRQyBwLEztMLeGzP83IBWfEtKQA3B%2526pli%253D1%2523rows%253Aid%253D1%26cityobjectsJsonUrl%3D%26minLodPixels%3D100%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200)] [[More](https://www.businesslocationcenter.de/en/economic-atlas/download-portal/)] [[Point clouds](https://gdi.berlin.de/geonetwork/srv/ger/catalog.search#/metadata/f4a8997d-4dea-382f-aa3a-d452f4bf3943)]

- **Brandenburg** various datasets of Brandenburg including LoD1 and LoD2 building models

[🏠][1️⃣][2️⃣][🗻]

[[Download LoD1](https://data.geobasis-bb.de/geobasis/daten/3d_gebaeude/lod1_gml/)] [[Download LoD2](https://data.geobasis-bb.de/geobasis/daten/3d_gebaeude/lod2_gml/)] [[More](https://data.geobasis-bb.de/geobasis/daten/)]

- **Bremen** LoD1 and LoD2 models of the city of Bremen (from 9th of June '24)

[1️⃣][2️⃣]

[[Download](https://www.geo.bremen.de/produkte/3d-produkte/3d-gebaeudemodelle-11892)] [[More](https://www.geo.bremen.de/produkte/3d-produkte/3d-gebaeudemodelle-11892)] [[ALS](https://www.geo.bremen.de/produkte/3d-produkte/hoehenmodelle-12482)]


- **Freiburg** 3D building model of the entire City of Freiburg

[🏠][1️⃣][2️⃣]

[[Download LoD1](https://geodaten.freiburg.de/geonetwork/srv/ger/catalog.search#/metadata/164ceef4-6c67-4763-8100-c5799a2ea6d8)] [[Download LoD2](https://geodaten.freiburg.de/geonetwork/srv/ger/catalog.search#/metadata/1c576440-e5e1-4095-bff1-a14d76cec6f4)] [[Visualisation](https://3d.freiburg.de/#/)] [[More](https://geodaten.freiburg.de/geonetwork/srv/ger/catalog.search#/metadata/f4c62c54-4a27-409b-9e82-a55cb4783801)]


- **Hamburg** 3D models of the city of Hamburg in LoD1 & LoD2 over multiple years. Extended by LoD2 manually improved roof types and texturized.

[🏠][🎇][1️⃣][2️⃣][⌛]

[[Download](https://suche.transparenz.hamburg.de/dataset/3d-stadtmodell-lod2-de-hamburg2)] [[Download detailed LoD2](https://metaver.de/trefferanzeige?docuuid=B438AD57-223B-43A4-8E74-767CEC8A96D7)] [[Visualisation](https://geoportal-hamburg.de/geo-online/)] [[More](http://transparenz.hamburg.de/das-transparenzportal/)]

- **Hannover** 3D building models of the city of Hannover in CityGML and in DWG

[🏠][1️⃣][2️⃣]

[[Download](https://www.hannover.de/Leben-in-der-Region-Hannover/Verwaltungen-Kommunen/Die-Verwaltung-der-Landeshauptstadt-Hannover/Dezernate-und-Fachbereiche-der-LHH/Stadtentwicklung-und-Bauen/Fachbereich-Planen-und-Stadtentwicklung/Geoinformation/Open-GeoData/3D-Stadtmodell-und-Gel%C3%A4ndemodell/Digitales-3D-Stadtmodell)]


- **Hessen** 3D building models of the state of Hessen in CityGML along with DEM1 and DSM1

[🏠][2️⃣][🗻]

[[Download](https://gds.hessen.de/INTERSHOP/web/WFS/HLBG-Geodaten-Site/de_DE/-/EUR/ViewDownloadcenter-Start;pgid=NIZSrncl7gBSRpNPt1AR16YC0000D-qCFKhx)] [[More](https://gds.hessen.de/INTERSHOP/web/WFS/HLBG-Geodaten-Site/de_DE/-/EUR/ViewDownloadcenter-Start;pgid=NIZSrncl7gBSRpNPt1AR16YC0000D-qCFKhx)]


- **Ingolstadt** 3D models of the city of Ingolstadt in SketchUp and CityGML in LoD3

[🏠][🎇][3️⃣]


[[Download](https://github.com/savein/lod3-road-space-models/releases)] [[Visualisation](https://www.3dcitydb.net/3dcitydb-web-map/1.6.1/3dwebclient/?title=Ingolstadt_CityGML_LoD3_Demo&shadows=false&terrainShadows=0&latitude=48.76421616414265&longitude=11.423261087465157&height=189.46220553536946&heading=170.97575939059712&pitch=-39.02715451772515&roll=0.03843163755915946&layer_0=url%3Dhttps%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252Fingolstadt%252Fingolstadt_lod3%252Fkml_ingolstadt_trafficareas%252Fkml_ingolstadt_trafficareas_collada_MasterJSON.json%26name%3DIngolstadt_CityGML_TrafficArea%26active%3Dtrue%26spreadsheetUrl%3D%26cityobjectsJsonUrl%3D%26minLodPixels%3D0%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_1=url%3Dhttps%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252Fingolstadt%252Fingolstadt_lod3%252Fkml_ingolstadt_auxiliarytrafficareas%252Fkml_ingolstadt_auxiliarytrafficareas_collada_MasterJSON.json%26name%3DIngolstadt_CityGML_AuxiliaryTrafficArea%26active%3Dtrue%26spreadsheetUrl%3D%26cityobjectsJsonUrl%3D%26minLodPixels%3D0%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_2=url%3Dhttps%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252Fingolstadt_2%255Ckml_building_lod3_ingolstadt_neu%252Fkml_building_lod3_ingolstadt_collada_MasterJSON.json%26name%3DIngolstadt_CityGML_Building_LoD3%26active%3Dtrue%26spreadsheetUrl%3D%26cityobjectsJsonUrl%3D%26minLodPixels%3D0%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_3=url%3Dhttps%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252Fingolstadt%252Fingolstadt_lod3%252Fkml_ingolstadt_sections%252Fkml_ingolstadt_sections_collada_MasterJSON.json%26name%3DIngolstadt_CityGML_Section%26active%3Dfalse%26spreadsheetUrl%3D%26cityobjectsJsonUrl%3D%26minLodPixels%3D0%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_4=url%3Dhttps%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252Fingolstadt%252Fingolstadt_lod3%252Fkml_ingolstadt_intersection%252Fkml_ingolstadt_intersection_collada_MasterJSON.json%26name%3DIngolstadt_CityGML_Intersection%26active%3Dfalse%26spreadsheetUrl%3D%26cityobjectsJsonUrl%3D%26minLodPixels%3D0%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200)] [[More](https://github.com/savein/lod3-road-space-models)] 

- **Leipzig** 3D building models of the city of Leipzig in CityGML and DXF 

[🏠][🎇][2️⃣]

[[Download LoD2](https://opendata.leipzig.de/dataset/3d-stadtmodell)] [[Visualisation](https://geoportal.leipzig.de/arcgis/apps/webappviewer3d/index.html?id=636b96152aac4769b6cf316312f3bf70)] [[More](https://www.leipzig.de/bauen-und-wohnen/bauen/geodaten-und-karten/3d-stadtmodell)]


- **Technical University of Munich (tum2twin)** LoD3 and textured LoD2 building models of the TUM in Munich

[🏠][🎇][2️⃣][3️⃣]

[[Download](https://github.com/tum-gis/tum2twin)]

- **Mecklenburg-Vorpommern** Various datasets of Mecklenburg-Vorpommern including LoD2 building models

[🏠][2️⃣][🗻]

[[Download](https://www.geodaten-mv.de/dienste/gebaeude_atom?type=dataset&amp;id=8397b554-5cb9-4274-8be8-c20490d9a6e8)] [[More](https://www.laiv-mv.de/Geoinformation/Geobasisdaten/)]

- **Niedersachsen** LoD1 and LoD2 building models of Lower Saxony including orthoimages and more

[🏠][1️⃣][2️⃣]

[[Download LoD1](https://opengeodata.lgln.niedersachsen.de/#lod1)] [[Download LoD2](https://opengeodata.lgln.niedersachsen.de/#lod2)] [[More](https://opengeodata.lgln.niedersachsen.de/)]

- **Nordrhein-Westfalen** various datasets of North Rhine-Westphalia including LoD1 and LoD2 building models

[🏠][1️⃣][2️⃣][🗻]

[[Download LoD1](https://www.opengeodata.nrw.de/produkte/geobasis/3dg/lod1_gml/)] [[Download LoD2](https://www.opengeodata.nrw.de/produkte/geobasis/3dg/lod2_gml/)] [[More](https://www.opengeodata.nrw.de/produkte/geobasis/)]

- **Potsdam** LoD2 building models of Potsdam (see also related Berlin and Brandenburg)

[🏠][2️⃣]

[[Download](https://potsdam.opendatasoft.com/explore/dataset/3d-gebaudemodell-lod2-citygml/information/)]  [[More](https://potsdam.opendatasoft.com/explore/dataset/3d-gebaudemodell-lod2-citygml/information/)]

- **Rheinland-Pfalz** various datasets of Rhineland-Palatinate including LoD2 building models

[🏠][2️⃣][🗻]

[[Download](https://geobasis-rlp.de/data/geb3dlo/current/gml/)] [[More](https://geobasis-rlp.de/data/)]

- **Sachsen** various datasets of Saxony including LoD1 and LoD2 building models

[🏠][1️⃣][2️⃣][🗻]

[[Download](https://www.geodaten.sachsen.de/downloadbereich-digitale-3d-stadtmodelle-4875.html)] [[More](https://www.geodaten.sachsen.de/digitale-hoehenmodelle-3994.html)]

- **Sachsen-Anhalt** various datasets of Saxony including LoD1 and LoD2 building models, DSM2, and DEM2 

[🏠][1️⃣][2️⃣][🗻]

[[Download LoD1](https://www.lvermgeo.sachsen-anhalt.de/de/gdp-download-lod1.html)] [[Download LoD2](https://www.lvermgeo.sachsen-anhalt.de/de/gdp-download-lod2.html)] [[More](https://www.lvermgeo.sachsen-anhalt.de/de/gdp-open-data.html)]

- **Schleswig-Holstein (SH)** various datasets of Schleswig-Holstein including LoD1 and LoD2 building models, DTM1, and DTM5

[🏠][1️⃣][2️⃣]

[[Download LoD1](https://geodaten.schleswig-holstein.de/gaialight-sh/_apps/dladownload/dl-lod1.html)] [[Download LOD2](https://geodaten.schleswig-holstein.de/gaialight-sh/_apps/dladownload/dl-lod2.html)] [[More](https://geodaten.schleswig-holstein.de/gaialight-sh/_apps/dladownload/index.php)]

- **Thüringen** 3D building models of the complete state of Thuringia in LoD1 as well as LoD2

[🏠][1️⃣][2️⃣]

[[Download](https://geoportal.thueringen.de/gdi-th/download-offene-geodaten/download-3d-gebaeudedaten)] [[Visualisation](
https://geoportal5.geoportal-th.de/wega-3d/)] [[More](https://geoportal.thueringen.de/themen/3d)]


## Ireland

- **Dublin** :large_orange_diamond: 500 x 500 meters of Dublin in CAD (AutoCad DWG, FBX and SKP)

[🏠][2️⃣][🚗]

[[Download](https://poly.google.com/view/1H7Ew3x32sC)] [[Visualisation](https://poly.google.com/view/1H7Ew3x32sC)] [[More](https://www.accucities.com/product/free-3d-dublin-city-model-sample/)] 


## Japan

- **Japan** the PLATEAU project encompassing multiple cities and prefectures in Japan, 3D building models in LoD1 and 2, roads and planning areas. On the way to twin the whole Japan (around 210 cities, towns, and wards right now, such as: Tokyo, Sapporo, Shirakawa, Hokota, Iwaki, Kiryu, Koriyama, Utsunomiya)

[🏠][🚗][1️⃣][2️⃣][🗻][🎇][⌛]

[[Download](https://www.geospatial.jp/ckan/dataset/plateau)] [[Download (english)](https://www-geospatial-jp.translate.goog/ckan/dataset/plateau?_x_tr_sl=auto&_x_tr_tl=en&_x_tr_hl=en-US&_x_tr_pto=wapp)] [[Metadata](https://gic-plateau.s3.ap-northeast-1.amazonaws.com/2020/attributedata.xlsx)] [[Additional Demo by TUM](https://collab.dvb.bayern/display/TUMgisproject/Semantic+3D+City+Model+of+Tokyo)]

## Latvia


- **Riga** LoD1 and LoD2 buildings available as SketchUp, OBJ, 3DS, GDB, and CityGML datasets. Additionally, tree models, meshes, and annotated point clouds avaialbe in the viewer.

[🏠][1️⃣][2️⃣]

[[Download](https://georiga.eu/en/atvertie-dati/lod2/)]  [[Visualisation](https://experience.arcgis.com/experience/1525b7aa346342e6bbcffd99bc96a734)] [[More](https://georiga.eu/en/3d-riga/)][[pointClouds](https://experience.arcgis.com/experience/d9863aca5f854b89a6844e3cbdbc6df6?locale=lv)]


## Liechtenstein

- **Liechtenstein** buildings available within the Swiss repository

[🏠][2️⃣]

[[Download](https://www.swisstopo.admin.ch/en/geodata/landscape/buildings3d2.html#technische_details)] [[Visualisation](https://map.geo.admin.ch/?lang=en&topic=ech&bgLayer=ch.swisstopo.pixelkarte-farbe&layers=ch.swisstopo.swissnames3d&lon=7.43291&lat=46.93555&elevation=1494&heading=360.000&pitch=-39.803)] [[More](https://www.swisstopo.admin.ch/en/geodata/landscape.html)]

## Luxembourg

- **Luxembourg** 3D models for the state of Luxembourg. The sample of LoD2 download for the city of Diekirch and Bastendorf. The LoD2 state-wide creation is pending

[🏠][1️⃣][2️⃣]


[[DownloadLod2Sample](https://data.public.lu/en/datasets/5cf4e1230f7fb0030af0771a/)] [[DownloadLod1](https://data.public.lu/en/datasets/5cecd25a4384b06ad27e5c58/)] [[Visualisation](
https://map.geoportail.lu/theme/main?version=3&zoom=17.77189888003778&X=685434&Y=6423250&lang=fr&layers=&opacities=&bgLayer=basemap_2015_global&3d_enabled=true&3d_lon=6.15736&3d_lat=49.86686&3d_elevation=1000&3d_heading=360.000&3d_pitch=-90.000&rotation=0)] [[More](https://data.public.lu/en/datasets/5cf4e1230f7fb0030af0771a/)] 

## Netherlands

- **Leiden** :large_orange_diamond: part of the dataset prepared for Dutch cities in various formats encompassing miscellaneous landscape models, buildings etc. only in the OBJ format

[🏠] [🌲] [🗻] [1️⃣] 

[[Download](https://3d.bk.tudelft.nl/opendata/3dfier/)] [[More](https://3d.bk.tudelft.nl/opendata/3dfier/)] 

- **Netherlands, buildings** 10 mln buildings for the whole Netherlands area in LoD 2 (2.2) and 1 (1.2, 1.3) in various formats CityJSON, OBJ; Also WMS and WFS available. 

[🏠] [1️⃣] [2️⃣] [🔢]

[[Download](https://3dbag.nl/en/download?tid=2935)] [[Visualisation](3dbag.nl)] [[Visualisation, Amsterdam, Unity](https://3d.amsterdam.nl/#1050.63,-961.12,1143.55,56.00,344.51,0.00)]  [[More](https://docs.3dbag.nl/en/)] 

- **Netherlands, sewer systems** for 170 out of 344 municipalities and 12 out of 21 water boards available in various formats CityGML, GeoPackage, and GML. 

[⛲] [🔢]

[[Download](https://apps.gwsw.nl/item_geo?dataset=Delft)] [[More](https://apps.gwsw.nl/)] 


- **Rotterdam** within the 3D viewer, objects and complete areas can be selected for download in various formats including CityGML

[🏠] [🚗] [🌲] [🗻] [1️⃣] [2️⃣]

[[Download](https://www.3drotterdam.nl/#/export)] [[Visualization](https://www.3drotterdam.nl)] 


## UK

- **London** :large_orange_diamond: 1000 x 1000 m of London city centre. CAD models obtained from aerial imagery (15 cm accuracy) with roof structure of LoD2 buildings (LoD 3 concerns only roof structure (more or fewer details))

[🏠] [2️⃣]

[[Download](https://poly.google.com/view/2QqTgkkloVI)][[Visualisation](https://poly.google.com/view/2QqTgkkloVI)] [[More](https://www.accucities.com/new-3d-london-samples-cover-full-square-kilometer/)] 

## USA

- **Austin** :large_orange_diamond: the city of Austin in KMZ format and additional datasets like orthoimages + LiDAR

[🏠] [2️⃣] 

[[Download](http://austintexas.gov/department/gis-data)] [[More](http://austintexas.gov/department/gis-data)] 

- **Boston** :large_orange_diamond: the city of Boston in CAD-like formats and the Esri Multipatch format

[🗻] [🏠] [1️⃣] [2️⃣] [🔢] 

[[Download](http://www.bostonplans.org/3d-data-maps/3d-smart-model/3d-data-download)] [[Visualisation](https://boston.maps.arcgis.com/apps/webappviewer3d/index.html?id=cf3415dea19d480caa71eb5dbdce185f)] [[More](http://www.bostonplans.org/3d-data-maps/3d-smart-model/about-3d)] 

- **Cambridge** :large_orange_diamond: dataset of the city of Cambridge with CAD models of buildings and terrain. Esri Multipatch also available

[🗻] [🏠] [1️⃣]

[[Download](https://www.cambridgema.gov/GIS/3D/3ddata/3ddatadownloadmap)] [[More](https://www.cambridgema.gov/GIS/3D/3ddata)] 

- **Las Vegas** the Las Vegas Motor Speedway racing track (e.g., tracks, buildings, terrain) in CityGML and as OBJ

[🏠] [🗻] [🚗] [🌲] [1️⃣]

[[Download](https://github.com/OloOcki/LAS-Vegas-LoD1)]  [[More](https://github.com/OloOcki/LAS-Vegas-LoD1)] 

- **USA** the whole USA teritory in LoD1 with more than 125 million buildings separated by state  

[🏠] [1️⃣]

[[Download](https://github.com/opencitymodel/opencitymodel)] [[More](https://github.com/opencitymodel/opencitymodel)] 


- **New York City** Department of Information Technology and Telecommunications (DOITT) 

[🏠] [1️⃣] [2️⃣] [🔢]

[[Download](https://maps.nyc.gov/download/3dmodel/DA_WISE_GML.zip)] [[Visualisation](https://cesiumjs.org/NewYork/index.html?view=-74.01881302800247%2C40.69114333714821%2C753.2406554180401%2C21.27879878293835%2C-21.34390550872465%2C0.0716951918898415)] [[More](https://github.com/CityOfNewYork/nyc-geo-metadata/blob/master/Metadata/Metadata_3DBuildingModel.md)] 

- **New York City** Technical University of Munich (TUM)

[🏠] [🚗] [1️⃣] [2️⃣] [🔢] 

[[Download Sample](www.3dcitydb.net/3dcitydb/fileadmin/public/datasets/NYC/NYC_street_space_extract/NYC_Flatiron_Streetpace_CityGML_LoD2.zip)] [[Visualisation](http://www.3dcitydb.org/3dcitydb-web-map/1.8.2/3dwebclient/?title=NYC_Detailed_Road_Model&shadows=false&terrainShadows=0&latitude=40.74324791682301&longitude=-73.98788672934239&height=393.81226291411065&heading=212.81661879694937&pitch=-54.90142422275028&roll=359.8214281982287&layer_0=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FEntrance1%252FEntrance1_collada_MasterJSON.json%26name%3DParking_Lot_Entrance%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1-3JFVBB16ZY2heG6a1eJi6W1rEPo5FEPuKQ469G-hxA%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_1=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FParking_Lot1%252FParking_Lot1_collada_MasterJSON.json%26name%3DParking_Lot%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1A-907mG66x_Ry1s3T0k5cBLVi7Xo4ijrezHoqVGkDe0%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_2=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FMedian_Grass%252FMedian_Grass_collada_MasterJSON.json%26name%3DGrass_Area%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1rhjSQwkgky74jTe1jDJlHIiQB6_sFiX-LJ5ZEpbhLtY%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_3=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FSidewalk1%252FSidewalk1_collada_MasterJSON.json%26name%3DSidewalk%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1GIcPNoMLAyPJVtVbNE3-_0Tiu1Xjr1Fj09tY2QPPA2s%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_4=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FMedian_Painted1%252FMedian_Painted1_collada_MasterJSON.json%26name%3DRoad_Marking%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1fd-xnvIoAPvJjzRwRTuGogKgJX08nDDyym184t02avo%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_5=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FIntersection1%252FIntersection1_collada_MasterJSON.json%26name%3DIntersection%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1DL1TpKUcOfSmcaqfJ-iB6rHBW2TQJkYLvl2sg6FGes4%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_6=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FRoadbed1%252FRoadbed1_collada_MasterJSON.json%26name%3DRoadbed%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F13U0NRWyRjjaAOlsIHvhtKFYNSUUpmseBKAzr4ei-954%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_7=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FPlaza1%252FPlaza_collada_MasterJSON.json%26name%3DPlaza%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1qkO0qgrfnP8tbuiJhz2I5ydX-lR1CCZl-wyxbXdcjvk%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_8=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FCurb%252FCurb_collada_MasterJSON.json%26name%3DCurb%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1fNljJXfTFkAiDMFncGUYhse8R_CQ1Vo_HeNWRP_fijU%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_9=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FTrack%252FTrack_collada_MasterJSON.json%26name%3DTrack%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dfalse%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1Z9PIPrFQY5tudHOqczsPjfIN29XfCrtXez2rtgpto7g%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_10=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FTraffic_Islands%252FTraffic_Islands_collada_MasterJSON.json%26name%3DDividing_Strips%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1qXPJ1ezPV04RNONpOBlJYm7JE_8I_Q8ho-bJLdXlqlc%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&layer_11=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252FNYC-Model-20170501%252FBuilding_gltf%252FBuilding_gltf_collada_MasterJSON.json%26name%3DBuildings%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D1.0%26active%3Dtrue%26spreadsheetUrl%3Dhttps%253A%252F%252Fdocs.google.com%252Fspreadsheets%252Fd%252F1DbkMUSYW_YlE48MUxH5fak56uaCL8QXNrBgEr0gfuCY%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D125%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&splashWindow=url%3Dsplash%252FSplashWindow.html%26showOnStart%3Dtrue)] [[More](https://www.lrg.tum.de/gis/projekte/new-york-city-3d/)] 

- **Philadelphia** textured building models of 2008, 2010, and 2015 (see the list under tag 'More') as LoD2 GDB files

[🏠] [🎇] [2️⃣] [⌛]

[[Download](https://www.pasda.psu.edu/uci/DataSummary.aspx?dataset=7146)] [[More](https://www.pasda.psu.edu/uci/SearchResults.aspx?Keyword=Philadelphia)] 

- **Washington** the White House street space area in CityGML

[🚗] [1️⃣]

[[Download](https://wiki.tum.de/display/gisproject/Download+Section)] [[Visualisation](http://www.3dcitydb.net/3dcitydb-web-map/1.6.1/3dwebclient/?title=Washington_Road_Demo&shadows=false&terrainShadows=0&latitude=38.889078957501305&longitude=-77.03700093391359&height=1006.8315445658836&heading=1.6544813327191306&pitch=-49.66103584894631&roll=0.008414778094956044&layer_0=url%3Dhttp%253A%252F%252Fwww.3dcitydb.net%252F3dcitydb%252Ffileadmin%252Fpublic%252F3dwebclientprojects%252Fwashington_demo%252Fkml_transportation_example%252Fkml_washington_transportation_example_collada_MasterJSON.json%26name%3DWashington_Road%26layerDataType%3DCOLLADA%252FKML%252FglTF%26gltfVersion%3D2.0%26active%3Dtrue%26spreadsheetUrl%3D%26thematicDataSource%3DGoogleSheets%26tableType%3DHorizontal%26cityobjectsJsonUrl%3D%26minLodPixels%3D0%26maxLodPixels%3D1.7976931348623157e%252B308%26maxSizeOfCachedTiles%3D200%26maxCountOfVisibleTiles%3D200&splashWindow=url%3Dsplash%252FSplashWindow.html%26showOnStart%3Dfalse)] [[More](https://wiki.tum.de/display/gisproject/Download+Section)] 

## Poland

- **Opolskie** tree models at the CityGML LoD1 published as a WMS service for several counties in Opolskie voivodeship; planned to be released for the whole Poland (see 'Poland' below).

[🌲][1️⃣] 

[[Download](https://mapy.geoportal.gov.pl/imap/Imgp_2.html?gpmap=imap3d)] [[More](https://www.geoportal.gov.pl/aktualnosci/ggk-udostepnia-kolejne-modele-3d-drzew-2/)] 


- **Poland** ~15.5 million buildings for the whole Poland in LoD1 and LoD2. To download - go to Data for download -> BDOT data packages -> 3D models of buildings.  

[🏠] [1️⃣] [2️⃣]

[[Download](https://mapy.geoportal.gov.pl/imap/Imgp_2.html?gpmap=gp0)] [[Visualisation](https://mapy.geoportal.gov.pl/imap/Imgp_2.html?gpmap=imap3d)] [[More](http://www.gugik.gov.pl/aktualnosci/2020/22.07.2019-wszystkie-modele-budynkow-3d-w-standardzie-lod1-opublikowane)] [[More2](http://www.gugik.gov.pl/__data/assets/pdf_file/0007/89242/SIWZ.pdf)][[More3](https://docplayer.pl/132658493-Dane-i-e-uslugi-3d-w-projekcie-capap.html)]

- **Poznan** City of Poznan with various semantic datasets. Download using the map (use Widget menu -> Export widget) or on website (only for buildings)

[🏠] [🌲] [🗻] [🚦] [🎇] [1️⃣] [2️⃣] [3️⃣]

[[Download](http://sip.poznan.pl/sip/dz/get_budynki/id_rap/101/v_lod3/1)] [[Visualisation](http://sip.poznan.pl/model3d/#/legend)] [[More](http://sip.poznan.pl/sip/)] [[TLSpointClouds](https://sip.poznan.pl/sip/zielen2/pcl)]


## Singapore

- **Singapore** Public housing (HDB) buildings in LoD1 available in CityJSON and OBJ formats

[🏠] [1️⃣] 

[[Download](https://github.com/ualsg/hdb3d-data)] [[More](https://github.com/ualsg/hdb3d-data)] 


## Switzerland

- **Switzerland** :large_orange_diamond: buildings for the whole Switzerland in LoD2 in various formats (CityGML available for a fee in swissBUILDINGS 2.0; and at no cost in swissBUILDINGS 3.0, whereby only several regions available). Also DEM available and other 3D related features (see More)

[🏠][2️⃣]

[[Download ver 2.0](https://www.swisstopo.admin.ch/en/geodata/landscape/buildings3d2.html#technische_details)] [Download ver 3.0](https://www.swisstopo.admin.ch/de/landschaftmodell-swissbuildings3d-3-0-beta#swissBUILDINGS3D-3.0-Beta---Download)]  [[Visualisation](https://map.geo.admin.ch/?lang=en&topic=ech&bgLayer=ch.swisstopo.pixelkarte-farbe&layers=ch.swisstopo.swissnames3d&lon=7.43291&lat=46.93555&elevation=1494&heading=360.000&pitch=-39.803)] [[More](https://www.swisstopo.admin.ch/en/geodata/landscape.html)]


- **Zurich** buildings available for the city of Zurich

[🏠] [1️⃣] [2️⃣]


[[Download](https://data.stadt-zuerich.ch/dataset?q=&tags=3d-stadtmodell)] [[Visualisation](https://3d.stzh.ch/appl/3d/zuerichvirtuell/)] [[More](https://www.stadt-zuerich.ch/geodaten/)] 


## ArtificialCities

- **Random3Dcity** samples of generated buildings in LoD 1,2,3 and variations of these. The modeling engine is published as open-source code to enable further buildings' generation

[🏠] [1️⃣] [2️⃣] [3️⃣] [🔢]

[[Download](https://filipbiljecki.com/code/Random3Dcity.html)] [[More](https://github.com/tudelft3d/Random3Dcity)] 

