message(STATUS "")
message(STATUS "🎉 ${CMAKE_PROJECT_NAME} v${${CMAKE_PROJECT_NAME}_VERSION} Configuration Done. 🎉")
message(STATUS "")

message(STATUS "SYSTEM_NAME               : ${CMAKE_SYSTEM_NAME}")
message(STATUS "HOST_SYSTEM_NAME          : ${CMAKE_HOST_SYSTEM_NAME}")
message(STATUS "HOST_SYSTEM_PROCESSOR     : ${CMAKE_HOST_SYSTEM_PROCESSOR}")
message(STATUS "HOST_SYSTEM_VERSION       : ${CMAKE_HOST_SYSTEM_VERSION}")

message(STATUS "CMAKE_VERSION             : ${CMAKE_VERSION}")
message(STATUS "CMAKE_GENERATOR           : ${CMAKE_GENERATOR}")
message(STATUS "CMAKE_CXX_COMPILER_ID     : ${CMAKE_CXX_COMPILER_ID}")

include(ProcessorCount)
ProcessorCount(N)
if(N EQUAL 0)
  set(PARALLEL_LEVEL "")
else()
  set(PARALLEL_LEVEL "-j${N}")
endif()

if(CMAKE_BUILD_TYPE)
  set(BUILD_CONFIG "--config ${CMAKE_BUILD_TYPE}")
  set(BUILD_CONFIG_TEST "-C ${CMAKE_BUILD_TYPE}")
endif()

message(STATUS " ")
message(STATUS "📌 Versions:")
message(STATUS "  Qt                      : ${QT_VERSION_MAJOR}.${QT_VERSION_MINOR}.${QT_VERSION_PATCH}")
message(STATUS " ")
message(STATUS "🔨 Build Commands:")
message(STATUS "  NetUdp                          : cmake --build . --target NetUdp ${BUILD_CONFIG} ${PARALLEL_LEVEL}")

if(NETUDP_ENABLE_TESTS)

  message(STATUS " ")
  message(STATUS "✅ Test Commands:")
  if(TARGET NetUdp_Tests)
    message(STATUS "  NetUdp_Tests                    : cmake --build . --target NetUdp_Tests ${BUILD_CONFIG} ${PARALLEL_LEVEL}")
  endif()
  if(TARGET NetUdp_QuickTests)
    message(STATUS "  NetUdp_QuickTests               : cmake --build . --target NetUdp_QuickTests ${BUILD_CONFIG} ${PARALLEL_LEVEL}")
  endif()
  message(STATUS "  Run Tests                       : ctest ${BUILD_CONFIG_TEST} . --verbose --progress")

endif()

if(NETUDP_ENABLE_EXAMPLES)

  message(STATUS " ")
  message(STATUS "🚀 Examples Commands:")
  if(TARGET NetUdp_EchoClient)
    message(STATUS "  NetUdp_EchoClient               : cmake --build . --target NetUdp_EchoClient ${BUILD_CONFIG} ${PARALLEL_LEVEL}")
  endif()
  if(TARGET NetUdp_EchoServer)
    message(STATUS "  NetUdp_EchoServer               : cmake --build . --target NetUdp_EchoServer ${BUILD_CONFIG} ${PARALLEL_LEVEL}")
  endif()
  if(TARGET NetUdp_EchoClientServer)
    message(STATUS "  NetUdp_EchoClientServer         : cmake --build . --target NetUdp_EchoClientServer ${BUILD_CONFIG} ${PARALLEL_LEVEL}")
  endif()
  if(TARGET NetUdp_EchoMulticastLoopback)
    message(STATUS "  NetUdp_EchoMulticastLoopback    : cmake --build . --target NetUdp_EchoMulticastLoopback ${BUILD_CONFIG} ${PARALLEL_LEVEL}")
  endif()
  if(TARGET NetUdp_EchoQml)
    message(STATUS "  NetUdp_EchoQml                  : cmake --build . --target NetUdp_EchoQml ${BUILD_CONFIG} ${PARALLEL_LEVEL}")
  endif()
endif()

message(STATUS " ")
