﻿using Newtonsoft.Json;
using ApprovalCenter.Domain.Core.Events;
using ApprovalCenter.Domain.Core.Interfaces.Events;
using ApprovalCenter.Domain.Core.Interfaces.Repository.EventSourcing;
using ApprovalCenter.Domain.General.Interfaces;

namespace ApprovalCenter.Infra.Data.EventSourcing
{
    public class SqlEventStore : IEventStore
    {
        private readonly IEventStoreRepository _eventStoreRepository;
        private readonly IUser _user;

        public SqlEventStore(IEventStoreRepository eventStoreRepository, IUser user)
        {
            _eventStoreRepository = eventStoreRepository;
            _user = user;
        }

        public void Save<T>(T theEvent) where T : Event
        {
            var serializedData = JsonConvert.SerializeObject(theEvent);

            var storedEvent = new StoredEvent(
                theEvent,
                serializedData,
                _user.Name);

            _eventStoreRepository.Store(storedEvent);
        }
    }
}
