<?php
// 初始化变量及引入初始文件
$dbPathPart		= '';
$webPathPart	= '';
$jsPathPart		= '';

require('ucCheck.php');

require(OT_ROOT .'inc/classTemplate.php');

$tpl = new Template;
$tpl->obj->template_dir	= OT_ucROOT .'template/default/';	// 模板目录

// 初始化公共变量
$tpl->webTypeName	= 'w';
$tpl->webTitle		= '';
$tpl->webKey		= '*';
$tpl->webDesc		= '*';

$pcWap	= 'uc';
$tplType = 'main';
$tplName = 'ucMain.html';
$mudi	= OT::GetStr('m');
$type	= OT::GetStr('type');

$webContent = StrInfo::AlertStr('ucAudit0');
switch ($mudi){
	case 'pay':
		$webTitle = '在线支付';
		$quanArr = array('quan1','quan2','quan3','quan4','quan5');
		if (in_array($type,$quanArr)){
			$quanName = $DB->GetOne('select MS_quickQuanTheme'. str_replace('quan','',$type) .' from '. OT_dbPref .'moneySys');
			if (strlen(''. $quanName) > 0){
				$webTitle = $quanName .'_在线支付';
			}else{
				JS::AlertCloseEnd('该渠道暂未开放，如有问题请联系管理员。');
			}
		}else{
			$typeArr = PayInfo::QuickTypeArr('key');
				if (in_array($type,$typeArr)){
					$quickTypeArr = PayInfo::QuickTypeArr();
					$webTitle = $quickTypeArr[$type] .'_在线支付';
				}
		}
		$webContent = AppMoneyPay::PayWeb($pcWap);
		break;

	case 'payResult':
		$webTitle	= '在线支付结果';
		$webContent = AppMoneyPay::ResultWeb($pcWap);
		break;

	case 'payRefer':
		$webTitle	= '在线支付订单查询';
		$webContent = AppMoneyPay::ReferWeb($pcWap);
		break;

	case 'siteMessage':
		$webTitle	= '站内信息密码登录';
		$webContent = AppSiteMessage::UcLogin($pcWap);
		break;

	case 'siteMessageAdd':
		$webTitle	= '提交站内信息';
		$webContent = AppSiteMessage::UcAdd(0,'pwd',$pcWap);
		break;

	case 'siteMessageReply':
		$webTitle	= '站内信息回复';
		$webContent = AppSiteMessage::UcReply(0,'pwd',$pcWap);
		break;

	case 'userApiSuccess':
		$webTitle	= '用户快捷注册';
		$tplType	= 'index';
		$tplName	= 'ucIndex.html';
		$webContent = AppLogin::SuccessWeb($pcWap);
		break;

	default :
		die('目的不明确');
		break;

}

$tpl->webTitle = $webTitle .'_'. $systemArr['SYS_title'];

if ($tplType == 'index'){
	// 使用 ucIndex.html 模板要加载的内容

}else{
	// 使用 ucMain.html 模板要加载的内容
	$webTop = '
		<div class="topbar-left">
			<div class="uc-aside-toggler">
				<span class="uc-toggler-bar"></span>
				<span class="uc-toggler-bar"></span>
				<span class="uc-toggler-bar"></span>
			</div>
			<span class="navbar-page-title"> '. $webTitle .'</span>
		</div>
		<ul class="topbar-right">
			<li class="dropdown dropdown-profile">
				<!-- <a href="javascript:void(0)" data-toggle="dropdown">
					<img class="img-qrcode img-qrcode-46" src="static/images/def-face.png" alt="用户头像" />
					<span>用户<span class="caret"></span></span>
				</a> -->
				<ul class="dropdown-menu dropdown-menu-right">
					<li> <a href="?mudi=revInfo"><i class="otcms-uc-58"></i> 个人信息</a> </li>
					<li class="divider"></li>
					<li><a href="javascript:void(0);" onclick="UserExit();return false;"><i class="otcms-uc-exit2"></i> 退出登录</a> </li>
				</ul>
			</li>
		</ul>
		';

	$menuList = '';
	if (in_array($mudi, array('pay','payResult','payRefer'))){
		$menuList .= '
			<li><a href="w.php?m=pay">在线支付</a></li>
			<li><a href="w.php?m=payRefer">已付订单查询</a></li>
			';
	}elseif (in_array($mudi, array('siteMessage','siteMessageAdd','siteMessageReply'))){
		$menuList .= '
			<li><a href="usersCenter.php?mudi=siteMessage">站内信息管理</a></li>
			';
	}
	$webMenu = '
		<script language="javascript" type="text/javascript" src="js/usersCenter.js?v='. OT_VERSION .'"></script>

		<li class="nav-item"> <a href="'. UcBase::PcWapParDir() .'"><i class="otcms-uc-82"></i>网站首页</a> </li>
		<li class="nav-item nav-item-has-subnav open">
			<a href="javascript:void(0)"><i class="fa fa-paperclip fa-fw"></i> 网站导航</a>
			<ul class="nav nav-subnav">
				<li><a href="usersCenter.php">会员中心</a></li>
				'. $menuList .'
			</ul>
		</li>
		';
	$tpl->Add('webTop',			$webTop);
	$tpl->Add('webLogo',		'<div style="padding:18px 0 0 10px;color:#ffffff;font-weight:bold;font-size:18px;line-height:1.2;">'. $systemArr['SYS_title'] .'</div>');
	$tpl->Add('webMenu',		$webMenu);
}

$styleWidthStr = '';
if (empty($userSysArr)){ $userSysArr = Cache::PhpFile('userSys'); }
if ($userSysArr['US_newSysWidth'] > 0){ $styleWidthStr = ' style="max-width:'. $userSysArr['US_newSysWidth'] .'px;margin:0 auto;"'; }

$tpl->Add('siteVer',		OT_VERSION);
$tpl->Add('webTypeName',	$tpl->webTypeName);
$tpl->Add('dbPathPart',		$dbPathPart);
$tpl->Add('webPathPart',	$webPathPart);
$tpl->Add('jsPathPart',		$jsPathPart);
$tpl->Add('isMobile',		UcBase::JudMobile() ? 1 : 0);
$tpl->Add('beforeURL',		UcBase::BeforeURL());

$tpl->Add('webTitle',		$tpl->webTitle);
$tpl->Add('webContent',		$webContent);
$tpl->Add('styleWidthStr',	$styleWidthStr);

$tpl->Show($tplName);


function MainArea($content, $title, $faName='snowflake-o'){
	return '
	<div class="row">
		<div class="col-lg-12">
			<div class="card">
				<div class="card-header"><h4>'. $title .'</h4></div>
		  		<div class="card-body">
		  			'. $content .'
		  		</div>
            </div>
      	</div>
    </div>';
}
?>