<?php
header('Content-Type: text/html; charset=UTF-8');

define('OT_ROOT', dirname(dirname(dirname(__FILE__))) .'/');
define('OT_Charset',	'utf-8');


// 自动加载类文件
if (version_compare(PHP_VERSION, '5.3.0', '>=')) {
	spl_autoload_register('OTautoload', true, true);
}else{
	spl_autoload_register('OTautoload');
}

function OTautoload($className){
	$judStrrev = false;
	if ( in_array(substr($className,0,3),array('App','Api')) ){
		$judStrrev = true;
		$classPath = OT_ROOT .'plugin/class'. $className .'.php';

	}else{
		$classPath = OT_ROOT .'inc/class'. $className .'.php';
	}
	if (file_exists($classPath)){
		include_once($classPath);
	}else{
		if ($judStrrev){
			$classPath = OT_ROOT .'pluDef/class'. $className .'.php';
		}else{
			$classPath = OT_ROOT .'inc/class'. $className .'.php';
		}
		if (file_exists($classPath)){
			include_once($classPath);
		}else{
			echo('类路径错误或不存在.'. $classPath .'或'. OT_ROOT .'inc/class'. $className .'.php');
		}
	}
}


$m = OT::GetStr2( OT::ParaArr('mudi') );

switch ($m){
	case 'getKeyWord':
		// 获取文章关键词
		KeyWord::GetDeal();
		break;

	case 'getUrlencode':
		// 字符串url编码化
		echo(urlencode(OT::GetStr('str')));
		break;

	case 'getGeetest':
		// 获取滑动验证码
		GetGeetest();
		break;

	case 'pinyin':
		// 获取中文拼音化
		PinYin::GetDeal();
		break;

	case 'encPwd':
		// 加密密码
		Encrypt::GetDeal();
		break;

	case 'getCityData':
		// 获取省份城市信息
		ProvCity::GetDeal();
		break;

	case 'outUrl':
		// 外部网址温馨提醒页
		Area::OutUrl('uc');
		break;

	case 'qrcode':
		// 显示二维码图
		Area::MakeQRcode();
		break;

	default :
		die('[该访问地址存在]');
		// die('err');
}



// 获取验证码结果
function GetGeetest(){
	$geetest = new Geetest();
	$geetest->ShowRes('web');
}

?>