<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class Info{

	// 分目录存放 日期目录
	public static function DateTimeDir($isDir){
		$retStr = '';
		if ($isDir > 0){
			switch ($isDir){
				case 1:	$retStr = TimeDate::Get('Y') .'/';		break;
				case 2:	$retStr = TimeDate::Get('Ym') .'/';		break;
				case 3:	$retStr = TimeDate::Get('Ymd') .'/';	break;
			}
		}
		return $retStr;
	}


	// 静态日期时间目录
	public static function DatetimeDirName($dirTime,$dirMode=-1){
		global $systemArr;

		$retStr = '';
		if ($dirMode == -1){ $dirMode=$systemArr['SYS_htmlDatetimeDir']; }
		switch ($dirMode){
			case 10:	$retStr = TimeDate::Get('Y',$dirTime); break;
			case 20:	$retStr = TimeDate::Get('Ym',$dirTime); break;
			default:	$retStr = TimeDate::Get('Ymd',$dirTime);
		}

		return $retStr;
	}


	// 栏目模式路径
	public static function InfoTypeUrl($itArr=array()){
		if ($itArr['IT_mode'] == 'web'){
			$retStr = $itArr['mainUrl'] . Url::WebID($itArr['IT_webID'],0,$itArr['webPathPart']);
		}elseif ($itArr['IT_mode'] == 'topic'){
			$retStr = $itArr['mainUrl'] . Url::ListTypeID('topic',$itArr['IT_webID'],0,$itArr['webPathPart']);
		}elseif ($itArr['IT_mode'] == 'taobaoke'){
			$retStr = $itArr['mainUrl'] . Url::GoodsList($itArr['IT_webID'],0,$itArr['webPathPart']);
		}elseif ($itArr['IT_mode'] == 'domain'){
			$retStr = $itArr['mainUrl'] .'domain.php';
		}elseif ($itArr['IT_mode'] == 'domainHtml'){
			$retStr = $itArr['mainUrl'] .'domain.html';
		}elseif (substr($itArr['IT_mode'],0,3) == 'url'){
			$retStr = $itArr['mainUrl'] . Url::ListUrl($itArr['IT_mode'],$itArr['IT_URL'],$itArr['IT_isEncUrl'],$itArr['IT_ID'],$itArr['webPathPart']);
			if (strlen($retStr) == 0){ $retStr='./'; }
		}else{
			$retStr = $itArr['mainUrl'] . Url::ListID('',$itArr['IT_htmlName'],$itArr['IT_ID'],0,$itArr['webPathPart']);
		}
		return $retStr;
	}

	// 文章图片的路径带自动配缩略图
	public static function AutoImgUrl($img, $pathHead, $id, $theme, $mode='pc'){
		if (strlen($img) > 3){
			return self::InfoImgUrl($img, $pathHead . InfoImgDir, $mode);
		}else{
			global $appSysArr;
			if (empty($appSysArr)){ $appSysArr = Cache::PhpFile('appSys'); }

			if ($appSysArr['AS_isAutoImg'] == 1){
				return AppAutoImg::ImgUrl($id, $theme, $pathHead, $mode);
			}
		}
	}

	// 文章图片的路径
	public static function InfoImgUrl($img, $pathDir, $mode='pc'){
		$img = $img .'';
		if (strlen($img) > 0){
			if (Is::HttpUrl($img)){
				if ($mode == 'wap'){
					return str_replace($pathDir, $pathDir .'thumb_', $img);
				}else{
					return $img;
				}
			}else{
				if ($mode == 'wap' && strpos($img,'/') === false){
					return $pathDir .'thumb_'. $img;
				}else{
					return $pathDir . $img;
				}
			}
		}else{
			return '';
		}
	}

	// 缩略图路径
	public static function ImgThumbPath($imgStr){
		if (strpos($imgStr,'/') !== false){
			$headPart = substr($imgStr, 0, strrpos($imgStr,'/')+1);
			return str_replace($headPart, $headPart .'thumb_', $imgStr);
		}else{
			return 'thumb_'. $imgStr;
		}
	}

	// img没有alt属性的加上alt属性
	public static $altNewStr = '';
	public static function AddImgAlt($conStr, $altStr){
		global $altNewStr,$infoSysArr;
		$altNewStr = str_replace(' ', '_', Str::MoreReplace($altStr,'input'));

		// 给图片加注释
		$conStr = preg_replace_callback("/(<img)(?![^<>]*?alt[^<>]*?>)(.*?>)/i", function ($ms){
				global $altNewStr;
				static $i;
				$i ++;
				return $ms[1] .' alt="'. $altNewStr .' 图'. $i .'" title="'. $altNewStr .' 图'. $i .'" '. $ms[2];
			}, $conStr);

		// $conStr = preg_replace("/(<img[\s\S]*?)(alt=['\"]{2})(.[^>]*>)/i",'${1}${3}',$conStr);
		/* $conStr = preg_replace("/(<img)(?![^<>]*?alt[^<>]*?>)(.*?>)/i", '${1} alt="'. $altNewStr .'" ${2}', $conStr); */
		// $conStr = preg_replace("/(<img[\s\S]*?)(alt=['\"])([^>\\\"\\'\\s]*)(['\"])(.[^>]*>)/i", '${1}${2}${3}${4} title="${3}" ${5}', $conStr);

		$conStr = self::AddCopyBtn($conStr);
		return $conStr;
	}

	// 加一键复制[OT_copy][/OT_copy]
	public static function AddCopyBtn($conStr){
		global $infoSysArr;

		if (strpos($conStr,'[OT_copy]') !== false && strpos($conStr,'[/OT_copy]') !== false){
			if (empty($infoSysArr)){ $infoSysArr = Cache::PhpFile('infoSys'); }
			if (strlen($infoSysArr['IS_copyBtnName']) > 0){ $copyBtnName = $infoSysArr['IS_copyBtnName']; }else{ $copyBtnName = '点击复制以上文本内容'; }
			while (strpos($conStr,'[OT_copy]') !== false){
				$copyStr = Str::GetMark($conStr, '[OT_copy]', '[/OT_copy]');
				$newStr = '';
				if (strlen($copyStr) > 0){
					$copyTemp = Str::RegExp($copyStr,'html');
					$newStr = '
						<div class="copyTextArea">
							<textarea class="txtarea">'. Str::MoreReplace($copyTemp,'textarea') .'</textarea>
							<div class="copyTextDiv"><input type="button" value="'. $copyBtnName .'" class="copyTextBtn" data-copyText="'. $copyTemp .'" /></div>
						</div>';
				}
				$conStr = str_replace('[OT_copy]'. $copyStr .'[/OT_copy]', $newStr, $conStr);
			}
		}
		return $conStr;
	}

	// 过滤关键词/标签
	public static function FilterThemeKey($str){
		return Trim(Str::MoreReplace(Str::RegExp($str,'html'),'themeKey'));
	}

	// 过滤内容摘要
	public static function FilterContentKey($str){
		return str_replace('[OT_page]','',Str::MoreReplace(Str::RegExp(Str::RegExp(Str::FilterMark(Str::FilterMark($str,'script'),'style'),'html'),'contentKey'),'contentKey'));
	}

	// 过滤编辑器内容
	public static function FilterEditor($str){
		/*
		preg_match_all("/<(\w[^>|\s]*)([^>]*?)(window\.|javascript:|vbscript:|js:|about:|file:|Document\.|vbs:|cookie| name| id|&#)(.[^>]*)/si",$str,$img_array);
		$tmp = print_r($img_array,true);
		echo('<pre>'. htmlspecialchars($str) .'<br /><br /><br />'. htmlspecialchars($tmp) .'</pre>');
		*/
		// die();

		$str = preg_replace("/(<(meta|iframe|frame|tbody|layer|form)[^>]*>|<\/(iframe|frame|meta|tbody|layer|form)>)/si","",$str);
		$str = preg_replace("/<\\?\?xml[^>]*>/si","",$str);
		$str = preg_replace("/<\s*xss[^>]*>/si","",$str);
		$str = preg_replace("/<\s*(script[^>]*)>([\s\S][^<]*)<\/\s*script>/si","",$str);
		$str = preg_replace("/<\s*(script[^>]*)>/si","",$str);
		$str = preg_replace("/<\/\s*script[^>]*>/si","",$str);
		// $str = preg_replace("/<(\w[^>|\s]*)([^>]*)(on(finish|mouse|Exit|error|click|key|load|change|focus|blur))(.[^>]*)/si",'<${1}${2}',$str);
		$str = preg_replace("/<(\w[^>|\s]*)([^>]*?)(on(Abort|Activate|AfterPrint|AfterUpdate|BeforeActivate|BeforeCopy|BeforeCut|BeforeDeactivate|BeforeEditFocus|BeforePaste|BeforePrint|BeforeUnload|BeforeUpdate|Begin|Blur|Bounce|CellChange|Change|Click|ContextMenu|ControlSelect|Copy|Cut|DataAvailable|DataSetChanged|DataSetComplete|DblClick|Deactivate|Drag|DragEnd|DragLeave|DragEnter|DragOver|DragDrop|DragStart|Drop|End|Error|ErrorUpdate|FilterChange|Finish|Focus|FocusIn|FocusOut|HashChange|Help|Input|KeyDown|KeyPress|KeyUp|LayoutComplete|Load|LoseCapture|MediaComplete|MediaError|Message|MouseDown|MouseEnter|MouseLeave|MouseMove|MouseOver|MouseUp|MouseWheel|Move|MoveEnd|MoveStart|Offline|Online|OutOfSync|Paste|Pause|PopState|Progress|PropertyChange|ReadyStateChange|Redo|Repeat|Reset|Resize|ResizeEnd|ResizeStart|Resume|Reverse|RowsEnter|RowExit|RowDelete|RowInserted|Scroll|Seek|Select|SelectionChange|SelectStart|Start|Stop|Storage|SyncRestored|Submit|TimeError|TrackChange|Undo|Unload|URLFlip|mouse|Exit|key|mouseout|rowenter|rowsdelete|rowsinserted))(.[^>]*)/si",'<${1}${2}',$str);
		$str = preg_replace("/<(\w[^>|\s]*)([^>]*?)(&#|window\.|javascript:|vbscript:|js:|data:|about:|file:|Document\.|vbs:|:expression|cookie| name| id)(.[^>]*)/si",'<${1}${2}',$str);
		$str = preg_replace("/<a (.*?)>(.*?)<\/a>/si",'<a ${1} target="_blank">${2}</a>',$str);

		$str = preg_replace("/\s+/", " ", $str);			//过滤多余回车
		$str = preg_replace("/<[ ]+/si","<",$str);			//过滤<__("<"号后面带空格)
		$str = preg_replace("/<\!–.*?–>/si","",$str);		//注释
		$str = preg_replace("/<(\!.*?)>/si","",$str);		//过滤DOCTYPE
		$str = preg_replace("/<(\/?html.*?)>/si","",$str);	//过滤html标签
		$str = preg_replace("/<(\/?head.*?)>/si","",$str);	//过滤head标签
		$str = preg_replace("/<(\/?meta.*?)>/si","",$str);	//过滤meta标签
		$str = preg_replace("/<(\/?body.*?)>/si","",$str);	//过滤body标签
		$str = preg_replace("/<(\/?link.*?)>/si","",$str);	//过滤link标签
		$str = preg_replace("/<(\/?form.*?)>/si","",$str);	//过滤form标签
		$str = preg_replace("/cookie/si","COOKIE",$str);	//过滤COOKIE标签
		$str = preg_replace("/<(applet.*?)>(.*?)<(\/applet.*?)>/si","",$str);	//过滤applet标签
		$str = preg_replace("/<(\/?applet.*?)>/si","",$str);	//过滤applet标签
		$str = preg_replace("/<(style.*?)>(.*?)<(\/style.*?)>/si","",$str);		//过滤style标签
		$str = preg_replace("/<(\/?style.*?)>/si","",$str);		//过滤style标签
		$str = preg_replace("/<(title.*?)>(.*?)<(\/title.*?)>/si","",$str);		//过滤title标签
		$str = preg_replace("/<(\/?title.*?)>/si","",$str);		//过滤title标签
		$str = preg_replace("/<(object.*?)>(.*?)<(\/object.*?)>/si","",$str);	//过滤object标签
		$str = preg_replace("/<(\/?objec.*?)>/si","",$str);		//过滤object标签
		$str = preg_replace("/<(noframes.*?)>(.*?)<(\/noframes.*?)>/si","",$str);	//过滤noframes标签
		$str = preg_replace("/<(\/?noframes.*?)>/si","",$str);	//过滤noframes标签
		$str = preg_replace("/<(i?frame.*?)>(.*?)<(\/i?frame.*?)>/si","",$str);	//过滤frame标签
		$str = preg_replace("/<(\/?i?frame.*?)>/si","",$str);	//过滤frame标签
		$str = preg_replace("/<(script.*?)>(.*?)<(\/script.*?)>/si","",$str);	//过滤script标签
		$str = preg_replace("/<(\/?script.*?)>/si","",$str);	//过滤script标签
		//$str = preg_replace("/javascript/si","Javascript",$str);//过滤script标签
		//$str = preg_replace("/vbscript/si","Vbscript",$str);	//过滤script标签
		//$str = preg_replace("/on([a-z]+)\s*=/si","",$str);		//过滤script标签
		$str = preg_replace("/&#/si","&＃",$str);				//过滤script标签
		$str = preg_replace('/[\r\n]+/', "\n", $str);			//过滤多余空行

		return $str;
	}


	// 获取内容表的内容
	public static function GetTabContent($tabID, $dataID){
		global $DB;
		return $DB->GetOne('select IC_content from '. OT_dbPref .'infoContent'. $tabID .' where IC_ID='. $dataID);
	}

	// 设置内容表的内容（先检查，然后判断新增还是更新）
	public static function SetTabContent($tabID, $dataID, $content){
		global $DB;

		$retArr = array('res' => false, 'note' => '', 'data' => '');
		if ($tabID > 0){
			$chkRow = $DB->GetRow('select IC_ID from '. OT_dbPref .'infoContent'. $tabID .' where IC_ID='. $dataID);
			if ($chkRow){
				$retRes = $DB->UpdateParam('infoContent'. $tabID, array('IC_content'=>$content), 'IC_ID='. $dataID);
				$retArr = array('res' => true, 'note' => '更新成功', 'data' => $retRes);
			}else{
				$retRes = $DB->InsertParam('infoContent'. $tabID, array('IC_ID'=>$dataID, 'IC_content'=>$content));
				$retArr = array('res' => true, 'note' => '新增成功', 'data' => $retRes);
			}
		}else{
			$retArr = array('res' => false, 'note' => 'tabID错误', 'data' => '');
		}
		return $retArr;
	}


	// 锚文本替换字符串(自动过滤超链接和图片标签)(没用到)
	public static function KeyWordContent($strTemp, $mode='pc'){
		global $DB;

		preg_match_all("/(\<a[^<>]+\>.+?\<\/a\>)|(\<img[^<>]+\>)/is", $strTemp, $img_array);
		$img_array = array_unique($img_array[0]);	// 去掉重复

		$tempArr = array();
		$tempNum = 0;
		foreach ($img_array as $key => $value) {
			$tempArr[$tempNum] = $value;
			$strTemp = str_replace($value,'<OTre'. $tempNum .'>',$strTemp);
			$tempNum ++;
		}

		// 锚文本
		$wordexe = $DB->query('select KW_theme,KW_URL,KW_wapURL,KW_useNum from '. OT_dbPref .'keyWord where KW_isUse=1 order by KW_rank ASC');
		while ($row = $wordexe->fetch()){
			if (strpos($strTemp,$row['KW_theme']) !== false){
				if ($mode == 'wap' && strlen($row['KW_wapURL']) > 8){ $wapUrl = $row['KW_wapURL']; }else{ $wapUrl = $row['KW_URL']; }
				if ($row['KW_useNum']>0){
					$strTemp = preg_replace('/'. $row['KW_theme'] .'/', '<a href="'. $wapUrl .'" class="keyWord" target="_blank"><strong>'. $row['KW_theme'] .'</strong></a>', $strTemp, $row['KW_useNum']);
				}else{
					$strTemp = preg_replace('/'. $row['KW_theme'] .'/', '<a href="'. $wapUrl .'" class="keyWord" target="_blank"><strong>'. $row['KW_theme'] .'</strong></a>', $strTemp);
				}
			}
		}

		if ($tempNum > 0){
			for ($i=0; $i<$tempNum; $i++){
				$strTemp = str_replace('<OTre'. $i .'>', $tempArr[$i], $strTemp);
			}
		}
		
		return $strTemp;
	}


	// 下载附件
	public static function FileList($dataID, $IF_file, $IF_fileName, $IF_fileStr='', $fileTitle='', $fileStyle=0, $webPathPart=''){
		$retStr = '';
		if (strlen(''. $IF_fileStr) > 0){
			$fileArr = array_filter(explode('<arr>', $IF_fileStr));
			$fileCount = count($fileArr);
			if ($fileCount > 0){
				$retStr .= '<div style="font-size:14px;font-weight:bold;padding:1px 0;margin:10px 0 6px 0;border-bottom:1px #c9c9c9 solid;"><img src="'. $webPathPart .'inc_img/file.gif" style="margin:0 3px;display:inline;" />'. $fileTitle .'</div>';
				for ($i=0; $i<$fileCount; $i++){
					list($IF_file,$IF_fileName,$IF_fileRnd,$IF_filePwd) = explode('|', $fileArr[$i] .'||||');
					if (strlen($IF_file) >= 1){
						if (strlen($IF_fileName) == 0){ $IF_fileName = self::DefFileName($IF_file, $i+1); }
						$retStr .= '
							<div class="down_btn'. $fileStyle .'">
								<div class="down_left'. $fileStyle .'"></div>
								<div class="down_bg'. $fileStyle .'"><a href="'. $webPathPart .'deal.php?mudi=download&dataID='. $dataID .'&point='. $i .'&code='. $IF_fileRnd .'" class="font1_1" target="_blank"><b>'. $IF_fileName .'</b></a></div>
								'. (strlen($IF_filePwd) > 0 ? '<div class="down_bg'. $fileStyle .'"><div class="down_hline'. $fileStyle .'"></div><span class="copyTextBtn" style="cursor:pointer;" data-copytext="'. $IF_filePwd .'" title="点击复制提取码">提取码：'. $IF_filePwd .'</span></div>' : '') .'
								<div class="down_right'. $fileStyle .'"></div>
								<div class="clr"></div>
							</div>
							';
					}
				}
			}
			return $retStr .'<div class="clr"></div>';
		}else{
			if (strlen(''. $IF_file) >= 1){
				if (strlen(''. $IF_fileName) == 0){
					$IF_fileName = '点击下载';
				/* }else{
					$fileExt = File::GetExt($IF_file);
					if (strlen($fileExt) > 10){ $fileExt = ''; }else{ $fileExt = '.'. $fileExt; }
					$IF_fileName .= $fileExt; */
				}
				return '<div style="margin:12px 0 12px 0;"><a href="'. $webPathPart .'deal.php?mudi=download&dataID='. $dataID .'" class="font1_1"><b>附件下载：'. $IF_fileName .'</b></a></div>';
			}
		}
		return $retStr;
	}


	// 下载附件名称
	public static function DefFileName($fileUrl, $filePoint=''){
		$retStr = '点击下载'. $filePoint;
		if (Is::HttpUrl($fileUrl)){
			if (strpos($fileUrl,'//pan.baidu.com/') !== false){
				$retStr = '百度网盘'. $filePoint;
			}elseif (strpos($fileUrl,'.yunpan.com/') !== false){
				$retStr = '360安全云盘'. $filePoint;
			}elseif (strpos($fileUrl,'.aliyundrive.com/') !== false){
				$retStr = '阿里云盘'. $filePoint;
			}elseif (strpos($fileUrl,'//share.weiyun.com/') !== false){
				$retStr = '腾讯微云'. $filePoint;
			}elseif (strpos($fileUrl,'//caiyun.139.com/') !== false){
				$retStr = '中国移动云盘'. $filePoint;
			}elseif (strpos($fileUrl,'//cloud.189.cn/') !== false){
				$retStr = '天翼云盘'. $filePoint;
			}
		}

		return $retStr;
	}


	// 内容库分表+1
	public static function TabCurrNumAdd($tabRow = null){
		global $DB;

		if (! $tabRow){ $tabRow = $DB->GetRow('select IS_tabCurrNum,IS_tabMaxNum from '. OT_dbPref .'infoSys'); }
		$tabCurrNum = $tabRow['IS_tabCurrNum'] + 1;
		if ($tabCurrNum >= $tabRow['IS_tabMaxNum']){
			$retArr = Info::CreateInfoContent();
		}else{
			$DB->UpdateParam('infoSys', array('IS_tabCurrNum'=>'IS_tabCurrNum+1'), 'IS_ID=1');
		}

	}


	// 创建内容库分表
	public static function CreateInfoContent(){
		global $DB,$dbName,$infoSysArr;

		if (empty($infoSysArr)){ $infoSysArr = Cache::PhpFile('infoSys'); }
		
		if ($infoSysArr['IS_tabID'] == 0){ return array('ret'=>false, 'currNum'=>0, 'note'=>'用自身表，无需创建新表'); }

		$newTabID = 0;
		$retArr = array('ret'=>false,'note'=>'');
		$maxNewsNum = $DB->GetOne('select count(IC_ID) from '. OT_dbPref .'infoContent'. $infoSysArr['IS_tabID']);
			if ($maxNewsNum > $infoSysArr['IS_tabMaxNum']){
				$newTabID = $infoSysArr['IS_tabNum'] + 1;
			}

		if ($newTabID > 0){
			$tabName = 'infoContent'. $newTabID;
			if (OT_Database == 'sqlite'){
				$res = $DB->query('CREATE TABLE "OT_'. $tabName .'" (
							"IC_ID"  INTEGER(11) NOT NULL,
							"IC_content"  TEXT,
							PRIMARY KEY ("IC_ID")
							);');
			}else{
				$res = $DB->query('CREATE TABLE '. OT_dbPref . $tabName .' (
						  IC_ID int(11) NOT NULL DEFAULT "0",
						  IC_content longtext,
						  PRIMARY KEY (IC_ID)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;');
				// 判断如果 OT_infoContent1表IC_content字段编码是utf8mb4，也更改
				$charset = $DB->GetOne('SELECT CHARACTER_SET_NAME FROM information_schema.`COLUMNS` WHERE TABLE_SCHEMA="'. $dbName .'" AND TABLE_NAME="'. OT_dbPref .'infoContent1" AND COLUMN_NAME="IC_content"');
					if ($charset == 'utf8mb4'){
						$DB->query('ALTER TABLE `'. OT_dbPref . $tabName .'` MODIFY COLUMN `IC_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci');
					}
			}

			if ($res){
				$DB->UpdateParam('infoSys', array('IS_tabID'=>$newTabID, 'IS_tabNum'=>$newTabID, 'IS_tabCurrNum'=>0), 'IS_ID=1');

				$retArr = array('ret'=>true, 'currNum'=>0, 'note'=>'创建内容表 '. $tabName .' 成功');
			}else{
				if ($infoSysArr['IS_tabCurrNum'] != $maxNewsNum){
					$DB->UpdateParam('infoSys', array('IS_tabCurrNum'=>$maxNewsNum), 'IS_ID=1');
				}
				$retArr = array('ret'=>false, 'currNum'=>$maxNewsNum, 'note'=>'创建内容表 '. $tabName .' 失败');
			}
			
			$Cache = new Cache();
			$Cache->Php('infoSys');
		}else{
			$retArr = array('ret'=>false, 'currNum'=>$maxNewsNum, 'note'=>'当前内容表'. $infoSysArr['IS_tabID'] .'文章数量为'. $maxNewsNum .'，无需创建新表');
		}

		return $retArr;
	}


	// 计算内容图片各类型数量信息 array('total'=>总数, 'httpNum'=>远程数, 'ossNum'=>云存储数, 'localNum'=>本地数)
	public static function CalcFileNum($str){
		$total = $httpNum = $ossNum = $localNum = 0;

		if (strlen(''. $str) > 0){
			$ossUrlArr = AreaApp::OssUrlArr();

			$fileArr = array_filter(explode('<arr>', $str));
			$fileCount = count($fileArr);
			for ($i=0; $i<$fileCount; $i++){
				list($fileUrl,$fileName,$fileRnd,$filePwd) = explode('|', $fileArr[$i] .'||||');
				$total ++;
				if (Is::HttpUrl($fileUrl)){
					$imgType = AreaApp::OssUrlType($fileUrl, $ossUrlArr);
					if (strlen($imgType) > 0){
						$ossNum ++;
					}else{
						$httpNum ++;
					}
				}else{
					$localNum ++;
				}
			}
		}

		return array('total'=>$total, 'httpNum'=>$httpNum, 'ossNum'=>$ossNum, 'localNum'=>$localNum);
	}


	// 文章栏目infoTypeStr 转为栏目数组
	public static function InfoTypeArr($typeStr){
		$type1ID = 0;
		$type2ID = 0;
		$type3ID = 0;
		$typeCurrID = 0;
		if ($typeStr == 'announ'){
			$type1ID = -1;
		}else{
			$typeArr = explode(',', $typeStr);
			$typeCount = count($typeArr);
			if ($typeCount >= 3){
				$typeCurrID = intval($typeArr[$typeCount-2]);
				$type1ID = intval($typeArr[1]);
				if ($typeCount >= 4){
					$type2ID = intval($typeArr[2]);
					if ($typeCount >= 5){
						$type3ID = intval($typeArr[3]);
					}
				}
			}
		}
		if ($typeCurrID == 0){ $typeCurrID = $type1ID; }

		return array('type1ID' => $type1ID, 'type2ID' => $type2ID, 'type3ID' => $type3ID, 'typeCurrID' => $typeCurrID);
	}


	// 附件列表字符串转为数组
	public static function FileStrToArr($str){
		$retArr = array();
		$fileArr = array_filter(explode('<arr>', $str));
		$fileCount = count($fileArr);
		for ($i=0; $i<$fileCount; $i++){
			$itemArr = explode('|', $fileArr[$i] .'||||');	// 至少5个数组元素 0文件地址|1文件名称|2适配码|3提取码|4预留项
			$retArr[] = array('theme' => $itemArr[1], 'url' => $itemArr[0], 'rnd' => $itemArr[2], 'pwd' => $itemArr[3]);
		}
		return $retArr;
	}


	// 附件列表字符串转为数组
	public static function InfoTypeCN($type1ID, $type2ID=0, $type3ID=0, $mode=''){
		global $DB;

		$typeArr = array();
		$type1Name = $DB->GetOne('select IT_theme from '. OT_dbPref .'infoType where IT_ID='. $type1ID);
		$typeArr[] = $type1Name;
		if ($type2ID > 0){
			$type2Name = $DB->GetOne('select IT_theme from '. OT_dbPref .'infoType where IT_ID='. $type2ID);
			$typeArr[] = $type2Name;
		}
		return implode('→', $typeArr);
	}


	// 缩略图类型/文件类型
	// 0无，1本地，2远程，3云存储，10自动配图，13自动配图云存储
	// 1,10 本地图片；2,3,13 远程图片；2,13 云存储
	public static function ImgMode($img){
		global $ossUrlArr;

		$imgMode = 0;
		if (strlen($img) > 7){
			if (Is::HttpUrl($img)){
				if (empty($ossUrlArr)){ $ossUrlArr = AreaApp::OssUrlArr(); }
				$imgType = AreaApp::OssUrlType($img, $ossUrlArr);
				if (strlen($imgType) > 0){
					if (strpos($img,'autoImg/info') !== false){
						$imgMode = 13;	// 自动配图云存储
					}else{
						$imgMode = 3;	// 云存储图片
					}
				}else{
					$imgMode = 2;	// 远程图片
				}
			}elseif (strpos($img,'autoImg/info') !== false){
				$imgMode = 10;	// 自动配图
			}else{
				$imgMode = 1;	// 本地图片
			}
		}
		return $imgMode;
	}


	// 获取附件文件数组
	public static function FileUrlArr($str, $type=''){
		$fileArr = self::FileStrToArr($str);
		$retArr = array();
		foreach ($fileArr as $item){
			if ($type == '' || ($type == 'local' && Is::AbsUrl($item['url']) == false)){
				$retArr[] = $item['url'];
			}
		}
	}


	// 是否是可以删除的图片
	public static function IsDelImg($img){
		if (substr($img,0,2)=='OT' || substr($img,0,5)=='coll/' || substr($img,0,8)=='ueditor/'){
			return true;
		}else{
			return false;
		}
	}


	// 删除文章及其相关记录
	public static function DelData($dataID, $row=null){
		global $DB,$systemArr;

		$alertStr = '';
		if (! $row){
			$row = $DB->GetRow('select IF_ID,IF_upImgStr,IF_imgMode,IF_img,IF_fileStr,IF_pageCount,IF_userID,IF_infoTypeDir,IF_datetimeDir,IF_tabID,IF_content from '. OT_dbPref .'info where IF_ID='. $dataID);
		}

		$ossUrlArr = AreaApp::OssUrlArr();

		// 读取文章正文内容
		if ($row['IF_tabID'] > 0){
			$content = $DB->GetOne('select IC_content from '. OT_dbPref .'infoContent'. $row['IF_tabID'] .' where IC_ID='. $dataID);
		}else{
			$content = $row['IF_content'];
		}
		// 获取正文内容图片信息
		$imgArr = Content::GetImgArr($content, true);
		if ($row['IF_imgMode'] > 0){
			$imgArr[] = $row['IF_img'];
		}
		// print_r($imgArr);die();
		// 删除图片
		foreach ($imgArr as $img){
			if (strlen($img) > 3){
				$img = str_replace(array('../','..\\','%'), array('','',''), $img);
				$ossArr = AreaApp::OssUrlType($img, $ossUrlArr, 'arr');
				if (! empty($ossArr)){
					if (self::IsDelImg($ossArr['name'])){
						$ossRetArr = AreaApp::OssDel($ossArr['type'], $ossArr['name']);
						// echo('<div>'. $ossArr['type'] .'|'. $ossArr['name'] .'</div>');
						// print_r($ossRetArr);
					}

				}elseif (self::IsDelImg($img)){
					File::Del(OT_ROOT . InfoImgDir . $img);

				}
			}
		}
		// 删除附件

		if ($row['IF_userID'] > 0){
			// 删掉会员相关记录
			$DB->query('update '. OT_dbPref .'users set UE_newsCount=UE_newsCount-1 where UE_ID='. $row['IF_userID']);
			Users::DelFile('UF_proID='. $dataID .' and UF_proType="info"');
		}

		// ServerFile::UseCutMore($row['IF_upImgStr'] .'|'. $row['IF_img']);

		// 如果纯静态路径，删除静态页
		if ($systemArr['SYS_newsShowUrlMode'] == 'html-2.x'){
			$htmlPath = Url::NewsID($row['IF_infoTypeDir'],$row['IF_datetimeDir'],$dataID,0);
			$delJud = File::Del(OT_ROOT . $htmlPath);
			$alertStr .= '<div>'. $htmlPath .' 删除'. ($delJud ? '成功' : '失败') .'</div>';

			$htmlPath = 'wap/'. Url::NewsID($row['IF_infoTypeDir'],$row['IF_datetimeDir'],$dataID,0);
			$delJud = File::Del(OT_ROOT . $htmlPath);
			$alertStr .= '<div>'. $htmlPath .' 删除'. ($delJud ? '成功' : '失败') .'</div>';

			if ($row['IF_pageCount'] > 1){
				for ($i=2; $i<=$row['IF_pageCount']; $i++){
					$htmlPath = Url::NewsID($row['IF_infoTypeDir'],$row['IF_datetimeDir'],$dataID,$i);
					$delJud = File::Del(OT_ROOT . $htmlPath);
					$alertStr .= '<div>'. $htmlPath .' 删除'. ($delJud ? '成功' : '失败') .'</div>';

					$htmlPath = 'wap/'. Url::NewsID($row['IF_infoTypeDir'],$row['IF_datetimeDir'],$dataID,$i);
					$delJud = File::Del(OT_ROOT . $htmlPath);
					$alertStr .= '<div>'. $htmlPath .' 删除'. ($delJud ? '成功' : '失败') .'</div>';
				}
			}
		}

		if (AppUserView::Jud()){
			// 会员文章浏览记录
			$DB->query('delete from '. OT_dbPref .'userView where UV_infoID='. $dataID .' and UV_type='. $DB->ForStr('info'));
		}
		if (AppUserMark::Jud()){
			// 会员文章收藏记录
			$DB->query('delete from '. OT_dbPref .'userMark where UM_infoID='. $dataID .' and UM_type='. $DB->ForStr('info'));
		}
		if (AppInfoDown::Jud()){
			// 会员文章下载记录
			$DB->query('delete from '. OT_dbPref .'infoDown where ID_infoID='. $dataID);
		}
		/*
		if (AppReport::Jud()){
			// 举报功能
			$DB->query('delete from '. OT_dbPref .'report where RP_dataID='. $dataID);
		}
		*/

		// 删除内容表记录
		if ($row['IF_tabID'] > 0){
			$DB->query('delete from '. OT_dbPref .'infoContent'. $row['IF_tabID'] .' where IC_ID='. $dataID);
		}
		// 删除文章记录
		$judRes = $DB->query('delete from '. OT_dbPref .'info where IF_ID='. $dataID);

		return array('res' => $judRes, 'note'=>$alertStr);
	}


	// 生成个新采集路径文件名 如：coll/OT123.jpg 、coll/2023/OT123.jpg
	public static function NewCollFileName($isDir, $ext){
		$saveDirPath = Info::DateTimeDir($isDir);
		if (strlen($saveDirPath) > 0){
			$newFileDir = 'coll/'. $saveDirPath;
				if (! File::CreateDir(OT_ROOT . InfoImgDir . $newFileDir)){
					$newFileDir = 'coll/';
				}
		}else{
			$newFileDir = 'coll/';
		}
		$newFileName = $newFileDir .'OT'. File::GetNewName($ext);
		return $newFileName;
	}


	// 通过文章标签获取相关文章ID集
	public static function MarkNewsIdArr($markStr, $id = 0, $maxNum = 18){
		global $DB;

		$idNum = 0;
		$idArr = array();
		if (strlen($markStr) >= 1){
			$markArr = explode(',', $markStr);
			foreach ($markArr as $mark){
				if ($mark != ''){
					$keyexe = $DB->query('select IF_ID from '. OT_dbPref .'info where IF_isAudit=1 and IF_state=1 and IF_wapState=1'. OT_TimeInfoWhereStr ." and IF_themeKey like '%". $mark ."%' and IF_ID not in (". $id .') order by IF_time DESC limit '. $maxNum);
					while ($row = $keyexe->fetch()){
						$idNum ++;
						$idArr[] = $row['IF_ID'];
						if ($idNum >= $maxNum){
							break 2;
						}
					}
					$keyexe = null;
				}
			}
		}
		return $idArr;
	}


	// 获取文章上几篇ID集
	public static function PrevIdArr($infoTime, $whereStr='', $maxNum = 1){
		global $DB;

		$idArr = array();
		$dataexe = $DB->query('select IF_ID from '. OT_dbPref .'info where IF_isAudit=1 and IF_state=1 and IF_wapState=1'. $whereStr .' and IF_time<='. $DB->ForTime(TimeDate::Add('s',-1,$infoTime)) .' order by IF_time DESC limit '. $maxNum);
		while ($row = $dataexe->fetch()){
			$idArr[] = $row['IF_ID'];
		}
		$dataexe = null;

		return $idArr;
	}


	// 获取文章下几篇ID集
	public static function NextIdArr($infoTime, $whereStr='', $maxNum = 1){
		global $DB;

		$idArr = array();
		$dataexe = $DB->query('select IF_ID from '. OT_dbPref .'info where IF_isAudit=1 and IF_state=1 and IF_wapState=1'. $whereStr .' and IF_time>='. $DB->ForTime(TimeDate::Add('s',1,$infoTime)) .' order by IF_time ASC limit '. $maxNum);
		while ($row = $dataexe->fetch()){
			$idArr[] = $row['IF_ID'];
		}
		$dataexe = null;

		return $idArr;
	}


	// IF_addition 项目数组
	public static function AdditionArr($addition){
		$retArr = array();
		// $retArr['themeAppr']		= strpos($addition,'|themeAppr|') !== false ? 1 : 0;			// 标题伪原创
		// $retArr['contentAppr']	= strpos($addition,'|contentAppr|') !== false ? 1 : 0;			// 内容伪原创
		$retArr['ori']				= strpos($addition,'|ori|') !== false ? 1 : 0;					// 原创
		$retArr['noMakeHtml']		= strpos($addition,'|noMakeHtml|') !== false ? 1 : 0;			// 提交不生成静态页
		$retArr['noInfoType']		= strpos($addition,'|noInfoType|') !== false ? 1 : 0;			// 栏目[文章设置覆盖]无效
		$retArr['autoImg']			= strpos($addition,'|autoImg|') !== false ? 1 : 0;				// 缩略图栏如为空，自动配图
		$retArr['autoImg_homeThumb']= strpos($addition,'|autoImg_homeThumb|') !== false ? 1 : 0;	// 自动配图 首页缩略图
		$retArr['autoImg_thumb']	= strpos($addition,'|autoImg_thumb|') !== false ? 1 : 0;		// 自动配图 缩略图
		$retArr['autoImg_flash']	= strpos($addition,'|autoImg_flash|') !== false ? 1 : 0;		// 自动配图 幻灯片
		$retArr['autoImg_img']		= strpos($addition,'|autoImg_img|') !== false ? 1 : 0;			// 自动配图 滚动图片
		$retArr['isSaveContImg']	= strpos($addition,'|isSaveContImg|') !== false ? 1 : 0;		// 保存内容中的图片到本地
		$retArr['checkUser']		= strpos($addition,'|checkUser|') !== false ? 1 : 0;			// 仅限会员阅读
		$retArr['checkReply']		= strpos($addition,'|checkReply|') !== false ? 1 : 0;			// 会员回复可见
		$retArr['checkQuick']		= strpos($addition,'|checkQuick|') !== false ? 1 : 0;			// 直接在线支付
		$retArr['checkPwd']			= strpos($addition,'|checkPwd|') !== false ? 1 : 0;				// 输入密码可见
		$retArr['encMediaFile']		= strpos($addition,'|encMediaFile|') !== false ? 1 : 0;			// 隐藏区 视频音频
		$retArr['encFile']			= strpos($addition,'|encFile|') !== false ? 1 : 0;				// 隐藏区 附件文件
		return $retArr;
	}


	// 栏目数组
	public static function InfoTypeListArr($type=''){
		global $DB;

		$whereStr = '';
		if ($type == 'admin'){ // 后台投稿
			$whereStr = " and IT_isAdminUser=1 and IT_mode in ('item','url','web')";
			$where2Str = " and IT_isAdminUser=1 and IT_mode='item'";
		}elseif ($type == 'qiantai'){ // 前台投稿
			$whereStr = ' and IT_isUser=1';
			$where2Str = ' and IT_isUser=1';
		}
		$typeNum = 0;
		$retArr = array();
		$typeexe = $DB->query('select IT_ID,IT_theme,IT_mode from '. OT_dbPref ."infoType where IT_state=1 and IT_level=1". $whereStr ." order by IT_rank ASC");
		while ($row = $typeexe->fetch()){
			$typeNum ++;
			$type2Arr = array();

			$type2exe=$DB->query('select IT_ID,IT_theme,IT_mode from '. OT_dbPref ."infoType where IT_state=1 and IT_level=2 and IT_fatID=". $row['IT_ID'] . $where2Str ." order by IT_rank ASC");
				while ($row2 = $type2exe->fetch()){
					$type2Arr[] = $row2;
				}
			$type2exe = null;

			$tmp = array();
			$tmp['serNum']	= $typeNum;
			$tmp['arr']		= $type2Arr;
			$retArr[] = array_merge($row, $tmp);
		}

		return $retArr;
	}


	// 栏目option列表
	public static function InfoTypeOption($type='', $def=''){
		$dataArr = self::InfoTypeListArr($type);

		$retStr = '';
		if (count($dataArr) > 0){
			foreach ($dataArr as $row){
				$txt = '';
				if ($type == 'admin'){
					$txt = '&ensp;&ensp;[id:'. $row['IT_ID'] .']'. InfoType::ModeCN($row['IT_mode']) .'';
				}
				$retStr .= '<option value=",'. $row['IT_ID'] .'," '. Is::InstrSelected($def, ','. $row['IT_ID'] .',') .'>'. $row['serNum'] .'、'. $row['IT_theme'] . $txt .'</option>';
				foreach ($row['arr'] as $row2){
					if ($type == 'admin'){
						$txt = '&ensp;&ensp;[id:'. $row2['IT_ID'] .']';
					}
					$retStr .= '<option value=",'. $row['IT_ID'] .','. $row2['IT_ID'] .'," '. Is::InstrSelected($def, ','. $row2['IT_ID'] .',') .'>&ensp;&ensp;&ensp;┣&ensp;'. $row2['IT_theme'] . $txt .'</option>';
				}
				// if (count($row['arr']) == 0){
				// }else{
				//	$retStr .= '<optgroup label="'. $row['serNum'] .'、'. $row['IT_theme'] .'" style="font-weight:normal;"></optgroup>';
				// }
			}
		}else{
			$txt = '无栏目';
			if ($type == 'admin'){
				$txt = '无栏目【常规设置→栏目管理】（是否【后台投稿】未开启，【状态】隐藏）';
			}
			$retStr .= '<option value="">'. $txt .'</option>';
		}

		return $retStr;
	}


	// 类别option化
	public static function TypeOptionList($type, $noNote='', $addiArr = array()){
		global $DB;
	
		$retStr = '';
		$typeexe = $DB->query('select TP_theme from '. OT_dbPref ."type where TP_type='". $type ."' order by TP_rank ASC");
		if ($row = $typeexe->fetch()){
			do {
				if ($type == 'writer' && isset($addiArr['realname'])){
					$theme = str_replace('{%昵称%}', $addiArr['realname'], $row['TP_theme']);
				}else{
					$theme = $row['TP_theme'];
				}
				$selectedStr = '';
				if (isset($addiArr['defValue']) && strlen($addiArr['defValue'])>0){
					$selectedStr = ' selected="selected"';
				}
				$retStr .= '<option value="'. $theme .'"'. $selectedStr .'>'. $theme .'</option>';
			}while ($row = $typeexe->fetch());
		}else{
			if (strlen($noNote) > 0){ $retStr .= '<option value="">'. $noNote .'</option>'; }
		}
		unset($typeexe);

		return $retStr;
	}


	// 文章信息处理，如增加文章阅读量
	public static function NewsDeal(){
		global $DB;

		$mode		= OT::GetStr('mode');
		$id			= OT::GetInt('id');
		$isNoRet	= OT::GetInt('isNoRet');		// 0 纯静态或有缓存，1 无静态无缓存
			if ($mode != 'wap'){ $mode = 'pc'; }

		$judAdd = true;
		$infoSysArr = Cache::PhpFile('infoSys');
		if ($infoSysArr['IS_oneReadNum'] == 1){
			if (! isset($_SESSION[OT_SiteID .'readNumList'])){ $_SESSION[OT_SiteID .'readNumList'] = ''; }
			if (strpos($_SESSION[OT_SiteID .'readNumList'],'['. $id .']') !== false){
				$judAdd = false;
			}else{
				$_SESSION[OT_SiteID .'readNumList'] .= '['. $id .']';
			}
		}

		if ($judAdd){
			$addReadNum = OT::RndNumTo($infoSysArr['IS_readNum1'],$infoSysArr['IS_readNum2']);
			if ($addReadNum < 1){ $addReadNum = 1; }

			$DB->query('update '. OT_dbPref .'info set IF_readNum=IF_readNum+'. $addReadNum .',IF_readNumReal=IF_readNumReal+1 where IF_ID='. $id);
			echo('/* +'. $addReadNum .' */'. PHP_EOL);
		}else{
			echo('/* 已访问过 */'. PHP_EOL);
		}

		if ($isNoRet == 0){
			$infoexe = $DB->query('select IF_readNum,IF_replyNum,IF_mediaFile from '. OT_dbPref .'info where IF_ID='. $id);
				if ($row = $infoexe->fetch()){
					echo('
					try {
						document.getElementById("infoReadNum").innerHTML="'. $row['IF_readNum'] .'";
					}catch (e) {}
					try {
						document.getElementById("infoReplyNum").innerHTML="'. $row['IF_replyNum'] .'";
					}catch (e) {}
					try {
						document.getElementById("replyBoxNum").innerHTML="'. $row['IF_replyNum'] .'";
					}catch (e) {}
					$(function (){
						try {
							document.getElementById("infoReadNum").innerHTML="'. $row['IF_readNum'] .'";
						}catch (e) {}
						try {
							document.getElementById("infoReplyNum").innerHTML="'. $row['IF_replyNum'] .'";
						}catch (e) {}
						try {
							document.getElementById("replyBoxNum").innerHTML="'. $row['IF_replyNum'] .'";
						}catch (e) {}
					});
					');
				}
			unset($infoexe);
		}

		echo(AppUserMark::NewsJs($id));
	}

	// 检测文章重复标题
	public static function CheckRepeatTheme(){
		global $DB;

		$dataID		= OT::GetInt2( OT::ParaArr('id') );
		$theme		= OT::GetStr('theme');
			if (strlen($theme) == 0){
				die('文章标题不能为空。');
			}
		$themeMd5	= md5($theme);
			if ($dataID>0){ $whereIdStr = ' and IF_ID not in ('. $dataID .')'; }else{ $whereIdStr = ''; }

		$checkexe=$DB->query("select IF_ID from ". OT_dbPref ."info where IF_themeMd5='". $themeMd5 ."'". $whereIdStr .' limit 1');
			if ($checkexe->fetch()){
				die('抱歉，该文章标题已存在。');
			}else{
				die('恭喜，该文章标题未被占用。');
			}
		unset($checkexe);
	}

	// 统计付费人员数量
	public static function PayUserCount($scoreUserList){
		if (strpos(''. $scoreUserList,'[') !== false){
			$strArr = explode('[', ''. $scoreUserList);
			return count($strArr) - 1;
		}else{
			return 0;
		}
	}



	// 判断付费阅读是否通过，输入文章ID，返回数组
	public static function InfoReadPassArr($type, $dataID){
		global $DB;

		if ($type == 'reply'){
			// 限制阅读 会员回复可见
			$userRow = Users::Open('get',',UE_username,UE_state','',$judUserErr);
			if ((! $userRow) || $judUserErr != ''){
				return array('res'=>false, 'note'=>'请先会员登录，再发表评论');
			}
			if ($userRow['UE_state'] == 0){
				return array('res'=>false, 'note'=>'您当前状态 未审核，审核通过后再发表评论');
			}

			$userID = $userRow['UE_ID'];
			$imRow = $DB->GetRow('select IM_state from '. OT_dbPref .'infoMessage where IM_infoID='. $dataID .' and IM_userID='. $userID .' order by IM_state DESC limit 1');
			if ($imRow){
				if ($imRow['IM_state'] == 1){
					return array('res'=>true, 'note'=>'');
				}else{
					return array('res'=>false, 'note'=>'等待评论审核通过');
				}
			}else{
				return array('res'=>false, 'note'=>'发表评论，并审核通过显示出来');
			}

		}elseif ($type == 'score'){
			// 限制阅读 仅限会员阅读
		
		}
	}



	// 栏目【限制/付费阅读】isCheckUser值
	public static function InfoTypeIsCheckUser($addition, $IF_addition){
		$retNum = 0;
		$retVal = 0;
		if (strpos(''. $addition,'|act_checkUser|') !== false){
			$retNum ++;
			if (strpos(''. $addition,'|checkUser|') !== false){
				$retVal += 10;
			}
		}elseif (strpos($IF_addition,'|checkUser|') !== false){
			$retVal += 10;
		}

		if (strpos(''. $addition,'|act_checkReply|') !== false){
			$retNum ++;
			if (strpos(''. $addition,'|checkReply|') !== false){
				$retVal += 10;
			}
		}elseif (strpos($IF_addition,'|checkReply|') !== false){
			$retVal += 10;
		}

		if (strpos(''. $addition,'|act_checkQuick|') !== false){
			$retNum ++;
			if (strpos(''. $addition,'|checkQuick|') !== false){
				$retVal += 10;
			}
		}elseif (strpos($IF_addition,'|checkQuick|') !== false){
			$retVal += 10;
		}

		if (strpos(''. $addition,'|act_checkPwd|') !== false){
			$retNum ++;
			if (strpos(''. $addition,'|checkPwd|') !== false){
				$retVal += 10;
			}
		}elseif (strpos($IF_addition,'|checkPwd|') !== false){
			$retVal += 10;
		}

		if ($retNum == 0){
			return -1;
		}else{
			return $retVal;
		}
	}

}
?>