<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class AutoRun{
	public static $isAjaxRun = 1;
	public static $dayStatiNum = 0;

	// 自动操作运行
	public static function Deal($mode='pc'){
		global $DB,$systemArr;

		$type		= OT::GetStr('type');
		$beforeURL	= GetUrl::CurrDir();

		$todayDate	= TimeDate::Get('date');
		$todayMonth	= TimeDate::Get('m');

		self::$isAjaxRun = OT::GetInt('isAjaxRun');

		// 获取模板参数数组
		$autoRunSysArr = Cache::PhpFile('autoRunSys');

		if (strlen($type) == 0 || strpos($autoRunSysArr['ARS_runArea'],'|'. $type .'|') === false){
			AutoRun::StrShow('time', 'type参数 不再 '. $autoRunSysArr['ARS_runArea'] .' 范围内');
			die();
		}

		if ($mode == 'wap'){
			$modeCN = '手机';
			$fieldStr = 'Wap';
		}else{
			$mode = 'pc';
			$modeCN = '电脑';
			$fieldStr = '';
		}

		if (strtotime($autoRunSysArr['ARS_dayDate']) != strtotime($todayDate)){
			$judTodayRun = true;
		}else{
			$judTodayRun = false;
		}

		if ($judTodayRun){
			// 节日倒计时
			if ( AppJieri::Jud() ){
				if ( AppJieri::UpdateJsCache() ){
					AutoRun::StrShow('time', '生成jieri.js成功');
				}else{
					AutoRun::StrShow('time', '生成jieri.js失败');
				}
			}else{
				AutoRun::StrShow('time', '【节日倒计时】插件未使用');
			}
			
			// 前台js集缓存
			if (Cache::UpdateConfigJs()){
				AutoRun::StrShow('time', '生成configJs.js成功');
			}else{
				AutoRun::StrShow('time', '生成configJs.js失败');
			}

			$DB->query('update '. OT_dbPref .'autoRunSys set ARS_dayDate='. $DB->ForTime(TimeDate::Get('date')));
			$Cache = new Cache();
			$Cache->Php('autoRunSys');
			$Cache->Js('autoRunSys');
		}


		// 判断是否运行定时检查
		if ($autoRunSysArr['ARS_isTimeRun'] == 1 && ($type == 'duli' || strpos($autoRunSysArr['ARS_runArea'],'|qiantaiTime|') !== false)){
			if (strtotime($autoRunSysArr['ARS_timeRunTime']) + $autoRunSysArr['ARS_timeRunMin']*60 < time()){
				$startTime	= microtime(true);
				$todayTime = TimeDate::Get();
				$Cache = new Cache();

				$DB->query('update '. OT_dbPref .'autoRunSys set ARS_timeRunTime='. $DB->ForTime( TimeDate::Add('min',$autoRunSysArr['ARS_timeRunMin']*(-60)+15,$todayTime) ));
				$Cache->Php('autoRunSys');
				$Cache->Js('autoRunSys');

				$logStr = '';
				if (strpos($autoRunSysArr['ARS_timeRunItem'],'|infoContent|') !== false){
					$retArr = AutoRun::InfoContent();
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('time', '【定时检查】'. $retArr['note']);
				}
				if (strpos($autoRunSysArr['ARS_timeRunItem'],'|taokeOrder|') !== false){
					$retArr = AppTaokeOrder::AutoRunDeal();
					if (strlen($logStr) > 3){ $logStr .= '<br />'; }
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('time', '【定时检查】'. $retArr['note']);
				}
				if (strpos($autoRunSysArr['ARS_timeRunItem'],'|gainJiesuan|') !== false){
					$retArr = AppGain::AutoRunDeal();
					if (strlen($logStr) > 3){ $logStr .= '<br />'; }
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('time', '【定时检查】'. $retArr['note']);
				}
				if (strpos($autoRunSysArr['ARS_timeRunItem'],'|taobaokeDataoke|') !== false){
					$retArr = AppTaobaoke::AutoRunDeal();
					if (strlen($logStr) > 3){ $logStr .= '<br />'; }
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('time', '【定时检查】'. $retArr['note']);
				}

				$DB->query('update '. OT_dbPref .'autoRunSys set ARS_timeRunTime='. $DB->ForTime($todayTime));
				$Cache->Php('autoRunSys');
				$Cache->Js('autoRunSys');

				$endTime = microtime(true);

				$logArr = array();
				$logArr['ARL_time']		= $todayTime;
				$logArr['ARL_type']		= 'time';
				$logArr['ARL_dataID']	= 0;
				$logArr['ARL_content']	= ($type=='duli' ? '『独立页』' : '【'. $modeCN .'版】') .'用时'. round($endTime-$startTime,2) .'秒<br />' . $logStr;
				$DB->InsertParam('autoRunLog',$logArr);
			}else{
				AutoRun::StrShow('time', '【定时检查】未到时间 '. $autoRunSysArr['ARS_timeRunTime'] .'['. $autoRunSysArr['ARS_timeRunMin'] .']');
			}
		}else{
			AutoRun::StrShow('time', '【定时检查】未开启');
		}


		// 判断是否运行每日检查
		if ($autoRunSysArr['ARS_isDayRun'] == 1 && ($type == 'duli' || strpos($autoRunSysArr['ARS_runArea'],'|qiantaiDay|') !== false)){
			if (strtotime($autoRunSysArr['ARS_dayRunTime']) < strtotime($todayDate)){
				$startTime	= microtime(true);
				$todayTime = TimeDate::Get();
				$Cache = new Cache();

				$DB->query('update '. OT_dbPref .'autoRunSys set ARS_dayRunTime='. $DB->ForTime($todayTime));
				$Cache->Php('autoRunSys');
				$Cache->Js('autoRunSys');

				$logStr = '';
				if (strpos($autoRunSysArr['ARS_dayRunItem'],'|infoContent|') !== false){
					// 文章内容库分表
					$retArr = AutoRun::InfoContent();
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('day', '【每日检查】'. $retArr['note']);
				}
				if (strpos($autoRunSysArr['ARS_dayRunItem'],'|userGroupExp|') !== false){
					// 会员组过期x天转为默认组
					$retArr = AutoRun::UserGroupExp();
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('day', '【每日检查】'. $retArr['note']);
				}
				if (strpos($autoRunSysArr['ARS_dayRunItem'],'|prevNext|') !== false){
					// 内容页上下篇ID清空
					$retArr = AutoRun::PrevNext();
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('day', '【每日检查】'. $retArr['note']);
				}
				if (strpos($autoRunSysArr['ARS_dayRunItem'],'|markNews|') !== false){
					// 内容页相关文章ID清空
					$retArr = AutoRun::MarkNews();
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('day', '【每日检查】'. $retArr['note']);
				}
				if (strpos($autoRunSysArr['ARS_dayRunItem'],'|ca|') !== false){
					// 广告数据
					$retArr = AutoRun::Ca();
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('day', '【每日检查】'. $retArr['note']);
				}
				if (strpos($autoRunSysArr['ARS_dayRunItem'],'|robot|') !== false){
					// 访客雷达-更新每日统计
					$retArr = AppRobot::AddListData();
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('day', '【每日检查】【访客雷达-更新每日统计】'. $retArr['note']);
				}
				if (strpos($autoRunSysArr['ARS_dayRunItem'],'|dingding|') !== false){
					// 每日网站汇总-钉钉群
					$retArr = AppDingding::AutoRunDeal();
					$retArr['note'] = str_replace('<br />', '', $retArr['note']);
					if (strlen($logStr) > 3){ $logStr .= '<br />'; }
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('day', '【每日检查】'. $retArr['note']);
				}
				if (strpos($autoRunSysArr['ARS_dayRunItem'],'|weixinWork|') !== false){
					// 每日网站汇总-企业微信群
					$retArr = AppWeixinWork::AutoRunDeal();
					$retArr['note'] = str_replace('<br />', '', $retArr['note']);
					if (strlen($logStr) > 3){ $logStr .= '<br />'; }
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('day', '【每日检查】'. $retArr['note']);
				}
				/* if (strpos($autoRunSysArr['ARS_dayRunItem'],'|phone|') !== false){
					$retArr = AppPhone::AutoRunDeal();
					$retArr['note'] = str_replace('<br />', '', $retArr['note']);
					if (strlen($logStr) > 3){ $logStr .= '<br />'; }
					$logStr .= $retArr['note'] .';';
					AutoRun::StrShow('day', '【每日检查】'. $retArr['note']);
				} */

				$DB->query('update '. OT_dbPref .'autoRunSys set ARS_dayRunTime='. $DB->ForTime($todayTime));
				$Cache->Php('autoRunSys');
				$Cache->Js('autoRunSys');

				$endTime = microtime(true);

				$logArr = array();
				$logArr['ARL_time']		= $todayTime;
				$logArr['ARL_type']		= 'day';
				$logArr['ARL_dataID']	= 0;
				$logArr['ARL_content']	= ($type=='duli' ? '『独立页』' : '【'. $modeCN .'版】') .'用时'. round($endTime-$startTime,2) .'秒<br />' . $logStr;
				$DB->InsertParam('autoRunLog',$logArr);
			}else{
				AutoRun::StrShow('day', '【每日检查】未到时间 '. $autoRunSysArr['ARS_dayRunTime'] .'');
			}
		}else{
			AutoRun::StrShow('day', '【每日检查】未开启');
		}


		// 判断是否生成首页静态页
		if ($autoRunSysArr['ARS_isHtmlHome'] == 1 && $systemArr['SYS_isHtmlHome'] == 1){
			if ($judTodayRun || strtotime($autoRunSysArr['ARS_htmlHome'. $fieldStr .'Time']) + $autoRunSysArr['ARS_htmlHomeMin']*60 < time()){
				AutoRun::ResShow('home', 'makeHtml_run'. $fieldStr .'.php?mudi=homeHtml', $mode);
			}else{
				AutoRun::StrShow('home', '生成首页静态页 '. $systemArr['SYS_htmlHomeName'] .' 未到时间 '. $autoRunSysArr['ARS_htmlHome'. $fieldStr .'Time'] .'['. $autoRunSysArr['ARS_htmlHomeMin'] .']');
			}
		}else{
			AutoRun::StrShow('home', '生成首页静态页 '. $systemArr['SYS_htmlHomeName'] .' 未开启');
		}


		// 判断是否生成列表静态页
		if ($autoRunSysArr['ARS_isHtmlList'] == 1){
			if (strtotime($autoRunSysArr['ARS_htmlList'. $fieldStr .'Time']) + $autoRunSysArr['ARS_htmlListMin']*60 < time()){
				if ($mode == 'wap'){
					AppAutoHtml::WapList();
				}else{
					AppAutoHtml::PcList();
				}
			}else{
				AutoRun::StrShow('list', '生成列表静态页 未到时间 '. $autoRunSysArr['ARS_htmlList'. $fieldStr .'Time'] .'['. $autoRunSysArr['ARS_htmlListMin'] .']');
			}
		}else{
			AutoRun::StrShow('list', '生成列表静态页 未开启');
		}


		// 判断是否生成内容静态页
		if ($autoRunSysArr['ARS_isHtmlShow'] == 1){
			if (strtotime($autoRunSysArr['ARS_htmlShow'. $fieldStr .'Time']) + $autoRunSysArr['ARS_htmlShowMin']*60 < time()){
				if ($mode == 'wap'){
					AppAutoHtml::WapShow();
				}else{
					AppAutoHtml::PcShow();
				}
			}else{
				AutoRun::StrShow('show', '生成内容静态页 未到时间 '. $autoRunSysArr['ARS_htmlShow'. $fieldStr .'Time'] .'['. $autoRunSysArr['ARS_htmlShowMin'] .']');
			}
		}else{
			AutoRun::StrShow('show', '生成内容静态页 未开启');
		}


		// 判断是否数据同步/导入
		if ($autoRunSysArr['ARS_isApiItem'] == 1 && ($type == 'duli' || strpos($autoRunSysArr['ARS_runArea'],'|qiantaiApiItem|') !== false)){
			if (strtotime($autoRunSysArr['ARS_ApiItemTime']) + $autoRunSysArr['ARS_ApiItemMin']*60 < time()){
				AppAutoApiItem::PcShow();
			}else{
				AutoRun::StrShow('show', '数据同步/导入 未到时间 '. $autoRunSysArr['ARS_ApiItemTime'] .'['. $autoRunSysArr['ARS_ApiItemMin'] .']');
			}
		}else{
			AutoRun::StrShow('show', '数据同步/导入 未开启');
		}


		self::$isAjaxRun = 0;
		// 判断是否自动采集
		if ($autoRunSysArr['ARS_isColl'] == 1 && ($type == 'duli' || strpos($autoRunSysArr['ARS_runArea'],'|qiantaiColl|') !== false)){
			if (strtotime($autoRunSysArr['ARS_collTime']) + $autoRunSysArr['ARS_collMin']*60 < time()){
				AutoRun::StrShow('coll', '采集配置初始化中......');
				AutoRun::ResShow('coll', 'collRun2.php?mudi=start', $mode);

			}else{
				AutoRun::StrShow('coll', '自动采集 未到时间 '. $autoRunSysArr['ARS_collTime'] .'['. $autoRunSysArr['ARS_collMin'] .']');
			}
		}else{
			AutoRun::StrShow('coll', '自动采集 未开启');
		}

	}


	// 定时检查-内容库分表
	public static function InfoContent(){
		global $DB;

		$retArr = array('ret'=>false,'note'=>'');

		$infoSysArr = Cache::PhpFile('infoSys');

		if (strtotime($infoSysArr['IS_tabCheckTime']) + $infoSysArr['IS_tabCheckMin']*60 < time()){
			if ($infoSysArr['IS_tabID'] > 0){
				// $tabNum = $DB->GetRow('select IS_tabID,IS_tabNum,IS_tabMaxNum,IS_tabCurrNum from '. OT_dbPref .'infoSys');
				$retArr = Info::CreateInfoContent();
				$retArr['note'] = '【内容库分表】'. $retArr['note'];
			}else{
				$retArr = array('ret'=>false,'note'=>'【内容库分表】没用到内容表，无需创建新表');
			}
			$DB->query('update '. OT_dbPref .'infoSys set IS_tabCheckTime='. $DB->ForTime(TimeDate::Get()));
			$Cache = new Cache();
			$Cache->Php('infoSys');
		}else{
			$retArr = array('ret'=>false,'note'=>'【内容库分表】时间未到，最后检查时间'. $infoSysArr['IS_tabCheckTime'] .'，每'. $infoSysArr['IS_tabCheckMin'] .'分钟检查次');
		}

		return $retArr;
	}


	// 定时检查-会员组过期x天转为默认组
	public static function UserGroupExp(){
		global $DB;

		$retArr = array('ret'=>false,'note'=>'');

		$userSysArr = Cache::PhpFile('userSys');

		if ($userSysArr['US_groupExpDay'] > 0){
			$total = 0;
			$expTime = TimeDate::Add('d', $userSysArr['US_groupExpDay']*(-1), TimeDate::Get());
			$num = $DB->GetOne('select count(UE_ID) from '. OT_dbPref .'users where UE_isGroupTime=1 and UE_groupTime<='. $DB->ForTime($expTime));
			$DB->query('update '. OT_dbPref .'users set UE_groupID=1,UE_isGroupTime=0 where UE_isGroupTime=1 and UE_groupTime<='. $DB->ForTime($expTime));
			$retArr = array('ret'=>true,'note'=>'【会员组过期转默认组】过期'. $userSysArr['US_groupExpDay'] .'天'. $num .'名会员转为默认组');
		}else{
			$retArr = array('ret'=>false,'note'=>'【会员组过期转默认组】groupExpDay:'. $userSysArr['US_groupExpDay'] .'不启用');
		}

		return $retArr;
	}


	// 定时检查-内容页上下篇ID清空x天前
	public static function PrevNext(){
		global $DB;

		$retArr = array('ret'=>false,'note'=>'');

		$infoSysArr = Cache::PhpFile('infoSys');

		if ($infoSysArr['IS_prevNextDay'] > 0){
			$total = 0;
			$todayTime = TimeDate::Get();
			$expTime = TimeDate::Add('d', $infoSysArr['IS_prevNextDay']*(-1), $todayTime);
			$num = $DB->GetOne('select count(IF_ID) from '. OT_dbPref .'info where IF_prevNextTime<='. $DB->ForTime($expTime));
			$DB->query('update '. OT_dbPref .'info set IF_prevNewsId=0,IF_nextNewsId=0,IF_prevNextTime='. $DB->ForTime($todayTime) .' where IF_prevNextTime<='. $DB->ForTime($expTime));
			$retArr = array('ret'=>true,'note'=>'【内容页上下篇ID清空】'. $infoSysArr['IS_prevNextDay'] .'天前'. $num .'篇文章ID清空');
		}else{
			$retArr = array('ret'=>false,'note'=>'【内容页上下篇ID清空】prevNextDay:'. $infoSysArr['IS_prevNextDay'] .'不启用');
		}

		return $retArr;
	}


	// 定时检查-内容页相关文章ID清空x天前
	public static function MarkNews(){
		global $DB;

		$retArr = array('ret'=>false,'note'=>'');

		$infoSysArr = Cache::PhpFile('infoSys');

		if ($infoSysArr['IS_markNewsDay'] > 0){
			$total = 0;
			$todayTime = TimeDate::Get();
			$expTime = TimeDate::Add('d', $infoSysArr['IS_markNewsDay']*(-1), $todayTime);
			$num = $DB->GetOne('select count(IF_ID) from '. OT_dbPref .'info where IF_markNewsTime<='. $DB->ForTime($expTime));
			$DB->query('update '. OT_dbPref .'info set IF_prevNewsId=0,IF_nextNewsId=0,IF_markNewsTime='. $DB->ForTime($todayTime) .' where IF_markNewsTime<='. $DB->ForTime($expTime));
			$retArr = array('ret'=>true,'note'=>'【内容页相关文章ID清空】'. $infoSysArr['IS_markNewsDay'] .'天前'. $num .'篇文章ID清空');
		}else{
			$retArr = array('ret'=>false,'note'=>'【内容页相关文章ID清空】markNewsDay:'. $infoSysArr['IS_markNewsDay'] .'不启用');
		}

		return $retArr;
	}


	// 定时检查-广告数据
	public static function Ca(){
		global $DB;

		$retArr = array('ret'=>false,'note'=>'');

		if (Ca::MakeJs()){
			$retArr = array('ret'=>true,'note'=>'【广告数据】生成成功');
		}else{
			$retArr = array('ret'=>false,'note'=>'【广告数据】生成失败');
		}

		return $retArr;
	}


	// 每日检查-每日网站汇总
	public static function DayStatiInfo($eolStr = PHP_EOL){
		global $DB,$autoRunSysArr;

		if (empty($autoRunSysArr)){ $autoRunSysArr = Cache::PhpFile('autoRunSys'); }
		$dayRunList = $autoRunSysArr['ARS_dayRunList'];

		$todayDate	= TimeDate::Get('date');
		$date_1		= TimeDate::Add('d',-1,$todayDate);
		$dateMonth	= TimeDate::Get('Y-m-1');
			$monthStr = '当月';
			if (TimeDate::Get('j') == 1){
				$dateMonth = TimeDate::Add('m',-1,$dateMonth);
				$monthStr = '上月';
			}
		
		$retStr = $headStr = $footStr = '';
		if (strpos($dayRunList,'|info|') !== false){
			// 文章
			$infoAddNum = $DB->GetOne('select count(IF_ID) from '. OT_dbPref .'info where IF_time>='. $DB->ForTime($date_1));
			$infoUserNum = $DB->GetOne('select count(IF_ID) from '. OT_dbPref .'info where IF_userID>=1 and IF_time>='. $DB->ForTime($date_1));
			if ($infoAddNum > 0 || strpos($dayRunList,'|noSkip|') !== false){
				$retStr .= '新增文章 '. $infoAddNum .' 篇（投稿 '. $infoUserNum .' 篇）；'. $eolStr;
			}
		}
		if (strpos($dayRunList,'|users|') !== false){
			// 会员
			$userNum = $DB->GetOne('select count(UE_ID) from '. OT_dbPref .'users where UE_time>='. $DB->ForTime($date_1));
			$user0Num = $DB->GetOne('select count(UE_ID) from '. OT_dbPref .'users where UE_state=0 and UE_time>='. $DB->ForTime($date_1));
			if ($userNum > 0 || strpos($dayRunList,'|noSkip|') !== false){
				$retStr .= '新增会员 '. $userNum .' 名（未审核 '. $user0Num .' 名）；'. $eolStr;
			}
		}
		if (strpos($dayRunList,'|infoMessage|') !== false){
			// 评论
			$infoNum = $DB->GetOne('select count(IM_ID) from '. OT_dbPref .'infoMessage where IM_time>='. $DB->ForTime($date_1));
			if ($infoNum > 0 || strpos($dayRunList,'|noSkip|') !== false){
				$retStr .= '新增评论 '. $infoNum .' 条；'. $eolStr;
			}
		}
		if (strpos($dayRunList,'|message|') !== false){
			// 留言
			$infoNum = $DB->GetOne('select count(MA_ID) from '. OT_dbPref .'message where MA_time>='. $DB->ForTime($date_1));
			if ($infoNum > 0 || strpos($dayRunList,'|noSkip|') !== false){
				$retStr .= '新增留言 '. $infoNum .' 条；'. $eolStr;
			}
		}
		if (strpos($dayRunList,'|moneyBase|') !== false && AppMoneyRecord::Jud()){
			// 财务信息
			$rrs = $DB->GetRow('select count(MR_ID) as num,sum(MR_money) as money from '. OT_dbPref .'moneyRecord where MR_state=1 and MR_money>=0 and DATE_FORMAT(MR_time,"%Y-%m-%d") in ("'. $date_1 .'")');
			$addNum		= $rrs['num'];
			$addMoney	= floatval($rrs['money']);

			$rrs = $DB->GetRow('select count(MR_ID) as num,sum(MR_money) as money from '. OT_dbPref .'moneyRecord where MR_state=1 and MR_money<=0.01 and DATE_FORMAT(MR_time,"%Y-%m-%d") in ("'. $date_1 .'")');
			$cutNum		= $rrs['num'];
			$cutMoney	= floatval($rrs['money']);

			$cost = floatval($DB->GetOne('select sum(MR_cost) from '. OT_dbPref .'moneyRecord where MR_state=1 and DATE_FORMAT(MR_time,"%Y-%m-%d") in ("'. $date_1 .'")'));
			$gain = floatval($DB->GetOne('select sum(MR_gain) from '. OT_dbPref .'moneyRecord where MR_state=1 and DATE_FORMAT(MR_time,"%Y-%m-%d") in ("'. $date_1 .'")'));
			$gainMonth = floatval($DB->GetOne('select sum(MR_gain) from '. OT_dbPref .'moneyRecord where MR_state=1 and MR_time>='. $DB->ForTime($dateMonth)));
		
			$headStr .= $monthStr .'利润 '. $gainMonth .' 元；'. $eolStr;
			$retStr .= '利润 '. $gain .' 元，成本 '. $cost .' 元；'. $eolStr;	// ，进出账'. $addMoney .'/'. abs($cutMoney) .'元
		}
		if (strpos($dayRunList,'|moneyPay|') !== false && AppMoneyPay::Jud()){
			// 在线充值
			$payrs = $DB->GetRow('select count(MP_ID) as num,sum(MP_money) as money from '. OT_dbPref .'moneyPay where MP_state=1 and DATE_FORMAT(MP_time,"%Y-%m-%d") in ("'. $date_1 .'")');
			$payNum		= $payrs['num'];
			$payMoney	= floatval($payrs['money']);
			$payMoneyrs = $DB->GetRow('select count(MP_ID) as num,sum(MP_money) as money from '. OT_dbPref .'moneyPay where MP_state=1 and MP_time>='. $DB->ForTime($dateMonth));
			$payNumMonth	= $payMoneyrs['num'];
			$payMoneyMonth	= floatval($payMoneyrs['money']);
		
			$headStr .= $monthStr .'在线充值 '. $payMoneyMonth .' 元（'. $payNumMonth .' 笔）；'. $eolStr;
			$retStr .= '在线充值 '. $payMoney .' 元（'. $payNum .' 笔）；'. $eolStr;
		}
		if (strpos($dayRunList,'|phone|') !== false && AppPhone::Jud()){
			// 短信
			$phoneNum = $DB->GetOne('select count(PU_ID) from '. OT_dbPref .'phoneUsers where PU_state=1 and DATE_FORMAT(PU_time,"%Y-%m-%d") in ("'. $date_1 .'")');
			if ($phoneNum > 0 || strpos($dayRunList,'|noSkip|') !== false){
				$retStr .= '短信 '. $phoneNum .' 条；';
			}
		}
		if (strpos($dayRunList,'|mail|') !== false && AppMail::Jud()){
			// 邮件
			$mailNum = $DB->GetOne('select count(MU_ID) from '. OT_dbPref .'mailUsers where MU_state=1 and DATE_FORMAT(MU_time,"%Y-%m-%d") in ("'. $date_1 .'")');
			if ($mailNum > 0 || strpos($dayRunList,'|noSkip|') !== false){
				$retStr .= '发邮件 '. $mailNum .' 条；';
			}
		}
		if (strpos($dayRunList,'|robot|') !== false && AppRobot::Jud()){
			$yesterdayDate = TimeDate::Add('day', -1, $todayDate);
			$row = $DB->GetRow('select * from '. OT_dbPref .'robotList where RL_date='. $DB->ForTime($yesterdayDate));
			if ($row){
				$retStr .= $eolStr;
				if ($row['RL_baiduNum'] > 0){
					$retStr .= '百度蜘蛛 '. $row['RL_baiduNum'] .'（'. TimeDate::Get('time',$row['RL_baiduTime']) .'）；'. $eolStr;
				}
				if ($row['RL_360Num'] > 0){
					$retStr .= '360蜘蛛 '. $row['RL_360Num'] .'（'. TimeDate::Get('time',$row['RL_360Time']) .'）；'. $eolStr;
				}
				if ($row['RL_sogouNum'] > 0){
					$retStr .= '搜狗蜘蛛 '. $row['RL_sogouNum'] .'（'. TimeDate::Get('time',$row['RL_sogouTime']) .'）；'. $eolStr;
				}
				if ($row['RL_shenmaNum'] > 0){
					$retStr .= '神马蜘蛛 '. $row['RL_shenmaNum'] .'（'. TimeDate::Get('time',$row['RL_shenmaTime']) .'）；'. $eolStr;
				}
				if ($row['RL_toutiaoNum'] > 0){
					$retStr .= '头条蜘蛛 '. $row['RL_toutiaoNum'] .'（'. TimeDate::Get('time',$row['RL_toutiaoTime']) .'）；'. $eolStr;
				}
				if ($row['RL_bingNum'] > 0){
					$retStr .= '必应蜘蛛 '. $row['RL_bingNum'] .'（'. TimeDate::Get('time',$row['RL_bingTime']) .'）；'. $eolStr;
				}
				if ($row['RL_googleNum'] > 0){
					$retStr .= '谷歌蜘蛛 '. $row['RL_googleNum'] .'（'. TimeDate::Get('time',$row['RL_googleTime']) .'）；'. $eolStr;
				}
				$retStr .= '浏览量 '. $row['RL_pv'] .'；访客数 '. $row['RL_uv'] .'；IP数 '. $row['RL_ipNum'] .'；新访客 '. $row['RL_newNum'] .'；老访客 '. $row['RL_oldNum'] .'；PC模板访客数 '. $row['RL_pcNum'] .'；'. ($row['RL_wapNum'] > 0 ? 'WAP模板访客数 '. $row['RL_wapNum'] .'；' : '') .'电脑端访客数 '. $row['RL_mobile0Num'] .'；移动端访客数 '. $row['RL_mobile1Num'] .'；'. $eolStr;
			}
		}

		$retStr = '【'. $date_1 .'汇总】'. $eolStr . $headStr . $eolStr . $retStr . $footStr;

		self::$dayStatiNum ++;
		if (self::$dayStatiNum == 1){
			$logArr = array();
			$logArr['ARL_time']		= TimeDate::Get();
			$logArr['ARL_type']		= 'dayStati';
			$logArr['ARL_dataID']	= 0;
			$logArr['ARL_content']	= $retStr;
			$DB->InsertParam('autoRunLog',$logArr);
		}

		return $retStr;
	}


	// 通过地址获取结果并显示
	public static function ResShow($type, $str, $mode='pc'){
		if ($mode == 'wap'){
			self::ResShowWap($type, $str);
		}else{
			if (self::$isAjaxRun == 1 || self::$isAjaxRun == 11){
				$runStr = '
					try { console.log("【'. $type .'】'. $str .'"); }catch(e){}
					if (typeof(jsPathPart) == "undefined"){ jsPathPart = ""; }
					$.ajaxSetup({cache:false});
					$.get(jsPathPart +"'. $str .'", function(result){
						try { console.log("【'. $type .'结果】"+ result); }catch(e){}
					});
					';
				if (self::$isAjaxRun == 11){
					die($runStr);
				}else{
					echo($runStr);
				}
			}else{
				$runStr = '
					try { console.log("【'. $type .'】[iframe]'. $str .'"); }catch(e){}
					if (typeof(jsPathPart) == "undefined"){ jsPathPart = ""; }
					autoRun_'. $type .'.location.href=jsPathPart +"'. $str .'";
					';
				if (self::$isAjaxRun == 10){
					die($runStr);
				}else{
					echo($runStr);
				}
			}
		}
	}


	// 通过地址获取结果并显示 手机版
	public static function ResShowWap($type, $str){
		if (in_array($type,array('home','list','show'))){
			$urlPart = 'jsPathPart +';
		}else{
			$urlPart = 'pcPathPart +';
		}
		if (self::$isAjaxRun == 1 || self::$isAjaxRun == 11){
			$runStr = '
				try { console.log("【'. $type .'】'. $str .'"); }catch(e){}
				$.get('. $urlPart .'"'. $str .'", function(result){
					try { console.log("【'. $type .'结果】"+ result); }catch(e){}
				});
				';
			if (self::$isAjaxRun == 11){
				die($runStr);
			}else{
				echo($runStr);
			}
		}else{
			$runStr = '
				try { console.log("【'. $type .'】[iframe]'. $str .'"); }catch(e){}
				autoRun_'. $type .'.location.href='. $urlPart .'"'. $str .'";
				';
			if (self::$isAjaxRun == 10){
				die($runStr);
			}else{
				echo($runStr);
			}
		}
	}


	// 信息显示
	public static function StrShow($type, $str){
		if (self::$isAjaxRun == 1 || self::$isAjaxRun == 11){
			echo('
			try { console.log("【'. $type .'】'. $str .'"); }catch(e){}
			/* 【'. $type .'】'. $str .' */
			');
		}else{
			echo('
			try { console.log("【'. $type .'】[iframe]'. $str .'"); }catch(e){}
			var doc = document.getElementById("autoRun_'. $type .'").contentDocument || document.frames["autoRun_'. $type .'"].document;
			doc.body.innerHTML += "'. $str .'";
			');
		}
	}


	// 信息显示并终止
	public static function DieShow($type,$str){
		die('
		<script language="javascript" type="text/javascript">
		try { console.log("【'. $type .'】'. $str .'"); }catch(e){}
		/* 【'. $type .'】'. $str .' */
		</script>
		');
	}

}

?>