<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class Adm{

	// 后台授权信息/页面获取路线
	public static function UrlWebMode($num){
		switch ($num){
			case 0:		return '主路线';	
			case 1:		return '国内备用路线';	
			case 2:		return '香港备用路线';	
			case 3:		return '美国备用路线';	
			default :	return '未知路线'. $num;
		}
	}

	// 后台授权/采集调用模式
	public static function UrlGetMode($num){
		switch ($num){
			case 0:		return '自动';	
			case 1:		return 'Snoopy插件';	
			case 2:		return 'curl模式';	
			case 3:		return 'fsockopen模式';	
			case 4:		return 'fopen模式';	
			default :	return '未知模式'. $num;
		}
	}

	// 添加用户操作记录
	public static function AddLog($logArr=array()){
		global $DB,$menuFileID,$menuTreeID,$userIpInfo,$user_ID,$user_realname,$user_time,$sysAdminArr;

		if (empty($logArr['userID'])){
			$logArr['userID']	= $user_ID;
		}
		if (empty($logArr['realname'])){
			$logArr['realname'] = $user_realname;
		}
		if (empty($logArr['menuFileID'])){
			$logArr['menuFileID']	= $menuFileID;
		}
		if (empty($logArr['menuTreeID'])){
			$logArr['menuTreeID']	= $menuFileID;
		}
		if (empty($logArr['theme'])){
			$logArr['theme']	= '';
		}else{
			if (empty($logArr['title'])){ $logArr['title'] = '标题'; }
			$logArr['theme']	= '（'. $logArr['title']  .'：'. Str::MoreReplace($logArr['theme'],'html') .'）';
		}

	/*
		if ($sysAdminArr['SA_memberLogRank']==0){
			return '';

		}elseif ($sysAdminArr['SA_memberLogRank']==10 && $logArr['menuFileID']!=0){
			return '';

		}elseif ($sysAdminArr['SA_memberLogRank']==20){
			$logArr['theme']	= '';

		}
	*/
		$userIP	= Users::GetIp();
		$ipInfoArr = OT::GetIpInfoArr($userIP, '');

		$record=array();
		$record['ML_time']		= TimeDate::Get();
		$record['ML_date']		= TimeDate::Get('date');
		$record['ML_userID']	= $logArr['userID'];
		$record['ML_realname']	= $logArr['realname'];
		$record['ML_menuFileID']= $logArr['menuFileID'];
		$record['ML_menuTreeID']= $logArr['menuTreeID'];
		$record['ML_note']		= $logArr['note'] . $logArr['theme'];
		$record['ML_readNum']	= 1;
		$record['ML_ip']		= $userIP;
		$record['ML_ipCN']		= $ipInfoArr['address'];
	//	print_r($logArr);die();

		return $DB->InsertParam('memberLog',$record);
	}

	// 项目切换文字
	public static function SwitchCN($num,$fieldName,$styleStr='text-decoration:underline;'){
		$newStr = '';
		if ($num==1){
			switch ($fieldName){
				case 'stateAudit':
					$newStr = '<span class="font3_2" style="'. $styleStr .'">已审</span>';
					break;
			
				case 'state2': case 'state3':
					$newStr = '<span class="font3_2" style="'. $styleStr .'">正常</span>';
					break;
			
				case 'state4':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">已使用</span>';
					break;
			
				case 'state5':
					$newStr = '<span class="font1_2" style="'. $styleStr .'">已阅</span>';
					break;
			
				case 'state': case 'wapState': case 'userState': case 'isMenu': case 'isSubMenu': case 'isHome': case 'isWap': case 'isWapHome': case 'isHomeWap':
					$newStr = '<span class="font3_2" style="'. $styleStr .'">显示</span>';
					break;
			
				case 'isLock': case 'isUser': case 'isRunCode': case 'isList':
					$newStr = '<span class="font3_2" style="'. $styleStr .'">是</span>';
					break;
			
				case 'isRecom':
					$newStr = '<span class="font3_2" style="'. $styleStr .'">推荐</span>';
					break;

				case 'isUse': case 'isSel':
					$newStr = '<span class="font3_2" style="'. $styleStr .'">启用</span>';
					break;

				case 'isUse2':
					$newStr = '<span class="font3_2" style="'. $styleStr .'">已启用</span>';
					break;

				case 'rightStr':
					$newStr = '<span class="font3_2" style="'. $styleStr .'">已确认</span>';
					break;

				case 'appState': case 'moneyState':
					$newStr = '<span class="font3_2" style="'. $styleStr .'">有效</span>';
					break;

				case 'sign':
					$newStr = '<span style="color:green;">√</span>';
					break;

				default :
					$newStr = '<span class="font3_2">'. $fieldName .'</span>';
					break;

			}

		}elseif ($num==0){
			switch ($fieldName){
				case 'stateAudit':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">未审</span>';
					break;
			
				case 'state2':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">冻结</span>';
					break;
			
				case 'state3': case 'moneyState':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">作废</span>';
					break;
			
				case 'state4':
					$newStr = '<span class="font3_2" style="'. $styleStr .'">未使用</span>';
					break;
			
				case 'state5':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">未阅</span>';
					break;
			
				case 'state': case 'wapState': case 'userState': case 'isMenu': case 'isSubMenu': case 'isHome': case 'isWap': case 'isWapHome': case 'isHomeWap':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">隐藏</span>';
					break;
			
				case 'isLock': case 'isUser': case 'isRunCode': case 'isList':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">否</span>';
					break;
			
				case 'isRecom':
					$newStr = '<span class="font1_2d" style="'. $styleStr .'">不推荐</span>';
					break;
			
				case 'isUse': case 'isSel':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">禁用</span>';
					break;

				case 'isUse2':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">已禁用</span>';
					break;

				case 'rightStr':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">未确认</span>';
					break;

				case 'appState':
					$newStr = '<span class="font2_2" style="'. $styleStr .'">失效</span>';
					break;

				case 'sign':
					$newStr = '<span style="color:red;">ㄨ</span>';
					break;

				default :
					$newStr = '<span class="font2_2">'. $fieldName .'</span>';
					break;
			
			}

		}
		return $newStr;
	}

	// 项目切换2文字
	public static function Switch2CN($name, $fieldValue){
		$newStr = '';
		if (is_numeric($fieldValue)){
			if ($fieldValue == 1){
				$newStr = '<span class="font3_2" style="text-decoration:underline;">'. $name .'</span>';
			}elseif ($fieldValue == 2){
				$newStr = '<span style="text-decoration:underline;color:red;">拒绝</span>';
			}else{
				$newStr = '<span class="font1_2d fontDel">'. $name .'</span>';
			}
		}else{
			if (strlen($fieldValue) > 0){
				$newStr = '<span class="font3_2" style="text-decoration:underline;">'. $name .'</span>';
			}else{
				$newStr = '<span class="font1_2d fontDel" style="color:#d9d9d9;">'. $name .'</span>';
			}
		}
		return $newStr;
	}

	public static function Switch3CN($fieldName, $fieldValue){
		$newStr = '';
		if (strlen($fieldValue .'') == 0){
			switch ($fieldName){
				case 'reply':
					$newStr = '<span class="font2_2" style="text-decoration:underline;">未回复</span>';
					break;
			}

		}else{
			switch ($fieldName){
				case 'reply':
					$newStr = '<span class="font3_2" style="text-decoration:underline;">已回复</span>';
					break;
			}
			
		}

		return $newStr;
	}

	// 项目切换代码
	public static function SwitchBtn($tabName,$dataID,$fieldValue,$fieldName,$fieldName2=''){
		global $dataType;

		if ($fieldName2==''){$fieldName2=$fieldName;}
		return '
		<a id="'. $fieldName2 . $dataID .'" href="#" class="font1_2" onclick=\'DataDeal.location.href="share_switch.php?mudi=switch&dataType='. $dataType .'&fieldName='. $fieldName .'&fieldName2='. $fieldName2 .'&tabName='. $tabName .'&dataID='. $dataID .'";return false;\'>'. self::SwitchCN($fieldValue,$fieldName2) .'</a>	
		';
	}

	// 项目切换代码
	public static function SwitchNo($tabName,$dataID,$fieldValue,$fieldName,$fieldName2=''){
		global $dataType;

		if ($fieldName2==''){$fieldName2=$fieldName;}
		return self::SwitchCN($fieldValue,$fieldName2,'');
	}

	// 项目切换代码
	public static function SwitchColl($tabName,$dataID,$fieldValue,$fieldName,$fieldName2=''){
		global $dataType;

		if ($fieldName2==''){$fieldName2=$fieldName;}
		return '<a id="'. $fieldName2 . $dataID .'" href="javascript:void(0);" class="font1_2" onclick=\'DataDeal.location.href="share_switch.php?mudi=switchColl&dataType='. $dataType .'&fieldName='. $fieldName .'&fieldName2='. $fieldName2 .'&tabName='. $tabName .'&dataID='. $dataID .'";return false;\'>'. self::SwitchCN($fieldValue,$fieldName2) .'</a>';
	}

	// 项目切换代码_属性
	public static function SwitchAddi($tabName, $dataID, $name, $fieldValue, $fieldName, $fieldName2='', $fieldValue2='', $alt=''){
		global $dataType;

		if ($fieldName2==''){ $fieldName2=$fieldName .'_'. $fieldName2 .'_'; }
		return '<a id="'. $fieldName2 . $dataID .'" href="javascript:void(0);" class="font1_2" style="padding:0 3px 0 3px;" onclick=\'DataDeal.location.href="share_switch.php?mudi=switchAddi&dataType='. $dataType .'&fieldValue='. $fieldValue .'&fieldName='. $fieldName .'&fieldName2='. $fieldName2 .'&fieldValue2='. $fieldValue2 .'&tabName='. $tabName .'&dataID='. $dataID .'&name='. urlencode($name) .'";return false;\' title="'. $alt .'">'. self::Switch2CN($name,$fieldValue) .'</a>';
	}


	// 项目切换代码_存在与不存在
	public static function SwitchExist($tabName, $dataID, $fieldAllVal, $fieldValue, $fieldName, $fieldName2='',$addiExt=''){
		global $dataType;

		if ($fieldName2==''){$fieldName2=$fieldName;}
		return '<a id="'. $fieldName2 . $dataID . $addiExt .'" href="javascript:void(0);" class="font1_2" onclick=\'DataDeal.location.href="share_switch.php?mudi=switchExsit&dataType='. $dataType .'&fieldName='. $fieldName .'&fieldName2='. $fieldName2 .'&tabName='. $tabName .'&fieldValue='. $fieldValue .'&dataID='. $dataID .'&addiExt='. $addiExt .'";return false;\'>'. self::SwitchCN(strpos($fieldAllVal,$fieldValue)===false?0:1, $fieldName2) .'</a>';
	}


	// 操作系统名称颜色
	public static function AdminName($adminID,$adminName){
		if ($adminID==0){
			return '<span class="font3_2">'. $adminName .'</span>';
		}else{
			return '<span class="font1_2">'. $adminName .'</span>';
		}
	}


	// 过滤编辑器内容
	public static function FilterEditor($str){
		$str = preg_replace('/[\r\n]+/', "\n", $str);
		return $str;
	}


	// 没插件默认内容
	public static function PluDefItem($appName, $itemName = '', $td2Addi = '', $strAddi = ''){
		if (strlen($itemName) == 0){ $itemName = $appName; }
		return '
			<tr class="pluDefClass">
				<td align="right">'. Skin::PluSign($appName) . $itemName .'：</td>
				<td '. $td2Addi .' style="color:#c9c9c9;">需要购买“<span style="color:red;">'. $appName .'</span>”插件'. $strAddi .'</td>
			</tr>
			';
	}


	// 插件文件数组
	public static function PluFileArr(){
		return array(
			2	=> array('classAppRss.php'),
			4	=> array('classAppBase.php'),
			5	=> array('classAppColl.php'),
			6	=> array('classAppWap.php'),
			7	=> array('classAppLogin.php'),
			9	=> array('classAppBbs.php','classAppBbsDeal.php','classAppBbsTpl.php','classAppBbsTplWap.php'),
			10	=> array('classAppTaobaoke.php','classAppTaobaokeWap.php','classAppTaobaokeDeal.php'),
			12	=> array('classAppTplInfo.php'),
			13	=> array('classAppTplBlog.php'),
			14	=> array('classAppTplBlue.php'),
			15	=> array('classAppWeixin.php'),
			17	=> array('classAppMapBaidu.php'),
			18	=> array('classAppUpload.php'),
			19	=> array('classAppForm.php'),
			21	=> array('classAppTopic.php'),
			22	=> array('classAppLogoAdd.php'),
			23	=> array('classAppMoneyPay.php','classAppMoneyPayDeal.php','classAppMoneyRecord.php'),
			26	=> array('classAppUserScore.php'),
			27	=> array('classAppTaokeOrder.php'),
			28	=> array('classAppGift.php'),
			29	=> array('classAppMoneyAlipay.php'),
			31	=> array('classAppDashang.php'),
			33	=> array('classAppNewsEnc.php'),
			39	=> array('classAppVideo.php'),
			41	=> array('classAppChangyan.php'),
			42	=> array('classAppBuyOrders.php'),
			43	=> array('classAppNewsPwd.php'),
			46	=> array('classAppRecom.php'),
			47	=> array('classAppQiandao.php'),
			54	=> array('classAppQuan.php'),
			55	=> array('classAppMail.php'),
			56	=> array('classAppPhone.php'),
			57	=> array('classAppGain.php'),
			58	=> array('classAppNewsGain.php'),
			59	=> array('classAppMoneyWeixin.php'),
			62	=> array('classAppWeixinJs.php'),
			63	=> array('classAppToTop.php'),
			64	=> array('classAppTplQiyeBlue.php'),
			66	=> array('classAppAutoHtml.php'),
			67	=> array('classAppAutoColl.php'),
			68	=> array('classAppAdminRightNews.php'),
			70	=> array('classAppTplYule.php'),
			71	=> array('classAppTplBlack.php'),
			72	=> array('classAppOssQiniu.php','classAppOssQiniuDeal.php'),
			73	=> array('classAppOssAliyun.php','classAppOssAliyunDeal.php'),
			75	=> array('classAppOssUpyun.php','classAppOssUpyunDeal.php'),
			76	=> array('classAppUserState1.php'),
			77	=> array('classAppUserGroup.php'),
			78	=> array('classAppUserGroupWork.php'),
			79	=> array('classAppSiteMessage.php'),
			80	=> array('classAppWorkCenter.php'),
			81	=> array('classAppTplWhite.php'),
			82	=> array('classAppWapTplWhite.php'),
			83	=> array('classAppMoneyGive.php'),
			84	=> array('classAppLoginPhone.php'),
			85	=> array('classAppLoginMail.php'),
			86	=> array('classAppOssFtp.php','classAppOssFtpDeal.php'),
			87	=> array('classAppCopyKouling.php'),
			89	=> array('classAppTplXiaodao.php'),
			90	=> array('classAppWapTplXiaodao.php'),
			91	=> array('classAppTplMedia.php'),
			92	=> array('classAppWapTplMedia.php'),
			97	=> array('classAppResBaidu.php'),
			98	=> array('classAppRes360.php'),
			99	=> array('classAppResSogou.php'),
			100	=> array('classAppResShenma.php'),
			101	=> array('classAppUserExport.php'),
			102	=> array('classAppFans.php'),
			104	=> array('classAppMoneyCodepay.php'),
			105	=> array('classAppDiyPay.php'),
			106	=> array('classAppMoneyF2fpay.php'),
			108	=> array('classAppChinaz.php'),
			110	=> array('classAppUserView.php'),
			111	=> array('classAppUserMark.php'),
			112	=> array('classAppInfoDown.php'),
			113	=> array('classAppReport.php'),
			115	=> array('classAppMoneyQuick.php'),
			117	=> array('classAppTag.php'),
			118	=> array('classAppSiteApi.php'),
			120	=> array('classAppNameWeixin.php'),
			121	=> array('classAppNameAlipay.php'),
			122	=> array('classAppTplDayNight.php'),
			123	=> array('classAppWapTplDayNight.php'),
			128	=> array('classAppAgent.php','classAppAgentUsers.php'),
			130	=> array('classAppNamePhone.php'),
			142	=> array('classAppAizhan.php'),
			143	=> array('classAppMoneyHpjpay.php'),
			145	=> array('classAppDingding.php'),
			148	=> array('classAppAuthSoft.php'),
			149	=> array('classAppMoneyEpay.php'),
			154	=> array('classAppTplUUnav9022.php'),
			155	=> array('classAppCa.php'),
			156	=> array('classAppApiItem.php'),
			157	=> array('classAppTplUUnew1222e2.php'),
			159	=> array('classAppTplUUnew1222r3.php'),
			160	=> array('classAppAutoApiItem.php'),
			162	=> array('classAppInfoImport.php'),
			163	=> array('classAppWeixinWork.php'),
			164	=> array('classAppUpKeepBigFile.php'),
			165	=> array('classAppAutoImg.php'),
			166	=> array('classAppResBing.php'),
			167	=> array('classAppScoreTo.php'),
			170	=> array('classAppRobot.php'),
			172	=> array('classAppGetGift.php'),
			174	=> array('classAppJieri.php'),
			//	=> array('classAppMoneyRecord.php'),	// 财务管理
			);
	}


	// 主菜单名称简化
	public static function NavMenu($menuName, $newName = ''){
		if (strlen($newName) > 0){ return $newName; }
		switch ($menuName){
			default :
				return $menuName;
		}
	}


	// 教程网址开启/关闭
	public static function StudyShow($type, $str){
		global $sysAdminArr,$user_ID;

		if (strpos(''. $sysAdminArr['SA_infoCloseArea'],'|'. $type .'|') === false || (strpos(''. $sysAdminArr['SA_infoCloseArea'],'|OTadmin|') !== false && $user_ID == 1)){
			return $str;
		}else{
			return '';
		}
	}


	// 引导页 功能块开关
	public static function FuncJud($type){
		global $sysAdminArr,$user_ID;

		if (strpos(''. $sysAdminArr['SA_funcCloseArea'],'|'. $type .'|') === false || (strpos(''. $sysAdminArr['SA_funcCloseArea'],'|OTadmin|') !== false && $user_ID == 1)){
			return true;
		}else{
			return false;
		}
	}


	// 值名称
	public static function ValCN($type, $val){
		switch ($type){
			case 'isMessage':		// 留言板
			case 'state':
				switch ($val){
					case 0:		return '禁用';
					case 1:		return '启用';
					case 10:	return '仅限会员';
				}
				break;

			case 'messageRndMd5':	// 留言/评论跟随信息验证
			case 'state2':
				switch ($val){
					case 0:		return '关闭';
					case 1:		return '开启';
					case 2:		return '开启(过期自动更新)';
				}
				break;

			case 'messageMode':		// 留言板填写框位置
				switch ($val){
					case 0:		return '底部';
					case 1:		return '头部';
				}
				break;

			case 'messageAudit':	// 留言审核
				switch ($val){
					case 0:		return '需审核';
					case 1:		return '无需审核';
				}
				break;

			case 'messageEvent':	// 留言/评论附加功能
				$cnStr = '';
				if (strpos($val,'|filterUrl|') !== false){ $cnStr .= '[过滤网址]'; }
				if (strpos($val,'|noRevName|') !== false){ $cnStr .= '[游客不能编辑昵称]'; }
				if (strpos($val,'|IP|') !== false){ $cnStr .= '[显示IP地址]'; }
				return $cnStr;
				break;

			case 'isNewsTime':		// 文章时间
				switch ($val){
					case 0:		return '关闭';
					case 1:		return '显示头部(日期)';
					case 2:		return '显示尾部(日期)';
					case 3:		return '显示头部(日期+时间)';
					case 4:		return '显示尾部(日期+时间)';
				}
				break;

			case 'isNewsSource':	// 文章来源
			case 'isNewsWriter':	// 文章作者
				switch ($val){
					case 0:		return '关闭';
					case 1:		return '显示头部';
					case 2:		return '显示尾部';
				}
				break;

			case 'prevAndNext':		// 上/下一篇
				switch ($val){
					case 0:		return '关闭';
					case 1:		return '开启（有显示，没有自动生成）';
					case 11:	return '开启（有显示，没有不显示）';
				}
				break;

			case 'newsReplyAudit':
				switch ($val){
					case 0:		return '开启';
					case 1:		return '关闭';
				}
				break;
		}

		return '['. $type .':'. $val .']';
	}


	// WAP值信息
	public static function WapValInfo($val, $title='手机版：', $str1='&ensp;&ensp;'){
		return '<span style="color:red;">'. $str1 .'（'. $title .''. $val .'<span style="color:#000;"></span>）</span>';
	}

}
?>