""" from https://github.com/keithito/tacotron """

'''
Cleaners are transformations that run over the input text at both training and eval time.

Cleaners can be selected by passing a comma-delimited list of cleaner names as the "cleaners"
hyperparameter. Some cleaners are English-specific. You'll typically want to use:
  1. "english_cleaners" for English text
  2. "transliteration_cleaners" for non-English text that can be transliterated to ASCII using
     the Unidecode library (https://pypi.python.org/pypi/Unidecode)
  3. "basic_cleaners" if you do not want to transliterate (in this case, you should also update
     the symbols in symbols.py to match your data).
'''

# Regular expression matching whitespace:
import re
from unidecode import unidecode

#from num import normalize_numbers
#from korean import tokenize as ko_tokenize
from .korean import tokenize as ko_tokenize

def korean_cleaners(text):
    text=ko_tokenize(text, as_id=False)
    return text 
