# Axes

You can modify the colors and styles of the axes on the charts.

Both the X Axis and the Y Axis have similar options you can set on them.

### Basic Options

| Key for X Axis | Key for Y Axis | Remark                                  |
| -------------- | -------------- | --------------------------------------- |
| x              | y              | true or false to show or hide the axis. |
| x.height       |                | Height of the x axis.                   |
|                | y.width        | Width of the y axis.                    |
| x.lineWidth    | y.lineWidth    | Line width of the axis.                 |
| x.lineColor    | y.lineColor    | Line color of the axis.                 |
| x.tickLength   | y.tickLength   | Tick length of the axis.                |
| x.tickWidth    | y.tickWidth    | Tick width of the axis.                 |
| y.padRigth     |                | Padding right of the x axis.            |
|                | y.padTop       | Padding top of the y axis.              |
|                | y.align        | Alignment of the y axis.                    |
| x.step         | y.step         | Step of the axis.                       |
| x.min          | y.min          | Min value of the axis.                  |
| x.max          | y.max          | Max value of the axis.                  |

### Title Options

| Key for X Axis           | For for Y Axis           | Remark                               |
| ------------------------ | ------------------------ | ------------------------------------ |
| x.title                  | y.title                  | Title text of the axis.              |
| x.title.y                |                          | Y offset of the title of the x axis. |
| x.title.align            | y.title.align            | Alignment of the title.                  |
| x.title.fontSize         | y.title.fontSize         | Font size of the title.              |
| x.title.fontFamily       | y.title.fontFamily       | Font family of the title.            |
| x.title.fontWeight       | y.title.fontWeight       | Font weight of the title.            |
| x.title.fontStyle        | y.title.fontStyle        | Font style of the title.             |
| x.title.color            | y.title.color            | Color of the title.                  |
| x.title.additionalStyles | y.title.additionalStyles | Additional styles of the title.      |

###  Labels Options

| Key for X Axis            | For for Y Axis            | Remark                                                    |
| ------------------------- | ------------------------- | --------------------------------------------------------- |
| x.labels                  | y.labels                  | true or false to show or hide the labels.                 |
| x.labels.format           | y.labels.format           | Format of the labels.                                     |
| x.labels.rotation         |                           | Rotation of the labels. Accepts values between -90 and 90. |
| x.labels.fontSize         | y.labels.fontSize         | Font size of the labels.                                  |
| x.labels.fontFamily       | y.labels.fontFamily       | Font family of the labels.                                |
| x.labels.fontWeight       | y.labels.fontWeight       | Font weight of the labels.                                |
| x.labels.fontStyle        | y.labels.fontStyle        | Font style of the labels.                                 |
| x.labels.color            | y.labels.color            | Font color of the labels.                                 |
| x.labels.additionalStyles | y.labels.additionalStyles | Additional styles of the labels.                          |
