/**
 * [OElove] (C)2010-2099 oelove.com biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2019/05/16 by bo $
*/
const html = String.raw;
var alert = Vue.extend({
  template: html`
    <div class="oe_alert" @touchmove="stopScroll" ref="oeAlert">
      <div class="mask" @click="hide"></div>
      <div class="alert">
        <div class="header">
          提示
        </div>
        <div class="body">{{msg}}</div>
        <div class="footer">
          <a href="javascript:;" class="btn" @click="sure">确定</a>
        </div>
      </div>
    </div>
  `,
  name: 'oe_alert',
  data () {
    return {
      msg: '欢迎使用OEUI'
    }
  },
  methods: {
    stopScroll (event) {
      event.preventDefault();
    },
    hide() {
      this.$el.remove();
    }
  }
});
var loading = Vue.extend({
  template: html`
    <div class="oe_loading">
      <div class="box">
        <div class="wrap">
          <div class="icon_box">
            <div class="icon loading_animate"></div>
          </div>
          <div class="text" v-if="text">{{text}}</div>
        </div>
      </div>
    </div>
  `,
  name: 'oa_loading',
  data () {
    return {
      text: ''
    }
  }
})
var confirm = Vue.extend({
  template: html`
    <div class="oe_confirm">
      <div class="mask" @click="cancel" @touchmove.prevent></div>
      <div class="confirm">
        <div class="header">{{title}}</div>
        <div class="body">{{msg}}</div>
        <div class="footer">
          <a href="javascript:;" class="btn" @click="cancel">取消</a>
          <a href="javascript:;" class="btn" @click="sure">确定</a>
        </div>
      </div>      
    </div>
  `,
  data () {
    return {
      
    }
  },
  methods: {
    cancel () {
      this.$el.remove();
    }
  }
})

var toast = Vue.extend({
  template: html`
    <div class="oe_toast" :class="{'toast_icon': type, 'top': position=='top', 'bottom': position=='bottom'}" ref="oeToast">
      <div class="icon" v-if="type=='success'">
        <em class="iconfont icon-gouxuan3"></em>
      </div>
      <div class="icon" v-if="type=='fail'">
        <em class="iconfont icon-shibai"></em>
      </div>
      <div class="icon" v-if="type=='warn'">
        <em class="iconfont icon-jinggao"></em>
      </div>
      <div class="text">{{msg}}</div>
    </div>
  `,
  name: 'oe_toast',
  data () {
    return {
      type: '',
      msg: '',
      position: ''
    }
  },
  mounted () {
    setTimeout(() => {
      this.$refs.oeToast.remove();
    }, 3000);
  }
})

var $loadingVm;
Vue.use(
  {
    install (Vue, options) {
      Vue.prototype.$oeAlert = (msg, fn) => {
        const oeAlert = Vue.extend(alert);
        let $vm = new oeAlert({
          el: document.createElement('div'),
          data: {
            msg: msg
          },
          methods: {
            sure () {
              this.$el.remove();
              fn && fn();
            }
          }
        });
        document.body.appendChild($vm.$el);
      }
      Vue.prototype.$oeConfirm = ({title = '温馨提示', msg, fn}) => {
        const oeConfirm = Vue.extend(confirm);
        let $vm = new oeConfirm({
          el: document.createElement('div'),
          data: {
            title: title,
            msg: msg
          },
          methods: {
            sure () {
              this.$el.remove();
              fn && fn();
            }
          }
        });
        document.body.appendChild($vm.$el);
      }

      Vue.prototype.$oeLoadingShow = (text) => {
        const oeLoading = Vue.extend(loading);
        $loadingVm = new oeLoading({
          el: document.createElement('div'),
          data: {
            text: text
          }
        });
        document.body.appendChild($loadingVm.$el);
      }
      Vue.prototype.$oeLoadingHide = () => {
        $loadingVm && $loadingVm.$el.remove();
      }
      Vue.prototype.$oeToast = (msg, position = 'bottom', type) => {
        const oeToast = Vue.extend(toast);
        $vm = new oeToast({
          el: document.createElement('div'),
          data: {
            msg: msg,
            type: type,
            position: position
          }
        });
        document.body.appendChild($vm.$el);
      }
      Vue.prototype.$oeRandom = (n) => {
        const chars = ['0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];
        let res = "";
        for(let i = 0; i < n; i++) {
          let id = Math.ceil(Math.random()* 35);
          res += chars[id];
        }
        return res;
      }
    }
  }
);
Vue.use({
    install (Vue, options) {
        Vue.prototype.$login_tip = (msg, fn) => {
            Vue.prototype.$oeConfirm({
                msg: msg || '你还没有登录呦~',
                fn: () => {
                    if(fn) {
                        fn();
                    } else {
                        location.href= '/index.php?c=passport&a=login'
                    }
                }
            })
        }
    }
});