/**
 * [OElove Webapp] (C)2010-2099 oelove.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.05.19 Update by CL $
*/
$(function(){
    
    //第二步 注册类
    function OEReg2() {
       
        this._this_dialog = ''; //弹窗对象
        this.slide_time = 200; //速度
        
        
        this.forward = '';
        this.au_mod = ''; //授权类型 weixin,wechat/sina/qq
        this.openid = ''; //openid
        this.au_unionid = '';
        this.au_nickname = '';
        this.au_gender = '';
        this.au_province = '';
        this.au_city = '';
        this.au_headimgurl = '';
        this.mobile = '';

        this.obj_id = '';
        
        this.init();
        this.wake();
        this.touchBlur();
        this.submit();
    }
    
    OEReg2.prototype = {
        
        //初始化
        init:function() {
            var _this = this;
            
            _this.forward = $("#forward").val();
            if (typeof(_this.forward) == 'undefined') {
                _this.forward = '';
            }
            _this.au_mod = $("#au_mod").val();
            if (typeof(_this.au_mod) == 'undefined') {
                _this.au_mod = '';
            }
            _this.openid = $("#openid").val();
            if (typeof(_this.openid) == 'undefined') {
                _this.openid = '';
            }
            _this.au_unionid = $("#au_unionid").val();
            if (typeof(_this.au_unionid) == 'undefined') {
                _this.au_unionid = '';
            }
            _this.au_gender = $("#au_gender").val();
            if (typeof(_this.au_gender) == 'undefined') {
                _this.au_gender = '';
            }
            _this.au_province = $("#au_province").val();
            if (typeof(_this.au_province) == 'undefined') {
                _this.au_province = '';
            }
            _this.au_city = $("#au_city").val();
            if (typeof(_this.au_city) == 'undefined') {
                _this.au_city = '';
            }
            _this.au_headimgurl = $("#au_headimgurl").val();
            if (typeof(_this.au_headimgurl) == 'undefined') {
                _this.au_headimgurl = '';
            }
            _this.mobile = $("#mobile").val();
            if (typeof(_this.mobile) == 'undefined') {
                _this.mobile = '';
            }
            
            //校验用户名
            var $username = $("#username").val();
            if ($username != '') {
                _this.checkData("username", $username);
            }
            
        },
        
        //唤醒
        wake:function() {
            var _this = this;
            //单选 当选
            $(document).on("click", "[f='but_sel_item']", function(){
                var $item = $(this).attr("data-item");
                var $val = $(this).attr("data-val");
                $(this).parent().find('span').removeClass('bg_main color_f');
                $(this).parent().find('span').removeClass('bg_f2 color_9');
                $(this).addClass('bg_main color_f').siblings().addClass('bg_f2 color_9');
                
                $("#"+$item).val($val);
            });
            
            //多选 当选
            $(document).on("click", "[f='but_sel_multi']", function(){
                var $item = $(this).attr("data-item");
                if ($(this).hasClass('bg_main')) {
                    $(this).removeClass('bg_main color_f').addClass('bg_f2 color_9');
                }
                else {
                    $(this).removeClass('bg_f2 color_9').addClass('bg_main color_f');
                }
                
                var $vals = "";
                $(this).parent().find('span').each(function(i,v){
                    if ($(this).hasClass('bg_main')) {
                        var $val = $(this).attr("data-val");
                        if ($vals == '') {
                            $vals = $val;
                        }
                        else {
                            $vals += ","+$val;
                        }
                    }
                });
                $("#"+$item).val($vals);
            });
            
            //隐藏手机号
            $(document).on("click", "[f='but_hidemobile']", function(){
                if ($(this).find('i').hasClass('color_main')) {
                    $(this).find('i').removeClass('color_main').addClass('color_9');
                    $('#hidemobile').val('0');
                }
                else {
                    $(this).find('i').removeClass('color_9').addClass('color_main');
                    $('#hidemobile').val('1');
                }
            });
            
            //学历或以上
            $(document).on("click", "[f='but_above_edu']", function(){
                if ($(this).find('i').hasClass('color_main')) {
                    $(this).find('i').removeClass('color_main').addClass('color_9');
                    $('#cond_above_edu').val('0');
                }
                else {
                    $(this).find('i').removeClass('color_9').addClass('color_main');
                    $('#cond_above_edu').val('1');
                }
            });
            
            //关闭一组用户名
            $(document).on("click", "[f='but_close_morename']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            //选择一个用户名
            $(document).on("click", "[f='select_name']", function(){
                var $name = $(this).attr("data-name");
                $("#username").val($name);
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
                _this.checkData("username", $name); //再次校验数据
            });
            
        },
        
        //离开事件
        touchBlur:function() {
            var _this = this;
            
            //用户名
            $(document).on("blur", "#username", function() {
                var $dom_id = $(this).attr('id');
                var $val = $(this).val();
                if (strlen($val) < 3 || strlen($val) > 16) {
                    $("#"+$dom_id+"_icon").find("i").hide();
                    $("#"+$dom_id+"_icon").find(".color_f40").show();
                    $("#"+$dom_id+"_tips").html("用户名长度不正确").show();
                    $("#"+$dom_id+"_icon").show();
                }
                else {
                    _this.checkData("username", $val);
                }
            });
            
            //密码
            $(document).on("blur", "#password", function() {
                var $dom_id = $(this).attr('id');
                var $val = $(this).val();
                if (strlen($val) < 6 || strlen($val) > 16) {
                    $("#"+$dom_id+"_icon").find("i").hide();
                    $("#"+$dom_id+"_icon").find(".color_f40").show();
                    $("#"+$dom_id+"_tips").html("密码长度不正确").show();
                    $("#"+$dom_id+"_icon").show();
                }
                else {
                    $("#"+$dom_id+"_icon").find("i").hide();
                    $("#"+$dom_id+"_icon").find(".color_green").show();
                    $("#"+$dom_id+"_tips").html("").hide();
                    $("#"+$dom_id+"_icon").show();
                }
                
            });
            
            //邮箱
            $(document).on("blur", "#email", function() {
                var $dom_id = $(this).attr('id');
                var $val = $(this).val();
                if (!isEmail($val)) {
                    $("#"+$dom_id+"_icon").find("i").hide();
                    $("#"+$dom_id+"_icon").find(".color_f40").show();
                    $("#"+$dom_id+"_tips").html("邮箱格式不正确").show();
                    $("#"+$dom_id+"_icon").show();
                }
                else {
                    _this.checkData("email", $val);
                }
            });
            
            //姓名
            $(document).on("blur", "#truename", function() {
                var $dom_id = $(this).attr('id');
                var $val = $(this).val();
                if ($val == '' || $val == null) {
                    $("#"+$dom_id+"_icon").find("i").hide();
                    $("#"+$dom_id+"_icon").find(".color_f40").show();
                    $("#"+$dom_id+"_tips").html("请填写真实姓名").show();
                    $("#"+$dom_id+"_icon").show();
                }
                else {
                    $("#"+$dom_id+"_icon").find("i").hide();
                    $("#"+$dom_id+"_icon").find(".color_green").show();
                    $("#"+$dom_id+"_tips").html("").hide();
                    $("#"+$dom_id+"_icon").show();
                }
                
            });
            
            //微信
            $(document).on("blur", "#weixin", function() {
                var $dom_id = $(this).attr('id');
                var $val = $(this).val();
                if ($val == '' || $val == null) {
                    $("#"+$dom_id+"_icon").find("i").hide();
                    $("#"+$dom_id+"_icon").find(".color_f40").show();
                    $("#"+$dom_id+"_tips").html("请填写微信号").show();
                    $("#"+$dom_id+"_icon").show();
                }
                else {
                    $("#"+$dom_id+"_icon").find("i").hide();
                    $("#"+$dom_id+"_icon").find(".color_green").show();
                    $("#"+$dom_id+"_tips").html("").hide();
                    $("#"+$dom_id+"_icon").show();
                }
                
            });
            
            //QQ
            $(document).on("blur", "#qq", function() {
                var $dom_id = $(this).attr('id');
                var $val = $(this).val();
                if (!isQQ($val)) {
                    $("#"+$dom_id+"_icon").find("i").hide();
                    $("#"+$dom_id+"_icon").find(".color_f40").show();
                    $("#"+$dom_id+"_tips").html("QQ格式不正确").show();
                    $("#"+$dom_id+"_icon").show();
                }
                else {
                    _this.checkData("qq", $val);
                }
            });
        },
        
        //校验数据
        checkData:function(type, value) {
            var _this = this;
            
            $.ajax({
                type: "POST",
                url: WAP_APPFILE+"&c=picker",
                cache: false,
                data: {
                    a:"check", check_type:type, name:value
                },
                dataType: "json",
                success: function($data) {
                    $json = eval($data);
                    $response = $json.response;
                    $result = $json.result;
                    if ($response == "1") {
                        //可用
                        $("#"+type+"_icon").find("i").hide();
                        $("#"+type+"_icon").find(".color_green").show();
                        $("#"+type+"_tips").html("").hide();
                        $("#"+type+"_icon").show();
                    }
                    else {
                        if ($result == '' || $result == null) {
                            if (type == 'username') {
                                $result = '该用户名已被注册';
                                _this._getUserName(value); //获取一组用户名
                            }
                            else if (type == 'email') {
                                $result = '该邮箱已被注册';
                            }
                            else if (type == 'qq') {
                                $result = '该QQ已被注册';
                            }
                        }
                        $("#"+type+"_icon").find("i").hide();
                        $("#"+type+"_icon").find(".color_f40").show();
                        $("#"+type+"_tips").html($result).show();
                        $("#"+type+"_icon").show();
                    }
                },
                error: function() {
                }
            }); 
        },
        
        //获取一组用户名
        _getUserName:function(name) {
            var _this = this;
            
            $.ajax({
                type: "POST",
                url: WAP_APPFILE+"&c=passport",
                cache: false,
                data: {
                    a:"rndname", name:name, 
                },
                dataType: "json",
                success: function($data) {
                    $json = eval($data);
                    $response = $json.response;
                    $result = $json.result;
                    if ($response == "1") { //可用
                        $("#morename_data").html($result);
                        _this._this_dialog = OEUI.Dialog({
                            el: '#morename_box',
                            animated: 'zoomIn',
                            time:_this.slide_time
                        });
                    }
                },
                error: function() {
                }
            });
            
        },
        
        //注册
        submit:function() {
            var _this = this;
            
            $(document).on("click", "[f='but_submit_reg']", function(){
                _this.obj_id = $(this).attr("id");

                var $hidemobile = $("#hidemobile").val();
                if (typeof($hidemobile) == 'undefined') {
                    $hidemobile = 0;
                }
                
                var $username = $("#username").val();
                if ($username == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写用户名'
                    });
                    return;
                }
                var $password = $("#password").val();
                if ($password == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写登录密码'
                    });
                    return;
                }
                var $email = $("#email").val();
                if (typeof($email) == 'undefined') {
                    $email = '';
                }
                else {
                    if ($email == '') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请填写邮箱地址'
                        });
                        return;
                    }
                }
                var $gender = $("#gender").val();
                if ($gender == '' || $gender == '0') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请选择性别'
                    });
                    return;
                }
                
                var $birthday = $("#birthday").html();
                if (!isDate($birthday)) {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请设置生日'
                    });
                    return;
                }
                var $birth_da = $birthday.split("-");
                var $ageyear = $birth_da[0];
                var $agemonth = $birth_da[1];
                var $ageday = $birth_da[2];
                
                
                var $dist1 = $dist2 = $dist3 = '';
                $dist1 = $("#dist1").val();
                if ($dist1 == '' || $dist1 == '0') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请选择所在地'
                    });
                    return;
                }
                $dist2 = $("#dist2").val();
                if ($dist2 == '' || $dist2 == '0') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请选择所在地'
                    });
                    return;
                }
                $dist3 = $("#dist3").val();
                
                
                var $home1 = $home2 = $home3 = '';
                $home1 = $("#home1").val();
                if (typeof($home1) == 'undefined') {
                    $home1 = '';
                }
                else {
                    if ($home1 == '' || $home1 == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择户籍地'
                        });
                        return;
                    }
                    $home2 = $("#home2").val();
                    if ($home2 == '' || $home2 == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择户籍地'
                        });
                        return;
                    }
                    $home3 = $("#home3").val();
                }
                
                
                var $marry = $("#marry").val();
                if (typeof($marry) == 'undefined') {
                    $marry = '';
                }
                else {
                    if ($marry == '' || $marry == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择婚况'
                        });
                        return;
                    }
                }
                
                var $sort = $("#sort").val();
                if (typeof($sort) == 'undefined') {
                    $sort = '';
                }
                else {
                    if ($sort == '' || $sort == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择类型'
                        });
                        return;
                    }
                }
                
                //0.05.19
                var $education = $("#education").val();
                if (typeof($education) == 'undefined') {
                    $education = '';
                }
                else {
                    if ($education == '' || $education == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择学历'
                        });
                        return;
                    }
                }
                
                var $house = $("#house").val();
                if (typeof($house) == 'undefined') {
                    $house = '';
                }
                else {
                    if ($house == '' || $house == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择购房情况'
                        });
                        return;
                    }
                }
                
                var $car = $("#car").val();
                if (typeof($car) == 'undefined') {
                    $car = '';
                }
                else {
                    if ($car == '' || $car == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择购车情况'
                        });
                        return;
                    }
                }
                
                var $height = $("#height").val();
                if (typeof($height) == 'undefined') {
                    $height = '';
                }
                else {
                    if ($height == '' || $height == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择身高'
                        });
                        return;
                    }
                }
                
                var $weight = $("#weight").val();
                if (typeof($weight) == 'undefined') {
                    $weight = '';
                }
                else {
                    if ($weight == '' || $weight == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择体重'
                        });
                        return;
                    }
                }
                
                var $job = $("#job").val();
                if (typeof($job) == 'undefined') {
                    $job = '';
                }
                else {
                    if ($job == '' || $job == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择职业'
                        });
                        return;
                    }
                }
                
                var $salary = $("#salary").val();
                if (typeof($salary) == 'undefined') {
                    $salary = '';
                }
                else {
                    if ($salary == '' || $salary == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请选择年收入'
                        });
                        return;
                    }
                }
                
                var $truename = $("#truename").val();
                if (typeof($truename) == 'undefined') {
                    $truename = '';
                }
                else {
                    if ($truename == '' || $truename == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请填写真实姓名'
                        });
                        return;
                    }
                }
                
                var $weixin = $("#weixin").val();
                if (typeof($weixin) == 'undefined') {
                    $weixin = '';
                }
                else {
                    if ($weixin == '' || $weixin == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请填写微信号'
                        });
                        return;
                    }
                }
                
                var $qq = $("#qq").val();
                if (typeof($qq) == 'undefined') {
                    $qq = '';
                }
                else {
                    if ($qq == '' || $qq == '0') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请填写QQ号'
                        });
                        return;
                    }
                }
                
                //择偶要求
                var $cond_age1 = $("#cond_age1").val();
                if ($cond_age1 == '' || $cond_age1 == '0') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请设置择偶年龄要求'
                    });
                    return;
                }
                var $cond_age2 = $("#cond_age2").val();
                if ($cond_age2 == '' || $cond_age2 == '0') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请设置择偶年龄要求'
                    });
                    return;
                }
                
                var $cond_height1 = $("#cond_height1").val();
                if (typeof($cond_height1) == 'undefined') {
                    $cond_height1 = '';
                }
                var $cond_height2 = $("#cond_height2").val();
                if (typeof($cond_height2) == 'undefined') {
                    $cond_height2 = '';
                }
                
                var $cond_dist1 = $("#cond_dist1").val();
                if (typeof($cond_dist1) == 'undefined') {
                    $cond_dist1 = '';
                }
                var $cond_dist2 = $("#cond_dist2").val();
                if (typeof($cond_dist2) == 'undefined') {
                    $cond_dist2 = '';
                }
                
                var $cond_marry = $("#cond_marry").val();
                if (typeof($cond_marry) == 'undefined') {
                    $cond_marry = '';
                }
                var $cond_education = $("#cond_education").val();
                if (typeof($cond_education) == 'undefined') {
                    $cond_education = '';
                }
                var $cond_above_edu = $("#cond_above_edu").val();
                if (typeof($cond_above_edu) == 'undefined') {
                    $cond_above_edu = '';
                }
                
                var $send_data = {
                    'mobile':_this.mobile, 'hidemobile':$hidemobile,
                    'username':$username, 'password':$password, 'email':$email,
                    'gender':$gender, 'ageyear':$ageyear, 'agemonth':$agemonth, 'ageday':$ageday, 
                    'dist1':$dist1, 'dist2':$dist2, 'dist3':$dist3, 
                    'home1':$home1, 'home2':$home2, 'home3':$home3, 
                    'marry':$marry, 'sort':$sort, 'education':$education, 'house':$house, 
                    'car':$car, 'height':$height, 'weight':$weight, 'job':$job, 'salary':$salary, 
                    'truename':$truename, 'weixin':$weixin, 'qq':$qq, 
                    'cond_age1':$cond_age1, 'cond_age2':$cond_age2, 
                    'cond_height1':$cond_height1, 'cond_height2':$cond_height2, 
                    'cond_area1':$cond_dist1, 'cond_area2':$cond_dist2, 
                    'cond_marry':$cond_marry, 'cond_education':$cond_education, 
                    'cond_eduup':$cond_above_edu, 
                    
                    'forward':_this.forward, 'au_mod':_this.au_mod, 'openid':_this.openid, 
                    'au_unionid':_this.au_unionid, 'au_nickname':_this.au_nickname, 
                    'au_gender':_this.au_gender, 'au_province':_this.au_province, 
                    'au_city':_this.au_city, 'au_headimgurl':_this.au_headimgurl
                };
                
                _this.submitPost($send_data);
                
            });
            
        }, 
        
        submitPost:function(send_data) {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: WAP_APPFILE + "&c=passport&a=regpost",
                    cache: false,
                    data: send_data,
                    dataType: "json",
                    
                    success: function(data) {
                        var $json = eval(data);
                        $response = $json.response;
                        $result = $json.result;

                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") { //成功
                            if (_this.forward == '') {
                                _this.forward = WAP_APPFILE+'&c=cp';
                            }
                            window.location.href = WAP_APPFILE+"&c=passport&a=success&forward="+encodeURIComponent(_this.forward);
                        }
                        else if ($response == "2") {
                            window.top.location.href = $result; //整合OEM
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '注册失败，请检查会员资料！';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                    
            }
            
        }
    }
    
    new OEReg2();
    
});
