/**
 * [OElove Webapp] (C)2010-2099 oelove.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.02.18 Update by CL $
*/
$(function(){
    
    function OESuccess() {
        this.content = '';
        this.obj_id = '';
        this.forward = '';
        
        this.wake();
    }
    
    OESuccess.prototype = {
        
        //唤醒
        wake:function() {
            var _this = this;
            
            //选择标签
            $(document).on("click", "[f='but_sel_tags']", function() {
                var $val = $(this).attr("data-val");
                
                var $content = $("#content").val();
                if ($content != ''){
                    $val = " "+$val;
                }
                $("#content").val($content+$val);
            });
            
            //提交
            $(document).on("click", "[f='but_save_tags']", function(){
                _this.obj_id = $(this).attr("id");
                
                _this.content = $("#content").val();
                if (_this.content == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写个人简介'
                    });
                    return;
                }
                if (strQuantity(_this.content) > 500) {
                    OEUI.toast({
                        type: 'bottom',
                        text: '个人简介不得超过500个字'
                    });
                    return;
                }
                
                _this.submitPost();
                
            }); 
        },
        
        //保存
        submitPost:function() {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: WAP_APPFILE + "&c=profile",
                    data: {
                        a:"saveintro", content:_this.content, datatype:"json"
                    },
                    dataType: 'json',
                    success: function ($data) {
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        $json = eval($data);
                        $response = $json.response;
                        $result = $json.result;
                        
                        if ($response == '1') {
                            //成功
                            if (_this.forward == '') {
                                _this.forward = WAP_APPFILE+'&c=cp';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: '保存成功'
                            });
                            setTimeout(function(){
                                window.location.href = _this.forward;
                            }, 600);
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '保存失败，请检查网络';
     
                            } 
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            });
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function () {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
            
            }
            
        }
    }
    
    new OESuccess(); 
    
});
