/**
 * [OElove webapp] (C)2010-2099 oelove.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.04.24 Update by CL $
*/
$(function(){
    
    //第一步 注册类
    function OEReg() {
        this.mobile = ''; //手机号
        this.mobilecode = ''; //手机验证码
        
        this._this_dialog = ''; //弹窗对象
        this.slide_time = 200; //速度
        
        this.need_send_sms = '0'; //是否启用短信验证码
        this.forward = '';
        this.au_mod = ''; //授权类型 weixin,wechat/sina/qq
        this.openid = ''; //openid
        this.obj_id = '';
        
        this.wake();
        this.blurCheck();
    }
    
    OEReg.prototype = {
        
        wake:function() {
            var _this = this;
            
            //初始化
            _this.need_send_sms = $("#need_send_sms").val();
            if (typeof(_this.need_send_sms) == 'undefined') {
                _this.need_send_sms = '0';
            }
            _this.forward = $("#forward").val();
            if (typeof(_this.forward) == 'undefined') {
                _this.forward = '';
            }
            _this.au_mod = $("#au_mod").val();
            if (typeof(_this.au_mod) == 'undefined') {
                _this.au_mod = '';
            }
            _this.openid = $("#openid").val();
            if (typeof(_this.openid) == 'undefined') {
                _this.openid = '';
            }
            //判断是否有第三方登录
            if ($("#auth_data").find('a').length == 0) {
                $("#auth_box").hide();
            }
            
            //默认显示温馨提示 0.04.24
            setTimeout(function() {
                _this._this_dialog = OEUI.Dialog({
                    el: '#tips_box',
                    animated: 'zoomIn',
                    time:_this.slide_time,
                    type: '2'
                });
            }, 100);
            //关闭提示
            $(document).on("click", "[f='but_close_tips']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            
            //阅读协议
            $(document).on("click", "[f='but_open_xieyi']", function(){
                _this._this_dialog = OEUI.Dialog({
                    el: '#xieyi_box',
                    animated: 'slideRightIn',
                    time:_this.slide_time
                });
            });
            //关闭协议
            $(document).on("click", "[f='but_close_xieyi']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            //同意协议
            $(document).on("click", "[f='but_agree']", function(){
                if ($(this).hasClass('color_main')) {
                    $("#agree").val("");
                    $(this).removeClass('color_main');
                    $(this).addClass('color_m');
                }
                else {
                    $("#agree").val("1");
                    $(this).addClass('color_main');
                    $(this).removeClass('color_m');
                }
            });
            
            //重新输入手机号
            $(document).on("click", "[f='but_reset_mobile']", function(){
                $("#exist_result").hide();
                $("#mobile").val("");
            });
            //确认为我的号码
            $(document).on("click", "[f='but_confirm_login']", function(){
                $("#exist_result").hide();
                var $mobile = $("#mobile").val();
                if (_this.need_send_sms == '1') {
                    $(".menu_next").hide();
                    $(".menu_login").show();
                    
                    $("#but_send_mobile_code").attr('f', 'but_send_mobile_code');
                    $("#but_send_mobile_code").attr('data-type', 'login');
                    $("[f='but_send_mobile_code']").click();
                }
                else {
                    var $login_url = WAP_APPFILE+'&c=passport&a=login'+
                                    "&loginname="+$mobile+"&au_mod="+_this.au_mod+
                                    "&forward="+encodeURIComponent(_this.forward);
                    window.location.href = $login_url;
                }
            });
            
            //下一步
            $(document).on("click", "[f='but_submit_next']", function(){
                _this.obj_id = $(this).attr('id');
                var $mobile = $("#mobile").val();
                if ($mobile == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入手机号码'
                    });
                    return;
                }
                _this.mobile = $mobile;
                
                if (_this.need_send_sms == '1') {
                    var $mobile_code = $("#mobilecode").val();
                    if ($mobile_code == '') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '请输入手机验证码'
                        });
                        return;
                    }
                    _this.mobile_code = $mobile_code;
                }
                
                
                var $agree = $("#agree").val();
                if (typeof($agree) == 'undefined') {
                    $agree = '0';
                }
                if ($agree != '1') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '您还没同意注册协议'
                    });
                    return;
                }
                
                _this.submitNext();
            });
            
            //手机短信登录
            $(document).on("click", "[f='but_submit_login']", function(){
                _this.obj_id = $(this).attr('id');
                var $mobile = $("#mobile").val();
                if ($mobile == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入手机号码'
                    });
                    return;
                }
                _this.mobile = $mobile;
                
                var $mobile_code = $("#mobilecode").val();
                if ($mobile_code == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入手机验证码'
                    });
                    return;
                }
                _this.mobile_code = $mobile_code;
                
                _this.mobileLogin();
            });
    
        },
        
        //校验数据
        blurCheck: function() {
            var _this = this;
            //检测手机
            $(document).on("blur", "#mobile", function(){
                var $val = $(this).val();
                if ($val != '') {
                    _this.checkData("mobile", $val);
                }
            });
        },
        checkData:function(check_type, value) {
            var _this = this;
            
            var $check_url = WAP_APPFILE;
            $.ajax({
                type: "POST",
                url: $check_url,
                cache: false,
                data: {
                    c:'picker', a:'check', check_type:check_type, name:value
                },
                dataType: "json",
                success: function($data) {
                    $json = eval($data);
                    $response = $json.response;
                    $result = $json.result;
                    if ($response == "1") { //可用
                        if (check_type == 'mobile') {
                            if ($("#but_send_mobile_code").length > 0) {
                                $("#but_send_mobile_code").attr("f", "but_send_mobile_code");
                            }
                        }
                    }
                    else {
                        //手机号存在，提示去登录 0.02.10
                        if (check_type == 'mobile') {
                            if ($result != '') {
                                OEUI.toast({
                                    type: 'bottom',
                                    text: $result
                                });
                            }
                            else {
                                $("#mobile_text").html(value);
                                $("#exist_result").show();
                            }
                            
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                if (check_type == 'username') {
                                    $result = '该用户名已存在，请更改其他名称';
                                }
                                else {
                                    $result = '该用户名已存在，请更改其他名称';
                                }
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            });
                        }
                    }
                },
                error: function() {
                }
            }); 
        },
        
        //下一步
        submitNext:function() {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: WAP_APPFILE + "&c=passport",
                    cache: false,
                    data: {
                        a:"regpost1", datatype:"ajax", 
                        mobile:_this.mobile, mobilecode:_this.mobile_code, 
                        au_mod:_this.au_mod, openid:_this.openid
                    },
                    dataType: "json",
                    
                    success: function(data) {
                        var $json = eval(data);
                        $response = $json.response;
                        $result = $json.result;

                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") { //校验成功
                            var $reg2_url = WAP_APPFILE+"&c=passport"+
                                            "&a=reg2&mobile="+_this.mobile+
                                            "&openid="+encodeURIComponent(_this.openid)+
                                            "&au_mod="+encodeURIComponent(_this.au_mod)+
                                            "&forward="+encodeURIComponent(_this.forward);
                            window.location.href = $reg2_url;
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '提交失败，请检查！';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                    
            }
        },
        
        //短信登录
        mobileLogin:function() {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: WAP_APPFILE + "&c=passport",
                    cache: false,
                    data: {
                        a:"loginmobile", datatype:"ajax", 
                        mobile:_this.mobile, validcode:_this.mobile_code, 
                        au_mod:_this.au_mod, openid:_this.openid
                    },
                    dataType: "json",
                    
                    success: function(data) {
                        var $json = eval(data);
                        $response = $json.response;
                        $result = $json.result;

                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") { //登录成功
                            if (_this.forward == '') {
                                _this.forward = WAP_APPFILE+'&c=cp';
                            }
                            window.location.href = _this.forward;
                        }
                        else if ($response == "2") {
                            window.top.location.href = $result; //整合OEM
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '登录失败，请检查手机号和验证码！';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                    
            }
        }
        
    }
    
    new OEReg();
    
});

