/**
 * [OElove Webapp] (C)2010-2099 oelove.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.02.17 Update by CL $
*/
$(function(){
    
    //取回密码类
    function OEForget() {
        this.mobile = ''; //手机号
        this.mobilecode = ''; //手机验证码
        
        this._this_dialog = ''; //弹窗对象
        this.slide_time = 200; //速度
        
        this.submitNext();
        this.submitReset();
    }
    
    OEForget.prototype = {
        
        
        //下一步
        submitNext: function() {
            var _this = this;
            
            $(document).on("click", "[f='but_next']", function(){
                _this.mobile = $("#mobile").val();
                _this.mobilecode = $("#mobilecode").val();
                
                if (_this.mobile == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入手机号码'
                    });
                    return;
                }
                if (_this.mobilecode == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入手机验证码'
                    });
                    return;
                }
                _this.checkMobile();
            });
            
        },
        //执行验证
        checkMobile:function() {
            
            var _this = this;
            var loading = null;
            var timer = setTimeout(function () {
                loading = OEUI.showLoading({
                    type:2
                });
            }, 200);
            
            $.ajax({
                type: "POST",
                url: _ROOT_PATH + "index.php?m=wap&c=picker",
                cache: false,
                data: {
                    a:"check", check_type:"mobilecode", 
                    name:_this.mobile, checkcode:_this.mobilecode
                },
                dataType: "json",
                success: function($data) {
                    $json = eval($data);
                    $response = $json.response;
                    $result = $json.result;
                    
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    
                    if ($response == "1") { //校验成功
                        _this._this_dialog = OEUI.Dialog({
                            el: '#reset_wrap',
                            animated: 'slideRightIn',
                            time:_this.slide_time
                        });
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '手机验证码错误';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: $result
                        });
                        return;
                    }
                },
                error: function() {
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            }); 
        },
        
        
        //重置密码
        submitReset:function() {
            var _this = this;
            
            //关闭重置
            $(document).on("click", "[f='close_reset']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            
            //完成
            $(document).on("click", "[f='but_submit_reset']", function() {
                var $obj_id = $(this).attr("id");
                var $password = $("#mobile_newpassword").val();
                var $confirm_password = $("#mobile_confirmpassword").val();
                if ($password.length == 0 || $password == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请设置6-16个字符的新密码'
                    });
                    return;
                }
                if ($confirm_password != $password) {
                    OEUI.toast({
                        type: 'bottom',
                        text: '确认密码不正确'
                    });
                    return;
                }
                
                $("#"+$obj_id).attr("f", "");
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                
                $.ajax({
                    type: "POST",
                    url: WAP_APPFILE + "&c=passport",
                    cache: false,
                    data: {
                        a:"setpassword", datatype:"ajax", 
                        type:2, name:_this.mobile, validcode:_this.mobilecode, 
                        password:$password 
                    },
                    dataType: "json",
                    success: function($data) {
                        $json = eval($data);
                        $response = $json.response;
                        $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") { //成功
                            OEUI.toast({
                                type: 'bottom',
                                text: '取回密码成功，请记住新密码'
                            });
                            if (_this._this_dialog) {
                                _this._this_dialog.hide();
                            }
                            setTimeout(function(){
                                window.location.href = WAP_APPFILE+'&c=cp'
                            }, 800);
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '取回密码失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            });
                            $("#"+$obj_id).attr("f", "but_submit_reset");
                        }
                    },
                    error: function() {
                        $("#"+$obj_id).attr("f", "but_submit_reset");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                        
                    }
                });   
            });
        }
        
    }
    
    new OEForget();
});
