/**
 * [OElove] (C)2010-2099 OELOVE.COM Inc.biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/16 by CL $
*/
var _inst_oepay = null;
$(function(){
    
    function OEPay() {
        this.api_url = WAP_APPFILE + "&c=pay";
        this.sdkid = '';
        this.sdkname = '';
        this.paynum = ''; //订单号
        this.forward = ''; //返回页
        this.obj_id = '';
        
        this.init();
        this.wake();
    }
    
    OEPay.prototype = {
        
        //初始化
        init:function() {
            var _this = this;
            //获取第一个
            $("[f='but_sel_pay']").each(function(iv, el){
                if (iv == 0) {
                    _this.sdkid = $(this).attr("data-sdkid");
                    _this.sdkname = $(this).attr("data-sdkname");
                    $("#sdkid").val(_this.sdkid);
                    $("#sdkname").val(_this.sdkname);
                    
                    $(this).find("._gou").find("i").removeClass("icon-tubiao-xuanze color_f");
                    $(this).find("._gou").find("i").addClass("icon-xuanze1 color_green");
                    return;
                }
            });
            
            setTimeout(function(){
                _this.reqPayResult();
            }, 2000);
        },
        
        wake:function() {
            var _this = this;
            //选择支付方式
            $(document).on("click", "[f='but_sel_pay']", function(){
                _this.sdkid = $(this).attr("data-sdkid");
                _this.sdkname = $(this).attr("data-sdkname");
                $("#sdkid").val(_this.sdkid);
                $("#sdkname").val(_this.sdkname);
                
                $("[f='but_sel_pay']").find("._gou").find("i").removeClass("icon-xuanze1 color_green");
                $("[f='but_sel_pay']").find("._gou").find("i").addClass("icon-tubiao-xuanze color_f");
                $(this).find("._gou").find("i").addClass("icon-xuanze1 color_green");
                    
            });
            
            //确定付款
            $(document).on("click", "[f='but_submit_pay']", function(){
                _this.obj_id = $(this).attr("id");
                _this.paynum = $("#paynum").val();
                _this.forward = $("#forward").val();
                
                _this.confirmPay();
            });
        },
        
        //提交支付
        confirmPay:function() {
            var _this = this;
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data: {
                        a:'savepaysdk', paynum:_this.paynum, 
                        sdkid:_this.sdkid, sdkname:_this.sdkname, 
                        forward:_this.forward
                    },
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        
                        if ($response == "1") {
                            //余额支付
                            if (_this.sdkid == '999') {
                                _this.balancePay();
                            }
                            //微信支付(公众号)
                            else if (_this.sdkid == '998') {
                                _inst_oewx_pay.getWxPayJsParams();
                            }
                            //其他支付
                            else {
                                var $pay_url = _this.api_url+"&a=submit&paynum="+_this.paynum+
                                                "&sdkid="+_this.sdkid+"&sdk="+_this.sdkname+
                                                "&forward="+encodeURIComponent(_this.forward);
                                window.location.href = $pay_url;
                            }
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '提交失败，请检查！';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                }); 
            }
        },
        
        
        //余额支付
        balancePay:function() {
            var _this = this;
            
            var loading = null;
            var timer = setTimeout(function () {
                loading = OEUI.showLoading({
                    type:2
                });
            }, 200);
            
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data: {
                    a:'paybalance', paynum:_this.paynum
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    
                    if ($response == "1") {
                        OEUI.toast({
                            type: 'bottom',
                            text: '支付成功'
                        }); 
                        if (_this.forward == '') {
                            _this.forward = WAP_APPFILE+'&c=cp';
                        }
                        setTimeout(function(){
                            window.location.href = _this.forward;
                        }, 800);
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '支付失败，请检查！';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: $result
                        }); 
                    }
                    
                },
                error: function() {
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            });   
        }, 
        
        
        //时时请求付款结果
        reqPayResult:function() {
            var _this = this;
            var $paynum = $("#paynum").val();
            if (typeof($paynum) == 'undefined') {
                $paynum = '';
            }
            var $forward = $("#forward").val();
            if (typeof($forward) == 'undefined') {
                $forward = '';
            }
            
            if ($paynum != '') {
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data: {
                        a:'checkpay', paynum:$paynum
                    },
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        if ($response == "1") {
                            if ($result == "10") {
                                //成功
                                window.location.href = _this.api_url+"&a=show&paynum="+$paynum+
                                                        "&forward="+encodeURIComponent($forward);
                            }
                            else if ($result == "11") {
                                //失败
                                window.location.href = _this.api_url+"&a=show&paynum="+$paynum+
                                                        "&forward="+encodeURIComponent($forward);
                            }
                            else {
                                //时时查询
                                setTimeout(function(){
                                  _this.reqPayResult();
                                }, 1000);
                            }
                        }
                    },
                    error: function() {

                    }
                });
            }
        }
    }
    
    _inst_oepay = new OEPay();
});
