/**
 * [OElove] (C)2010-2099 OELOVE.COM Inc.biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/05/07 by CL $
*/
$(function(){
    //报名类
    function OEPartyBm() {
        
        this.data_id = "bm_data"; //报名框
        this.page = 1;
        this._this_dialog2 = null;
        this.slide_time = 200;
        this.api_url = WAP_APPFILE +'&c=party';
        
        this.id = ''; //ID
        this.obj_id = ''; //按钮ID
        
        this.wake();
        this.clickBm();
    }
    
    
    OEPartyBm.prototype = {
        
        //唤醒
        wake:function() {
            var _this = this;
            //报名按钮
            $(document).on("click", "[f='but_open_bm']", function(){
                _this.id = $(this).attr("data-id");
                _this.obj_id = $(this).attr("id");
                _this.getBm();
            });
            //关闭报名表
            $(document).on("click", "[f='but_close_bm']", function(){
                if (_this._this_dialog2) {
                    _this._this_dialog2.hide();
                }
            });
            
            //关闭VIP提示 0.05.27
            $(document).on("click", "[f='but_close_needvip']", function(){
                var $url = $(this).attr("data-url");
                if (typeof($url) == 'undefined') {
                    $url = '';
                }
                if ($url != '') {
                    _this._this_dialog2.hide(function(){
                        setTimeout(function(){
                            window.location.href = $url;
                        }, 100);
                    });
                }
                else {
                    _this._this_dialog2.hide();
                }
            });
            
            //关闭实名提示 0.05.07
            $(document).on("click", "[f='but_close_needrz']", function(){
                var $url = $(this).attr("data-url");
                if (typeof($url) == 'undefined') {
                    $url = '';
                }
                if ($url != '') {
                    _this._this_dialog2.hide(function(){
                        setTimeout(function(){
                            window.location.href = $url;
                        }, 100);
                    });
                }
                else {
                    _this._this_dialog2.hide();
                }
            });
        }, 
        
        getBm:function() {
            var _this = this;
            
            var loading = null;
            var timer = setTimeout(function () {
                loading = OEUI.showLoading({
                    type:2
                });
            }, 200);
            
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data: {
                    a:'bm', partyid:_this.id
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    
                    if ($response == '1') {
                        $("#"+_this.data_id).html($result);
                        _this._this_dialog2 = OEUI.Dialog({
                            el: '#bm_wrap',
                            animated: 'slideRightIn',
                            time:_this.slide_time
                        });
                        setTimeout(function(){
                           _this.checkMobi();
                        }, 50);
                    }
                    else if ($response == '2') {
                        //登录
                        var $back_url = _this.api_url+'&a=detail&id='+_this.id+'&nofollow=1';
                        window.location.href = WAP_APPFILE+'&c=passport&a=login&forward='+encodeURIComponent($back_url);
                    }
                    else if ($response == '3') {
                        //需实名认证
                        _this._this_dialog2 = OEUI.Dialog({
                            el: '#needrz_wrap',
                            animated: 'zoomIn',
                            time:_this.slide_time
                        });
                        
                    }
                    else if ($response == '4') {
                        //开通VIP
                        _this._this_dialog2 = OEUI.Dialog({
                            el: '#needvip_wrap',
                            animated: 'zoomIn',
                            time:_this.slide_time
                        });
                    }
                    else {
                        if ($result == '' || $result == null) {
                            $result = '没有可报名的活动';
                        }
                        OEUI.toast({
                            type: 'bottom', 
                            text: $result
                        });
                        return;
                    }
                },
                error: function() {
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                }
            });
        },
        
        
        //检测手机号码是否获取验证码
        checkMobi:function() {
            var _this = this;
            var $mobile = $("#mobile").val();
            if (typeof($mobile) == 'undefined') {
                $mobile = '';
            }
            if ($mobile != '') {
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data: {
                        a:"checkmob", mobile:$mobile
                    },
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        if ($response == '1') {
                            $("#mobilecode_box").hide();
                        }
                        else if ($response == '2') {
                            if ($result != '') {
                                OEUI.toast({
                                    type: 'bottom', 
                                    text: $result
                                });
                            }
                        }
                        else {
                            $("#mobilecode_box").show();
                        }
                    },
                    error: function() {
                    }
                });
            }
            else {
                $("#mobilecode_box").hide();
            }
        },
        
        
        clickBm:function() {
            var _this = this;
            
            //检测手机号
            $(document).on("blur", "#mobile", function(){
               _this.checkMobi(); 
            });
            
            //提交
            $(document).on("click", "[f='but_submit_bm']", function(){
                _this.id = $(this).attr("data-id");
                _this.obj_id = $(this).attr("id");
                //手机
                var $mobile = $("#mobile").val();
                if ($mobile == '') {
                    OEUI.toast({
                        type: 'bottom', 
                        text: '请填写手机号'
                    });
                    return;
                }
                //验证码
                var $mobilecode = '';
                if ($("#mobilecode_box").css('display') == 'none') {
                    
                }
                else {
                    $mobilecode = $("#mobilecode").val();
                    if ($mobilecode == '') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请填写手机验证码'
                        });
                        return;
                    }
                }
                //姓名
                var $truename = $("#truename").val();
                if (typeof($truename) == "undefined") {
                    $truename = "";
                }
                else {
                    if ($truename == '') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请填写姓名'
                        });
                        return;
                    }
                }
                //身份证
                var $idnumber = $("#idnumber").val();
                if (typeof($idnumber) == "undefined") {
                    $idnumber = "";
                }
                else {
                    if ($idnumber.length == 0) {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请填写身份证号'
                        });
                        return;
                    }
                }
                //微信
                var $weixin = $("#weixin").val();
                if (typeof($weixin) == "undefined") {
                    $weixin = "";
                }
                else {
                    if ($weixin.length == 0) {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请填写微信号'
                        });
                        return;
                    }
                }
                //性别
                var $gender = $("#gender").val();
                if (typeof($gender) == "undefined") {
                    $gender = "";
                }
                else {
                    if ($gender.length == 0) {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择性别'
                        });
                        return;
                    }
                }
                //地区
                var $dist1 = $("#dist1").val();
                if (typeof($dist1) == "undefined") {
                    $dist1 = "";
                }
                else {
                    if ($dist1 == '' || $dist1 == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择所在地'
                        });
                        return;
                    }
                }
                var $dist2 = $("#dist2").val();
                if (typeof($dist2) == "undefined") {
                    $dist2 = "";
                }
                else {
                    if ($dist2 == '' || $dist2 == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择所在地'
                        });
                        return;
                    }
                }
                var $dist3 = $("#dist3").val();
                if (typeof($dist3) == "undefined") {
                    $dist3 = "";
                }
                //生日
                var $ageyear = $agemonth = $ageday = '';
                if ($("#birthday").length > 0) {
                    var $birthday = $("#birthday").html();
                    if ($birthday == '' || $birthday == '&nbsp;') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择生日'
                        });
                        return;
                    }
                    var $arr = $birthday.split('-');
                    $ageyear = $arr[0];
                    if (typeof($ageyear) == 'undefined') {
                        $ageyear = '';
                    }
                    $agemonth = $arr[1];
                    if (typeof($agemonth) == 'undefined') {
                        $agemonth = '';
                    }
                    $ageday = $arr[2];
                    if (typeof($ageday) == 'undefined') {
                        $ageday = '';
                    }
                }
                //婚况
                var $marry = $("#marry").val();
                if (typeof($marry) == "undefined") {
                    $marry = "";
                }
                else {
                    if ($marry == '' || $marry == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择婚况'
                        });
                        return;
                    }
                }
                //类型
                var $sort = $("#sort").val();
                if (typeof($sort) == "undefined") {
                    $sort = "";
                }
                else {
                    if ($sort == '' || $sort == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择交友类型'
                        });
                        return;
                    }
                }
                //身高
                var $height = $("#height").val();
                if (typeof($height) == "undefined") {
                    $height = "";
                }
                else {
                    if ($height == '' || $height == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择身高'
                        });
                        return;
                    }
                }
                //体重
                var $weight = $("#weight").val();
                if (typeof($weight) == "undefined") {
                    $weight = "";
                }
                else {
                    if ($weight == '' || $weight == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择体重'
                        });
                        return;
                    }
                }
                //学历
                var $education = $("#education").val();
                if (typeof($education) == "undefined") {
                    $education = "";
                }
                else {
                    if ($education == '' || $education == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择学历'
                        });
                        return;
                    }
                }
                //职业
                var $job = $("#job").val();
                if (typeof($job) == "undefined") {
                    $job = "";
                }
                else {
                    if ($job == '' || $job == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择职业'
                        });
                        return;
                    }
                }
                //年收入
                var $salary = $("#salary").val();
                if (typeof($salary) == "undefined") {
                    $salary = "";
                }
                else {
                    if ($salary == '' || $salary == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择年收入'
                        });
                        return;
                    }
                }
                //购房
                var $house = $("#house").val();
                if (typeof($house) == "undefined") {
                    $house = "";
                }
                else {
                    if ($house == '' || $house == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择购房情况'
                        });
                        return;
                    }
                }
                //购车
                var $car = $("#car").val();
                if (typeof($car) == "undefined") {
                    $car = "";
                }
                else {
                    if ($car == '' || $car == '0') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请选择购车情况'
                        });
                        return;
                    }
                }
                //从哪知道本活动的
                var $sources = $("#sources").val();
                if (typeof($sources) == "undefined") {
                    $sources = "";
                }
                else {
                    if ($sources == '') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请填写从哪知道本活动的'
                        });
                        return;
                    }
                }
                //目的
                var $target = $("#target").val();
                if (typeof($target) == "undefined") {
                    $target = "";
                }
                else {
                    if ($target == '') {
                        OEUI.toast({
                            type: 'bottom', 
                            text: '请填写参加活动目的'
                        });
                        return;
                    }
                }
                
                var $send_data = {
                    'mobile':$mobile, 'mobilecode':$mobilecode, 'truename':$truename, 
                    'idnumber':$idnumber, 'weixin':$weixin, 'gender':$gender, 
                    'dist1':$dist1, 'dist2':$dist2, 'dist3':$dist3, 
                    'ageyear':$ageyear, 'agemonth':$agemonth, 'ageday':$ageday, 
                    'marry':$marry, 'sort':$sort, 'height':$height, 'weight':$weight, 
                    'education':$education, 'job':$job, 'salary':$salary, 
                    'house':$house, 'car':$car, 'sources':$sources, 'target':$target
                };
                _this.submitBm($send_data);
                
            });
            
        }, 
        
        //保存报名
        submitBm:function($send_data) {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: _this.api_url+'&a=savebm&id='+_this.id,
                    cache: false,
                    data:$send_data,
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") {
                            //成功
                            OEUI.toast({
                                type: 'bottom',
                                text: '报名成功，请准时参加活动'
                            });
                            _this._this_dialog2.hide(function(){
                                setTimeout(function(){
                                    window.location.reload();
                                }, 800);
                            });
                        }
                        else if ($response == '2'){
                            //收银台
                            _this._this_dialog2.hide(function(){
                                setTimeout(function(){
                                    window.location.href = WAP_APPFILE+"&c=pay&paynum="+$result;
                                }, 100);
                            });
                        }
                        else if ($response == '22') {
                            //微信支付
                            var $back_url = WAP_APPFILE+'&c=myparty&nofollow=1';
                            var $pay_data = {
                                'paynum': $result,
                                'forward': $back_url
                            };
                            _inst_oewx_pay.initPay($pay_data, function(){
                                OEUI.toast({
                                    type: 'bottom',
                                    text: '报名成功，请准时参加活动'
                                });
                                setTimeout(function() {
                                    window.location.href = $back_url;
                                }, 800);
                            });
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '没有可报名的活动';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        }
    }
    
    new OEPartyBm();
    
});