/**
 * [OElove] (C)2010-2099 oelove.com Webapp
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/04/17 by CL $
*/
$(function () {
    function OEVip () {
        this.api_url = WAP_APPFILE+"&c=vip";
        this.tcid = '';
        this.agree = '1';
        this.obj_id = '';
        
        this.wake();
        
    }
    
    OEVip.prototype = {
        
        
        wake: function () {
            var _this = this;
            
            //默认选择第一个
            $("[f='select_vip']").each(function(iv, elm){
                if (iv == 0) {
                    var $tcid = $(this).attr("data-tcid");
                    var $level = $(this).attr("data-level");
                    var $days = $(this).attr("data-days");
                    var $price = $(this).attr("data-price");
                    
                    $(this).addClass('color_f40').siblings().removeClass('color_f40');
                    
                    $("[f='select_vip']").find(".check em").removeClass('color_f40').addClass('color_m');
                    $(this).find(".check em").removeClass('color_m').addClass('color_f40');
                    $('#days').html($days);
                    $('#level').html('VIP'+$level);
                    
                    _this.tcid = $tcid;
                    
                    return true;
                }
            });
            
            //展开、隐藏
            $(document).on("click", "[f='show_detail']", function(){
                var $id = $(this).attr("data-id");
                if ($(this).find("em").hasClass('icon-jiantouxiaxi')) {
                    $(this).find("em").removeClass('icon-jiantouxiaxi').addClass('icon-jiantoushangxi');
                    $("#detail_"+$id).show();
                }
                else {
                    $(this).find("em").removeClass('icon-jiantoushangxi').addClass('icon-jiantouxiaxi');
                    $("#detail_"+$id).hide();
                }
            });
            
            
            //选择套餐
            $(document).on('click', '[f="select_vip"]', function (e) {
                var $tcid = $(this).attr("data-tcid");
                var $level = $(this).attr("data-level");
                var $days = $(this).attr("data-days");
                var $price = $(this).attr("data-price");
                
                $(this).addClass('color_f40').siblings().removeClass('color_f40');
                
                $("[f='select_vip']").find(".check em").removeClass('color_f40').addClass('color_m');
                $(this).find(".check em").removeClass('color_m').addClass('color_f40');
                $('#days').html($days);
                $('#level').html('VIP'+$level);
                
                _this.tcid = $tcid;
                
            });
            
            //同意开通
            $(document).on("click", "[f='but_agree']", function(){
                if ($(this).find("em").hasClass('color_main')) {
                    $(this).find("em").removeClass('color_main').addClass('color_m');
                    $("#agree").val('0');
                }
                else {
                    $(this).find("em").removeClass('color_m').addClass('color_main');
                    $("#agree").val('1');
                }
            });
            
            //提交开通
            $(document).on("click", "[f='but_submit_vip']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $agree = $("#agree").val();
                if ($agree == '0' || $agree == '') {
                    OEUI.toast({
                        type: 'bottom',  
                        text: '您未同意开通VIP服务'
                    });
                    return;
                }
                
                _this.submitVip();
                
            });
        },
        
        //开通
        submitVip:function() {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);

                $.ajax({
                    type: 'POST',
                    url: _this.api_url,
                    data: {
                        a:'confirmbuy', tcid:_this.tcid
                    },
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == '2') {
                            //收银台
                            window.location.href = _this.api_url+'&c=pay&paynum='+$result;
                        }
                        else if ($response == '22') {
                            //微信支付
                            var $back_url = WAP_APPFILE+'&c=cp&nofollow=1';
                            var $pay_data = {
                                'paynum': $result,
                                'forward': $back_url
                            };
                            _inst_oewx_pay.initPay($pay_data, function(){
                                setTimeout(function() {
                                    window.location.href = $back_url;
                                }, 800);
                            });
                        }
                        
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '开通失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                    },
                    error: function () {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        }
    }
    new OEVip();
});