/**
 * [OElove webapp] (C)2010-2099 OELOVE.COM Inc.biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/05/12 by CL $
*/
$(function(){
    
    function OESet() {
        this.api_url = WAP_APPFILE + "&c=set";
        this._this_dialog = ''; //弹窗对象
        this.slide_time = 200; //速度
        this.obj_id = '';
        
        this.set_mod = ''; //设置类型
        this.set_value = ''; //值
        this.this_dom = '';
        
        this.wake();
        this.bindLogin();
    }
    
    
    OESet.prototype = {
        
        //触发
        wake:function() {
            var _this = this;
            
            //弹出关注公众号
            $(document).on("click", "[f='but_open_wxqr']", function(){
                _this._this_dialog = OEUI.Dialog({
                    el: '#wxqr_tips',
                    animated: 'zoomIn',
                    time:_this.slide_time
                }); 
            });
            //关闭关注公众号
            $(document).on("click", "[f='but_close_wxqr']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            //设置
            $(document).on("click", "[f='switch']", function() {
                _this.set_mod = $(this).attr("data-mod");
                _this.this_dom = $(this);
                
                var $cur_val = $(this).attr("data-value"); //当前值
                if (_this.set_mod == 'hidemobile') {
                    if ($cur_val == '0') {
                        _this.set_value = '1'; //保存为隐藏
                    }
                    else {
                        _this.set_value = '0'; //保存为开启
                    }
                }
                else {
                    if ($cur_val == '0') {
                        _this.set_value = '1'; //开启
                    }
                    else {
                        _this.set_value = '0'; //关闭
                    }
                }
                _this.saveSet();
            });
            
            //修改密码
            $(document).on("click", "[f='but_open_password']", function(){
                _this._this_dialog = OEUI.Dialog({
                    el: '#password_wrap',
                    animated: 'slideRightIn',
                    time:_this.slide_time
                }); 
            });
            //关闭密码
            $(document).on("click", "[f='but_close_password']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            //提交密码
            $(document).on("click", "[f='but_submit_password']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $newpassword = $("#newpassword").val();
                var $confirmpassword = $("#confirmpassword").val();
                if ($newpassword == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入新密码,6-16个字符'
                    }); 
                    return;
                }
                if ($confirmpassword == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入确认密码'
                    }); 
                    return;
                }
                if ($confirmpassword != $newpassword) {
                    OEUI.toast({
                        type: 'bottom',
                        text: '确认密码不正确'
                    }); 
                    return;
                }
                
                var $send_data = {
                    'a':'savepassword', 'newpassword':$newpassword, 'confirmpassword':$confirmpassword
                };
                _this.sendEditPassword($send_data);
            });
            
            
        },
        
        //保存设置
        saveSet:function() {
            var _this = this;
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data: {
                    a:'saveset', mod:_this.set_mod, value:_this.set_value
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    if ($response == "1") {
                        $(_this.this_dom).attr('data-value', _this.set_value);
                        if (_this.set_mod == 'hidemobile') {
                            //0.05.12
                            if (_this.set_value == '1') {
                                $(_this.this_dom).find('.oe_switch').addClass('active');
                            } 
                            else {
                                $(_this.this_dom).find('.oe_switch').removeClass('active');
                            }
                        } 
                        else {
                            if (_this.set_value == '1') {
                                $(_this.this_dom).find('.oe_switch').addClass('active');
                            }
                            else {
                                $(_this.this_dom).find('.oe_switch').removeClass('active');
                            }
                        }
                    } 
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '设置失败，请检查！';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: $result
                        }); 
                        
                    }
                },
                error: function() {
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试'
                    });
                }
            });
        },
        
        //修改密码
        sendEditPassword:function($send_data) {
            var _this = this;
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data:$send_data,
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") {
                            OEUI.toast({
                                type: 'bottom',
                                text: '修改成功，请记住新密码！'
                            });
                            setTimeout(function(){
                                if (_this._this_dialog) {
                                    _this._this_dialog.hide();
                                    $("#newpassword").val('');
                                    $("#confirmpassword").val('');
                                }
                            }, 800);
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '修改失败，请检查！';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        },
        
        
        //绑定登录
        bindLogin: function () {
            var _this = this;
            
            //立即绑定
            $(document).on("click", "[f='but_set_bind']", function(){
                var $type = $(this).attr("data-type");
                var $bind_url = WAP_APPFILE+ '&c=passport&a=auth&mod='+$type+'&from=set';
                window.location.href = $bind_url;
            });
            
            //取消绑定
            $(document).on("click", "[f='but_cancel_bind']", function(){
                var $type = $(this).attr("data-type");
                OEUI.confirm({
                    text: '确定要删除该绑定吗?',
                    confirm: function () {
                        _this.unbindLogin($type);
                    }
                });
            });
        },
        
        unbindLogin: function ($type) {
            var _this = this;
            
            var loading = null;
            var timer = setTimeout(function () {
                loading = OEUI.showLoading({
                    type:2
                });
            }, 200);
            
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data:{
                    a:'cancelbind', bindtype:$type
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    
                    if ($response == "1") {
                        OEUI.toast({
                            type: 'bottom',
                            text: '解除成功'
                        });
                        setTimeout(function(){
                            window.location.reload();
                        }, 800);
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '解除失败，请检查！';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: $result
                        }); 
                    }
                },
                error: function() {
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            });

        }
    }
    new OESet();
});