/**
 * [OElove webapp] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.03.26 Update by OE/CL $
*/
$(function(){
    
    //修改收款资料
    function OEBank() {
        this.api_url = WAP_APPFILE+"&c=set";
        this.mobilecode = '';
        this.alipaycontact = '';
        this.alipayaccount = '';
        
        this.bankname = '';
        this.banksub = '';
        this.bankcontact = '';
        this.bankaccount = '';
        
        this.obj_id = '';
        
        this.edit();
    }
    
    OEBank.prototype = {
        
        edit:function() {
            var _this = this;
            
            //选择银行
            $(document).on("click", "[f='but_select_bank']", function(){
                var $val = $(this).attr("data-val");
                $(this).addClass('current').siblings().removeClass('current');
                $('#bankname').val($val);
            });
            
            //提交修改
            $(document).on("click", "[f='but_edit_bank']", function() {
                _this.obj_id = $(this).attr("id");
                _this.mobilecode = $("#mobilecode").val();
                if (_this.mobilecode == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写手机验证码'
                    });
                    return;
                }
                
                _this.alipaycontact = $("#alipaycontact").val();
                _this.alipayaccount = $("#alipayaccount").val();
                
                _this.bankname = $("#bankname").val();
                _this.banksub = $("#banksub").val();
                _this.bankcontact = $("#bankcontact").val();
                _this.bankaccount = $("#bankaccount").val();
                
                if (_this.alipaycontact == '' && _this.bankcontact == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '支付宝和银行卡至少填写一项'
                    });
                    return;
                }
                if (_this.alipaycontact != '' && _this.bankcontact != '') {
                    
                    if (_this.alipaycontact != _this.bankcontact) {
                        OEUI.toast({
                            type: 'bottom',
                            text: '支付宝姓名和银行卡开户人姓名不一致'
                        });
                        return;
                    }
                }
                
                _this.post();
            });
            
        },
        
        //执行修改
        post:function() {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data: {
                        a:'savebank', datatype:'ajax', mobilecode:_this.mobilecode, 
                        alipaycontact:_this.alipaycontact, alipayaccount:_this.alipayaccount, 
                        bankname:_this.bankname, banksub:_this.banksub, 
                        bankaccount:_this.bankaccount, bankcontact:_this.bankcontact
                    },
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") { 
                            OEUI.toast({
                                type: 'bottom',
                                text: '修改成功'
                            });
                            setTimeout(function(){
                                window.location.reload();
                            }, 800);
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '修改失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        }
    }
    
    new OEBank();
    
});