/**
 * [OElove webapp] (C)2010-2099 oelove.com Webapp
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/17 by bo $
*/
$(function () {
    
    function OEMy () {
        this.api_url = WAP_APPFILE;
        this._this_dialog = null;
        this.slide_time = 300;
        
        this.obj_id = '';
        this.wakeRechare();
        this.wakeTrans();
    }
    
    
    OEMy.prototype = {
        
        wakeRechare:function() {
            var _this = this;
            
            //弹出充值页
            $(document).on("click", "[f='but_open_recharge']", function(){
                _this._this_dialog = OEUI.Dialog({
                    el: '#recharge_dialog',
                    animated: 'slideRightIn',
                    time: _this.slide_time
                });
            });
            //关闭充值页
            $(document).on("click", "[f='but_close_recharge']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            //选择金额
            $(document).on("click", "[f='but_sel_money']", function() {
                var $val = $(this).attr("data-val");
                $("[f='but_sel_money']").find("i").removeClass("color_f40 color_9 icon-xuanze1");
                $("[f='but_sel_money']").find("i").addClass("color_9 icon-tubiao-xuanze");
                $(this).find("i").addClass("color_f40 icon-xuanze1");
                
                $("#recharge_money").val($val);
            });
            
            //提交充值
            $(document).on("click", "[f='but_submit_recharge']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $money = $('#recharge_money').val();
                if ($money == '' || $money == '0') {
                    OEUI.toast({
                        type: 'bottom',  
                        text: '请输入充值金额'
                    });
                    return;
                }
                
                var $send_data = {
                    'money':$money
                };
                
                _this.submitRecharge($send_data);
            });
            
        },
        
        //充值
        submitRecharge:function($send_data) {
            var _this = this;
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);

                $.ajax({
                    type: 'POST',
                    url: _this.api_url+'&c=recharge&a=submit',
                    data: $send_data,
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == '1') {
                            _this._this_dialog.hide(function() {
                                window.location.href = _this.api_url+'&c=pay&paynum='+$result;
                            });
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '充值失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                    },
                    error: function () {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        },
        
        
        wakeTrans:function() {
            var _this = this;
            //弹出转换页
            $(document).on("click", "[f='but_open_trans']", function(){
                _this._this_dialog = OEUI.Dialog({
                    el: '#trans_dialog',
                    animated: 'slideRightIn',
                    time: _this.slide_time
                });
            });
            //关闭充值页
            $(document).on("click", "[f='but_close_trans']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            //提交金额
            $(document).on("click", "[f='but_submit_trans']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $trans_money = $('#trans_money').val();
                var $mobilecode = $('#mobilecode').val();
                if ($mobilecode == '') {
                    OEUI.toast({
                        type: 'bottom',  
                        text: '请输入验证码'
                    });
                    return;
                }
                if ($trans_money == '' || $trans_money == '0') {
                    OEUI.toast({
                        type: 'bottom',  
                        text: '请输入转换金额'
                    });
                    return;
                }
                
                var $send_data = {
                    'mobilecode':$mobilecode, 'quantity':$trans_money
                };
                
                _this.submitTranslate($send_data);
            });
        },
        //转入余额
        submitTranslate: function ($send_data) {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);

                $.ajax({
                    type: 'POST',
                    url: _this.api_url+'&c=withdraw&a=savetrans',
                    data: $send_data,
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == '1') {
                            OEUI.toast({
                                type: 'bottom', 
                                text: '转入成功'
                            });
                            _this._this_dialog.hide(function() {
                                setTimeout(function(){
                                    window.location.reload();
                                }, 800);
                            });
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '转入失败，请检查钱包';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                    },
                    error: function () {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        }
    }
    new OEMy();
});