/**
 * [OElove webapp] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.03.23 Update by OE/CL $
*/
$(function(){
    //设置地图
    function OEMap() {
        this.api_url = WAP_APPFILE+'&c=map';
        this._this_dialog = null;
        this.slide_time = 200; //侧滑响应时间
        
        this.maplng = null; //经度
        this.maplat = null; //纬度
        this.obj_id = null;
        
        this.wake();
    }
    
    OEMap.prototype = {
        
        //触发
        wake:function() {
            var _this = this;
            
            //打开
            $(document).on("click", "[f='but_open_setmap']", function(){
                //弹出
                _this._this_dialog = OEUI.Dialog({
                    el: '#setmap_wrap',
                    animated: 'slideRightIn',
                    time:_this.slide_time
                });
                //初始化地图标注
                setTimeout(function(){
                    _initOEmap();
                }, _this.slide_time);
                
            });
            //关闭
            $(document).on("click", "[f='but_close_setmap']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            //搜索地区
            $(document).on("click", "[f='but_search_map_location']", function(){
                var $maplocation = $("#maplocation").val();
                if ($maplocation == '') {
                    OEUI.toast({
                        text: '请输入要搜索的地址'
                    });
                    return;
                }
                _searchMap();
            });
            
            //保存
            $(document).on("click", "[f='but_save_setmap']", function(){
                _this.obj_id = $(this).attr("id");
                _this.maplng = $("#maplng").val();
                if (_this.maplng == '') {
                    OEUI.toast({
                        text: '请标注地图'
                    });
                    return;
                }
                _this.maplat = $("#maplat").val();
                if (_this.maplat == '') {
                    OEUI.toast({
                        text: '请标注地图'
                    });
                    return;
                }
                _this.post();
            });
        },
        
        post:function() {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data: {
                        a:'saveset', datatype:'ajax', 
                        maplng:_this.maplng, maplat:_this.maplat
                    },
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") {
                            OEUI.toast({
                                text: '保存成功'
                            });
                            
                            if (_this._this_dialog) {
                                setTimeout(function(){
                                    if (_this._this_dialog) {
                                        _this._this_dialog.hide();
                                    }
                                }, 500);
                            }
                            
                            var $from = $("#from").val();
                            if (typeof($from) == 'undefined') {
                                $from = '';
                            }
                            if ($from == 'usermap') {
                                setTimeout(function(){
                                    window.location.href = WAP_APPFILE+'&c=usermap';
                                }, 800);
                            }
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '保存失败，请检查！';
                            }
                            OEUI.toast({
                                text: $result
                            }); 
                        }
                        
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
            }
        } 
    }
    new OEMap();
    
});

