/**
 * [OElove] (C)2010-2099 oelove.com Webapp
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/12 by CL $
*/
$(function () {

    function OEFriend() {
        this.api_url = WAP_APPFILE+'&c=friend';
        
        this.id = '';
        this.wake();
        
    }
    OEFriend.prototype = {
        //触发
        wake:function() {
            var _this = this;
            
            //删除
            $(document).on("click", "[f='but_del_friend']", function(){
                _this.id = $(this).attr("data-id");
                OEUI.confirm({
                    title: '温馨提示',
                    text: '确定要删除吗？',
                    confirm: function () {
                        _this.submitDel();
                    }
                });
            });
            
            //聊天
            $(document).on("click", "[f='but_tochat']", function(){
                var $to_uid = $(this).attr("data-uid");
                _this.toChat($to_uid);
            });
        },
        
        //删除
        submitDel:function() {
            var _this = this;
            var loading = null;
            var timer = setTimeout(function () {
                loading = OEUI.showLoading({
                    type:2
                });
            }, 200);
            
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data:{
                    a:'del', id:_this.id
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    
                    if ($response == "1") { 
                        OEUI.toast({
                            type: 'bottom',
                            text: '删除成功'
                        });
                        $("#list_"+_this.id).remove();
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '删除失败，请检查';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: $result
                        }); 
                    }
                },
                error: function() {
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            });
                
        },
        
        //去聊天
        toChat:function($to_uid) {
            $.ajax({
                type: "POST",
                url: WAP_APPFILE+'&c=msgchat',
                cache: false,
                data:{
                    a:'setsid', touid:$to_uid, from:'friend'
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;

                    if ($response == "1") { 
                        window.location.href = WAP_APPFILE+"&c=msgchat&sid="+$result+"&from=friend";
                    }
                    else {
                        
                        var $power_code = $result.power_code;
                        if (typeof($power_code) == 'undefined') {
                            $power_code = '';
                        }
                        var $power_msg = $result.power_msg;
                        if (typeof($power_msg) == 'undefined') {
                            $power_msg = '';
                        }
                        
                        if ($power_msg == '') {
                            $power_msg = '请求失败，请稍后再试';
                        }
                        if ($power_code == '20') {
                            window.location.href = WAP_APPFILE+"&c=qzform&a=land&from=friend&uid="+$to_uid;
                        }
                        else {
                            OEUI.toast({
                                type: 'bottom',
                                text: $power_msg
                            }); 
                        }
                    }
                },
                error: function() {
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            });
        }
        
    }
    new OEFriend();

});