/**
 * [OElove webapp] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.03.24 Update by OE/CL $
*/
var _inst_oecut = null;
$(function(){
    
    //裁剪头像
    function OECut() {
        this.api_url = WAP_APPFILE+'&c=avatar';
        this._this_dialog = null;
        this.slide_time = 200; //侧滑响应时间
        
        this.userImage_id = 'userImage_id';
        this._scaleX = 0; //x坐标
        this._scaleY = 0; //y坐标
        
        this.type = ''; //类型 avatar/头像, logo/商户
        this.img_url = null; //图片路径
        this.img_code = null; //base64加密后的图片路径
        this.img_width = null; //图片原始宽
        this.img_height = null; //图片原始高
        this.cut_base64_imgUrl = null; //裁剪的base64
        this.input_name = 'img';
        
        this.obj_id = null;
        
        this.wake();
        
    }
    
    OECut.prototype = {
        
        //上传完头像后回调初始化
        initCallBack:function(data, type, input) {
            var _this = this;
            if (typeof(data) == 'undefined') {
                data = null;
                return;
            }
            //类型
            if (typeof(type) == 'undefined') {
                type = 'avatar';
            }
            _this.type = type;
            //input img
            if (typeof(input) == 'undefined') {
                input = 'img';
            }
            _this.input_name = input;
            
            
            _this.img_url = data.drawimg;
            _this.img_code = data.base64img;
            _this.img_width = data.imgwidth;
            _this.img_height = data.imgheight;
            
            $("#"+_this.userImage_id).attr("src", _this.img_url);
            $("#userImage_code").val(_this.img_code);
            $("#userImage_width").val(_this.img_width);
            $("#userImage_height").val(_this.img_height);
            
            _this.justBoxsize(); //弹出框
            
        },
        
        //调整avatar框大小
        justBoxsize:function() {
            var _this = this;
            
            $(".profile_cut").css({"height":(WIN_HEIGHT-44)+"px"});
            var $img_width = parseInt($("#userImage_width").val());
            var $img_height = parseInt($("#userImage_height").val());
            if ($img_width < 200) {
                $img_width = 200; //图片至少200宽
            }
            
            var $box_width = WIN_WIDTH;
            var $box_height = (WIN_HEIGHT-154);
            
            if ($img_width < $box_width) {
                $box_width = $img_width;
            }
            if ($img_height < $box_height) {
                $box_height = $img_height;
            }
            var $box_margin = (((WIN_HEIGHT-154)-$box_height)/2);
            $("#imgBox").css({
                "width":$box_width, "height":$box_height, "margin-top":$box_margin+"px"
            });
            
            _this.initCropper();
            
            setTimeout(function(){
                //弹出
                _this._this_dialog = OEUI.Dialog({
                    el: '#avatar_box',
                    animated: 'slideRightIn',
                    time:_this.slide_time
                });
            }, 500);
        },
        
        //初始化cropper
        initCropper:function() {
            var _this = this;
            $("#"+_this.userImage_id).cropper({
                aspectRatio: 5/6, //比例
                autoCropArea: 0.8, //图片的80%
                autoCrop:true, //
                dragMode: "move",//设置移动图片、重新绘制选图区域
                cropBoxResizable: true, //是否允许调整裁剪框大小
                movable: true,//是否允许移动裁切框
                resizable:true, //是否允许改变裁剪框大小
                mouseWheelZoom:false,
                touchDragZoom:false,
                zoomable: false,//是否允许放大图片
                guides:true,//显示裁切线中间的虚线网格
                dragCrop:false, //禁止重新创建一个裁剪框
                minCanvasWidth:0,
                minCanvasHeight:0,
                crop: function(data){
                    //初始化
                    window._scaleX = data.scaleX;
                    window._scaleY = data.scaleY;
                    
                    var $_x = data.x; //剪裁区域左侧的偏移
                    var $_y = data.y; //剪裁区域距上部的偏移
                    var $_cut_width = data.width; //剪裁区域的宽度
                    var $_cut_height = data.height; //剪裁区域的高度
                    $("#x1").val($_x);
                    $("#y1").val($_y);
                    $("#w").val($_cut_width);
                    $("#h").val($_cut_height);
                }
            });
        },

        //操作
        wake:function() {
            var _this = this;
            
            //左右变换
            $(document).on('click', '#scaleX_id', function() {
                _this._scaleX = window._scaleX * -1;
                $('#'+_this.userImage_id).cropper('scaleX', _this._scaleX);
            });
            //上下变换
            $(document).on('click', '#scaleY_id', function(){
                _this._scaleY = window._scaleY * -1;
                $('#'+_this.userImage_id).cropper('scaleY', _this._scaleY);
            });
            //旋转90°
            $(document).on('click', '#rotateMax_id', function(){
                $('#'+_this.userImage_id).cropper('rotate', 90);
            });
            //取消
            $(document).on('click', "[f='but_cancel_cut']", function() {
                $('#'+_this.userImage_id).cropper('destroy');
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            //确定
            $(document).on("click", "[f='but_submit_cut']", function() {
                _this.obj_id = $(this).attr('id');
                var dataURL = $('#'+_this.userImage_id).cropper("getCroppedCanvas", {
                    width:$("#w").val(),
                    height:$("#h").val()
                });
                //裁剪为base64
                _this.cut_base64_imgUrl = dataURL.toDataURL("image/png", 1);
                _this.submitCut();
            });
        },
        
        //裁剪
        submitCut:function() {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                $("#"+_this.obj_id).find("img").show(); //loading...image
                
                var $url = WAP_APPFILE+'&c=avatar';
                $url += "&a=savecut";
                
                $.ajax({
                    type: "POST",
                    url: $url,
                    cache: false,
                    data: {
                        datatype:'ajax', 
                        base64img:_this.cut_base64_imgUrl, img:_this.img_code
                    },
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        var $attid = $json.attid;
                        if (typeof($attid) == "undefined") {
                            $attid = "";
                        }
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        $("#"+_this.obj_id).find("img").hide(); //loading...image
                        
                        if ($response == "1") {
                            _oeloveFileSynYun($attid); //同步云存储
                            
                            if ($('#'+_this.input_name+'_url').length > 0) {
                                $('#'+_this.input_name+'_url').val($result);
                            }
                            if ($('#'+_this.input_name+'_preview').length > 0) {
                                $('#'+_this.input_name+'_preview').attr('src', $result);
                            }
                            OEUI.toast({
                                text: '裁剪成功'
                            });
                            
                            var $from = $("#from").val();
                            if (typeof($from) == 'undefined') {
                                $from = '';
                            }
                            if ($from == 'profile') {
                                var $backurl = WAP_APPFILE +"&c=profile&nofollow=1&refresh=avatar";
                            }
                            else {
                                var $backurl = WAP_APPFILE +"&c=cp&refresh=avatar";
                            }
                            setTimeout(function(){
                                //$('#'+_this.userImage_id).cropper('destroy');
                                window.location.href = $backurl;
                            }, 800);
                            /*
                            if (_this._this_dialog) {
                                _this._this_dialog.hide();
                            }
                            */
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '裁剪失败，请检查！';
                            }
                            OEUI.toast({
                                text: $result
                            }); 
                        }
                        
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        $("#"+_this.obj_id).find("img").hide(); //loading...image
                        OEUI.toast({
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
            }
            
        }
        
    }
    _inst_oecut = new OECut(); //保存实例化
    
});
