/**
 * [OElove] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020-11-03 by BO $
*/
$(function () {
    function Dynamic () {
        this.switchVerify();
        this.submit();
        this.initUpload();
        this.removeImg();
    }
    Dynamic.prototype = {
        initUpload: function () {
            var loading;
            var upload = new Uploader({
                el: document.getElementById('uploader'),
                url: _ROOT_PATH+"index.php?c=index&a=upload&forbidcom=&forbidwater=&module=dynamic&thumbfiles=1",
                data: {
                  uploadpart: 'file'
                }
            });
            upload.on('beforeUploadOption', function () {
                if ($('[f="remove_img"]').length >= 9) {
                    OEUI.message.msg({text: '最多上传9张图片'});
                    return false;
                }
                return true;
            })
            upload.on('beforeUpload', function (e) {
                var file = e.target.files[0];
                var regexp = /.(gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG)$/;
                if (!regexp.test(file.name)) {
                    OEUI.message.msg({ text: '请上传gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG格式的图片' });
                    return false;
                }
                loading = OEUI.loading({
                  el: document.getElementById('uploader'),
                  color: '#999',
                  width: 30,
                  height: 30
                });
                loading.show();
                return true;
            });
            upload.on('success', function (res) {
                var html = '\
                  <div class="img_60 bo_eb bg_f5 fl mr10 pr img_box">\
                    <div class="w100per h100per oh">\
                      <img class="ob_c" src="'+ res.thumbimg +'" f="upload_img" data-src="'+ res.uploadimg +'">\
                    </div>\
                    <div class="pa cursor t_5" style="right: -5px;" f="remove_img">\
                      <em class="iconfont icon-yichu color_red lhn"></em>\
                    </div>\
                  </div>\
                ';
                $('#uploader').before(html);
                loading.remove();
            });
            upload.on('error', function () {
                loading.remove();
            });
        },
        removeImg: function () {
            $(document).on('click', '[f="remove_img"]', function () {
                var target = $(this);
                OEUI.modal.info({
                    title: '温馨提示',
                    text: '是否删移除该图片？',
                    confirm: function () {
                        target.closest('.img_box').remove();
                    }
                });
            });
        },
        switchVerify: function () {
            $('[f="switch_verify"]').on('click', function () {
                var target = $(this);
                var url = target.attr('src');
                var rand = parseInt(Math.random() * 1000);
                target.attr('src', url + '&r=' + rand);
            });
        },
        submit: function () {
            var is_http = false;
            $('[f="submit"]').on('click', function () {
                var content = $('#content').val();
                var verify = $('#verify').val();
                if (content == '') {
                    OEUI.message.msg({text: '请输入内容'});
                    return;
                }
                if (verify == '') {
                    OEUI.message.msg({text: '请输入验证码'});
                    return;
                }

                var pic = [];
                var img = $('[f="upload_img"]');
                $.each(img, function (i, v) {
                    pic.push({
                        thumbimg: $(v).attr('src'),
                        drawimg: $(v).attr('data-src')
                    });
                });
                if (is_http) return;
                is_http = true;

                var loading, timer, el = this;
                timer = setTimeout(function () {
                    loading = OEUI.loading({
                        el: el,
                        color: '#666'
                    });
                    loading.show();
                }, 200); 
                $.ajax({
                    type: 'POST',
                    url: _ROOT_PATH+"index.php?c=dynamic",
                    data: {
                        content: content, 
                        imgcode: verify,
                        thumbimg: pic[0] ? pic[0].thumbimg : '', 
                        drawimg: pic[0] ? pic[0].drawimg : '', 
                        thumbimg2: pic[1] ? pic[1].thumbimg : '', 
                        drawimg2: pic[1] ? pic[1].drawimg : '', 
                        thumbimg3: pic[2] ? pic[2].thumbimg : '', 
                        drawimg3: pic[2] ? pic[2].drawimg : '',
                        thumbimg4: pic[3] ? pic[3].thumbimg : '', 
                        drawimg4: pic[3] ? pic[3].drawimg : '', 
                        thumbimg5: pic[4] ? pic[4].thumbimg : '', 
                        drawimg5: pic[4] ? pic[4].drawimg : '', 
                        thumbimg6: pic[5] ? pic[5].thumbimg : '', 
                        drawimg6: pic[5] ? pic[5].drawimg : '',
                        thumbimg7: pic[6] ? pic[6].thumbimg : '', 
                        drawimg7: pic[6] ? pic[6].drawimg : '', 
                        thumbimg8: pic[7] ? pic[7].thumbimg : '', 
                        drawimg8: pic[7] ? pic[7].drawimg : '', 
                        thumbimg9: pic[8] ? pic[8].thumbimg : '', 
                        drawimg9: pic[8] ? pic[8].drawimg : '',
                        a:"saveadd",
                    },
                    success: function (json) {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            OEUI.message.msg({text: '发布成功'});
                            setTimeout(function () {
                                window.parent.location.reload();
                            }, 500);
                        } else {
                            if (res.result) {
                                OEUI.message.msg({text: res.result});
                            } else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再用'});
                            }
                        }
                    },
                    error: function () {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        OEUI.message.msg({text: '网络繁忙，请稍后再用'});
                    }
                });
            });
        }
    }
    new Dynamic();
});