<?php die();?>
DROP TABLE IF EXISTS `{dbpre}about`;

CREATE TABLE `{dbpre}about` (
  `abid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(10) unsigned DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `thumbimg` varchar(255) DEFAULT '',
  `drawimg` varchar(255) DEFAULT '',
  `orders` smallint(2) unsigned DEFAULT '0',
  `content` text,
  `metatitle` varchar(255) DEFAULT '',
  `metakeyword` varchar(255) DEFAULT '',
  `metadesc` varchar(255) DEFAULT '',
  `tplname` varchar(100) DEFAULT '',
  `wtplname` varchar(100) DEFAULT '',
  `hits` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `wapelite` tinyint(1) unsigned DEFAULT '0',
  `nofollow` tinyint(1) DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `creatid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`abid`),
  KEY `catid` (`catid`),
  KEY `flag` (`flag`),
  KEY `elite` (`elite`),
  KEY `wapelite` (`wapelite`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}about_category`;

CREATE TABLE `{dbpre}about_category` (
  `catid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catname` varchar(255) DEFAULT '',
  `orders` smallint(2) unsigned DEFAULT '0',
  `catimg` varchar(255) DEFAULT '',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `creatid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`catid`),
  KEY `catname` (`catname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}admin`;

CREATE TABLE `{dbpre}admin` (
  `adminid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `loginname` varchar(20) DEFAULT '',
  `password` varchar(32) DEFAULT '',
  `status` tinyint(1) unsigned DEFAULT '0',
  `super` tinyint(1) unsigned DEFAULT '0',
  `roleid` smallint(1) unsigned DEFAULT '0',
  `lastname` varchar(20) DEFAULT '',
  `tel` varchar(100) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `email` varchar(100) DEFAULT '',
  `qq` varchar(50) DEFAULT '',
  `weixin` varchar(50) DEFAULT '',
  `address` varchar(255) DEFAULT '',
  `remark` varchar(255) DEFAULT '',
  `creatid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `logintime` int(10) unsigned DEFAULT '0',
  `logintimes` int(10) unsigned DEFAULT '0',
  `loginip` varchar(50) DEFAULT '',
  `headimg` varchar(255) DEFAULT '',
  `salt` varchar(20) DEFAULT '',
  `safeword` varchar(32) DEFAULT '',
  PRIMARY KEY (`adminid`),
  KEY `roleid` (`roleid`),
  KEY `loginname` (`loginname`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}area`;

CREATE TABLE `{dbpre}area` (
  `areaid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `areaname` varchar(100) DEFAULT '',
  `spread` varchar(50) DEFAULT '',
  `letter` varchar(10) DEFAULT '',
  `parentid` int(10) unsigned DEFAULT '0',
  `depth` int(10) unsigned DEFAULT '0',
  `orders` int(10) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `nextchilds` smallint(4) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `creatid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`areaid`),
  KEY `parentid` (`parentid`),
  KEY `depth` (`depth`),
  KEY `flag` (`flag`),
  KEY `letter` (`letter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}article`;

CREATE TABLE `{dbpre}article` (
  `articleid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `area1` int(10) unsigned DEFAULT '0',
  `area2` int(10) unsigned DEFAULT '0',
  `area3` int(10) unsigned DEFAULT '0',
  `area4` int(10) unsigned DEFAULT '0',
  `catid` int(10) unsigned DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `thumbimg` varchar(255) DEFAULT '',
  `drawimg` varchar(255) DEFAULT '',
  `isimg` tinyint(1) unsigned DEFAULT '0',
  `metatitle` varchar(255) DEFAULT '',
  `metakeyword` varchar(255) DEFAULT '',
  `metadesc` varchar(255) DEFAULT '',
  `summary` varchar(500) DEFAULT '',
  `comefrom` varchar(50) DEFAULT '',
  `author` varchar(50) DEFAULT '',
  `content` text,
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `istop` tinyint(1) unsigned DEFAULT '0',
  `hits` int(10) unsigned DEFAULT '0',
  `comments` int(10) unsigned DEFAULT '0',
  `tplname` varchar(50) DEFAULT '',
  `ownerid` int(10) unsigned DEFAULT '0',
  `creatid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`articleid`),
  KEY `area2` (`area2`),
  KEY `catid` (`catid`),
  KEY `ownerid` (`ownerid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}article_category`;

CREATE TABLE `{dbpre}article_category` (
  `catid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catname` varchar(255) DEFAULT '',
  `subname` varchar(255) DEFAULT '',
  `parentid` int(10) unsigned DEFAULT '0',
  `depth` int(10) unsigned DEFAULT '0',
  `orders` int(10) unsigned DEFAULT '0',
  `aliasname` varchar(50) DEFAULT '',
  `catimg` varchar(100) DEFAULT '',
  `metatitle` varchar(255) DEFAULT '',
  `metakeyword` varchar(255) DEFAULT '',
  `metadesc` varchar(255) DEFAULT '',
  `intro` varchar(500) DEFAULT '',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `indextpl` varchar(100) DEFAULT '',
  `listtpl` varchar(100) DEFAULT '',
  `detailtpl` varchar(100) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `creatid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`catid`),
  KEY `parentid` (`parentid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}attach`;

CREATE TABLE `{dbpre}attach` (
  `attid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `filetype` varchar(15) DEFAULT '',
  `file1` varchar(100) DEFAULT '',
  `file2` varchar(100) DEFAULT '',
  `synyun` tinyint(1) unsigned DEFAULT '0',
  `syntime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`attid`),
  KEY `userid` (`userid`),
  KEY `filetype` (`filetype`),
  KEY `synyun` (`synyun`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}collect`;

CREATE TABLE `{dbpre}collect` (
  `collid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `tuserid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `readflag` tinyint(1) unsigned DEFAULT '0',
  `readtime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`collid`),
  KEY `userid` (`userid`),
  KEY `tuserid` (`tuserid`),
  KEY `addtime` (`addtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}diary`;

CREATE TABLE `{dbpre}diary` (
  `diaryid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `thumbimg` varchar(100) DEFAULT '',
  `drawimg` varchar(100) DEFAULT '',
  `content` text,
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `hits` int(10) unsigned DEFAULT '0',
  `comms` int(10) unsigned DEFAULT '0',
  `lastcomm` int(10) unsigned DEFAULT '0',
  `lastcommuid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`diaryid`),
  KEY `userid` (`userid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}diary_comment`;

CREATE TABLE `{dbpre}diary_comment` (
  `commid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cmuid` int(10) unsigned DEFAULT '0',
  `diaryid` int(10) unsigned DEFAULT '0',
  `cmtime` int(10) unsigned DEFAULT '0',
  `cmcont` varchar(500) DEFAULT '',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `ip` varchar(50) DEFAULT '',
  PRIMARY KEY (`commid`),
  KEY `cmuid` (`cmuid`),
  KEY `diaryid` (`diaryid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}display`;

CREATE TABLE `{dbpre}display` (
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` int(10) unsigned DEFAULT '0',
  `endtime` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `remark` varchar(255) DEFAULT '',
  PRIMARY KEY (`userid`),
  KEY `starttime` (`starttime`),
  KEY `endtime` (`endtime`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}diyintro`;

CREATE TABLE `{dbpre}diyintro` (
  `diyid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `male` tinyint(1) unsigned DEFAULT '0',
  `female` tinyint(1) unsigned DEFAULT '0',
  `content` varchar(500) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`diyid`),
  KEY `male` (`male`),
  KEY `female` (`female`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}dynamic`;

CREATE TABLE `{dbpre}dynamic` (
  `dyid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `dytype` varchar(20) DEFAULT '',
  `content` varchar(400) DEFAULT '',
  `photoids` varchar(100) DEFAULT '',
  `thumbimg` varchar(150) DEFAULT '',
  `drawimg` varchar(150) DEFAULT '',
  `thumbimg2` varchar(100) DEFAULT '',
  `drawimg2` varchar(100) DEFAULT '',
  `thumbimg3` varchar(100) DEFAULT '',
  `drawimg3` varchar(100) DEFAULT '',
  `thumbimg4` varchar(100) DEFAULT '',
  `drawimg4` varchar(100) DEFAULT '',
  `thumbimg5` varchar(100) DEFAULT '',
  `drawimg5` varchar(100) DEFAULT '',
  `thumbimg6` varchar(100) DEFAULT '',
  `drawimg6` varchar(100) DEFAULT '',
  `thumbimg7` varchar(100) DEFAULT '',
  `drawimg7` varchar(100) DEFAULT '',
  `thumbimg8` varchar(100) DEFAULT '',
  `drawimg8` varchar(100) DEFAULT '',
  `thumbimg9` varchar(100) DEFAULT '',
  `drawimg9` varchar(100) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `hits` int(10) unsigned DEFAULT '0',
  `rewards` smallint(6) unsigned DEFAULT '0',
  `zans` smallint(6) unsigned DEFAULT '0',
  `comms` smallint(6) unsigned DEFAULT '0',
  `tyear` smallint(4) unsigned DEFAULT '0',
  `tmonth` tinyint(2) unsigned DEFAULT '0',
  `comefrom` varchar(20) DEFAULT '',
  `unionid` int(10) unsigned DEFAULT '0',
  `storeid` int(10) unsigned DEFAULT '0',
  `type` tinyint(1) unsigned DEFAULT '0',
  `topicid` int(10) unsigned DEFAULT '0',
  `qzid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`dyid`),
  KEY `userid` (`userid`),
  KEY `dytype` (`dytype`),
  KEY `flag` (`flag`),
  KEY `tyear` (`tyear`),
  KEY `tmonth` (`tmonth`),
  KEY `unionid` (`unionid`),
  KEY `storeid` (`storeid`),
  KEY `type` (`type`),
  KEY `topicid` (`topicid`),
  KEY `hits` (`hits`),
  KEY `zans` (`zans`),
  KEY `qzid` (`qzid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}dynamic_comment`;

CREATE TABLE `{dbpre}dynamic_comment` (
  `commid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dyid` int(10) unsigned DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `content` varchar(500) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`commid`),
  KEY `dyid` (`dyid`),
  KEY `userid` (`userid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}dynamic_zan`;

CREATE TABLE `{dbpre}dynamic_zan` (
  `zanid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dyid` int(10) unsigned DEFAULT '0',
  `zanuid` int(10) unsigned DEFAULT '0',
  `zantime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`zanid`),
  KEY `dyid` (`dyid`),
  KEY `zanuid` (`zanuid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}email_checkcode`;

CREATE TABLE `{dbpre}email_checkcode` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `email` varchar(100) DEFAULT '',
  `checkcode` varchar(20) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `lasttime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `email` (`email`),
  KEY `checkcode` (`checkcode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}email_tpl`;

CREATE TABLE `{dbpre}email_tpl` (
  `tplid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) DEFAULT '',
  `title` varchar(255) DEFAULT '',
  `content` text,
  `issystem` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`tplid`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}friend`;

CREATE TABLE `{dbpre}friend` (
  `friendid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `fuserid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `black` tinyint(1) unsigned DEFAULT '0',
  `blacktime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`friendid`),
  KEY `userid` (`userid`),
  KEY `fuserid` (`fuserid`),
  KEY `black` (`black`),
  KEY `blacktime` (`blacktime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}friend_apply`;

CREATE TABLE `{dbpre}friend_apply` (
  `applyid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `fuserid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `msg` varchar(255) DEFAULT '',
  `flag` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`applyid`),
  KEY `userid` (`userid`),
  KEY `fuserid` (`fuserid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}friendlink`;

CREATE TABLE `{dbpre}friendlink` (
  `linkid` int(10) unsigned NOT NULL DEFAULT '0',
  `cityid` int(10) unsigned DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `orders` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `remark` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`linkid`),
  KEY `cityid` (`cityid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}gift`;

CREATE TABLE `{dbpre}gift` (
  `giftid` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` tinyint(2) unsigned DEFAULT '0',
  `giftname` varchar(100) DEFAULT '',
  `imgurl` varchar(255) DEFAULT '',
  `intro` varchar(500) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `istop` tinyint(1) unsigned DEFAULT '0',
  `fee` decimal(18,2) unsigned DEFAULT '0.00',
  `feetype` tinyint(1) unsigned DEFAULT '0',
  `usetimes` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`giftid`),
  KEY `catid` (`catid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}gift_record`;

CREATE TABLE `{dbpre}gift_record` (
  `recordid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `giftid` int(10) unsigned DEFAULT '0',
  `fromuid` int(10) unsigned DEFAULT '0',
  `touid` int(10) unsigned DEFAULT '0',
  `fee` decimal(18,2) unsigned DEFAULT '0.00',
  `feetype` tinyint(1) unsigned DEFAULT '1',
  `message` varchar(255) DEFAULT '',
  `sendtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `viewstatus` tinyint(1) unsigned DEFAULT '0',
  `viewtime` int(10) unsigned DEFAULT '0',
  `income` decimal(18,2) unsigned DEFAULT '0.00',
  `paystatus` tinyint(1) unsigned DEFAULT '0',
  `paytime` int(10) unsigned DEFAULT '0',
  `paytype` tinyint(1) unsigned DEFAULT '0',
  `payid` int(10) unsigned DEFAULT '0',
  `paynum` varchar(30) DEFAULT '',
  `remark` varchar(255) DEFAULT '',
  PRIMARY KEY (`recordid`),
  KEY `giftid` (`giftid`),
  KEY `fromuid` (`fromuid`),
  KEY `touid` (`touid`),
  KEY `flag` (`flag`),
  KEY `viewstatus` (`viewstatus`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}greet`;

CREATE TABLE `{dbpre}greet` (
  `greetid` int(10) unsigned NOT NULL DEFAULT '0',
  `male` tinyint(1) unsigned DEFAULT '1',
  `female` tinyint(1) unsigned DEFAULT '1',
  `greeting` varchar(255) DEFAULT NULL,
  `timeline` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '1',
  `usecount` smallint(2) unsigned DEFAULT '0',
  `issystem` tinyint(1) unsigned DEFAULT '0',
  `dist1` mediumint(8) unsigned DEFAULT '0',
  `dist2` mediumint(8) unsigned DEFAULT '0',
  PRIMARY KEY (`greetid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}group`;

CREATE TABLE `{dbpre}group` (
  `groupid` smallint(4) unsigned NOT NULL DEFAULT '0',
  `groupname` varchar(50) DEFAULT '',
  `asname` varchar(100) DEFAULT '',
  `img1` varchar(100) DEFAULT '',
  `img2` varchar(100) DEFAULT '',
  `intro` varchar(500) DEFAULT '',
  `orders` smallint(6) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `feeset` varchar(5000) DEFAULT '',
  `powerset` varchar(5000) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `cleartimes` tinyint(2) unsigned DEFAULT '1',
  PRIMARY KEY (`groupid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}guest`;

CREATE TABLE `{dbpre}guest` (
  `guestid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mobile` varchar(30) DEFAULT '',
  `mobilerz` tinyint(1) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `lasttime` int(10) unsigned DEFAULT '0',
  `wxopenid` varchar(50) DEFAULT '',
  `qqopenid` varchar(50) DEFAULT '',
  `sinaopenid` varchar(50) DEFAULT '',
  `wxletopenid` varchar(50) DEFAULT '',
  `wxunionid` varchar(50) DEFAULT '',
  `fromdevice` varchar(50) DEFAULT '',
  `tyear` smallint(4) unsigned DEFAULT '0',
  `tmonth` tinyint(2) unsigned DEFAULT '0',
  PRIMARY KEY (`guestid`),
  KEY `mobile` (`mobile`),
  KEY `userid` (`userid`),
  KEY `wxopenid` (`wxopenid`),
  KEY `tyear` (`tyear`),
  KEY `tmonth` (`tmonth`),
  KEY `fromdevice` (`fromdevice`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}guestbook`;

CREATE TABLE `{dbpre}guestbook` (
  `bookid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `catid` tinyint(2) unsigned DEFAULT '0',
  `title` varchar(100) DEFAULT '',
  `content` varchar(1000) DEFAULT '',
  `email` varchar(100) DEFAULT '',
  `mobile` varchar(20) DEFAULT '',
  `img1` varchar(100) DEFAULT '',
  `img2` varchar(100) DEFAULT '',
  `img3` varchar(100) DEFAULT '',
  `img4` varchar(100) DEFAULT '',
  `img5` varchar(100) DEFAULT '',
  `img6` varchar(100) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `reply` varchar(500) DEFAULT '',
  `replytime` int(10) unsigned DEFAULT '0',
  `remark` varchar(255) DEFAULT '',
  PRIMARY KEY (`bookid`),
  KEY `userid` (`userid`),
  KEY `catid` (`catid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}hi_log`;

CREATE TABLE `{dbpre}hi_log` (
  `hiid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fromuid` int(10) unsigned DEFAULT '0',
  `touid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`hiid`),
  KEY `fromuid` (`fromuid`),
  KEY `touid` (`touid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}hometown`;

CREATE TABLE `{dbpre}hometown` (
  `areaid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `areaname` varchar(100) DEFAULT '',
  `spread` varchar(50) DEFAULT '',
  `parentid` int(10) unsigned DEFAULT '0',
  `depth` int(10) unsigned DEFAULT '0',
  `orders` int(10) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `nextchilds` smallint(4) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `creatid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`areaid`),
  KEY `parentid` (`parentid`),
  KEY `depth` (`depth`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}htmllabel`;

CREATE TABLE `{dbpre}htmllabel` (
  `labelid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `labelname` varchar(100) DEFAULT '',
  `title` varchar(255) DEFAULT '',
  `content` text,
  `addtime` int(10) unsigned DEFAULT '0',
  `templet` varchar(50) DEFAULT '',
  PRIMARY KEY (`labelid`),
  KEY `labelname` (`labelname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}item_options`;

CREATE TABLE `{dbpre}item_options` (
  `itemname` varchar(50) NOT NULL DEFAULT '',
  `itemvalue` varchar(2000) DEFAULT '',
  `memo` varchar(255) DEFAULT '',
  `orders` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`itemname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}jubao`;

CREATE TABLE `{dbpre}jubao` (
  `juid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `homeuid` int(10) unsigned DEFAULT '0',
  `blacktype` tinyint(2) unsigned DEFAULT '0',
  `judes` varchar(500) DEFAULT '',
  `juimg` varchar(200) DEFAULT '',
  `jumobile` varchar(20) DEFAULT '',
  `juemail` varchar(100) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `handtime` int(10) unsigned DEFAULT '0',
  `handremark` varchar(255) DEFAULT '',
  `yunstatus` tinyint(1) unsigned DEFAULT '0',
  `isblack` tinyint(1) unsigned DEFAULT '0',
  `isforbid` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`juid`),
  KEY `userid` (`userid`),
  KEY `homeuid` (`homeuid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}kefu`;

CREATE TABLE `{dbpre}kefu` (
  `kefuid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '',
  `mobile` varchar(50) DEFAULT '',
  `weixin` varchar(50) DEFAULT '',
  `headimg` varchar(100) DEFAULT '',
  `intro` varchar(500) DEFAULT '',
  `orders` int(10) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `wxcode` varchar(100) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `hits` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`kefuid`),
  KEY `mobile` (`mobile`),
  KEY `orders` (`orders`),
  KEY `elite` (`elite`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}log_admin`;

CREATE TABLE `{dbpre}log_admin` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `opuser` varchar(30) DEFAULT '',
  `control` varchar(20) DEFAULT '',
  `action` varchar(20) DEFAULT '',
  `ip` varchar(30) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `dowhat` varchar(300) DEFAULT '',
  `success` tinyint(1) unsigned DEFAULT '0',
  `adminid` int(10) unsigned DEFAULT '0',
  `clientport` varchar(20) DEFAULT '',
  `ipaddr` varchar(50) DEFAULT '',
  PRIMARY KEY (`logid`),
  KEY `opuser` (`opuser`),
  KEY `addtime` (`addtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}log_user`;

CREATE TABLE `{dbpre}log_user` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `opuser` varchar(30) DEFAULT '',
  `control` varchar(20) DEFAULT '',
  `action` varchar(20) DEFAULT '',
  `ip` varchar(30) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `dowhat` varchar(300) DEFAULT '',
  `success` tinyint(1) unsigned DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `clientport` varchar(20) DEFAULT '',
  `ipaddr` varchar(50) DEFAULT '',
  PRIMARY KEY (`logid`),
  KEY `opuser` (`opuser`),
  KEY `addtime` (`addtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}login_log`;

CREATE TABLE `{dbpre}login_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `dateline` int(10) unsigned DEFAULT '0',
  `reward` decimal(18,2) unsigned DEFAULT '0.00',
  `times` smallint(4) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `dateline` (`dateline`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}login_sign`;

CREATE TABLE `{dbpre}login_sign` (
  `signid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) DEFAULT '0',
  `money` decimal(18,2) DEFAULT '0.00',
  `addtime` int(10) unsigned DEFAULT '0',
  `dayint` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`signid`),
  KEY `userid` (`userid`),
  KEY `dayint` (`dayint`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}love`;

CREATE TABLE `{dbpre}love` (
  `loveid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `homeuid` int(10) unsigned DEFAULT '0',
  `loveuid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`loveid`),
  KEY `homeuid` (`homeuid`),
  KEY `loveuid` (`loveuid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}mail_content`;

CREATE TABLE `{dbpre}mail_content` (
  `contid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT '',
  `content` text,
  `creattime` int(10) unsigned DEFAULT '0',
  `sendnums` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`contid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `{dbpre}mail_log`;

CREATE TABLE `{dbpre}mail_log` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contid` int(10) unsigned DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `agentid` int(10) unsigned DEFAULT '0',
  `email` varchar(100) DEFAULT '',
  `sendtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `response` varchar(100) DEFAULT '',
  PRIMARY KEY (`logid`),
  KEY `contid` (`contid`),
  KEY `userid` (`userid`),
  KEY `agentid` (`agentid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}match`;

CREATE TABLE `{dbpre}match` (
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `lastdate` int(10) unsigned DEFAULT '0',
  `matchuids` varchar(1000) DEFAULT '',
  PRIMARY KEY (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}message`;

CREATE TABLE `{dbpre}message` (
  `msgid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bgsid` varchar(16) DEFAULT '',
  `fromuid` int(10) unsigned DEFAULT '0',
  `touid` int(10) unsigned DEFAULT '0',
  `content` varchar(1000) DEFAULT '',
  `sendtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `readtime` int(10) unsigned DEFAULT '0',
  `readstatus` tinyint(1) unsigned DEFAULT '0',
  `fromdel` tinyint(1) unsigned DEFAULT '0',
  `todel` tinyint(1) unsigned DEFAULT '0',
  `tyear` smallint(4) unsigned DEFAULT '0',
  `tmonth` tinyint(2) unsigned DEFAULT '0',
  `comefrom` varchar(20) DEFAULT '',
  `isfree` tinyint(1) unsigned DEFAULT '0',
  `showtime` tinyint(1) unsigned DEFAULT '1',
  `isvoice` tinyint(1) unsigned DEFAULT '0',
  `wxmediaid` varchar(100) DEFAULT '',
  `voiceurl` varchar(100) DEFAULT '',
  `voicelong` smallint(4) unsigned DEFAULT '0',
  PRIMARY KEY (`msgid`),
  KEY `bgsid` (`bgsid`),
  KEY `fromuid` (`fromuid`),
  KEY `touid` (`touid`),
  KEY `flag` (`flag`),
  KEY `readstatus` (`readstatus`),
  KEY `fromdel` (`fromdel`),
  KEY `todel` (`todel`),
  KEY `isfree` (`isfree`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}message_contact`;

CREATE TABLE `{dbpre}message_contact` (
  `contactid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bgsid` varchar(16) DEFAULT '',
  `userid` int(10) unsigned DEFAULT '0',
  `fuserid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `lastmsgid` int(10) unsigned DEFAULT '0',
  `sendnums` int(10) unsigned DEFAULT '0',
  `receivenums` int(10) unsigned DEFAULT '0',
  `lastsend` int(10) unsigned DEFAULT '0',
  `lastreceive` int(10) unsigned DEFAULT '0',
  `lastime` int(10) unsigned DEFAULT '0',
  `delflag` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`contactid`),
  KEY `bgsid` (`bgsid`),
  KEY `userid` (`userid`),
  KEY `fuserid` (`fuserid`),
  KEY `lastmsgid` (`lastmsgid`),
  KEY `lastime` (`lastime`),
  KEY `delflag` (`delflag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}message_daysend`;

CREATE TABLE `{dbpre}message_daysend` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `tyear` smallint(4) unsigned DEFAULT '0',
  `tmonth` tinyint(2) unsigned DEFAULT '0',
  `dateline` int(10) unsigned DEFAULT '0',
  `sendnums` int(10) unsigned DEFAULT '0',
  `lasttime` int(10) unsigned DEFAULT '0',
  `touid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `tyear` (`tyear`),
  KEY `tmonth` (`tmonth`),
  KEY `dateline` (`dateline`),
  KEY `touid` (`touid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}message_link`;

CREATE TABLE `{dbpre}message_link` (
  `bgsid` varchar(16) NOT NULL DEFAULT '',
  `uid1` int(10) unsigned DEFAULT '0',
  `uid2` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `freelock` tinyint(1) unsigned DEFAULT '0',
  `freetime` int(10) unsigned DEFAULT '0',
  `freeuid` int(10) unsigned DEFAULT '0',
  `freefee` varchar(10) DEFAULT '',
  `msgnums` int(10) unsigned DEFAULT '0',
  `msgchat` tinyint(1) unsigned DEFAULT '0',
  `chatendtime` int(10) unsigned DEFAULT '0',
  `lasttime` int(10) unsigned DEFAULT '0',
  `payid` int(10) unsigned DEFAULT '0',
  `paynum` varchar(30) DEFAULT '',
  `remark` varchar(255) DEFAULT '',
  PRIMARY KEY (`bgsid`),
  KEY `freelock` (`freelock`),
  KEY `uid1` (`uid1`),
  KEY `uid2` (`uid2`),
  KEY `addtime` (`addtime`),
  KEY `lasttime` (`lasttime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}mobile_checkcode`;

CREATE TABLE `{dbpre}mobile_checkcode` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `mobile` varchar(20) DEFAULT '',
  `checkcode` varchar(20) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `lasttime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mobile` (`mobile`),
  KEY `lasttime` (`lasttime`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}mobile_sendlog`;

CREATE TABLE `{dbpre}mobile_sendlog` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `mobile` varchar(20) DEFAULT '',
  `content` varchar(500) DEFAULT '',
  `sendtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `response` varchar(255) DEFAULT '',
  PRIMARY KEY (`logid`),
  KEY `mobile` (`mobile`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}mobile_tpl`;

CREATE TABLE `{dbpre}mobile_tpl` (
  `tplid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(20) DEFAULT NULL,
  `content` varchar(500) DEFAULT NULL,
  `issystem` tinyint(1) unsigned DEFAULT '0',
  `longurl` varchar(200) DEFAULT '',
  `shorturl` varchar(100) DEFAULT '',
  `idmark` varchar(16) DEFAULT '',
  PRIMARY KEY (`tplid`),
  KEY `type` (`type`),
  KEY `idmark` (`idmark`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `{dbpre}money_action`;

CREATE TABLE `{dbpre}money_action` (
  `actionid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `quantity` decimal(18,2) unsigned DEFAULT '0.00',
  `actiontype` tinyint(1) unsigned DEFAULT '0',
  `actiontime` int(10) unsigned DEFAULT '0',
  `tyear` smallint(2) unsigned DEFAULT '0',
  `tmonth` smallint(2) unsigned DEFAULT '0',
  `tday` smallint(2) unsigned DEFAULT '0',
  `logcontent` varchar(500) DEFAULT '',
  `remain` decimal(18,2) unsigned DEFAULT '0.00',
  `opuser` varchar(50) DEFAULT '',
  `creatid` int(10) unsigned DEFAULT '0',
  `moneytype` smallint(2) unsigned DEFAULT '0',
  `mdtype` varchar(30) DEFAULT '',
  PRIMARY KEY (`actionid`),
  KEY `userid` (`userid`),
  KEY `actiontype` (`actiontype`),
  KEY `moneytype` (`moneytype`),
  KEY `mdtype` (`mdtype`),
  KEY `actiontime` (`actiontime`),
  KEY `tyear` (`tyear`),
  KEY `tmonth` (`tmonth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `{dbpre}msg`;

CREATE TABLE `{dbpre}msg` (
  `msgid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contid` int(10) unsigned DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `agentid` int(10) unsigned DEFAULT '0',
  `sendtime` int(10) unsigned DEFAULT '0',
  `readflag` tinyint(1) unsigned DEFAULT '0',
  `readtime` int(10) unsigned DEFAULT '0',
  `msgtype` varchar(20) DEFAULT '',
  `relattr` varchar(50) DEFAULT '',
  PRIMARY KEY (`msgid`),
  KEY `contid` (`contid`),
  KEY `userid` (`userid`),
  KEY `readflag` (`readflag`),
  KEY `agentid` (`agentid`),
  KEY `msgtype` (`msgtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}msg_content`;

CREATE TABLE `{dbpre}msg_content` (
  `contid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT '',
  `content` text,
  `creattime` int(10) unsigned DEFAULT '0',
  `sendnums` int(10) unsigned DEFAULT '0',
  `url` varchar(255) DEFAULT '',
  PRIMARY KEY (`contid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}msgchat_times`;

CREATE TABLE `{dbpre}msgchat_times` (
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `times` smallint(6) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `lasttime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`userid`),
  KEY `times` (`times`),
  KEY `addtime` (`addtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}msgchat_timesaction`;

CREATE TABLE `{dbpre}msgchat_timesaction` (
  `actionid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `times` smallint(6) unsigned DEFAULT '0',
  `actiontype` tinyint(2) unsigned DEFAULT '0',
  `actiontime` int(10) unsigned DEFAULT '0',
  `tyear` smallint(4) unsigned DEFAULT '0',
  `tmonth` tinyint(2) unsigned DEFAULT '0',
  `tday` tinyint(2) unsigned DEFAULT '0',
  `logcont` varchar(500) DEFAULT '',
  `mdtype` varchar(50) DEFAULT '',
  `buid` int(10) unsigned DEFAULT '0',
  `remain` smallint(6) unsigned DEFAULT '0',
  `opuser` varchar(30) DEFAULT '',
  PRIMARY KEY (`actionid`),
  KEY `userid` (`userid`),
  KEY `actiontype` (`actiontype`),
  KEY `actiontime` (`actiontime`),
  KEY `tyear` (`tyear`),
  KEY `tmonth` (`tmonth`),
  KEY `tday` (`tday`),
  KEY `mdtype` (`mdtype`),
  KEY `buid` (`buid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}msgtip_log`;

CREATE TABLE `{dbpre}msgtip_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fromuid` int(10) unsigned DEFAULT '0',
  `touid` int(10) unsigned DEFAULT '0',
  `tipdate` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `times` smallint(4) unsigned DEFAULT '0',
  `tiptype` tinyint(1) unsigned DEFAULT '0',
  `fromtype` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fromuid` (`fromuid`),
  KEY `touid` (`touid`),
  KEY `tipdate` (`tipdate`),
  KEY `tiptype` (`tiptype`),
  KEY `fromtype` (`fromtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}myads`;

CREATE TABLE `{dbpre}myads` (
  `adid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `zoneid` int(10) unsigned DEFAULT '0',
  `cityid` int(10) unsigned DEFAULT '0',
  `admark` varchar(200) DEFAULT '',
  `adname` varchar(255) DEFAULT '',
  `drawimg` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `orders` smallint(2) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `templet` varchar(50) DEFAULT '',
  `channel` varchar(50) DEFAULT '',
  `remark` varchar(255) DEFAULT '',
  PRIMARY KEY (`adid`),
  KEY `zoneid` (`zoneid`),
  KEY `admark` (`admark`),
  KEY `cityid` (`cityid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}options`;

CREATE TABLE `{dbpre}options` (
  `optionname` varchar(50) NOT NULL DEFAULT '',
  `optionvalue` text,
  `desc` varchar(50) DEFAULT '',
  PRIMARY KEY (`optionname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}party`;

CREATE TABLE `{dbpre}party` (
  `partyid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` tinyint(2) unsigned DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `area1` smallint(6) unsigned DEFAULT '0',
  `area2` smallint(6) unsigned DEFAULT '0',
  `area3` smallint(6) unsigned DEFAULT '0',
  `area4` smallint(6) unsigned DEFAULT '0',
  `address` varchar(100) DEFAULT '',
  `traffic` varchar(200) DEFAULT '',
  `thumbimg` varchar(150) DEFAULT '',
  `drawimg` varchar(150) DEFAULT '',
  `starttime` int(10) unsigned DEFAULT '0',
  `endtime` int(10) unsigned DEFAULT '0',
  `endbmtime` int(10) unsigned DEFAULT '0',
  `explain` varchar(255) DEFAULT '',
  `limitlady` smallint(4) unsigned DEFAULT '0',
  `limitman` smallint(4) unsigned DEFAULT '0',
  `moneylady` decimal(18,2) unsigned DEFAULT '0.00',
  `moneyman` decimal(18,2) unsigned DEFAULT '0.00',
  `offlinepay` tinyint(1) unsigned DEFAULT '0',
  `contact` varchar(200) DEFAULT '',
  `content` text,
  `intro` varchar(500) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `hits` int(10) unsigned DEFAULT '0',
  `zans` int(10) unsigned DEFAULT '0',
  `comments` int(10) unsigned DEFAULT '0',
  `bmladys` smallint(6) unsigned DEFAULT '0',
  `bmmans` smallint(6) unsigned DEFAULT '0',
  `tyear` smallint(4) unsigned DEFAULT '0',
  `tmonth` smallint(2) unsigned DEFAULT '0',
  `maplng` varchar(30) DEFAULT '',
  `maplat` varchar(30) DEFAULT '',
  `otherbms` int(10) DEFAULT '0',
  `finishtime` int(10) unsigned DEFAULT '0',
  `finishop` varchar(30) DEFAULT '',
  `sharetitle` varchar(200) DEFAULT '',
  `shareintro` varchar(500) DEFAULT '',
  `review` text,
  PRIMARY KEY (`partyid`),
  KEY `catid` (`catid`),
  KEY `area1` (`area1`),
  KEY `area2` (`area2`),
  KEY `starttime` (`starttime`),
  KEY `endtime` (`endtime`),
  KEY `endbmtime` (`endbmtime`),
  KEY `flag` (`flag`),
  KEY `elite` (`elite`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}party_bm`;

CREATE TABLE `{dbpre}party_bm` (
  `bmid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `partyid` int(10) unsigned DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `bmno` varchar(20) DEFAULT '',
  `mobile` varchar(20) DEFAULT '',
  `loveid` smallint(6) unsigned DEFAULT '0',
  `amount` decimal(18,2) unsigned DEFAULT '0.00',
  `truename` varchar(20) DEFAULT '',
  `idnumber` varchar(20) DEFAULT '',
  `gender` tinyint(1) unsigned DEFAULT '0',
  `weixin` varchar(30) DEFAULT '',
  `dist1` smallint(4) unsigned DEFAULT '0',
  `dist2` smallint(4) unsigned DEFAULT '0',
  `dist3` smallint(4) unsigned DEFAULT '0',
  `dist4` smallint(4) unsigned DEFAULT '0',
  `marry` tinyint(1) unsigned DEFAULT '0',
  `education` tinyint(2) unsigned DEFAULT '0',
  `height` smallint(2) unsigned DEFAULT '0',
  `weight` smallint(2) unsigned DEFAULT '0',
  `job` tinyint(2) unsigned DEFAULT '0',
  `ageyear` smallint(4) unsigned DEFAULT '0',
  `agemonth` tinyint(2) unsigned DEFAULT '0',
  `ageday` tinyint(2) unsigned DEFAULT '0',
  `car` tinyint(2) unsigned DEFAULT '0',
  `house` tinyint(2) unsigned DEFAULT '0',
  `salary` tinyint(2) unsigned DEFAULT '0',
  `sort` tinyint(2) unsigned DEFAULT '0',
  `sources` varchar(255) DEFAULT '',
  `target` varchar(255) DEFAULT '',
  `payflag` tinyint(1) unsigned DEFAULT '0',
  `paytype` tinyint(1) unsigned DEFAULT '0',
  `paytime` int(10) unsigned DEFAULT '0',
  `paymoney` decimal(18,2) unsigned DEFAULT '0.00',
  `payid` int(10) unsigned DEFAULT '0',
  `paynum` varchar(30) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `status` tinyint(1) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '1',
  `issystem` tinyint(1) unsigned DEFAULT '0',
  `reason` varchar(300) DEFAULT '',
  `canceltime` int(10) unsigned DEFAULT '0',
  `apptime` int(10) unsigned DEFAULT '0',
  `refundflag` tinyint(1) unsigned DEFAULT '0',
  `refundmoney` decimal(18,2) unsigned DEFAULT '0.00',
  `refundtime` int(10) unsigned DEFAULT '0',
  `refundcert` varchar(100) DEFAULT '',
  `refunduser` varchar(20) DEFAULT '',
  `refremark` varchar(200) DEFAULT '',
  `remark` varchar(300) DEFAULT '',
  `signin` tinyint(1) unsigned DEFAULT '0',
  `signtime` int(10) unsigned DEFAULT '0',
  `signtype` tinyint(1) unsigned DEFAULT '0',
  `bankname` varchar(50) DEFAULT '',
  `banksub` varchar(100) DEFAULT '',
  `bankaccount` varchar(50) DEFAULT '',
  `bankcontact` varchar(50) DEFAULT '',
  PRIMARY KEY (`bmid`),
  KEY `partyid` (`partyid`),
  KEY `userid` (`userid`),
  KEY `payflag` (`payflag`),
  KEY `status` (`status`),
  KEY `refundflag` (`refundflag`),
  KEY `signin` (`signin`),
  KEY `gender` (`gender`),
  KEY `dist1` (`dist1`),
  KEY `dist2` (`dist2`),
  KEY `dist3` (`dist3`),
  KEY `dist4` (`dist4`),
  KEY `marry` (`marry`),
  KEY `education` (`education`),
  KEY `height` (`height`),
  KEY `weight` (`weight`),
  KEY `job` (`job`),
  KEY `ageyear` (`ageyear`),
  KEY `car` (`car`),
  KEY `house` (`house`),
  KEY `salary` (`salary`),
  KEY `sort` (`sort`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}payment_order`;

CREATE TABLE `{dbpre}payment_order` (
  `orderid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `paynum` varchar(30) DEFAULT '',
  `sdkid` smallint(2) unsigned DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `unionid` int(10) unsigned DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `paytype` varchar(20) DEFAULT '',
  `amount` decimal(18,2) unsigned DEFAULT '0.00',
  `quantity` int(10) unsigned DEFAULT '0',
  `currency` varchar(10) DEFAULT '',
  `relattr` varchar(500) DEFAULT '',
  `bankid` varchar(30) DEFAULT '',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `tyear` smallint(2) unsigned DEFAULT '0',
  `tmonth` tinyint(2) unsigned DEFAULT '0',
  `paystatus` tinyint(2) unsigned DEFAULT '0',
  `dealnum` varchar(50) DEFAULT '',
  `noticetime` int(10) unsigned DEFAULT '0',
  `from` varchar(10) DEFAULT '',
  `payrate` varchar(10) DEFAULT '',
  `truemoney` decimal(18,2) unsigned DEFAULT '0.00',
  `payfee` decimal(18,2) unsigned DEFAULT '0.00',
  `fromurl` varchar(200) DEFAULT '',
  `wxopenid` varchar(100) DEFAULT '',
  `isdown` tinyint(2) unsigned DEFAULT '0',
  `downtype` varchar(20) DEFAULT '',
  `paycode` varchar(20) DEFAULT '',
  `finishtime` int(10) unsigned DEFAULT '0',
  `finishop` varchar(30) DEFAULT '',
  `remark` varchar(300) DEFAULT '',
  PRIMARY KEY (`orderid`),
  KEY `paynum` (`paynum`),
  KEY `userid` (`userid`),
  KEY `flag` (`flag`),
  KEY `paystatus` (`paystatus`),
  KEY `addtime` (`addtime`),
  KEY `tyear` (`tyear`),
  KEY `tmonth` (`tmonth`),
  KEY `paytype` (`paytype`),
  KEY `unionid` (`unionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}payment_sdk`;

CREATE TABLE `{dbpre}payment_sdk` (
  `sdkid` smallint(2) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) DEFAULT '',
  `logo` varchar(255) DEFAULT '',
  `intro` varchar(500) DEFAULT '',
  `sdkname` varchar(100) DEFAULT '',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `type` varchar(10) DEFAULT '',
  `orders` smallint(2) unsigned DEFAULT '0',
  `sdkflag` tinyint(1) unsigned DEFAULT '0',
  `merchantpid` varchar(255) DEFAULT '',
  `privatekey` varchar(255) DEFAULT '',
  `merchantaccount` varchar(255) DEFAULT '',
  `yjpayprivatekey` varchar(2000) DEFAULT '',
  `yjpaypublickey` varchar(2000) DEFAULT '',
  `yeepaypublickey` varchar(2000) DEFAULT '',
  `payrate` varchar(10) DEFAULT '',
  PRIMARY KEY (`sdkid`),
  KEY `sdkname` (`sdkname`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}photo`;

CREATE TABLE `{dbpre}photo` (
  `photoid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `title` varchar(100) DEFAULT '',
  `thumbimg` varchar(200) DEFAULT '',
  `drawimg` varchar(200) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `private` tinyint(1) unsigned DEFAULT '0',
  `hits` int(10) unsigned DEFAULT '0',
  `zans` smallint(6) unsigned DEFAULT '0',
  `rewards` smallint(6) unsigned DEFAULT '0',
  `tyear` smallint(4) unsigned DEFAULT '0',
  `tmonth` tinyint(2) unsigned DEFAULT '0',
  `comefrom` varchar(20) DEFAULT '',
  PRIMARY KEY (`photoid`),
  KEY `userid` (`userid`),
  KEY `flag` (`flag`),
  KEY `private` (`private`),
  KEY `tyear` (`tyear`),
  KEY `tmonth` (`tmonth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}photo_zan`;

CREATE TABLE `{dbpre}photo_zan` (
  `zanid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `photoid` int(10) unsigned DEFAULT '0',
  `zanuid` int(10) unsigned DEFAULT '0',
  `zantime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`zanid`),
  KEY `photoid` (`photoid`),
  KEY `zanuid` (`zanuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}rank`;

CREATE TABLE `{dbpre}rank` (
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` int(10) unsigned DEFAULT '0',
  `endtime` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `remark` varchar(255) DEFAULT '',
  PRIMARY KEY (`userid`),
  KEY `starttime` (`starttime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}roles`;

CREATE TABLE `{dbpre}roles` (
  `roleid` smallint(2) unsigned NOT NULL AUTO_INCREMENT,
  `rolename` varchar(50) DEFAULT '',
  `parentid` smallint(2) unsigned DEFAULT '0',
  `depth` smallint(2) unsigned DEFAULT '0',
  `orders` smallint(2) unsigned DEFAULT '0',
  `creatid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `desc` varchar(255) DEFAULT '',
  `mods` varchar(2000) DEFAULT '',
  `profiles` text,
  PRIMARY KEY (`roleid`),
  KEY `rolename` (`rolename`),
  KEY `parentid` (`parentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}safety`;

CREATE TABLE `{dbpre}safety` (
  `infoid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT '',
  `intro` varchar(500) DEFAULT '',
  `author` varchar(50) DEFAULT '',
  `content` text,
  `thumbimg` varchar(200) DEFAULT '',
  `drawimg` varchar(200) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `hits` int(10) unsigned DEFAULT '0',
  `isimg` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`infoid`),
  KEY `title` (`title`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}school`;

CREATE TABLE `{dbpre}school` (
  `schid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  `area1` smallint(6) unsigned DEFAULT '0',
  `area2` smallint(6) unsigned DEFAULT '0',
  `firstchar` varchar(10) DEFAULT '',
  `type` varchar(30) DEFAULT '',
  `quality` varchar(30) DEFAULT '',
  `intro` varchar(50) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`schid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}seo`;

CREATE TABLE `{dbpre}seo` (
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  `idmark` varchar(50) DEFAULT '',
  `chname` varchar(100) DEFAULT '',
  `title` varchar(255) DEFAULT '',
  `description` varchar(500) DEFAULT '',
  `keyword` varchar(255) DEFAULT '',
  `orders` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}sms_log`;

CREATE TABLE `{dbpre}sms_log` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `agentid` int(10) unsigned DEFAULT '0',
  `mobile` varchar(30) DEFAULT '',
  `content` varchar(255) DEFAULT '',
  `sendtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `response` varchar(100) DEFAULT '',
  `clientport` varchar(20) DEFAULT '',
  `ipaddr` varchar(50) DEFAULT '',
  `refurl` varchar(255) DEFAULT '',
  PRIMARY KEY (`logid`),
  KEY `userid` (`userid`),
  KEY `agentid` (`agentid`),
  KEY `mobile` (`mobile`),
  KEY `ipaddr` (`ipaddr`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}story`;

CREATE TABLE `{dbpre}story` (
  `storyid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` tinyint(2) unsigned DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `lovetime` varchar(30) DEFAULT '',
  `booktime` varchar(30) DEFAULT '',
  `marrytime` varchar(30) DEFAULT '',
  `thumbimg` varchar(200) DEFAULT '',
  `drawimg` varchar(200) DEFAULT '',
  `content` text,
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `hits` int(10) unsigned DEFAULT '0',
  `comms` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`storyid`),
  KEY `catid` (`catid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}story_comment`;

CREATE TABLE `{dbpre}story_comment` (
  `commid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `storyid` int(10) unsigned DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `content` varchar(500) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`commid`),
  KEY `storyid` (`storyid`),
  KEY `userid` (`userid`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}taocan`;

CREATE TABLE `{dbpre}taocan` (
  `tcid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tcname` varchar(255) DEFAULT '',
  `level` smallint(4) unsigned DEFAULT '0',
  `days` int(10) unsigned DEFAULT '0',
  `intro` varchar(2000) DEFAULT '',
  `oldprice` decimal(18,2) unsigned DEFAULT '0.00',
  `price` decimal(18,2) unsigned DEFAULT '0.00',
  `average` decimal(18,2) unsigned DEFAULT '0.00',
  `price2` decimal(18,2) unsigned DEFAULT '0.00',
  `average2` decimal(18,2) unsigned DEFAULT '0.00',
  `orders` int(10) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `salenums` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`tcid`),
  KEY `tcname` (`tcname`),
  KEY `orders` (`orders`),
  KEY `flag` (`flag`),
  KEY `elite` (`elite`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}tipsinfo`;

CREATE TABLE `{dbpre}tipsinfo` (
  `tipsid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `senduid` int(10) unsigned DEFAULT '0',
  `homeuid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `tipstype` tinyint(1) unsigned DEFAULT '0',
  `feedback` tinyint(1) unsigned DEFAULT '0',
  `feedtime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`tipsid`),
  KEY `senduid` (`senduid`),
  KEY `homeuid` (`homeuid`),
  KEY `tipstype` (`tipstype`),
  KEY `feedback` (`feedback`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}user`;

CREATE TABLE `{dbpre}user` (
  `userid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(30) DEFAULT '',
  `password` varchar(32) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `mobile` varchar(15) DEFAULT '',
  `dist1` smallint(5) unsigned DEFAULT '0',
  `dist2` smallint(5) unsigned DEFAULT '0',
  `dist3` smallint(5) unsigned DEFAULT '0',
  `dist4` smallint(5) unsigned DEFAULT '0',
  `money` decimal(18,2) unsigned DEFAULT '0.00',
  `income` decimal(18,2) unsigned DEFAULT '0.00',
  `gender` tinyint(1) unsigned DEFAULT '0',
  `ageyear` smallint(4) unsigned DEFAULT '0',
  `agemonth` tinyint(2) unsigned DEFAULT '0',
  `ageday` tinyint(2) unsigned DEFAULT '0',
  `lunar` tinyint(2) unsigned DEFAULT '0',
  `astro` tinyint(2) unsigned DEFAULT '0',
  `height` tinyint(3) unsigned DEFAULT '0',
  `weight` tinyint(3) unsigned DEFAULT '0',
  `marry` tinyint(1) unsigned DEFAULT '0',
  `education` tinyint(2) unsigned DEFAULT '0',
  `spend` tinyint(2) unsigned DEFAULT '0',
  `salary` tinyint(2) unsigned DEFAULT '0',
  `job` tinyint(2) unsigned DEFAULT '0',
  `car` tinyint(2) unsigned DEFAULT '0',
  `house` tinyint(2) unsigned DEFAULT '0',
  `sort` tinyint(2) unsigned DEFAULT '0',
  `headimg` varchar(100) DEFAULT '',
  `headimg_0` varchar(100) DEFAULT '',
  `headimg_s` varchar(100) DEFAULT '',
  `headimg_m1` varchar(100) DEFAULT '',
  `headimg_m2` varchar(100) DEFAULT '',
  `headimg_m3` varchar(100) DEFAULT '',
  `headflag` tinyint(1) unsigned DEFAULT '0',
  `headtime` int(10) unsigned DEFAULT '0',
  `avatar` tinyint(1) unsigned DEFAULT '0',
  `groupid` smallint(4) unsigned DEFAULT '1',
  `vipstime` int(10) unsigned DEFAULT '0',
  `vipetime` int(10) unsigned DEFAULT '0',
  `tcid` int(10) unsigned DEFAULT '0',
  `qq` varchar(15) DEFAULT '',
  `weixin` varchar(30) DEFAULT '',
  `truename` varchar(20) DEFAULT '',
  `idnumber` varchar(20) DEFAULT '',
  `paper1` varchar(100) DEFAULT '',
  `paper2` varchar(100) DEFAULT '',
  `paper3` varchar(100) DEFAULT '',
  `idtime` int(10) unsigned DEFAULT '0',
  `idrz` tinyint(1) DEFAULT '0',
  `localrz` tinyint(1) unsigned DEFAULT '0',
  `localimg` varchar(100) DEFAULT '',
  `localtime` int(10) unsigned DEFAULT '0',
  `localmemo` varchar(100) DEFAULT '',
  `mobilerz` tinyint(1) unsigned DEFAULT '0',
  `emailrz` tinyint(1) unsigned DEFAULT '0',
  `qqrz` tinyint(1) unsigned DEFAULT '0',
  `weixinrz` tinyint(1) unsigned DEFAULT '0',
  `star` tinyint(2) unsigned DEFAULT '0',
  `mobiletime` int(10) unsigned DEFAULT '0',
  `emailtime` int(10) unsigned DEFAULT '0',
  `qqtime` int(10) unsigned DEFAULT '0',
  `yunrz` tinyint(1) unsigned DEFAULT '0',
  `yuntime` int(10) unsigned DEFAULT '0',
  `intro` varchar(400) DEFAULT '',
  `introflag` tinyint(1) unsigned DEFAULT '0',
  `introtime` int(10) unsigned DEFAULT '0',
  `home1` smallint(5) unsigned DEFAULT '0',
  `home2` smallint(5) unsigned DEFAULT '0',
  `home3` smallint(5) unsigned DEFAULT '0',
  `hup` tinyint(1) unsigned DEFAULT '0',
  `child` tinyint(2) unsigned DEFAULT '0',
  `interest` varchar(30) DEFAULT '',
  `blood` tinyint(1) unsigned DEFAULT '0',
  `personality` tinyint(2) unsigned DEFAULT '0',
  `looks` tinyint(2) unsigned DEFAULT '0',
  `parts` tinyint(2) unsigned DEFAULT '0',
  `hairstyle` tinyint(2) unsigned DEFAULT '0',
  `haircolor` tinyint(2) unsigned DEFAULT '0',
  `facestyle` tinyint(2) unsigned DEFAULT '0',
  `bodystyle` tinyint(2) unsigned DEFAULT '0',
  `national` tinyint(2) unsigned DEFAULT '0',
  `allopatry` tinyint(1) unsigned DEFAULT '0',
  `sin` tinyint(1) unsigned DEFAULT '0',
  `health` tinyint(1) unsigned DEFAULT '0',
  `debt` tinyint(1) unsigned DEFAULT '0',
  `companytype` tinyint(2) unsigned DEFAULT '0',
  `workstatus` tinyint(2) unsigned DEFAULT '0',
  `familyback` tinyint(2) unsigned DEFAULT '0',
  `smoking` tinyint(1) unsigned DEFAULT '0',
  `drinking` tinyint(1) unsigned DEFAULT '0',
  `faith` tinyint(2) unsigned DEFAULT '0',
  `workout` tinyint(2) unsigned DEFAULT '0',
  `wedtime` tinyint(1) unsigned DEFAULT '0',
  `wantchild` tinyint(1) unsigned DEFAULT '0',
  `parentstatus` tinyint(2) unsigned DEFAULT '0',
  `parenteconomic` tinyint(2) unsigned DEFAULT '0',
  `fatherwork` tinyint(2) unsigned DEFAULT '0',
  `motherwork` tinyint(2) unsigned DEFAULT '0',
  `parentshealthcare` tinyint(2) unsigned DEFAULT '0',
  `tophome` tinyint(2) unsigned DEFAULT '0',
  `elderbrother` tinyint(2) unsigned DEFAULT '0',
  `eldersister` tinyint(2) unsigned DEFAULT '0',
  `youngerbrother` tinyint(2) unsigned DEFAULT '0',
  `youngersister` tinyint(2) unsigned DEFAULT '0',
  `focus` tinyint(1) unsigned DEFAULT '0',
  `wedding` tinyint(1) unsigned DEFAULT '0',
  `cooking` tinyint(1) unsigned DEFAULT '0',
  `housework` tinyint(1) unsigned DEFAULT '0',
  `liveparent` tinyint(1) unsigned DEFAULT '0',
  `rest` tinyint(2) unsigned DEFAULT '0',
  `language` varchar(30) DEFAULT '',
  `scharea1` smallint(6) DEFAULT '0',
  `scharea2` smallint(6) DEFAULT '0',
  `schid` mediumint(8) DEFAULT '0',
  `loginstatus` tinyint(1) unsigned DEFAULT '0',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `elite` tinyint(1) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `blacktype` tinyint(2) unsigned DEFAULT '0',
  `blacktime` int(10) unsigned DEFAULT '0',
  `regip` varchar(20) DEFAULT '',
  `logintime` int(10) unsigned DEFAULT '0',
  `logintimes` smallint(5) unsigned DEFAULT '0',
  `loginip` varchar(20) DEFAULT '',
  `hits` smallint(6) unsigned DEFAULT '0',
  `regfrom` varchar(10) DEFAULT '',
  `remark` varchar(255) DEFAULT '',
  `tyear` smallint(4) unsigned DEFAULT '0',
  `tmonth` tinyint(2) unsigned DEFAULT '0',
  `isvest` tinyint(1) unsigned DEFAULT '0',
  `oeopenid` varchar(32) DEFAULT '',
  `ispay` tinyint(1) unsigned DEFAULT '0',
  `paytotal` decimal(18,2) unsigned DEFAULT '0.00',
  `weixinid` varchar(32) DEFAULT '',
  `wxopenid` varchar(32) DEFAULT '',
  `qqopenid` varchar(32) DEFAULT '',
  `sinaopenid` varchar(32) DEFAULT '',
  `wxunionid` varchar(50) DEFAULT '',
  `wxletopenid` varchar(50) DEFAULT '',
  `wxletsalt` varchar(10) DEFAULT '',
  `wxlettime` int(10) unsigned DEFAULT '0',
  `wxscribe` tinyint(1) DEFAULT '0',
  `bindwx` tinyint(1) unsigned DEFAULT '0',
  `friends` smallint(4) unsigned DEFAULT '0',
  `listens` smallint(6) unsigned DEFAULT '0',
  `fans` smallint(6) unsigned DEFAULT '0',
  `editname` tinyint(1) unsigned DEFAULT '0',
  `editgender` tinyint(1) unsigned DEFAULT '0',
  `editage` tinyint(1) unsigned DEFAULT '0',
  `totallike` smallint(6) unsigned DEFAULT '0',
  `likes` smallint(6) unsigned DEFAULT '0',
  `dislikes` smallint(6) unsigned DEFAULT '0',
  `likeratio` float unsigned DEFAULT '0',
  `photos` smallint(4) unsigned DEFAULT '0',
  `phototime` int(10) unsigned DEFAULT '0',
  `emailtip` tinyint(1) unsigned DEFAULT '1',
  `mobiletip` tinyint(1) unsigned DEFAULT '1',
  `weixintip` tinyint(1) unsigned DEFAULT '1',
  `freeviews` smallint(4) unsigned DEFAULT '0',
  `freegifts` smallint(4) unsigned DEFAULT '0',
  `maplng` varchar(30) DEFAULT '',
  `maplat` varchar(30) DEFAULT '',
  `ismap` tinyint(1) unsigned DEFAULT '0',
  `netstar` tinyint(1) unsigned DEFAULT '0',
  `sound` varchar(200) DEFAULT '',
  `sdflag` tinyint(1) unsigned DEFAULT '0',
  `sdtime` int(10) unsigned DEFAULT '0',
  `sdsize` tinyint(3) unsigned DEFAULT '0',
  `growth` tinyint(3) unsigned DEFAULT '0',
  `payword` varchar(32) DEFAULT '',
  `salt` varchar(8) DEFAULT '',
  `bankname` varchar(50) DEFAULT '',
  `banksub` varchar(100) DEFAULT '',
  `bankaccount` varchar(50) DEFAULT '',
  `bankcontact` varchar(50) DEFAULT '',
  `alipayaccount` varchar(100) DEFAULT '',
  `alipaycontact` varchar(50) DEFAULT '',
  `houserz` tinyint(1) unsigned DEFAULT '0',
  `houseimg` varchar(100) DEFAULT '',
  `housetime` int(10) unsigned DEFAULT '0',
  `carrz` tinyint(1) unsigned DEFAULT '0',
  `carimg` varchar(100) DEFAULT '',
  `cartime` int(10) unsigned DEFAULT '0',
  `edurz` tinyint(1) unsigned DEFAULT '0',
  `eduimg` varchar(100) DEFAULT '',
  `edutime` int(10) unsigned DEFAULT '0',
  `marryrz` tinyint(1) unsigned DEFAULT '0',
  `marryimg` varchar(100) DEFAULT '',
  `marryuptime` int(10) unsigned DEFAULT '0',
  `keepsecret` tinyint(1) unsigned DEFAULT '1',
  `hidemobile` tinyint(1) unsigned DEFAULT '0',
  `maytype` tinyint(2) unsigned DEFAULT '0',
  `keepmarry` tinyint(1) unsigned DEFAULT '1',
  `tguid` int(10) unsigned DEFAULT '0',
  `siteid` smallint(6) unsigned DEFAULT '0',
  `unionid` int(10) unsigned DEFAULT '0',
  `storeid` int(10) unsigned DEFAULT '0',
  `blindcard` tinyint(1) unsigned DEFAULT '0',
  `bindunid` int(10) unsigned DEFAULT '0',
  `mpelite` tinyint(1) unsigned DEFAULT '0',
  `sourcefrom` tinyint(2) unsigned DEFAULT '0',
  `ismpreg` tinyint(1) DEFAULT '1',
  `isrewreg` tinyint(1) DEFAULT '0',
  `rewtime` int(10) unsigned DEFAULT '0',
  `rewmoney1` decimal(18,2) unsigned DEFAULT '0.00',
  `rewmoney2` decimal(18,2) unsigned DEFAULT '0.00',
  `rewtype` tinyint(1) unsigned DEFAULT '0',
  `joinqz` tinyint(1) unsigned DEFAULT '0',
  `qznums` smallint(4) unsigned DEFAULT '0',
  PRIMARY KEY (`userid`),
  KEY `username` (`username`),
  KEY `dist1` (`dist1`),
  KEY `dist2` (`dist2`),
  KEY `dist3` (`dist3`),
  KEY `dist4` (`dist4`),
  KEY `gender` (`gender`),
  KEY `ageyear` (`ageyear`),
  KEY `lunar` (`lunar`),
  KEY `astro` (`astro`),
  KEY `height` (`height`),
  KEY `weight` (`weight`),
  KEY `marry` (`marry`),
  KEY `education` (`education`),
  KEY `salary` (`salary`),
  KEY `job` (`job`),
  KEY `car` (`car`),
  KEY `house` (`house`),
  KEY `sort` (`sort`),
  KEY `headflag` (`headflag`),
  KEY `avatar` (`avatar`),
  KEY `groupid` (`groupid`),
  KEY `vipetime` (`vipetime`),
  KEY `idrz` (`idrz`),
  KEY `mobilerz` (`mobilerz`),
  KEY `qqrz` (`qqrz`),
  KEY `star` (`star`),
  KEY `introflag` (`introflag`),
  KEY `home1` (`home1`),
  KEY `home2` (`home2`),
  KEY `child` (`child`),
  KEY `flag` (`flag`),
  KEY `elite` (`elite`),
  KEY `logintime` (`logintime`),
  KEY `tyear` (`tyear`),
  KEY `tmonth` (`tmonth`),
  KEY `isvest` (`isvest`),
  KEY `photos` (`photos`),
  KEY `phototime` (`phototime`),
  KEY `maplng` (`maplng`),
  KEY `maplat` (`maplat`),
  KEY `ismap` (`ismap`),
  KEY `houserz` (`houserz`),
  KEY `carrz` (`carrz`),
  KEY `edurz` (`edurz`),
  KEY `tguid` (`tguid`),
  KEY `unionid` (`unionid`),
  KEY `mobile` (`mobile`),
  KEY `email` (`email`),
  KEY `marryrz` (`marryrz`),
  KEY `localrz` (`localrz`),
  KEY `storeid` (`storeid`),
  KEY `joinqz` (`joinqz`),
  KEY `wxletopenid` (`wxletopenid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}user_cond`;

CREATE TABLE `{dbpre}user_cond` (
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `gender` tinyint(1) unsigned DEFAULT '0',
  `age1` tinyint(2) unsigned DEFAULT '0',
  `age2` tinyint(2) unsigned DEFAULT '0',
  `height1` smallint(4) unsigned DEFAULT '0',
  `height2` smallint(4) unsigned DEFAULT '0',
  `weight1` smallint(4) unsigned DEFAULT '0',
  `weight2` smallint(4) unsigned DEFAULT '0',
  `marry` varchar(20) DEFAULT '',
  `education` tinyint(2) unsigned DEFAULT '0',
  `eduup` tinyint(1) unsigned DEFAULT '0',
  `salary` tinyint(2) unsigned DEFAULT '0',
  `salaryup` tinyint(1) unsigned DEFAULT '0',
  `house` tinyint(2) unsigned DEFAULT '0',
  `car` tinyint(2) unsigned DEFAULT '0',
  `child` tinyint(2) unsigned DEFAULT '0',
  `avatar` tinyint(1) unsigned DEFAULT '0',
  `rz` tinyint(1) unsigned DEFAULT '0',
  `area1` smallint(5) unsigned DEFAULT '0',
  `area2` smallint(5) unsigned DEFAULT '0',
  `other` varchar(300) DEFAULT '',
  PRIMARY KEY (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}view`;

CREATE TABLE `{dbpre}view` (
  `viewid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `homeuid` int(10) unsigned DEFAULT '0',
  `viewuid` int(10) unsigned DEFAULT '0',
  `viewtime` int(10) unsigned DEFAULT '0',
  `pwstatus` tinyint(1) unsigned DEFAULT '0',
  `readflag` tinyint(1) unsigned DEFAULT '0',
  `readtime` int(10) unsigned DEFAULT '0',
  `viewtimes` int(10) unsigned DEFAULT '0',
  `fromtype` tinyint(2) unsigned DEFAULT '0',
  PRIMARY KEY (`viewid`),
  KEY `homeuid` (`homeuid`),
  KEY `viewuid` (`viewuid`),
  KEY `viewtime` (`viewtime`),
  KEY `readflag` (`readflag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}view_contact`;

CREATE TABLE `{dbpre}view_contact` (
  `viewid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `homeuid` int(10) unsigned DEFAULT '0',
  `viewuid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `lasttime` int(10) unsigned DEFAULT '0',
  `fee` decimal(18,2) unsigned DEFAULT '0.00',
  `income` decimal(18,2) unsigned DEFAULT '0.00',
  `payid` int(10) unsigned DEFAULT '0',
  `paynum` varchar(30) DEFAULT '',
  `remark` varchar(255) DEFAULT '',
  `viewtimes` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`viewid`),
  KEY `homeuid` (`homeuid`),
  KEY `viewuid` (`viewuid`),
  KEY `payid` (`payid`),
  KEY `lasttime` (`lasttime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}view_photo`;

CREATE TABLE `{dbpre}view_photo` (
  `viewid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `homeuid` int(10) unsigned DEFAULT '0',
  `viewuid` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `fee` decimal(18,2) unsigned DEFAULT '0.00',
  `income` decimal(18,2) unsigned DEFAULT '0.00',
  `payid` int(10) unsigned DEFAULT '0',
  `paynum` varchar(30) DEFAULT '',
  PRIMARY KEY (`viewid`),
  KEY `homeuid` (`homeuid`),
  KEY `viewuid` (`viewuid`),
  KEY `payid` (`payid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}weixin_menu`;

CREATE TABLE `{dbpre}weixin_menu` (
  `menuid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` int(10) unsigned DEFAULT '0',
  `name` varchar(50) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `orders` int(10) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `menuval` varchar(200) DEFAULT '',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `appid` varchar(100) DEFAULT '',
  `pagepath` varchar(100) DEFAULT '',
  PRIMARY KEY (`menuid`),
  KEY `parentid` (`parentid`),
  KEY `orders` (`orders`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}weixin_tpl`;

CREATE TABLE `{dbpre}weixin_tpl` (
  `tplid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT '',
  `title` varchar(255) DEFAULT '',
  `content` varchar(5000) DEFAULT '',
  `issystem` tinyint(2) unsigned DEFAULT '0',
  `longurl` varchar(255) DEFAULT '',
  `shorturl` varchar(200) DEFAULT '',
  `idmark` varchar(50) DEFAULT '',
  `label` varchar(255) DEFAULT '',
  PRIMARY KEY (`tplid`),
  KEY `type` (`type`),
  KEY `issystem` (`issystem`),
  KEY `idmark` (`idmark`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}wx_subscribe`;

CREATE TABLE `{dbpre}wx_subscribe` (
  `scid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `openid` varchar(50) DEFAULT '',
  `subscribe` tinyint(1) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `canceltime` int(10) unsigned DEFAULT '0',
  `fromunid` int(10) unsigned DEFAULT '0',
  `bindunid` int(10) unsigned DEFAULT '0',
  `binduid` int(10) unsigned DEFAULT '0',
  `nickname` varchar(50) DEFAULT '',
  `gender` varchar(10) DEFAULT '',
  `province` varchar(50) DEFAULT '',
  `city` varchar(50) DEFAULT '',
  `headimgurl` varchar(255) DEFAULT '',
  `isadm` tinyint(1) unsigned DEFAULT '0',
  `wxunionid` varchar(100) DEFAULT '',
  `tyear` smallint(4) unsigned DEFAULT '0',
  `tmonth` tinyint(2) unsigned DEFAULT '0',
  `signtime` int(10) unsigned DEFAULT '0',
  `tiptimes` smallint(4) unsigned DEFAULT '0',
  `lasttip` int(10) unsigned DEFAULT '0',
  `storeid` int(10) unsigned DEFAULT '0',
  `storetip` smallint(4) unsigned DEFAULT '0',
  `storelasttip` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`scid`),
  KEY `openid` (`openid`),
  KEY `subscribe` (`subscribe`),
  KEY `fromunid` (`fromunid`),
  KEY `isadm` (`isadm`),
  KEY `tyear` (`tyear`),
  KEY `tmonth` (`tmonth`),
  KEY `tiptimes` (`tiptimes`),
  KEY `storeid` (`storeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}wxmsg_tpl`;

CREATE TABLE `{dbpre}wxmsg_tpl` (
  `tplid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idtype` varchar(100) DEFAULT '',
  `title` varchar(255) DEFAULT '',
  `template_id` varchar(255) DEFAULT '',
  `flag` tinyint(1) unsigned DEFAULT '0',
  `proto_title` varchar(255) DEFAULT '',
  `proto_tempid` varchar(255) DEFAULT '',
  `proto_content` varchar(1000) DEFAULT '',
  `tpl_content` varchar(1000) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `uptime` int(10) unsigned DEFAULT '0',
  `remark` varchar(255) DEFAULT '',
  `tag_title` varchar(100) DEFAULT '',
  `tag_remark` varchar(255) DEFAULT '',
  `tag_key1` varchar(100) DEFAULT '',
  `tag_key2` varchar(100) DEFAULT '',
  `tag_key3` varchar(100) DEFAULT '',
  `tag_key4` varchar(100) DEFAULT '',
  `tag_key5` varchar(100) DEFAULT '',
  PRIMARY KEY (`tplid`),
  KEY `idtype` (`idtype`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}wxsalt`;

CREATE TABLE `{dbpre}wxsalt` (
  `saltid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wxsalt` varchar(16) DEFAULT '',
  `wxtime` int(10) unsigned DEFAULT '0',
  `openid` varchar(50) DEFAULT '',
  `wxunionid` varchar(50) DEFAULT '',
  `wxnickname` varchar(50) DEFAULT '',
  `wxgender` tinyint(2) unsigned DEFAULT '0',
  `wxheadimg` varchar(255) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `loginflag` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`saltid`),
  KEY `wxsalt` (`wxsalt`),
  KEY `wxtime` (`wxtime`),
  KEY `loginflag` (`loginflag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}yunrz`;

CREATE TABLE `{dbpre}yunrz` (
  `rzid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rzno` varchar(50) DEFAULT '',
  `userid` int(10) unsigned DEFAULT '0',
  `idnumber` varchar(30) DEFAULT '',
  `truename` varchar(40) DEFAULT '',
  `mobile` varchar(20) DEFAULT '',
  `mobiletype` varchar(20) DEFAULT '',
  `sex` tinyint(1) unsigned DEFAULT '0',
  `area` varchar(50) DEFAULT '',
  `birthday` varchar(20) DEFAULT '',
  `addtime` int(10) unsigned DEFAULT '0',
  `fee` decimal(18,2) unsigned DEFAULT '0.00',
  `payflag` tinyint(1) unsigned DEFAULT '0',
  `paytime` int(10) unsigned DEFAULT '0',
  `paynum` varchar(50) DEFAULT '',
  `flag` tinyint(2) unsigned DEFAULT '0',
  `rzflag` tinyint(2) unsigned DEFAULT '0',
  `rettime` int(10) unsigned DEFAULT '0',
  `retcode` varchar(30) DEFAULT '',
  `retmsg` varchar(100) DEFAULT '',
  `retid` varchar(100) DEFAULT '',
  `remark` varchar(255) DEFAULT '',
  `reqstimes` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`rzid`),
  KEY `rzno` (`rzno`),
  KEY `userid` (`userid`),
  KEY `idnumber` (`idnumber`),
  KEY `truename` (`truename`),
  KEY `mobile` (`mobile`),
  KEY `addtime` (`addtime`),
  KEY `payflag` (`payflag`),
  KEY `flag` (`flag`),
  KEY `rzflag` (`rzflag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbpre}zone`;

CREATE TABLE `{dbpre}zone` (
  `zoneid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cityid` int(10) unsigned DEFAULT '0',
  `zonemark` varchar(200) DEFAULT '',
  `zonename` varchar(255) DEFAULT '',
  `zonewidth` smallint(2) unsigned DEFAULT '0',
  `zoneheight` smallint(2) unsigned DEFAULT '0',
  `addtime` int(10) unsigned DEFAULT '0',
  `templet` varchar(50) DEFAULT '',
  `channel` varchar(50) DEFAULT '',
  `remark` varchar(255) DEFAULT '',
  PRIMARY KEY (`zoneid`),
  KEY `zonemark` (`zonemark`),
  KEY `cityid` (`cityid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

