<?php
/**
 * Copyright (C) OElove Webapp All rights reserved.
 * <E-Mail：service@phpcoo.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 *     http://www.oelove.com
 * Update 2017.09.01
 */
if (!defined('IN_OELOVE')) {
    exit('OElove[OEPHP] Access Denied');
}
require_once(BASE_ROOT."api/netpay/weixinpay/lib/WxPay.Api.php");
/**
 * 
 * 刷卡支付实现类
 * @author widyhu
 *
 */
class NativePay {
	/**
	 * 
	 * 生成扫描支付URL,模式一
	 * @param BizPayUrlInput $bizUrlInfo
	 */
	public function GetPrePayUrl($productId)
	{
		$biz = new WxPayBizPayUrl();
		$biz->SetProduct_id($productId);
		$values = WxpayApi::bizpayurl($biz);
		$url = "weixin://wxpay/bizpayurl?" . $this->ToUrlParams($values);
		return $url;
	}
	
	/**
	 * 
	 * 参数数组转换为url参数
	 * @param array $urlObj
	 */
	private function ToUrlParams($urlObj)
	{
		$buff = "";
		foreach ($urlObj as $k => $v)
		{
			$buff .= $k . "=" . $v . "&";
		}
		
		$buff = trim($buff, "&");
		return $buff;
	}
	
	/**
	 * 
	 * 生成直接支付url，支付url有效期为2小时,模式二
	 * @param UnifiedOrderInput $input
	 */
	public function GetPayUrl($input)
	{
		if ($input->GetTrade_type() == "NATIVE" || $input->GetTrade_type() == "MWEB")
		{
			$result = WxPayApi::unifiedOrder($input);
			return $result;
		}
	}
}