﻿Option Strict On

Imports System.IO
Imports System.Text
Imports System.Text.RegularExpressions

Public Class GenerateForXamlCodeEdit
    Sub Run(projDir$)
        Const X2009Uri = "http://schemas.microsoft.com/winfx/2009/xaml",
              XFUri = "http://xamarin.com/schemas/2014/forms"
        Dim rootNamespace = projDir.Split({Path.DirectorySeparatorChar}, StringSplitOptions.RemoveEmptyEntries).Last
        Dim vbproj = Directory.GetFiles(projDir, "*.vbproj").FirstOrDefault
        If vbproj IsNot Nothing Then
            Dim vbprojDoc = XElement.Load(vbproj)
            Dim rnOverride = Aggregate pg In vbprojDoc...<PropertyGroup> Let rn = pg.<RootNamespace> Where rn IsNot Nothing
                          Select rn.Value Into FirstOrDefault
            If rnOverride <> Nothing Then
                rootNamespace = rnOverride
            End If
        End If
        Dim tryGetClrNamespace =
            Function(xmlns As String) As String
                If xmlns.StartsWith("using") OrElse xmlns.StartsWith("clr-namespace") Then
                    Dim endPos = xmlns.LastIndexOf(";"c)
                    Dim start = xmlns.IndexOf(":"c) + 1
                    If endPos <= 0 Then
                        Return xmlns.Substring(start)
                    Else
                        Return xmlns.Substring(start, endPos - start)
                    End If
                ElseIf xmlns = XFUri Then
                    Return "Xamarin.Forms"
                Else
                    Return String.Empty
                End If
            End Function
        Dim common = "Option Strict On
"
        Dim appXaml = ""
        Dim pageXaml = ""
        Dim noWithEventsElements = {"ControlTemplate", "DataTemplate", "Style"}
        Dim getXamlXClass As New Regex("(?<=x:Class\="").+?(?="")")
        Dim pageXamlBuilder As New StringBuilder
        Dim appXamlBuilder As New StringBuilder
        Dim commonBuilder As New StringBuilder(common)
        Dim getFiles As Func(Of String, Integer, IEnumerable(Of String)) =
            Iterator Function(dir, iterCount)
                Directory.SetCurrentDirectory(dir)
                If iterCount > 3 Then Return ' Special handling for recursive directory junction, to avoid infinite loop.
                Dim innerDirs = Directory.GetDirectories(dir)
                For Each f In Directory.GetFiles(dir)
                    Yield f
                Next
                For Each innerDir In innerDirs
                    For Each f In getFiles(innerDir, iterCount + 1)
                        Yield f
                    Next
                Next
            End Function
        For Each fp In From f In getFiles(projDir, 0)
                       Where f.EndsWith(".xaml", StringComparison.OrdinalIgnoreCase)
            Dim fn = Path.GetFileName(fp)
            Dim shortFp = fp.Substring(projDir.Length)
            Dim isAppXaml As Boolean = fn.Equals("App.xaml", StringComparison.OrdinalIgnoreCase)
            Dim curBuilder = If(isAppXaml, appXamlBuilder, pageXamlBuilder)
            Dim className = Path.GetFileNameWithoutExtension(fn)
            Dim xamlText As String = File.ReadAllText(fn)
            Dim definedXClass As Boolean = getXamlXClass.IsMatch(xamlText)
            If definedXClass Then
                Dim fullName = getXamlXClass.Match(xamlText).Value
                Dim dotIndex = fullName.LastIndexOf("."c)
                className = fullName.Substring(dotIndex + 1)
                If dotIndex > 0 Then
                    commonBuilder.AppendLine($"<Assembly: Global.Xamarin.Forms.Xaml.XamlResourceId(""{rootNamespace}.{fn}"", ""{shortFp}"", GetType(Global.{fullName}))>")
                    curBuilder.
                        Append("Namespace Global.").
                        Append(fullName, 0, dotIndex).AppendLine()
                Else
                    Throw New InvalidOperationException("Invalid x:Class value in App.xaml.")
                End If
            End If
            curBuilder.AppendLine($"<Global.Xamarin.Forms.Xaml.XamlFilePath(""{shortFp}"")>")
            If isAppXaml Then
                curBuilder.AppendLine($"Partial Public Class {className}
    Inherits Global.Xamarin.Forms.Application
	<Global.System.CodeDom.Compiler.GeneratedCodeAttribute(""Xamarin.Forms.Build.Tasks.XamlG"", ""2.0.0.0"")>
    Private Sub InitializeComponent()
        Global.Xamarin.Forms.Xaml.Extensions.LoadFromXaml(Me, GetType({className}))
    End Sub
End Class
")
            Else
                ' WithEvents code generation.
                Dim parsedXaml = XElement.Parse(xamlText)
                Dim xmlXName As XName = XName.Get("Name", X2009Uri)
                Dim xmlXKey As XName = XName.Get("Key", X2009Uri)
                Dim xmlXFieldModifier As XName = XName.Get("FieldModifier", X2009Uri)
                Dim baseClassNs = tryGetClrNamespace(parsedXaml.Name.Namespace.NamespaceName)
                Dim baseClass = parsedXaml.Name.LocalName
                If Not String.IsNullOrEmpty(baseClassNs) Then
                    baseClass = "Global." + baseClassNs + "." + baseClass
                End If
                Dim isResourceDictionary = baseClass = "Global.Xamarin.Forms.ResourceDictionary"
                Dim getNonTemplatedNodes As Func(Of XElement, IEnumerable(Of XElement)) =
                    Iterator Function(element)
                        Dim elementName As XName = element.Name
                        If noWithEventsElements.Contains(elementName.LocalName) AndAlso elementName.NamespaceName = XFUri Then
                            Return
                        End If
                        Yield element
                        For Each child In element.Elements
                            For Each innerChild In getNonTemplatedNodes(child)
                                Yield innerChild
                            Next
                        Next
                    End Function
                Dim tryGetAccessModifier =
                    Function(node As XElement) As String
                        Dim attr = node.Attribute(xmlXFieldModifier)
                        If attr Is Nothing Then
                            Return "Private "
                        Else
                            Dim value = attr.Value
                            ' TODO: Rewrite with Select Case when Option Compare OrdinalIgnoreCase is implemented.
                            If value.Equals("public", StringComparison.OrdinalIgnoreCase) Then
                                Return "Public "
                            ElseIf value.Equals("protected", StringComparison.OrdinalIgnoreCase) Then
                                Return "Protected "
                            ElseIf value.Equals("nonpublic", StringComparison.OrdinalIgnoreCase) OrElse
                                                       value.Equals("internal", StringComparison.OrdinalIgnoreCase) Then
                                Return "Friend "
                            ElseIf value.Equals("private", StringComparison.OrdinalIgnoreCase) Then
                                Return "Private "
                            Else
                                Return "Private "
                            End If
                        End If
                    End Function
                Dim namedElements = From node In getNonTemplatedNodes(parsedXaml)
                                    Let nameAttr = node.Attribute(xmlXName)
                                    Where nameAttr IsNot Nothing
                                    Let ctlName = nameAttr.Value ' We can't use node.@Value until VB has method scope Imports directive.
                                    Let ctlNamespace = tryGetClrNamespace(node.Name.Namespace.NamespaceName)
                                    Where Not (String.IsNullOrEmpty(ctlNamespace) OrElse String.IsNullOrEmpty(ctlName))
                                    Select ControlName = ctlName,
                                           TypeName = "Global." + ctlNamespace + "." + node.Name.LocalName,
                                           AccessModifier = tryGetAccessModifier(node)
                Dim backingFieldsBlock = String.Join(vbCrLf, From e In namedElements
                                                             Select $"{e.AccessModifier} {e.ControlName} As {e.TypeName}")
                Dim withEventsBlock = String.Join(vbCrLf, From e In namedElements
                                                          Select $"{e.AccessModifier}WithEvents {e.ControlName}WithEvents As {e.TypeName}")
                Dim backingFieldsInitBlock = String.Join(vbCrLf, From e In namedElements
                                                                 Select $"{e.ControlName} = Global.Xamarin.Forms.NameScopeExtensions.FindByName(Of {e.TypeName})(Me, NameOf({e.ControlName}))")
                Dim withEventsInitBlock = String.Join(vbCrLf, From e In namedElements
                                                              Select $"{e.ControlName}WithEvents = {e.ControlName}")
                Dim resourceDictionaryAccessProperties = String.Empty
                If isResourceDictionary Then
                    Dim keys = From node In parsedXaml.Elements
                               Let keyAttr = node.Attribute(xmlXKey)
                               Where keyAttr IsNot Nothing
                               Let propName = keyAttr.Value
                               Let ctlNamespace = tryGetClrNamespace(node.Name.Namespace.NamespaceName)
                               Let typeName = "Global." + ctlNamespace + "." + node.Name.LocalName
                               Select $"
    Private _{propName} As {typeName}
    Public ReadOnly Property {propName} As {typeName}
        Get
            If _{propName} Is Nothing Then
                _{propName} = DirectCast(Me!{propName}, {typeName})
            End If
            Return _{propName}
        End Get
    End Property"
                    resourceDictionaryAccessProperties = String.Join(vbCrLf, keys)
                End If
                curBuilder.AppendLine($"Partial Public Class {className}
    Inherits {baseClass}
{backingFieldsBlock}
{withEventsBlock}{resourceDictionaryAccessProperties}
    Sub New()
        InitializeComponent()
        InitializeWithEvents()
        OnComponentInitialized()
    End Sub

    Private Sub InitializeWithEvents()
{withEventsInitBlock}
    End Sub

    Partial Private Sub OnComponentInitialized()

    End Sub

    <Global.System.CodeDom.Compiler.GeneratedCodeAttribute(""Xamarin.Forms.Build.Tasks.XamlG"", ""2.0.0.0"")>
    Private Sub InitializeComponent()
        Global.Xamarin.Forms.Xaml.Extensions.LoadFromXaml(Me, GetType({className}))
{backingFieldsInitBlock}
    End Sub
End Class")
            End If
            If definedXClass Then
                curBuilder.AppendLine("End Namespace")
            End If
        Next
        common = commonBuilder.ToString
        appXaml = appXamlBuilder.ToString
        pageXaml = pageXamlBuilder.ToString
    End Sub
End Class