package com.novel.system.domain;

import com.novel.framework.enums.OnlineStatus;
import lombok.Data;
import lombok.ToString;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * 当前在线会话 sys_user_online
 *
 * @author novel
 * @since 2019/12/10
 */
@Data
@ToString
public class SysUserOnline implements Serializable {
    @Serial
    private static final long serialVersionUID = 1L;
    /**
     * 用户会话id
     */
    private String tokenId;

    /**
     * 部门名称
     */
    private String deptName;

    /**
     * 登录名称
     */
    private String loginName;

    /**
     * 登录IP地址
     */
    private String ipaddr;

    /**
     * 登录地址
     */
    private String loginLocation;

    /**
     * 浏览器类型
     */
    private String browser;

    /**
     * 操作系统
     */
    private String os;

    /**
     * session创建时间
     */
    private Date startTimestamp;

    /**
     * 在线状态
     */
    private OnlineStatus status = OnlineStatus.ON_LINE;
}
