package com.novel.system.domain;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * 登录用户身份权限
 *
 * @author novel
 * @since 2019/12/12
 */
@Data
public class LoginUser implements Serializable {
    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 用户唯一标识
     */
    private String sessionId;

    /**
     * 登录IP地址
     */
    private String ipaddr;

    /**
     * 登录地点
     */
    private String loginLocation;

    /**
     * 浏览器类型
     */
    private String browser;

    /**
     * 操作系统
     */
    private String os;

    /**
     * 用户信息
     */
    private SysUser user;
}
