// NodeDictionary.ts (barrel file) is generated by @/preprocess/barrel.mjs
// execute "yarn barrel" to update NodeDictionary.ts
import { NodeConstructorType } from '../NodeConstructorType';
import { ControlPoints } from './curve/analysis/ControlPoints';
import { CurveClosestPoint } from './curve/analysis/CurveClosestPoint';
import { CurveLength } from './curve/analysis/CurveLength';
import { Discontinuity } from './curve/analysis/Discontinuity';
import { EndPoints } from './curve/analysis/EndPoints';
import { EstimatePlane } from './curve/analysis/EstimatePlane';
import { EvaluateCurve } from './curve/analysis/EvaluateCurve';
import { PerpFrame } from './curve/analysis/PerpFrame';
import { PerpFrames } from './curve/analysis/PerpFrames';
import { PointInCurve } from './curve/analysis/PointInCurve';
import { PolygonCenter } from './curve/analysis/PolygonCenter';
import { DivideCurve } from './curve/division/DivideCurve';
import { DivideLength } from './curve/division/DivideLength';
import { Shatter } from './curve/division/Shatter';
import { Arc } from './curve/primitive/Arc';
import { ArcSED } from './curve/primitive/ArcSED';
import { Circle } from './curve/primitive/Circle';
import { Circle3Pt } from './curve/primitive/Circle3Pt';
import { Ellipse } from './curve/primitive/Ellipse';
import { Line } from './curve/primitive/Line';
import { LineSDL } from './curve/primitive/LineSDL';
import { PolyCircle } from './curve/primitive/PolyCircle';
import { Polygon } from './curve/primitive/Polygon';
import { Rectangle } from './curve/primitive/Rectangle';
import { Interpolate } from './curve/spline/Interpolate';
import { NurbsCurve } from './curve/spline/NurbsCurve';
import { Polyline } from './curve/spline/Polyline';
import { Explode } from './curve/utils/Explode';
import { Fillet } from './curve/utils/Fillet';
import { FilletAtParameter } from './curve/utils/FilletAtParameter';
import { FlipCurve } from './curve/utils/FlipCurve';
import { JoinCurves } from './curve/utils/JoinCurves';
import { OffsetCurve } from './curve/utils/OffsetCurve';
import { OffsetParallelCurve } from './curve/utils/OffsetParallelCurve';
import { LineDisplay } from './display/curve/LineDisplay';
import { ClipDisplay } from './display/mesh/ClipDisplay';
import { CustomPreview } from './display/mesh/CustomPreview';
import { TexcoordDisplay } from './display/mesh/TexcoordDisplay';
import { PointDisplay } from './display/vector/PointDisplay';
import { VectorDisplay } from './display/vector/VectorDisplay';
import { DxfExporter } from './exporter/DxfExporter';
import { FrepMCExporter } from './exporter/FrepMCExporter';
import { GltfExporter } from './exporter/GltfExporter';
import { ObjExporter } from './exporter/ObjExporter';
import { PlyExporter } from './exporter/PlyExporter';
import { StlExporter } from './exporter/StlExporter';
import { FrepDifference } from './frep/blend/FrepDifference';
import { FrepIntersection } from './frep/blend/FrepIntersection';
import { FrepSmoothDifference } from './frep/blend/FrepSmoothDifference';
import { FrepSmoothIntersection } from './frep/blend/FrepSmoothIntersection';
import { FrepSmoothUnion } from './frep/blend/FrepSmoothUnion';
import { FrepUnion } from './frep/blend/FrepUnion';
import { FrepCustomDistanceFunction } from './frep/plugins/FrepCustomDistanceFunction';
import { FrepCustomFilter } from './frep/plugins/FrepCustomFilter';
import { FBox } from './frep/primitives/FBox';
import { FCapsule } from './frep/primitives/FCapsule';
import { FCone } from './frep/primitives/FCone';
import { FCylinder } from './frep/primitives/FCylinder';
import { FSphere } from './frep/primitives/FSphere';
import { TPMSDiamond } from './frep/tpms/TPMSDiamond';
import { TPMSFischerKochS } from './frep/tpms/TPMSFischerKochS';
import { TPMSGyroid } from './frep/tpms/TPMSGyroid';
import { TPMSLidinoid } from './frep/tpms/TPMSLidinoid';
import { TPMSSchwarzP } from './frep/tpms/TPMSSchwarzP';
import { FrepBoundingBox } from './frep/utils/FrepBoundingBox';
import { FrepRound } from './frep/utils/FrepRound';
import { MarchingCubes } from './frep/utils/MarchingCubes';
import { CurveImporter } from './importer/CurveImporter';
import { MeshImporter } from './importer/MeshImporter';
import { Contour } from './intersects/math/Contour';
import { LineIntersection } from './intersects/math/LineIntersection';
import { LineMeshIntersection } from './intersects/math/LineMeshIntersection';
import { LinePlaneIntersection } from './intersects/math/LinePlaneIntersection';
import { LineTriangleIntersection } from './intersects/math/LineTriangleIntersection';
import { CurveIntersection } from './intersects/physical/CurveIntersection';
import { MeshDifference } from './intersects/shape/MeshDifference';
import { MeshIntersection } from './intersects/shape/MeshIntersection';
import { MeshUnion } from './intersects/shape/MeshUnion';
import { RegionDifference } from './intersects/shape/RegionDifference';
import { RegionIntersection } from './intersects/shape/RegionIntersection';
import { RegionUnion } from './intersects/shape/RegionUnion';
import { Complex } from './math/complex/Complex';
import { ComplexConjugate } from './math/complex/ComplexConjugate';
import { ComplexModulus } from './math/complex/ComplexModulus';
import { DeconstructComplex } from './math/complex/DeconstructComplex';
import { Bounds } from './math/domain/Bounds';
import { ConsecutiveDomains } from './math/domain/ConsecutiveDomains';
import { DeconstructDomain } from './math/domain/DeconstructDomain';
import { Domain } from './math/domain/Domain';
import { Includes } from './math/domain/Includes';
import { RemapNumbers } from './math/domain/RemapNumbers';
import { Expression } from './math/Expression';
import { PerlinNoise } from './math/noise/PerlinNoise';
import { SimplexNoise } from './math/noise/SimplexNoise';
import { Absolute } from './math/operator/Absolute';
import { Addition } from './math/operator/Addition';
import { Ceil } from './math/operator/Ceil';
import { Division } from './math/operator/Division';
import { Equality } from './math/operator/Equality';
import { Floor } from './math/operator/Floor';
import { GateAnd } from './math/operator/GateAnd';
import { GateNot } from './math/operator/GateNot';
import { GateOr } from './math/operator/GateOr';
import { LargerThan } from './math/operator/LargerThan';
import { MassAddition } from './math/operator/MassAddition';
import { MassMultiplication } from './math/operator/MassMultiplication';
import { Modulus } from './math/operator/Modulus';
import { Multiplication } from './math/operator/Multiplication';
import { Negative } from './math/operator/Negative';
import { Power } from './math/operator/Power';
import { Round } from './math/operator/Round';
import { SmallerThan } from './math/operator/SmallerThan';
import { Subtraction } from './math/operator/Subtraction';
import { Square } from './math/polynomials/Square';
import { SquareRoot } from './math/polynomials/SquareRoot';
import { ArcCosine } from './math/trigonometry/ArcCosine';
import { ArcSine } from './math/trigonometry/ArcSine';
import { ArcTangent } from './math/trigonometry/ArcTangent';
import { Cosine } from './math/trigonometry/Cosine';
import { Degrees } from './math/trigonometry/Degrees';
import { Radians } from './math/trigonometry/Radians';
import { Sine } from './math/trigonometry/Sine';
import { Tangent } from './math/trigonometry/Tangent';
import { Average } from './math/utils/Average';
import { Maximum } from './math/utils/Maximum';
import { Minimum } from './math/utils/Minimum';
import { PI } from './math/utils/PI';
import { DeconstructFace } from './mesh/analysis/DeconstructFace';
import { DeconstructMesh } from './mesh/analysis/DeconstructMesh';
import { Box } from './mesh/primitive/Box';
import { Cylinder } from './mesh/primitive/Cylinder';
import { Icosahedron } from './mesh/primitive/Icosahedron';
import { Mesh } from './mesh/primitive/Mesh';
import { Sphere } from './mesh/primitive/Sphere';
import { Triangle } from './mesh/primitive/Triangle';
import { TriangleLine } from './mesh/primitive/TriangleLine';
import { TrianglePoint } from './mesh/primitive/TrianglePoint';
import { FaceTexcoord } from './mesh/texcoord/FaceTexcoord';
import { ProjectTexcoord } from './mesh/texcoord/ProjectTexcoord';
import { TriplanarTexcoord } from './mesh/texcoord/TriplanarTexcoord';
import { DelaunayEdges } from './mesh/triangulation/DelaunayEdges';
import { Voronoi } from './mesh/triangulation/Voronoi';
import { FlipMesh } from './mesh/utils/FlipMesh';
import { JoinMeshes } from './mesh/utils/JoinMeshes';
import { WeldVertices } from './mesh/utils/WeldVertices';
import { Boolean } from './params/primitives/Boolean';
import { UIGraphMapper } from './params/ui/UIGraphMapper';
import { UIMDSlider } from './params/ui/UIMDSlider';
import { UINumber } from './params/ui/UINumber';
import { UINumberSlider } from './params/ui/UINumberSlider';
import { UIToggle } from './params/ui/UIToggle';
import { UIValueList } from './params/ui/UIValueList';
import { Comment } from './params/utils/Comment';
import { Panel } from './params/utils/Panel';
import { ParamViewer } from './params/utils/ParamViewer';
import { Relay } from './params/utils/Relay';
import { Custom } from './plugins/Custom';
import { Dispatch } from './sets/list/Dispatch';
import { Indices } from './sets/list/Indices';
import { InsertItems } from './sets/list/InsertItems';
import { ItemIndex } from './sets/list/ItemIndex';
import { ListItem } from './sets/list/ListItem';
import { ListLength } from './sets/list/ListLength';
import { PartitionList } from './sets/list/PartitionList';
import { ReverseList } from './sets/list/ReverseList';
import { ShiftList } from './sets/list/ShiftList';
import { SortList } from './sets/list/SortList';
import { Weave } from './sets/list/Weave';
import { CullIndex } from './sets/sequence/CullIndex';
import { CullPattern } from './sets/sequence/CullPattern';
import { Duplicate } from './sets/sequence/Duplicate';
import { Random } from './sets/sequence/Random';
import { Range } from './sets/sequence/Range';
import { Series } from './sets/sequence/Series';
import { FlattenTree } from './sets/tree/FlattenTree';
import { FlipMatrix } from './sets/tree/FlipMatrix';
import { GraftTree } from './sets/tree/GraftTree';
import { Merge } from './sets/tree/Merge';
import { ShiftPaths } from './sets/tree/ShiftPaths';
import { SimplifyTree } from './sets/tree/SimplifyTree';
import { SplitTree } from './sets/tree/SplitTree';
import { StreamFilter } from './sets/tree/StreamFilter';
import { StreamGate } from './sets/tree/StreamGate';
import { UnflattenTree } from './sets/tree/UnflattenTree';
import { Area } from './surface/analysis/Area';
import { EvaluateSurface } from './surface/analysis/EvaluateSurface';
import { SurfaceClosestPoint } from './surface/analysis/SurfaceClosestPoint';
import { BoundarySurfaces } from './surface/freeform/BoundarySurfaces';
import { Extrude } from './surface/freeform/Extrude';
import { ExtrudePoint } from './surface/freeform/ExtrudePoint';
import { Loft } from './surface/freeform/Loft';
import { Pipe } from './surface/freeform/Pipe';
import { Revolution } from './surface/freeform/Revolution';
import { SurfaceFromPoints } from './surface/freeform/SurfaceFromPoints';
import { Sweep } from './surface/freeform/Sweep';
import { BoundingBox } from './surface/primitive/BoundingBox';
import { ConstructBoundingBox } from './surface/primitive/ConstructBoundingBox';
import { DeconstructBoundingBox } from './surface/primitive/DeconstructBoundingBox';
import { OrientedBoundingBox } from './surface/primitive/OrientedBoundingBox';
import { PlaneSurface } from './surface/primitive/PlaneSurface';
import { DivideSurface } from './surface/utils/DivideSurface';
import { IsoTrim } from './surface/utils/IsoTrim';
import { TessellateSurface } from './surface/utils/TessellateSurface';
import { Format } from './text/Format';
import { Text } from './text/Text';
import { NUScale } from './transform/affine/NUScale';
import { UScale } from './transform/affine/UScale';
import { LinearArray } from './transform/array/LinearArray';
import { Mirror } from './transform/euclidean/Mirror';
import { Move } from './transform/euclidean/Move';
import { Orient } from './transform/euclidean/Orient';
import { Rotate } from './transform/euclidean/Rotate';
import { RotateAround } from './transform/euclidean/RotateAround';
import { RotateOnPlane } from './transform/euclidean/RotateOnPlane';
import { Scale } from './transform/euclidean/Scale';
import { MapToSurface } from './transform/morph/MapToSurface';
import { Group } from './utils/Group';
import { UnGroup } from './utils/UnGroup';
import { HexagonalGrid } from './vector/grid/HexagonalGrid';
import { HexagonalSpiral } from './vector/grid/HexagonalSpiral';
import { Populate2D } from './vector/grid/Populate2D';
import { PopulateGeometry } from './vector/grid/PopulateGeometry';
import { RectangularGrid } from './vector/grid/RectangularGrid';
import { RectangularSpiral } from './vector/grid/RectangularSpiral';
import { SquareGrid } from './vector/grid/SquareGrid';
import { TriangularGrid } from './vector/grid/TriangularGrid';
import { DeconstructPlane } from './vector/plane/DeconstructPlane';
import { FlipPlane } from './vector/plane/FlipPlane';
import { Plane } from './vector/plane/Plane';
import { XYPlane } from './vector/plane/XYPlane';
import { XZPlane } from './vector/plane/XZPlane';
import { YZPlane } from './vector/plane/YZPlane';
import { ClosestPoint } from './vector/point/ClosestPoint';
import { ClosestPoints } from './vector/point/ClosestPoints';
import { CullDuplicates } from './vector/point/CullDuplicates';
import { DeconstructPoint } from './vector/point/DeconstructPoint';
import { Distance } from './vector/point/Distance';
import { Point } from './vector/point/Point';
import { PointToVector } from './vector/point/PointToVector';
import { ProjectPoint } from './vector/point/ProjectPoint';
import { PullPoint } from './vector/point/PullPoint';
import { SortAlongCurve } from './vector/point/SortAlongCurve';
import { Amplitude } from './vector/vector/Amplitude';
import { Angle } from './vector/vector/Angle';
import { CrossProduct } from './vector/vector/CrossProduct';
import { DeconstructVector } from './vector/vector/DeconstructVector';
import { ProjectVector } from './vector/vector/ProjectVector';
import { RotateVectorAround } from './vector/vector/RotateVectorAround';
import { UnitVector } from './vector/vector/UnitVector';
import { UnitX } from './vector/vector/UnitX';
import { UnitY } from './vector/vector/UnitY';
import { UnitZ } from './vector/vector/UnitZ';
import { Vector } from './vector/vector/Vector';
import { Vector2Pt } from './vector/vector/Vector2Pt';
import { VectorLength } from './vector/vector/VectorLength';
import { VectorToPoint } from './vector/vector/VectorToPoint';

const Nodes = {
  ControlPoints,
  CurveClosestPoint,
  CurveLength,
  Discontinuity,
  EndPoints,
  EstimatePlane,
  EvaluateCurve,
  PerpFrame,
  PerpFrames,
  PointInCurve,
  PolygonCenter,
  DivideCurve,
  DivideLength,
  Shatter,
  Arc,
  ArcSED,
  Circle,
  Circle3Pt,
  Ellipse,
  Line,
  LineSDL,
  PolyCircle,
  Polygon,
  Rectangle,
  Interpolate,
  NurbsCurve,
  Polyline,
  Explode,
  Fillet,
  FilletAtParameter,
  FlipCurve,
  JoinCurves,
  OffsetCurve,
  OffsetParallelCurve,
  LineDisplay,
  ClipDisplay,
  CustomPreview,
  TexcoordDisplay,
  PointDisplay,
  VectorDisplay,
  DxfExporter,
  FrepMCExporter,
  GltfExporter,
  ObjExporter,
  PlyExporter,
  StlExporter,
  FrepDifference,
  FrepIntersection,
  FrepSmoothDifference,
  FrepSmoothIntersection,
  FrepSmoothUnion,
  FrepUnion,
  FrepCustomDistanceFunction,
  FrepCustomFilter,
  FBox,
  FCapsule,
  FCone,
  FCylinder,
  FSphere,
  TPMSDiamond,
  TPMSFischerKochS,
  TPMSGyroid,
  TPMSLidinoid,
  TPMSSchwarzP,
  FrepBoundingBox,
  FrepRound,
  MarchingCubes,
  CurveImporter,
  MeshImporter,
  Contour,
  LineIntersection,
  LineMeshIntersection,
  LinePlaneIntersection,
  LineTriangleIntersection,
  CurveIntersection,
  MeshDifference,
  MeshIntersection,
  MeshUnion,
  RegionDifference,
  RegionIntersection,
  RegionUnion,
  Complex,
  ComplexConjugate,
  ComplexModulus,
  DeconstructComplex,
  Bounds,
  ConsecutiveDomains,
  DeconstructDomain,
  Domain,
  Includes,
  RemapNumbers,
  Expression,
  PerlinNoise,
  SimplexNoise,
  Absolute,
  Addition,
  Ceil,
  Division,
  Equality,
  Floor,
  GateAnd,
  GateNot,
  GateOr,
  LargerThan,
  MassAddition,
  MassMultiplication,
  Modulus,
  Multiplication,
  Negative,
  Power,
  Round,
  SmallerThan,
  Subtraction,
  Square,
  SquareRoot,
  ArcCosine,
  ArcSine,
  ArcTangent,
  Cosine,
  Degrees,
  Radians,
  Sine,
  Tangent,
  Average,
  Maximum,
  Minimum,
  PI,
  DeconstructFace,
  DeconstructMesh,
  Box,
  Cylinder,
  Icosahedron,
  Mesh,
  Sphere,
  Triangle,
  TriangleLine,
  TrianglePoint,
  FaceTexcoord,
  ProjectTexcoord,
  TriplanarTexcoord,
  DelaunayEdges,
  Voronoi,
  FlipMesh,
  JoinMeshes,
  WeldVertices,
  Boolean,
  UIGraphMapper,
  UIMDSlider,
  UINumber,
  UINumberSlider,
  UIToggle,
  UIValueList,
  Comment,
  Panel,
  ParamViewer,
  Relay,
  Custom,
  Dispatch,
  Indices,
  InsertItems,
  ItemIndex,
  ListItem,
  ListLength,
  PartitionList,
  ReverseList,
  ShiftList,
  SortList,
  Weave,
  CullIndex,
  CullPattern,
  Duplicate,
  Random,
  Range,
  Series,
  FlattenTree,
  FlipMatrix,
  GraftTree,
  Merge,
  ShiftPaths,
  SimplifyTree,
  SplitTree,
  StreamFilter,
  StreamGate,
  UnflattenTree,
  Area,
  EvaluateSurface,
  SurfaceClosestPoint,
  BoundarySurfaces,
  Extrude,
  ExtrudePoint,
  Loft,
  Pipe,
  Revolution,
  SurfaceFromPoints,
  Sweep,
  BoundingBox,
  ConstructBoundingBox,
  DeconstructBoundingBox,
  OrientedBoundingBox,
  PlaneSurface,
  DivideSurface,
  IsoTrim,
  TessellateSurface,
  Format,
  Text,
  NUScale,
  UScale,
  LinearArray,
  Mirror,
  Move,
  Orient,
  Rotate,
  RotateAround,
  RotateOnPlane,
  Scale,
  MapToSurface,
  Group,
  UnGroup,
  HexagonalGrid,
  HexagonalSpiral,
  Populate2D,
  PopulateGeometry,
  RectangularGrid,
  RectangularSpiral,
  SquareGrid,
  TriangularGrid,
  DeconstructPlane,
  FlipPlane,
  Plane,
  XYPlane,
  XZPlane,
  YZPlane,
  ClosestPoint,
  ClosestPoints,
  CullDuplicates,
  DeconstructPoint,
  Distance,
  Point,
  PointToVector,
  ProjectPoint,
  PullPoint,
  SortAlongCurve,
  Amplitude,
  Angle,
  CrossProduct,
  DeconstructVector,
  ProjectVector,
  RotateVectorAround,
  UnitVector,
  UnitX,
  UnitY,
  UnitZ,
  Vector,
  Vector2Pt,
  VectorLength,
  VectorToPoint
};
export { Nodes };

const NodeDictionary: { [index: string]: { name:string; entity: NodeConstructorType }} = {
  'curve/analysis/ControlPoints': { name: 'ControlPoints', entity: ControlPoints },
  'curve/analysis/CurveClosestPoint': { name: 'CurveClosestPoint', entity: CurveClosestPoint },
  'curve/analysis/CurveLength': { name: 'CurveLength', entity: CurveLength },
  'curve/analysis/Discontinuity': { name: 'Discontinuity', entity: Discontinuity },
  'curve/analysis/EndPoints': { name: 'EndPoints', entity: EndPoints },
  'curve/analysis/EstimatePlane': { name: 'EstimatePlane', entity: EstimatePlane },
  'curve/analysis/EvaluateCurve': { name: 'EvaluateCurve', entity: EvaluateCurve },
  'curve/analysis/PerpFrame': { name: 'PerpFrame', entity: PerpFrame },
  'curve/analysis/PerpFrames': { name: 'PerpFrames', entity: PerpFrames },
  'curve/analysis/PointInCurve': { name: 'PointInCurve', entity: PointInCurve },
  'curve/analysis/PolygonCenter': { name: 'PolygonCenter', entity: PolygonCenter },
  'curve/division/DivideCurve': { name: 'DivideCurve', entity: DivideCurve },
  'curve/division/DivideLength': { name: 'DivideLength', entity: DivideLength },
  'curve/division/Shatter': { name: 'Shatter', entity: Shatter },
  'curve/primitive/Arc': { name: 'Arc', entity: Arc },
  'curve/primitive/ArcSED': { name: 'ArcSED', entity: ArcSED },
  'curve/primitive/Circle': { name: 'Circle', entity: Circle },
  'curve/primitive/Circle3Pt': { name: 'Circle3Pt', entity: Circle3Pt },
  'curve/primitive/Ellipse': { name: 'Ellipse', entity: Ellipse },
  'curve/primitive/Line': { name: 'Line', entity: Line },
  'curve/primitive/LineSDL': { name: 'LineSDL', entity: LineSDL },
  'curve/primitive/PolyCircle': { name: 'PolyCircle', entity: PolyCircle },
  'curve/primitive/Polygon': { name: 'Polygon', entity: Polygon },
  'curve/primitive/Rectangle': { name: 'Rectangle', entity: Rectangle },
  'curve/spline/Interpolate': { name: 'Interpolate', entity: Interpolate },
  'curve/spline/NurbsCurve': { name: 'NurbsCurve', entity: NurbsCurve },
  'curve/spline/Polyline': { name: 'Polyline', entity: Polyline },
  'curve/utils/Explode': { name: 'Explode', entity: Explode },
  'curve/utils/Fillet': { name: 'Fillet', entity: Fillet },
  'curve/utils/FilletAtParameter': { name: 'FilletAtParameter', entity: FilletAtParameter },
  'curve/utils/FlipCurve': { name: 'FlipCurve', entity: FlipCurve },
  'curve/utils/JoinCurves': { name: 'JoinCurves', entity: JoinCurves },
  'curve/utils/OffsetCurve': { name: 'OffsetCurve', entity: OffsetCurve },
  'curve/utils/OffsetParallelCurve': { name: 'OffsetParallelCurve', entity: OffsetParallelCurve },
  'display/curve/LineDisplay': { name: 'LineDisplay', entity: LineDisplay },
  'display/mesh/ClipDisplay': { name: 'ClipDisplay', entity: ClipDisplay },
  'display/mesh/CustomPreview': { name: 'CustomPreview', entity: CustomPreview },
  'display/mesh/TexcoordDisplay': { name: 'TexcoordDisplay', entity: TexcoordDisplay },
  'display/vector/PointDisplay': { name: 'PointDisplay', entity: PointDisplay },
  'display/vector/VectorDisplay': { name: 'VectorDisplay', entity: VectorDisplay },
  'exporter/DxfExporter': { name: 'DxfExporter', entity: DxfExporter },
  'exporter/FrepMCExporter': { name: 'FrepMCExporter', entity: FrepMCExporter },
  'exporter/GltfExporter': { name: 'GltfExporter', entity: GltfExporter },
  'exporter/ObjExporter': { name: 'ObjExporter', entity: ObjExporter },
  'exporter/PlyExporter': { name: 'PlyExporter', entity: PlyExporter },
  'exporter/StlExporter': { name: 'StlExporter', entity: StlExporter },
  'frep/blend/FrepDifference': { name: 'FrepDifference', entity: FrepDifference },
  'frep/blend/FrepIntersection': { name: 'FrepIntersection', entity: FrepIntersection },
  'frep/blend/FrepSmoothDifference': { name: 'FrepSmoothDifference', entity: FrepSmoothDifference },
  'frep/blend/FrepSmoothIntersection': { name: 'FrepSmoothIntersection', entity: FrepSmoothIntersection },
  'frep/blend/FrepSmoothUnion': { name: 'FrepSmoothUnion', entity: FrepSmoothUnion },
  'frep/blend/FrepUnion': { name: 'FrepUnion', entity: FrepUnion },
  'frep/plugins/FrepCustomDistanceFunction': { name: 'FrepCustomDistanceFunction', entity: FrepCustomDistanceFunction },
  'frep/plugins/FrepCustomFilter': { name: 'FrepCustomFilter', entity: FrepCustomFilter },
  'frep/primitives/FBox': { name: 'FBox', entity: FBox },
  'frep/primitives/FCapsule': { name: 'FCapsule', entity: FCapsule },
  'frep/primitives/FCone': { name: 'FCone', entity: FCone },
  'frep/primitives/FCylinder': { name: 'FCylinder', entity: FCylinder },
  'frep/primitives/FSphere': { name: 'FSphere', entity: FSphere },
  'frep/tpms/TPMSDiamond': { name: 'TPMSDiamond', entity: TPMSDiamond },
  'frep/tpms/TPMSFischerKochS': { name: 'TPMSFischerKochS', entity: TPMSFischerKochS },
  'frep/tpms/TPMSGyroid': { name: 'TPMSGyroid', entity: TPMSGyroid },
  'frep/tpms/TPMSLidinoid': { name: 'TPMSLidinoid', entity: TPMSLidinoid },
  'frep/tpms/TPMSSchwarzP': { name: 'TPMSSchwarzP', entity: TPMSSchwarzP },
  'frep/utils/FrepBoundingBox': { name: 'FrepBoundingBox', entity: FrepBoundingBox },
  'frep/utils/FrepRound': { name: 'FrepRound', entity: FrepRound },
  'frep/utils/MarchingCubes': { name: 'MarchingCubes', entity: MarchingCubes },
  'importer/CurveImporter': { name: 'CurveImporter', entity: CurveImporter },
  'importer/MeshImporter': { name: 'MeshImporter', entity: MeshImporter },
  'intersects/math/Contour': { name: 'Contour', entity: Contour },
  'intersects/math/LineIntersection': { name: 'LineIntersection', entity: LineIntersection },
  'intersects/math/LineMeshIntersection': { name: 'LineMeshIntersection', entity: LineMeshIntersection },
  'intersects/math/LinePlaneIntersection': { name: 'LinePlaneIntersection', entity: LinePlaneIntersection },
  'intersects/math/LineTriangleIntersection': { name: 'LineTriangleIntersection', entity: LineTriangleIntersection },
  'intersects/physical/CurveIntersection': { name: 'CurveIntersection', entity: CurveIntersection },
  'intersects/shape/MeshDifference': { name: 'MeshDifference', entity: MeshDifference },
  'intersects/shape/MeshIntersection': { name: 'MeshIntersection', entity: MeshIntersection },
  'intersects/shape/MeshUnion': { name: 'MeshUnion', entity: MeshUnion },
  'intersects/shape/RegionDifference': { name: 'RegionDifference', entity: RegionDifference },
  'intersects/shape/RegionIntersection': { name: 'RegionIntersection', entity: RegionIntersection },
  'intersects/shape/RegionUnion': { name: 'RegionUnion', entity: RegionUnion },
  'math/complex/Complex': { name: 'Complex', entity: Complex },
  'math/complex/ComplexConjugate': { name: 'ComplexConjugate', entity: ComplexConjugate },
  'math/complex/ComplexModulus': { name: 'ComplexModulus', entity: ComplexModulus },
  'math/complex/DeconstructComplex': { name: 'DeconstructComplex', entity: DeconstructComplex },
  'math/domain/Bounds': { name: 'Bounds', entity: Bounds },
  'math/domain/ConsecutiveDomains': { name: 'ConsecutiveDomains', entity: ConsecutiveDomains },
  'math/domain/DeconstructDomain': { name: 'DeconstructDomain', entity: DeconstructDomain },
  'math/domain/Domain': { name: 'Domain', entity: Domain },
  'math/domain/Includes': { name: 'Includes', entity: Includes },
  'math/domain/RemapNumbers': { name: 'RemapNumbers', entity: RemapNumbers },
  'math/Expression': { name: 'Expression', entity: Expression },
  'math/noise/PerlinNoise': { name: 'PerlinNoise', entity: PerlinNoise },
  'math/noise/SimplexNoise': { name: 'SimplexNoise', entity: SimplexNoise },
  'math/operator/Absolute': { name: 'Absolute', entity: Absolute },
  'math/operator/Addition': { name: 'Addition', entity: Addition },
  'math/operator/Ceil': { name: 'Ceil', entity: Ceil },
  'math/operator/Division': { name: 'Division', entity: Division },
  'math/operator/Equality': { name: 'Equality', entity: Equality },
  'math/operator/Floor': { name: 'Floor', entity: Floor },
  'math/operator/GateAnd': { name: 'GateAnd', entity: GateAnd },
  'math/operator/GateNot': { name: 'GateNot', entity: GateNot },
  'math/operator/GateOr': { name: 'GateOr', entity: GateOr },
  'math/operator/LargerThan': { name: 'LargerThan', entity: LargerThan },
  'math/operator/MassAddition': { name: 'MassAddition', entity: MassAddition },
  'math/operator/MassMultiplication': { name: 'MassMultiplication', entity: MassMultiplication },
  'math/operator/Modulus': { name: 'Modulus', entity: Modulus },
  'math/operator/Multiplication': { name: 'Multiplication', entity: Multiplication },
  'math/operator/Negative': { name: 'Negative', entity: Negative },
  'math/operator/Power': { name: 'Power', entity: Power },
  'math/operator/Round': { name: 'Round', entity: Round },
  'math/operator/SmallerThan': { name: 'SmallerThan', entity: SmallerThan },
  'math/operator/Subtraction': { name: 'Subtraction', entity: Subtraction },
  'math/polynomials/Square': { name: 'Square', entity: Square },
  'math/polynomials/SquareRoot': { name: 'SquareRoot', entity: SquareRoot },
  'math/trigonometry/ArcCosine': { name: 'ArcCosine', entity: ArcCosine },
  'math/trigonometry/ArcSine': { name: 'ArcSine', entity: ArcSine },
  'math/trigonometry/ArcTangent': { name: 'ArcTangent', entity: ArcTangent },
  'math/trigonometry/Cosine': { name: 'Cosine', entity: Cosine },
  'math/trigonometry/Degrees': { name: 'Degrees', entity: Degrees },
  'math/trigonometry/Radians': { name: 'Radians', entity: Radians },
  'math/trigonometry/Sine': { name: 'Sine', entity: Sine },
  'math/trigonometry/Tangent': { name: 'Tangent', entity: Tangent },
  'math/utils/Average': { name: 'Average', entity: Average },
  'math/utils/Maximum': { name: 'Maximum', entity: Maximum },
  'math/utils/Minimum': { name: 'Minimum', entity: Minimum },
  'math/utils/PI': { name: 'PI', entity: PI },
  'mesh/analysis/DeconstructFace': { name: 'DeconstructFace', entity: DeconstructFace },
  'mesh/analysis/DeconstructMesh': { name: 'DeconstructMesh', entity: DeconstructMesh },
  'mesh/primitive/Box': { name: 'Box', entity: Box },
  'mesh/primitive/Cylinder': { name: 'Cylinder', entity: Cylinder },
  'mesh/primitive/Icosahedron': { name: 'Icosahedron', entity: Icosahedron },
  'mesh/primitive/Mesh': { name: 'Mesh', entity: Mesh },
  'mesh/primitive/Sphere': { name: 'Sphere', entity: Sphere },
  'mesh/primitive/Triangle': { name: 'Triangle', entity: Triangle },
  'mesh/primitive/TriangleLine': { name: 'TriangleLine', entity: TriangleLine },
  'mesh/primitive/TrianglePoint': { name: 'TrianglePoint', entity: TrianglePoint },
  'mesh/texcoord/FaceTexcoord': { name: 'FaceTexcoord', entity: FaceTexcoord },
  'mesh/texcoord/ProjectTexcoord': { name: 'ProjectTexcoord', entity: ProjectTexcoord },
  'mesh/texcoord/TriplanarTexcoord': { name: 'TriplanarTexcoord', entity: TriplanarTexcoord },
  'mesh/triangulation/DelaunayEdges': { name: 'DelaunayEdges', entity: DelaunayEdges },
  'mesh/triangulation/Voronoi': { name: 'Voronoi', entity: Voronoi },
  'mesh/utils/FlipMesh': { name: 'FlipMesh', entity: FlipMesh },
  'mesh/utils/JoinMeshes': { name: 'JoinMeshes', entity: JoinMeshes },
  'mesh/utils/WeldVertices': { name: 'WeldVertices', entity: WeldVertices },
  'params/primitives/Boolean': { name: 'Boolean', entity: Boolean },
  'params/ui/UIGraphMapper': { name: 'UIGraphMapper', entity: UIGraphMapper },
  'params/ui/UIMDSlider': { name: 'UIMDSlider', entity: UIMDSlider },
  'params/ui/UINumber': { name: 'UINumber', entity: UINumber },
  'params/ui/UINumberSlider': { name: 'UINumberSlider', entity: UINumberSlider },
  'params/ui/UIToggle': { name: 'UIToggle', entity: UIToggle },
  'params/ui/UIValueList': { name: 'UIValueList', entity: UIValueList },
  'params/utils/Comment': { name: 'Comment', entity: Comment },
  'params/utils/Panel': { name: 'Panel', entity: Panel },
  'params/utils/ParamViewer': { name: 'ParamViewer', entity: ParamViewer },
  'params/utils/Relay': { name: 'Relay', entity: Relay },
  'plugins/Custom': { name: 'Custom', entity: Custom },
  'sets/list/Dispatch': { name: 'Dispatch', entity: Dispatch },
  'sets/list/Indices': { name: 'Indices', entity: Indices },
  'sets/list/InsertItems': { name: 'InsertItems', entity: InsertItems },
  'sets/list/ItemIndex': { name: 'ItemIndex', entity: ItemIndex },
  'sets/list/ListItem': { name: 'ListItem', entity: ListItem },
  'sets/list/ListLength': { name: 'ListLength', entity: ListLength },
  'sets/list/PartitionList': { name: 'PartitionList', entity: PartitionList },
  'sets/list/ReverseList': { name: 'ReverseList', entity: ReverseList },
  'sets/list/ShiftList': { name: 'ShiftList', entity: ShiftList },
  'sets/list/SortList': { name: 'SortList', entity: SortList },
  'sets/list/Weave': { name: 'Weave', entity: Weave },
  'sets/sequence/CullIndex': { name: 'CullIndex', entity: CullIndex },
  'sets/sequence/CullPattern': { name: 'CullPattern', entity: CullPattern },
  'sets/sequence/Duplicate': { name: 'Duplicate', entity: Duplicate },
  'sets/sequence/Random': { name: 'Random', entity: Random },
  'sets/sequence/Range': { name: 'Range', entity: Range },
  'sets/sequence/Series': { name: 'Series', entity: Series },
  'sets/tree/FlattenTree': { name: 'FlattenTree', entity: FlattenTree },
  'sets/tree/FlipMatrix': { name: 'FlipMatrix', entity: FlipMatrix },
  'sets/tree/GraftTree': { name: 'GraftTree', entity: GraftTree },
  'sets/tree/Merge': { name: 'Merge', entity: Merge },
  'sets/tree/ShiftPaths': { name: 'ShiftPaths', entity: ShiftPaths },
  'sets/tree/SimplifyTree': { name: 'SimplifyTree', entity: SimplifyTree },
  'sets/tree/SplitTree': { name: 'SplitTree', entity: SplitTree },
  'sets/tree/StreamFilter': { name: 'StreamFilter', entity: StreamFilter },
  'sets/tree/StreamGate': { name: 'StreamGate', entity: StreamGate },
  'sets/tree/UnflattenTree': { name: 'UnflattenTree', entity: UnflattenTree },
  'surface/analysis/Area': { name: 'Area', entity: Area },
  'surface/analysis/EvaluateSurface': { name: 'EvaluateSurface', entity: EvaluateSurface },
  'surface/analysis/SurfaceClosestPoint': { name: 'SurfaceClosestPoint', entity: SurfaceClosestPoint },
  'surface/freeform/BoundarySurfaces': { name: 'BoundarySurfaces', entity: BoundarySurfaces },
  'surface/freeform/Extrude': { name: 'Extrude', entity: Extrude },
  'surface/freeform/ExtrudePoint': { name: 'ExtrudePoint', entity: ExtrudePoint },
  'surface/freeform/Loft': { name: 'Loft', entity: Loft },
  'surface/freeform/Pipe': { name: 'Pipe', entity: Pipe },
  'surface/freeform/Revolution': { name: 'Revolution', entity: Revolution },
  'surface/freeform/SurfaceFromPoints': { name: 'SurfaceFromPoints', entity: SurfaceFromPoints },
  'surface/freeform/Sweep': { name: 'Sweep', entity: Sweep },
  'surface/primitive/BoundingBox': { name: 'BoundingBox', entity: BoundingBox },
  'surface/primitive/ConstructBoundingBox': { name: 'ConstructBoundingBox', entity: ConstructBoundingBox },
  'surface/primitive/DeconstructBoundingBox': { name: 'DeconstructBoundingBox', entity: DeconstructBoundingBox },
  'surface/primitive/OrientedBoundingBox': { name: 'OrientedBoundingBox', entity: OrientedBoundingBox },
  'surface/primitive/PlaneSurface': { name: 'PlaneSurface', entity: PlaneSurface },
  'surface/utils/DivideSurface': { name: 'DivideSurface', entity: DivideSurface },
  'surface/utils/IsoTrim': { name: 'IsoTrim', entity: IsoTrim },
  'surface/utils/TessellateSurface': { name: 'TessellateSurface', entity: TessellateSurface },
  'text/Format': { name: 'Format', entity: Format },
  'text/Text': { name: 'Text', entity: Text },
  'transform/affine/NUScale': { name: 'NUScale', entity: NUScale },
  'transform/affine/UScale': { name: 'UScale', entity: UScale },
  'transform/array/LinearArray': { name: 'LinearArray', entity: LinearArray },
  'transform/euclidean/Mirror': { name: 'Mirror', entity: Mirror },
  'transform/euclidean/Move': { name: 'Move', entity: Move },
  'transform/euclidean/Orient': { name: 'Orient', entity: Orient },
  'transform/euclidean/Rotate': { name: 'Rotate', entity: Rotate },
  'transform/euclidean/RotateAround': { name: 'RotateAround', entity: RotateAround },
  'transform/euclidean/RotateOnPlane': { name: 'RotateOnPlane', entity: RotateOnPlane },
  'transform/euclidean/Scale': { name: 'Scale', entity: Scale },
  'transform/morph/MapToSurface': { name: 'MapToSurface', entity: MapToSurface },
  'utils/Group': { name: 'Group', entity: Group },
  'utils/UnGroup': { name: 'UnGroup', entity: UnGroup },
  'vector/grid/HexagonalGrid': { name: 'HexagonalGrid', entity: HexagonalGrid },
  'vector/grid/HexagonalSpiral': { name: 'HexagonalSpiral', entity: HexagonalSpiral },
  'vector/grid/Populate2D': { name: 'Populate2D', entity: Populate2D },
  'vector/grid/PopulateGeometry': { name: 'PopulateGeometry', entity: PopulateGeometry },
  'vector/grid/RectangularGrid': { name: 'RectangularGrid', entity: RectangularGrid },
  'vector/grid/RectangularSpiral': { name: 'RectangularSpiral', entity: RectangularSpiral },
  'vector/grid/SquareGrid': { name: 'SquareGrid', entity: SquareGrid },
  'vector/grid/TriangularGrid': { name: 'TriangularGrid', entity: TriangularGrid },
  'vector/plane/DeconstructPlane': { name: 'DeconstructPlane', entity: DeconstructPlane },
  'vector/plane/FlipPlane': { name: 'FlipPlane', entity: FlipPlane },
  'vector/plane/Plane': { name: 'Plane', entity: Plane },
  'vector/plane/XYPlane': { name: 'XYPlane', entity: XYPlane },
  'vector/plane/XZPlane': { name: 'XZPlane', entity: XZPlane },
  'vector/plane/YZPlane': { name: 'YZPlane', entity: YZPlane },
  'vector/point/ClosestPoint': { name: 'ClosestPoint', entity: ClosestPoint },
  'vector/point/ClosestPoints': { name: 'ClosestPoints', entity: ClosestPoints },
  'vector/point/CullDuplicates': { name: 'CullDuplicates', entity: CullDuplicates },
  'vector/point/DeconstructPoint': { name: 'DeconstructPoint', entity: DeconstructPoint },
  'vector/point/Distance': { name: 'Distance', entity: Distance },
  'vector/point/Point': { name: 'Point', entity: Point },
  'vector/point/PointToVector': { name: 'PointToVector', entity: PointToVector },
  'vector/point/ProjectPoint': { name: 'ProjectPoint', entity: ProjectPoint },
  'vector/point/PullPoint': { name: 'PullPoint', entity: PullPoint },
  'vector/point/SortAlongCurve': { name: 'SortAlongCurve', entity: SortAlongCurve },
  'vector/vector/Amplitude': { name: 'Amplitude', entity: Amplitude },
  'vector/vector/Angle': { name: 'Angle', entity: Angle },
  'vector/vector/CrossProduct': { name: 'CrossProduct', entity: CrossProduct },
  'vector/vector/DeconstructVector': { name: 'DeconstructVector', entity: DeconstructVector },
  'vector/vector/ProjectVector': { name: 'ProjectVector', entity: ProjectVector },
  'vector/vector/RotateVectorAround': { name: 'RotateVectorAround', entity: RotateVectorAround },
  'vector/vector/UnitVector': { name: 'UnitVector', entity: UnitVector },
  'vector/vector/UnitX': { name: 'UnitX', entity: UnitX },
  'vector/vector/UnitY': { name: 'UnitY', entity: UnitY },
  'vector/vector/UnitZ': { name: 'UnitZ', entity: UnitZ },
  'vector/vector/Vector': { name: 'Vector', entity: Vector },
  'vector/vector/Vector2Pt': { name: 'Vector2Pt', entity: Vector2Pt },
  'vector/vector/VectorLength': { name: 'VectorLength', entity: VectorLength },
  'vector/vector/VectorToPoint': { name: 'VectorToPoint', entity: VectorToPoint }
};
export { NodeDictionary };