﻿//
//  SpanMarshallingTests.cs
//
//  Author:
//       Jarl Gullberg <jarl.gullberg@gmail.com>
//
//  Copyright (c) Jarl Gullberg
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

using System;
using AdvancedDLSupport.Tests.Data;
using AdvancedDLSupport.Tests.TestBases;
using Xunit;

#pragma warning disable SA1600, CS1591

namespace AdvancedDLSupport.Tests.Integration;

public class SpanMarshallingTests : LibraryTestBase<ISpanMarshallingTests>
{
    private const string _libraryName = "SpanMarshallingTests";

    public SpanMarshallingTests()
        : base(_libraryName)
    {
    }

    [Fact]
    public void CanMarshalCollectionWithConstLength()
    {
        var span = Library.GetInt32ArrayZeroToNine();

        Assert.True(span.Length == 10);

        for (var i = 0; i < 10; i++)
        {
            Assert.True(span[i] == i);
        }
    }

    [Fact]
    public void CanMarshalSpanAsPointer()
    {
        Span<int> span = stackalloc int[10];

        Library.WriteToInt32Array(span, 10);

        for (var i = 0; i < 10; i++)
        {
            Assert.True(span[i] == i);
        }
    }

    [Fact]
    public void ThrowsWhenSpanTypeIsReferenceType()
    {
        var activator = GetImplementationBuilder();

        Assert.Throws<NotSupportedException>(() => activator.ActivateInterface<IFailsReturnsSpanInvalid>(_libraryName));
    }

    [Fact]
    public void ThrowsWhenReturnParameterHasNoLengthAttribute()
    {
        var activator = GetImplementationBuilder();

        Assert.Throws<InvalidOperationException>(() => activator.ActivateInterface<IFailsReturnsSpanNoAttr>(_libraryName));
    }
}
