﻿//
//  DisposeChecksIntegrationTests.cs
//
//  Author:
//       Jarl Gullberg <jarl.gullberg@gmail.com>
//
//  Copyright (c) Jarl Gullberg
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

using System;
using AdvancedDLSupport.Tests.Data;
using AdvancedDLSupport.Tests.TestBases;
using Xunit;

#pragma warning disable SA1600, CS1591

namespace AdvancedDLSupport.Tests.Integration;

public class DisposeChecksIntegrationTests : LibraryTestBase<IDisposeCheckLibrary>
{
    private const string _libraryName = "DisposeTests";

    public DisposeChecksIntegrationTests()
        : base(_libraryName)
    {
    }

    [Fact]
    public void DisposedLibraryWithoutGeneratedChecksDoesNotThrow()
    {
        var library = new NativeLibraryBuilder().ActivateInterface<IDisposeCheckLibrary>(_libraryName);
        library.Dispose();
        library.Multiply(5, 5);
    }

    [Fact]
    public void UndisposedLibraryDoesNotThrow()
    {
        Library.Multiply(5, 5);
    }

    [Fact]
    public void DisposedLibraryThrows()
    {
        Library.Dispose();

        Assert.Throws<ObjectDisposedException>(() => Library.Multiply(5, 5));
    }

    [Fact]
    public void CanGetNewInstanceOfInterfaceAfterDisposalOfExistingInstance()
    {
        Library.Dispose();

        var newLibrary = new NativeLibraryBuilder(Config).ActivateInterface<IDisposeCheckLibrary>(_libraryName);

        newLibrary.Multiply(5, 5);
        Assert.NotSame(Library, newLibrary);
    }
}
